/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ui;

import java.io.IOException;
import java.net.URL;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.compare.EMFComparePlugin;
import org.eclipse.emf.compare.ui.EMFCompareUIMessages;
import org.eclipse.emf.compare.ui.export.IExportAction;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.osgi.framework.Bundle;

public abstract class AbstractCompareAction
extends Action {
    private static final IPath ICONS_PATH = new Path("$nl$/icons/full/");

    public AbstractCompareAction(IExportAction descriptor) {
        this.setText(descriptor.getText());
        this.setToolTipText(descriptor.getToolTipText());
        this.setImageDescriptor(ImageDescriptor.createFromImage((Image)descriptor.getEnabledImage()));
        this.setHoverImageDescriptor(ImageDescriptor.createFromImage((Image)descriptor.getEnabledImage()));
        this.setDisabledImageDescriptor(ImageDescriptor.createFromImage((Image)descriptor.getDisabledImage()));
    }

    public AbstractCompareAction(ResourceBundle bundle, String keyPrefix) {
        if (keyPrefix == null || keyPrefix.length() <= 0) {
            throw new IllegalArgumentException(EMFCompareUIMessages.getString("AbstractCompareAction.IllegalKey"));
        }
        if (bundle == null) {
            throw new IllegalArgumentException(EMFCompareUIMessages.getString("AbstractCompareAction.IllegalBundle"));
        }
        String labelKey = String.valueOf(keyPrefix) + "label";
        String tooltipKey = String.valueOf(keyPrefix) + "tooltip";
        String imageKey = String.valueOf(keyPrefix) + "image";
        this.setText(bundle.getString(labelKey));
        this.setToolTipText(bundle.getString(tooltipKey));
        String imagePath = bundle.getString(imageKey);
        if (imagePath != null && imagePath.trim().length() > 0) {
            String enabledImagePath;
            String disabledImagePath;
            if (imagePath.indexOf("/") >= 0) {
                String path = imagePath.substring(1);
                disabledImagePath = String.valueOf('d') + path;
                enabledImagePath = String.valueOf('e') + path;
            } else {
                disabledImagePath = "dlcl16/" + imagePath;
                enabledImagePath = "elcl16/" + imagePath;
            }
            ImageDescriptor disabledImageDescriptor = ImageDescriptor.createFromURL((URL)FileLocator.find((Bundle)Platform.getBundle((String)"org.eclipse.compare"), (IPath)ICONS_PATH.append(disabledImagePath), null));
            ImageDescriptor enabledImageDescriptor = ImageDescriptor.createFromURL((URL)FileLocator.find((Bundle)Platform.getBundle((String)"org.eclipse.compare"), (IPath)ICONS_PATH.append(enabledImagePath), null));
            if (disabledImageDescriptor.equals(ImageDescriptor.getMissingImageDescriptor())) {
                try {
                    disabledImageDescriptor = ImageDescriptor.createFromURL((URL)FileLocator.toFileURL((URL)Platform.getBundle((String)"org.eclipse.emf.compare.ui").getEntry("icons/full/" + imagePath)));
                    enabledImageDescriptor = ImageDescriptor.createFromURL((URL)FileLocator.toFileURL((URL)Platform.getBundle((String)"org.eclipse.emf.compare.ui").getEntry("icons/full/" + imagePath)));
                }
                catch (IOException e) {
                    EMFComparePlugin.log((String)e.getMessage(), (boolean)false);
                }
            }
            if (disabledImageDescriptor != null) {
                this.setDisabledImageDescriptor(disabledImageDescriptor);
            }
            if (enabledImageDescriptor != null) {
                this.setImageDescriptor(enabledImageDescriptor);
                this.setHoverImageDescriptor(enabledImageDescriptor);
            }
        }
    }

    public abstract void run();
}

