/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.transaction;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.model.CDOPackageUnit;
import org.eclipse.emf.cdo.common.revision.CDOReferenceAdjuster;
import org.eclipse.emf.cdo.common.revision.delta.CDORevisionDelta;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.internal.common.id.CDOIDExternalTempImpl;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.internal.cdo.messages.Messages;
import org.eclipse.emf.internal.cdo.transaction.CDOXATransactionImpl;
import org.eclipse.emf.spi.cdo.CDOSessionProtocol;
import org.eclipse.emf.spi.cdo.InternalCDOObject;
import org.eclipse.emf.spi.cdo.InternalCDOTransaction;
import org.eclipse.emf.spi.cdo.InternalCDOXATransaction;
import org.eclipse.net4j.util.ImplementationError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDOXACommitContextImpl
implements InternalCDOXATransaction.InternalCDOXACommitContext {
    private CDOXATransactionImpl transactionManager;
    private IProgressMonitor progressMonitor;
    private CDOXATransactionImpl.CDOXAState state;
    private CDOSessionProtocol.CommitTransactionResult result;
    private InternalCDOTransaction.InternalCDOCommitContext delegateCommitContext;
    private Map<CDOIDExternalTempImpl, InternalCDOTransaction> requestedIDs = new HashMap<CDOIDExternalTempImpl, InternalCDOTransaction>();
    private Map<InternalCDOObject, CDOIDExternalTempImpl> objectToID = new HashMap<InternalCDOObject, CDOIDExternalTempImpl>();

    public CDOXACommitContextImpl(CDOXATransactionImpl manager, InternalCDOTransaction.InternalCDOCommitContext commitContext) {
        this.transactionManager = manager;
        this.delegateCommitContext = commitContext;
    }

    @Override
    public CDOXATransactionImpl getTransactionManager() {
        return this.transactionManager;
    }

    public void setProgressMonitor(IProgressMonitor progressMonitor) {
        this.progressMonitor = progressMonitor;
    }

    public CDOXATransactionImpl.CDOXAState getState() {
        return this.state;
    }

    public void setState(CDOXATransactionImpl.CDOXAState state) {
        this.state = state;
    }

    @Override
    public CDOSessionProtocol.CommitTransactionResult getResult() {
        return this.result;
    }

    public void setResult(CDOSessionProtocol.CommitTransactionResult result) {
        this.result = result;
    }

    @Override
    public InternalCDOTransaction getTransaction() {
        return this.delegateCommitContext.getTransaction();
    }

    @Override
    public Map<CDOIDExternalTempImpl, InternalCDOTransaction> getRequestedIDs() {
        return this.requestedIDs;
    }

    @Override
    public Map<CDOID, CDOObject> getDirtyObjects() {
        return this.delegateCommitContext.getDirtyObjects();
    }

    @Override
    public Map<CDOID, CDOObject> getNewObjects() {
        return this.delegateCommitContext.getNewObjects();
    }

    @Override
    public List<CDOPackageUnit> getNewPackageUnits() {
        return this.delegateCommitContext.getNewPackageUnits();
    }

    @Override
    public Map<CDOID, CDOResource> getNewResources() {
        return this.delegateCommitContext.getNewResources();
    }

    @Override
    public Map<CDOID, CDOObject> getDetachedObjects() {
        return this.delegateCommitContext.getDetachedObjects();
    }

    @Override
    public Map<CDOID, CDORevisionDelta> getRevisionDeltas() {
        return this.delegateCommitContext.getRevisionDeltas();
    }

    @Override
    public Object call() throws Exception {
        this.state.handle(this, this.progressMonitor);
        return true;
    }

    public CDOID provideCDOID(Object idOrObject) {
        CDOID id = this.getTransaction().provideCDOID(idOrObject);
        if (id instanceof CDOIDExternalTempImpl) {
            if (idOrObject instanceof InternalEObject) {
                CDOIDExternalTempImpl proxyTemp = (CDOIDExternalTempImpl)id;
                if (!this.requestedIDs.containsKey(proxyTemp)) {
                    InternalCDOObject cdoObject = (InternalCDOObject)CDOUtil.getCDOObject((EObject)((InternalEObject)idOrObject));
                    InternalCDOTransaction cdoTransaction = (InternalCDOTransaction)cdoObject.cdoView();
                    this.getTransactionManager().add(cdoTransaction, (CDOID)proxyTemp);
                    this.requestedIDs.put(proxyTemp, cdoTransaction);
                    this.objectToID.put(cdoObject, proxyTemp);
                }
            } else {
                throw new ImplementationError(MessageFormat.format(Messages.getString("CDOXACommitContextImpl.0"), idOrObject));
            }
        }
        return id;
    }

    @Override
    public void preCommit() {
        this.delegateCommitContext.preCommit();
    }

    @Override
    public void postCommit(CDOSessionProtocol.CommitTransactionResult result) {
        if (result != null) {
            final CDOReferenceAdjuster defaultReferenceAdjuster = result.getReferenceAdjuster();
            result.setReferenceAdjuster(new CDOReferenceAdjuster(){

                public Object adjustReference(Object id) {
                    CDOIDExternalTempImpl externalID = (CDOIDExternalTempImpl)CDOXACommitContextImpl.this.objectToID.get(id);
                    if (externalID != null) {
                        id = externalID;
                    }
                    return defaultReferenceAdjuster.adjustReference(id);
                }
            });
        }
        this.delegateCommitContext.postCommit(result);
    }
}

