/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.net4j.protocol;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.io.CDODataInput;
import org.eclipse.emf.cdo.common.io.CDODataOutput;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.internal.cdo.bundle.OM;
import org.eclipse.emf.internal.cdo.net4j.protocol.CDOClientProtocol;
import org.eclipse.emf.internal.cdo.net4j.protocol.CDOClientRequest;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VerifyRevisionRequest
extends CDOClientRequest<List<InternalCDORevision>> {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_PROTOCOL, VerifyRevisionRequest.class);
    private Collection<InternalCDORevision> revisions;

    public VerifyRevisionRequest(CDOClientProtocol protocol, Collection<InternalCDORevision> revisions) {
        super(protocol, (short)11);
        this.revisions = revisions;
    }

    public VerifyRevisionRequest(CDOClientProtocol protocol, InternalCDORevision revision) {
        this(protocol, Collections.singleton(revision));
    }

    @Override
    protected void requesting(CDODataOutput out) throws IOException {
        if (TRACER.isEnabled()) {
            TRACER.format("Writing {0} IDs and versions", new Object[]{this.revisions.size()});
        }
        out.writeInt(this.revisions.size());
        for (InternalCDORevision revision : this.revisions) {
            CDOID id = revision.getID();
            int version = revision.getVersion();
            if (TRACER.isEnabled()) {
                TRACER.format("Writing ID and version: {0}v{1}", new Object[]{id, version});
            }
            out.writeCDOID(id);
            out.writeInt(version);
        }
    }

    @Override
    protected List<InternalCDORevision> confirming(CDODataInput in) throws IOException {
        ArrayList<InternalCDORevision> result = new ArrayList<InternalCDORevision>();
        if (TRACER.isEnabled()) {
            TRACER.format("Reading {0} timeStamps", new Object[]{this.revisions.size()});
        }
        for (InternalCDORevision revision : this.revisions) {
            long revised = in.readLong();
            if (TRACER.isEnabled()) {
                TRACER.format("Reading timeStamp: {0}", new Object[]{revised});
            }
            if (revised == 0L) continue;
            revision.setRevised(revised);
            result.add(revision);
        }
        return result;
    }
}

