/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDObjectFactory;
import org.eclipse.emf.cdo.common.model.CDOClass;
import org.eclipse.emf.cdo.common.model.CDOFeature;
import org.eclipse.emf.cdo.common.model.resource.CDOPathFeature;
import org.eclipse.emf.cdo.common.revision.CDOReferenceProxy;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.internal.common.revision.CDORevisionResolverImpl;
import org.eclipse.emf.cdo.internal.server.Repository;
import org.eclipse.emf.cdo.server.IRevisionManager;
import org.eclipse.emf.cdo.server.IStoreChunkReader;
import org.eclipse.emf.cdo.server.IStoreReader;
import org.eclipse.emf.cdo.server.StoreUtil;
import org.eclipse.emf.cdo.spi.common.InternalCDORevision;
import org.eclipse.net4j.util.collection.MoveableList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RevisionManager
extends CDORevisionResolverImpl
implements IRevisionManager {
    private Repository repository;
    private CDOPathFeature cdoPathFeature;

    public RevisionManager(Repository repository) {
        this.repository = repository;
        this.cdoPathFeature = repository.getPackageManager().getCDOResourcePackage().getCDOResourceClass().getCDOPathFeature();
    }

    @Override
    public Repository getRepository() {
        return this.repository;
    }

    public CDOIDObjectFactory getCDOIDObjectFactory() {
        return this.repository.getStore().getCDOIDObjectFactory();
    }

    public CDOID resolveReferenceProxy(CDOReferenceProxy referenceProxy) {
        throw new UnsupportedOperationException("Reference proxies not supported on server side");
    }

    public List<Integer> analyzeReferenceRanges(List<Object> list) {
        return null;
    }

    public boolean addRevision(InternalCDORevision revision) {
        if (revision.isResource()) {
            String path = (String)revision.get((CDOFeature)this.cdoPathFeature, 0);
            this.repository.getResourceManager().registerResource(revision.getID(), path);
        }
        return super.addRevision(revision);
    }

    protected InternalCDORevision verifyRevision(InternalCDORevision revision, int referenceChunk) {
        IStoreReader storeReader = null;
        revision = super.verifyRevision(revision, referenceChunk);
        if (this.repository.isVerifyingRevisions()) {
            storeReader = StoreUtil.getReader();
            revision = (InternalCDORevision)storeReader.verifyRevision((CDORevision)revision);
        }
        this.ensureChunks(revision, referenceChunk, storeReader);
        return revision;
    }

    protected void ensureChunks(InternalCDORevision revision, int referenceChunk, IStoreReader storeReader) {
        CDOClass cdoClass = revision.getCDOClass();
        CDOFeature[] features = cdoClass.getAllFeatures();
        int i = 0;
        while (i < features.length) {
            CDOFeature feature = features[i];
            if (feature.isReference() && feature.isMany()) {
                MoveableList list = revision.getList(feature);
                int chunkEnd = Math.min(referenceChunk, list.size());
                storeReader = this.ensureChunk(revision, feature, storeReader, (MoveableList<Object>)list, 0, chunkEnd);
            }
            ++i;
        }
    }

    public IStoreReader ensureChunk(InternalCDORevision revision, CDOFeature feature, int chunkStart, int chunkEnd) {
        MoveableList list = revision.getList(feature);
        chunkEnd = Math.min(chunkEnd, list.size());
        return this.ensureChunk(revision, feature, StoreUtil.getReader(), (MoveableList<Object>)list, chunkStart, chunkEnd);
    }

    protected IStoreReader ensureChunk(InternalCDORevision revision, CDOFeature feature, IStoreReader storeReader, MoveableList<Object> list, int chunkStart, int chunkEnd) {
        IStoreChunkReader chunkReader = null;
        int fromIndex = -1;
        int j = chunkStart;
        while (j < chunkEnd) {
            if (list.get(j) == InternalCDORevision.UNINITIALIZED) {
                if (fromIndex == -1) {
                    fromIndex = j;
                }
            } else if (fromIndex != -1) {
                int toIndex;
                if (chunkReader == null) {
                    if (storeReader == null) {
                        storeReader = StoreUtil.getReader();
                    }
                    chunkReader = storeReader.createChunkReader((CDORevision)revision, feature);
                }
                if (fromIndex == (toIndex = j) - 1) {
                    chunkReader.addSimpleChunk(fromIndex);
                } else {
                    chunkReader.addRangedChunk(fromIndex, toIndex);
                }
                fromIndex = -1;
            }
            ++j;
        }
        if (fromIndex != -1) {
            int toIndex;
            if (chunkReader == null) {
                if (storeReader == null) {
                    storeReader = StoreUtil.getReader();
                }
                chunkReader = storeReader.createChunkReader((CDORevision)revision, feature);
            }
            if (fromIndex == (toIndex = chunkEnd) - 1) {
                chunkReader.addSimpleChunk(fromIndex);
            } else {
                chunkReader.addRangedChunk(fromIndex, toIndex);
            }
        }
        if (chunkReader != null) {
            List<IStoreChunkReader.Chunk> chunks = chunkReader.executeRead();
            for (IStoreChunkReader.Chunk chunk : chunks) {
                int startIndex = chunk.getStartIndex();
                int indexInChunk = 0;
                while (indexInChunk < chunk.size()) {
                    CDOID id = chunk.getID(indexInChunk);
                    list.set(startIndex + indexInChunk, (Object)id);
                    ++indexInChunk;
                }
            }
        }
        return storeReader;
    }

    protected InternalCDORevision loadRevision(CDOID id, int referenceChunk) {
        IStoreReader storeReader = StoreUtil.getReader();
        return (InternalCDORevision)storeReader.readRevision(id, referenceChunk);
    }

    protected InternalCDORevision loadRevisionByTime(CDOID id, int referenceChunk, long timeStamp) {
        IStoreReader storeReader = StoreUtil.getReader();
        return (InternalCDORevision)storeReader.readRevisionByTime(id, referenceChunk, timeStamp);
    }

    protected InternalCDORevision loadRevisionByVersion(CDOID id, int referenceChunk, int version) {
        IStoreReader storeReader = StoreUtil.getReader();
        return (InternalCDORevision)storeReader.readRevisionByVersion(id, referenceChunk, version);
    }

    protected List<InternalCDORevision> loadRevisions(Collection<CDOID> ids, int referenceChunk) {
        IStoreReader storeReader = StoreUtil.getReader();
        ArrayList<InternalCDORevision> revisions = new ArrayList<InternalCDORevision>();
        for (CDOID id : ids) {
            InternalCDORevision revision = (InternalCDORevision)storeReader.readRevision(id, referenceChunk);
            revisions.add(revision);
        }
        return revisions;
    }

    protected List<InternalCDORevision> loadRevisionsByTime(Collection<CDOID> ids, int referenceChunk, long timeStamp) {
        IStoreReader storeReader = StoreUtil.getReader();
        ArrayList<InternalCDORevision> revisions = new ArrayList<InternalCDORevision>();
        for (CDOID id : ids) {
            InternalCDORevision revision = (InternalCDORevision)storeReader.readRevisionByTime(id, referenceChunk, timeStamp);
            revisions.add(revision);
        }
        return revisions;
    }

    protected void doBeforeActivate() throws Exception {
        super.doBeforeActivate();
        this.setCurrentLRUCapacity(this.getLRUCapacity("currentLRUCapacity"));
        this.setRevisedLRUCapacity(this.getLRUCapacity("revisedLRUCapacity"));
    }

    protected int getLRUCapacity(String prop) {
        String capacity = this.repository.getProperties().get(prop);
        return capacity == null ? 0 : Integer.valueOf(capacity);
    }
}

