/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.annotations.xml;

import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.teneo.annotations.StoreAnnotationsException;
import org.eclipse.emf.teneo.annotations.pamodel.PamodelPackage;
import org.eclipse.emf.teneo.annotations.pannotation.PannotationPackage;
import org.eclipse.emf.teneo.simpledom.Attribute;
import org.eclipse.emf.teneo.simpledom.Document;
import org.eclipse.emf.teneo.simpledom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceMappingSchemaGenerator {
    public static final String ESTRUCTURAL_FEATURE_SOURCE_NAME = "teneo/internal/EStructuralFeatureName";
    public static final String PERSISTENCE_MAPPING_SOURCE = "teneo/internal/PersistenceMapping";
    private static final String UNSUPPORTED_SOURCE = "teneo/internal/Unsupported";
    public static final String XML_SCHEMA_NAMESPACE = "http://www.w3.org/2001/XMLSchema";
    private EPackage modelEPackage;
    private EPackage[] annotationEPackages;
    private final Map<String, String> schemaTypeNamesByAnnotationType = new HashMap<String, String>();
    private String nameSpace = "http://www.eclipse.org/emft/teneo";

    public static void main(String[] args) {
        PersistenceMappingSchemaGenerator pmsg = new PersistenceMappingSchemaGenerator();
        pmsg.setAnnotationEPackages(new EPackage[]{PannotationPackage.eINSTANCE});
        pmsg.setModelEPackage((EPackage)PamodelPackage.eINSTANCE);
        try {
            FileWriter fw = new FileWriter("/home/mtaal/mytmp/persistence-mapping.xsd");
            fw.write(pmsg.generate());
            fw.close();
        }
        catch (Exception e) {
            throw new StoreAnnotationsException("Exception while generating mapping.xsd", e);
        }
    }

    private void initialize() {
        this.schemaTypeNamesByAnnotationType.put("EBoolean", "xsd:boolean");
        this.schemaTypeNamesByAnnotationType.put("EInt", "xsd:int");
        this.schemaTypeNamesByAnnotationType.put("ELong", "xsd:long");
        this.schemaTypeNamesByAnnotationType.put("EString", "xsd:string");
    }

    public String generate() {
        this.initialize();
        Document doc = new Document();
        Element root = new Element("xsd:schema").addAttribute("targetNamespace", this.nameSpace).addAttribute("elementFormDefault", "qualified").addAttribute("xmlns:xsd", XML_SCHEMA_NAMESPACE).addAttribute("xmlns", this.nameSpace);
        root.addElement("xsd:element").addAttribute("name", "persistence-mapping").addAttribute("type", "PersistenceMapping");
        root.addElement("xsd:complexType").addAttribute("name", "PersistenceMapping").addElement("xsd:sequence").addAttribute("minOccurs", "1").addAttribute("maxOccurs", "unbounded").addElement("xsd:element").addAttribute("name", "epackage").addAttribute("type", "EPackage");
        EPackage[] ePackageArray = this.annotationEPackages;
        int n = this.annotationEPackages.length;
        int n2 = 0;
        while (n2 < n) {
            EPackage annotationEPackage = ePackageArray[n2];
            ArrayList eclassifiers = new ArrayList(annotationEPackage.getEClassifiers());
            for (EClassifier eClassifier : eclassifiers) {
                EClass eClass;
                String schemaTypeName = eClassifier.getName();
                if (eClassifier instanceof EClass && this.oneMappableFeature(eClass = (EClass)eClassifier)) {
                    EStructuralFeature eStructuralFeature = (EStructuralFeature)eClass.getEStructuralFeatures().get(0);
                    EClassifier eType = eStructuralFeature.getEType();
                    schemaTypeName = this.schemaTypeNamesByAnnotationType.get(eType.getName());
                    if (schemaTypeName == null) {
                        schemaTypeName = eType.getName();
                    }
                    this.schemaTypeNamesByAnnotationType.put(eClassifier.getName(), schemaTypeName);
                    continue;
                }
                this.schemaTypeNamesByAnnotationType.put(eClassifier.getName(), schemaTypeName);
            }
            ++n2;
        }
        ArrayList<Element> annotationList = new ArrayList<Element>();
        EPackage[] ePackageArray2 = this.annotationEPackages;
        int n3 = this.annotationEPackages.length;
        n = 0;
        while (n < n3) {
            EPackage annotationEPackage = ePackageArray2[n];
            annotationList.addAll(this.processAnnotationEPackage(annotationEPackage));
            ++n;
        }
        root.addElement(this.createEPackageElement());
        root.addElement(this.createEClassElement());
        root.addElement(this.createEAttributeElement());
        root.addElement(this.createEReferenceElement());
        root.addElement(this.createPropertyElement());
        root.addElement(this.createEDataTypeElement());
        root.getChildren().addAll(annotationList);
        doc.setRoot(root);
        return doc.emitXML();
    }

    private List<Element> processAnnotationEPackage(EPackage epackage) {
        ArrayList<Element> elemList = new ArrayList<Element>();
        ArrayList eclassifiers = new ArrayList(epackage.getEClassifiers());
        Collections.sort(eclassifiers, new ENamedElementComparator());
        for (EClassifier eClassifier : eclassifiers) {
            if (PersistenceMappingSchemaGenerator.isIgnorable((EModelElement)eClassifier) || PersistenceMappingSchemaGenerator.isUnsupported((EModelElement)eClassifier)) continue;
            String schemaTypeName = eClassifier.getName();
            if (eClassifier instanceof EClass) {
                EList eStructuralFeatures;
                EClass eClass = (EClass)eClassifier;
                if (eClass.isAbstract() || (eStructuralFeatures = eClass.getEAllStructuralFeatures()).isEmpty() || this.oneMappableFeature(eClass)) continue;
                Element complexTypeElement = this.createSchemaComplexType(eClass.getName());
                elemList.add(complexTypeElement);
                Element choiceElement = complexTypeElement.addElement("xsd:choice");
                this.addZeroUnbounded(choiceElement);
                this.processStructuralFeatures(choiceElement, (List<EStructuralFeature>)eStructuralFeatures);
                if (choiceElement.getChildren().size() == 0) {
                    complexTypeElement.getChildren().remove(choiceElement);
                }
            } else if (eClassifier instanceof EEnum) {
                elemList.add(this.processEnum((EEnum)eClassifier));
            } else {
                throw new RuntimeException("Unexpected EClassifier: " + eClassifier.eClass().getName());
            }
            this.schemaTypeNamesByAnnotationType.put(eClassifier.getName(), schemaTypeName);
        }
        return elemList;
    }

    private boolean oneMappableFeature(EClass eclass) {
        int cnt = 0;
        for (EStructuralFeature ef : eclass.getEStructuralFeatures()) {
            if (PersistenceMappingSchemaGenerator.isIgnorable((EModelElement)ef) || PersistenceMappingSchemaGenerator.isUnsupported((EModelElement)ef)) continue;
            ++cnt;
        }
        return cnt == 1;
    }

    private Element processEnum(EEnum eEnum) {
        Element simpleTypeElement = this.createSchemaSimpleType(eEnum.getName(), null);
        Element restrictionElement = new Element("xsd:restriction");
        restrictionElement.addAttribute(new Attribute("base", "xsd:token"));
        simpleTypeElement.addElement(restrictionElement);
        EList literals = eEnum.getELiterals();
        for (EEnumLiteral literal : literals) {
            Element enumerationElement = new Element("xsd:enumeration");
            restrictionElement.addElement(enumerationElement);
            enumerationElement.addAttribute(new Attribute("value", literal.getLiteral()));
        }
        return simpleTypeElement;
    }

    private Element createEPackageElement() {
        Element epackElement = new Element("xsd:complexType").addAttribute("name", "EPackage");
        Element choiceElement = epackElement.addElement("xsd:choice");
        this.addZeroUnbounded(choiceElement);
        this.processStructuralFeatures(choiceElement, (List<EStructuralFeature>)this.getPAnnotatedEPackage().getEAllStructuralFeatures());
        choiceElement.addElement("xsd:element").addAttribute("name", "eclass").addAttribute("type", "EClass");
        choiceElement.addElement("xsd:element").addAttribute("name", "edatatype").addAttribute("type", "EDataType");
        epackElement.addElement("xsd:attribute").addAttribute("name", "namespace-uri").addAttribute("type", "xsd:anyURI").addAttribute("use", "required");
        return epackElement;
    }

    private Element createEClassElement() {
        Element eclassElement = new Element("xsd:complexType").addAttribute("name", "EClass");
        Element choiceElement = eclassElement.addElement("xsd:choice");
        this.addZeroUnbounded(choiceElement);
        this.processStructuralFeatures(choiceElement, (List<EStructuralFeature>)this.getPAnnotatedEClass().getEAllStructuralFeatures());
        choiceElement.addElement("xsd:element").addAttribute("name", "eattribute").addAttribute("type", "EAttribute");
        choiceElement.addElement("xsd:element").addAttribute("name", "ereference").addAttribute("type", "EReference");
        choiceElement.addElement("xsd:element").addAttribute("name", "property").addAttribute("type", "Property");
        choiceElement.addElement("xsd:element").addAttribute("name", "edatatype").addAttribute("type", "EDataType");
        eclassElement.addElement("xsd:attribute").addAttribute("name", "name").addAttribute("type", "xsd:token").addAttribute("use", "required");
        return eclassElement;
    }

    private Element createEReferenceElement() {
        Element erefElement = new Element("xsd:complexType").addAttribute("name", "EReference");
        Element choiceElement = erefElement.addElement("xsd:choice");
        this.addZeroUnbounded(choiceElement);
        this.processStructuralFeatures(choiceElement, (List<EStructuralFeature>)this.getPAnnotatedEReference().getEAllStructuralFeatures());
        erefElement.addElement("xsd:attribute").addAttribute("name", "name").addAttribute("type", "xsd:token").addAttribute("use", "required");
        return erefElement;
    }

    private Element createEAttributeElement() {
        Element eattrElement = new Element("xsd:complexType").addAttribute("name", "EAttribute");
        Element choiceElement = eattrElement.addElement("xsd:choice");
        this.addZeroUnbounded(choiceElement);
        this.processStructuralFeatures(choiceElement, (List<EStructuralFeature>)this.getPAnnotatedEAttribute().getEAllStructuralFeatures());
        eattrElement.addElement("xsd:attribute").addAttribute("name", "name").addAttribute("type", "xsd:token").addAttribute("use", "required");
        return eattrElement;
    }

    private Element createEDataTypeElement() {
        Element eattrElement = new Element("xsd:complexType").addAttribute("name", "EDataType");
        Element choiceElement = eattrElement.addElement("xsd:choice");
        this.addZeroUnbounded(choiceElement);
        this.processStructuralFeatures(choiceElement, (List<EStructuralFeature>)this.getPAnnotatedEDataType().getEAllStructuralFeatures());
        eattrElement.addElement("xsd:attribute").addAttribute("name", "name").addAttribute("type", "xsd:token").addAttribute("use", "required");
        return eattrElement;
    }

    private Element createPropertyElement() {
        Element propertyElement = new Element("xsd:complexType").addAttribute("name", "Property");
        Element choiceElement = propertyElement.addElement("xsd:choice");
        this.addZeroUnbounded(choiceElement);
        ArrayList<EStructuralFeature> features = new ArrayList<EStructuralFeature>((Collection<EStructuralFeature>)this.getPAnnotatedEAttribute().getEAllStructuralFeatures());
        features.removeAll((Collection<?>)this.getPAnnotatedEReference().getEAllStructuralFeatures());
        features.addAll((Collection<EStructuralFeature>)this.getPAnnotatedEReference().getEAllStructuralFeatures());
        this.processStructuralFeatures(choiceElement, features);
        propertyElement.addElement("xsd:attribute").addAttribute("name", "name").addAttribute("type", "xsd:token").addAttribute("use", "required");
        return propertyElement;
    }

    private void processStructuralFeatures(Element mainElement, List<EStructuralFeature> eStructuralFeatures) {
        ArrayList<EStructuralFeature> eFeatures = new ArrayList<EStructuralFeature>(eStructuralFeatures);
        Collections.sort(eFeatures, new ENamedElementComparator());
        for (EStructuralFeature ef : eFeatures) {
            this.processStructuralFeature(mainElement, ef);
        }
    }

    private void processStructuralFeature(Element parentElement, EStructuralFeature eStructuralFeature) {
        EClassifier eType = eStructuralFeature.getEType();
        if (PersistenceMappingSchemaGenerator.isIgnorable((EModelElement)eStructuralFeature) || PersistenceMappingSchemaGenerator.isIgnorable((EModelElement)eType) || PersistenceMappingSchemaGenerator.isUnsupported((EModelElement)eType)) {
            return;
        }
        int minOccurs = eStructuralFeature.isRequired() ? 1 : 0;
        EAnnotation eAnnotation = eStructuralFeature.getEAnnotation(PERSISTENCE_MAPPING_SOURCE);
        String elementName = null;
        if (eAnnotation != null) {
            elementName = (String)eAnnotation.getDetails().get((Object)"elementName");
        }
        if (elementName == null) {
            elementName = eStructuralFeature.getName();
            if (eStructuralFeature.isMany() && elementName.endsWith("s")) {
                elementName = elementName.substring(0, elementName.length() - 1);
            }
        }
        String xmlName = this.convertToXmlName(elementName);
        for (Element otherElem : parentElement.getChildren()) {
            String name = otherElem.getAttributeValue("name");
            if (name == null || name.compareTo(xmlName) != 0) continue;
            return;
        }
        if (parentElement.element(this.convertToXmlName(elementName)) != null) {
            return;
        }
        String typeName = this.schemaTypeNamesByAnnotationType.get(eType.getName());
        if (typeName == null) {
            typeName = eType.getName();
        }
        if (eStructuralFeature instanceof EReference) {
            Element element = this.createSchemaElement(elementName, typeName, eStructuralFeature.getName());
            if (parentElement.getName().compareTo("xsd:choice") != 0) {
                element.addAttribute(new Attribute("minOccurs", String.valueOf(minOccurs)));
                if (eStructuralFeature.isMany()) {
                    element.addAttribute(new Attribute("maxOccurs", "unbounded"));
                }
            }
            parentElement.addElement(element);
        } else {
            Element attributeElement = this.createSchemaAttribute(eStructuralFeature.getName(), typeName, eStructuralFeature.getName());
            attributeElement.addAttribute(new Attribute("use", minOccurs == 0 ? "optional" : "required"));
            parentElement.getParent().addElement(attributeElement);
            if (eStructuralFeature.isMany()) {
                Element element = this.createSchemaElement(eStructuralFeature.getName(), typeName, eStructuralFeature.getName());
                parentElement.addElement(element);
                if (parentElement.getName().compareTo("xsd:choice") != 0) {
                    element.addAttribute(new Attribute("minOccurs", "0"));
                    element.addAttribute(new Attribute("maxOccurs", "unbounded"));
                }
            }
        }
    }

    protected EClass getPAnnotatedEPackage() {
        return (EClass)this.modelEPackage.getEClassifier("PAnnotatedEPackage");
    }

    protected EClass getPAnnotatedEClass() {
        return (EClass)this.modelEPackage.getEClassifier("PAnnotatedEClass");
    }

    protected EClass getPAnnotatedEReference() {
        return (EClass)this.modelEPackage.getEClassifier("PAnnotatedEReference");
    }

    protected EClass getPAnnotatedEAttribute() {
        return (EClass)this.modelEPackage.getEClassifier("PAnnotatedEAttribute");
    }

    protected EClass getPAnnotatedEDataType() {
        return (EClass)this.modelEPackage.getEClassifier("PAnnotatedEDataType");
    }

    protected static boolean isIgnorable(EModelElement eModelElement) {
        EAnnotation eAnnotation = eModelElement.getEAnnotation(PERSISTENCE_MAPPING_SOURCE);
        boolean ignore = false;
        if (eAnnotation != null) {
            ignore = Boolean.valueOf((String)eAnnotation.getDetails().get((Object)"ignore"));
        }
        return ignore;
    }

    private Element createSchemaElement(String name, String type, String eStructuralFeatureName) {
        Element element = new Element("xsd:element");
        element.addAttribute(new Attribute("name", this.convertToXmlName(name)));
        element.addAttribute(new Attribute("type", type));
        if (!name.equals(eStructuralFeatureName)) {
            PersistenceMappingSchemaGenerator.addAppInfoElement(element, eStructuralFeatureName);
        }
        return element;
    }

    private Element createSchemaSimpleType(String name, String type) {
        Element element = new Element("xsd:simpleType");
        element.addAttribute(new Attribute("name", name));
        if (type != null) {
            element.addAttribute(new Attribute("type", type));
        }
        return element;
    }

    private Element createSchemaAttribute(String name, String type, String eStructuralFeatureName) {
        Element element = new Element("xsd:attribute");
        element.addAttribute(new Attribute("name", this.convertToXmlName(name)));
        element.addAttribute(new Attribute("type", type));
        if (!name.equals(eStructuralFeatureName)) {
            PersistenceMappingSchemaGenerator.addAppInfoElement(element, eStructuralFeatureName);
        }
        return element;
    }

    private static void addAppInfoElement(Element element, String eStructuralFeatureName) {
        Element annotationElement = new Element("xsd:annotation");
        element.addElement(annotationElement);
        Element appInfoElement = new Element("xsd:appinfo");
        appInfoElement.addAttribute(new Attribute("source", ESTRUCTURAL_FEATURE_SOURCE_NAME));
        appInfoElement.setText(eStructuralFeatureName);
        annotationElement.addElement(appInfoElement);
    }

    private Element createSchemaComplexType(String name) {
        Element element = new Element("xsd:complexType");
        element.addAttribute(new Attribute("name", name));
        return element;
    }

    protected static boolean isUnsupported(EModelElement eModelElement) {
        return eModelElement.getEAnnotation(UNSUPPORTED_SOURCE) != null;
    }

    private void addZeroUnbounded(Element elem) {
        this.addMinMaxOccurs(elem, "0", "unbounded");
    }

    private void addMinMaxOccurs(Element elem, String min, String max) {
        elem.addAttribute("minOccurs", min).addAttribute("maxOccurs", max);
    }

    protected String convertToXmlName(String name) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        int n = name.length();
        while (i < n) {
            char ch = name.charAt(i);
            if (Character.isUpperCase(ch)) {
                if (i > 0) {
                    sb.append('-');
                }
                ch = Character.toLowerCase(ch);
            }
            sb.append(ch);
            ++i;
        }
        return sb.toString();
    }

    public EPackage[] getAnnotationEPackages() {
        return this.annotationEPackages;
    }

    public void setAnnotationEPackages(EPackage[] annotationEPackages) {
        this.annotationEPackages = annotationEPackages;
    }

    public EPackage getModelEPackage() {
        return this.modelEPackage;
    }

    public void setModelEPackage(EPackage modelEPackage) {
        this.modelEPackage = modelEPackage;
    }

    public String getNameSpace() {
        return this.nameSpace;
    }

    public void setNameSpace(String nameSpace) {
        this.nameSpace = nameSpace;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ENamedElementComparator
    implements Comparator<ENamedElement> {
        private ENamedElementComparator() {
        }

        @Override
        public int compare(ENamedElement e1, ENamedElement e2) {
            return e1.getName().compareTo(e2.getName());
        }
    }
}

