/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.tests.merge;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.ConflictKind;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.EMFCompare;
import org.eclipse.emf.compare.merge.BatchMerger;
import org.eclipse.emf.compare.merge.IBatchMerger;
import org.eclipse.emf.compare.merge.IMerger;
import org.eclipse.emf.compare.scope.DefaultComparisonScope;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.compare.tests.merge.data.ThreeWayMergeInputData;
import org.eclipse.emf.ecore.resource.Resource;
import org.junit.Assert;
import org.junit.Test;

public class ThreeWayBatchMergingTest {
    private final ThreeWayMergeInputData input = new ThreeWayMergeInputData();
    private final IMerger.Registry mergerRegistry = IMerger.RegistryImpl.createStandaloneInstance();
    private final IBatchMerger merger = new BatchMerger(this.mergerRegistry);

    @Test
    public void mergingMoveToDifferentContainmentFeatureLeft() throws IOException {
        Resource origin = this.input.getMoveToDifferentContainmentFeatureOrigin();
        Resource left = this.input.getMoveToDifferentContainmentFeatureMove();
        Resource right = this.input.getMoveToDifferentContainmentFeatureUnchanged();
        this.assertUnchanged((IComparisonScope)new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin), DifferenceSource.RIGHT);
        this.batchMergeAndAssertEquality((IComparisonScope)new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin), DifferenceSource.LEFT);
    }

    @Test
    public void mergingMoveToDifferentContainmentFeatureRight() throws IOException {
        Resource origin = this.input.getMoveToDifferentContainmentFeatureOrigin();
        Resource left = this.input.getMoveToDifferentContainmentFeatureUnchanged();
        Resource right = this.input.getMoveToDifferentContainmentFeatureMove();
        this.assertUnchanged((IComparisonScope)new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin), DifferenceSource.LEFT);
        this.batchMergeAndAssertEquality((IComparisonScope)new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin), DifferenceSource.RIGHT);
    }

    private void assertUnchanged(IComparisonScope scope, DifferenceSource side) {
        Notifier supposeUnchanged = DifferenceSource.LEFT.equals((Object)side) ? scope.getLeft() : scope.getRight();
        IComparisonScope scopeForAssert = this.createTwoWayScopeWithOrigin(scope, supposeUnchanged);
        EList diffsForAssertion = this.compare(scopeForAssert).getDifferences();
        Assert.assertEquals((long)0L, (long)diffsForAssertion.size());
    }

    private IComparisonScope createTwoWayScopeWithOrigin(IComparisonScope scope, Notifier notifier) {
        return new DefaultComparisonScope(scope.getOrigin(), notifier, null);
    }

    private void batchMergeAndAssertEquality(IComparisonScope scope, DifferenceSource side) {
        this.batchMerge(scope, side);
        this.assertEqualityOfLeftAndRight(scope);
    }

    private void batchMerge(IComparisonScope scope, DifferenceSource side) {
        Comparison comparison = this.compare(scope);
        EList differences = comparison.getDifferences();
        if (DifferenceSource.LEFT.equals((Object)side)) {
            List<Diff> leftDiffs = this.filterDiffs((List<Diff>)differences, DifferenceSource.LEFT, false);
            this.merger.copyAllLeftToRight(leftDiffs, (Monitor)new BasicMonitor());
        } else {
            List<Diff> rightDiffs = this.filterDiffs((List<Diff>)differences, DifferenceSource.RIGHT, false);
            this.merger.copyAllRightToLeft(rightDiffs, (Monitor)new BasicMonitor());
        }
    }

    private Comparison compare(IComparisonScope scope) {
        return EMFCompare.builder().build().compare(scope);
    }

    private List<Diff> filterDiffs(List<Diff> diffs, DifferenceSource source, boolean filterConflicting) {
        ArrayList<Diff> filteredDiffs = new ArrayList<Diff>();
        for (Diff diff : diffs) {
            if (!source.equals((Object)diff.getSource()) || this.isConflicting(diff) && filterConflicting) continue;
            filteredDiffs.add(diff);
        }
        return filteredDiffs;
    }

    private boolean isConflicting(Diff diff) {
        return diff.getConflict() != null && ConflictKind.REAL.equals((Object)diff.getConflict().getKind());
    }

    private void assertEqualityOfLeftAndRight(IComparisonScope scope) {
        Notifier left = scope.getLeft();
        Notifier right = scope.getRight();
        DefaultComparisonScope assertScope = new DefaultComparisonScope(left, right, null);
        Comparison assertComparison = this.compare((IComparisonScope)assertScope);
        EList assertDiffs = assertComparison.getDifferences();
        Assert.assertTrue((boolean)assertDiffs.isEmpty());
    }
}

