/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.uml2.rcp.ui.tests.groups;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Conflict;
import org.eclipse.emf.compare.ConflictKind;
import org.eclipse.emf.compare.provider.spec.CompareItemProviderAdapterFactorySpec;
import org.eclipse.emf.compare.rcp.ui.internal.EMFCompareRCPUIMessages;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.impl.ThreeWayComparisonGroupProvider;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.nodes.ConflictNode;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.nodes.DiffNode;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.nodes.MatchNode;
import org.eclipse.emf.compare.rcp.ui.tests.structuremergeviewer.groups.provider.AbstractTestTreeNodeItemProviderAdapter;
import org.eclipse.emf.compare.tests.edit.data.ResourceScopeProvider;
import org.eclipse.emf.compare.uml2.rcp.ui.tests.groups.data.uml.compositeconflict.UMLJoiningConflictsWithOverlappingDiffsInputData;
import org.eclipse.emf.compare.uml2.rcp.ui.tests.groups.data.uml.conflictrefiningdiffs.UMLConflictWithRefiningDiffInputData;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.provider.EcoreItemProviderAdapterFactory;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.tree.TreeNode;
import org.eclipse.emf.edit.tree.TreePackage;
import org.junit.Assert;
import org.junit.Test;

public class ConflictsGroupTest
extends AbstractTestTreeNodeItemProviderAdapter {
    private AdapterFactoryItemDelegator itemDelegator;

    public void before() throws IOException {
        super.before();
        ArrayList factories = Lists.newArrayList();
        factories.add(new CompareItemProviderAdapterFactorySpec());
        factories.add(this.treeItemProviderAdapterFactory);
        factories.add(new EcoreItemProviderAdapterFactory());
        factories.add(new ReflectiveItemProviderAdapterFactory());
        ComposedAdapterFactory composedAdapterFactory = new ComposedAdapterFactory((Collection)factories);
        this.itemDelegator = new AdapterFactoryItemDelegator((AdapterFactory)composedAdapterFactory);
    }

    @Test
    public void testReplacementOfRefiningDiffs() throws IOException {
        Comparison comparison = ConflictsGroupTest.getComparison((ResourceScopeProvider)new UMLConflictWithRefiningDiffInputData());
        ECrossReferenceAdapter crossReferenceAdapter = new ECrossReferenceAdapter(){

            protected boolean isIncluded(EReference eReference) {
                return eReference == TreePackage.Literals.TREE_NODE__DATA;
            }
        };
        ThreeWayComparisonGroupProvider.ConflictsGroupImpl conflictsGroup = new ThreeWayComparisonGroupProvider.ConflictsGroupImpl(comparison, EMFComparePredicates.hasConflict((ConflictKind[])new ConflictKind[]{ConflictKind.REAL, ConflictKind.PSEUDO}), EMFCompareRCPUIMessages.getString((String)"ThreeWayComparisonGroupProvider.conflicts.label"), crossReferenceAdapter);
        conflictsGroup.buildSubTree();
        List conflictNodes = conflictsGroup.getChildren();
        Assert.assertEquals((long)1L, (long)conflictNodes.size());
        ConflictNode conflictNode = (ConflictNode)conflictNodes.get(0);
        EList matchNodes = conflictNode.getChildren();
        Assert.assertEquals((long)1L, (long)matchNodes.size());
        MatchNode matchNode = (MatchNode)matchNodes.get(0);
        this.checkText((TreeNode)matchNode, "Opaque Action OpaqueAction");
        EList diffNodes = matchNode.getChildren();
        Assert.assertEquals((long)2L, (long)diffNodes.size());
        DiffNode diffNodeDeletion = (DiffNode)diffNodes.get(0);
        this.checkText((TreeNode)diffNodeDeletion, "Opaque Action OpaqueAction [ownedNode delete]");
        Assert.assertEquals((long)0L, (long)diffNodeDeletion.getChildren().size());
        DiffNode diffNodeChange = (DiffNode)diffNodes.get(1);
        this.checkText((TreeNode)diffNodeChange, "Opaque Element Body Change Natural language");
        EList diffNodeChildren = diffNodeChange.getChildren();
        Assert.assertEquals((long)2L, (long)diffNodeChildren.size());
        DiffNode diffNodeBodyAdd = (DiffNode)diffNodeChildren.get(0);
        this.checkText((TreeNode)diffNodeBodyAdd, "This is a natural language definition of Opaque... [body add]");
        Assert.assertEquals((long)0L, (long)diffNodeBodyAdd.getChildren().size());
        DiffNode diffNodeLanguageAdd = (DiffNode)diffNodeChildren.get(1);
        this.checkText((TreeNode)diffNodeLanguageAdd, "Natural language [language add]");
        Assert.assertEquals((long)0L, (long)diffNodeLanguageAdd.getChildren().size());
    }

    @Test
    public void testJoiningConflictsWithOverlappingDiffs() throws IOException {
        Comparison comparison = ConflictsGroupTest.getComparison((ResourceScopeProvider)new UMLJoiningConflictsWithOverlappingDiffsInputData());
        ECrossReferenceAdapter crossReferenceAdapter = new ECrossReferenceAdapter(){

            protected boolean isIncluded(EReference eReference) {
                return eReference == TreePackage.Literals.TREE_NODE__DATA;
            }
        };
        ThreeWayComparisonGroupProvider.ConflictsGroupImpl conflictsGroup = new ThreeWayComparisonGroupProvider.ConflictsGroupImpl(comparison, EMFComparePredicates.hasConflict((ConflictKind[])new ConflictKind[]{ConflictKind.REAL, ConflictKind.PSEUDO}), EMFCompareRCPUIMessages.getString((String)"ThreeWayComparisonGroupProvider.conflicts.label"), crossReferenceAdapter);
        conflictsGroup.buildSubTree();
        List conflictNodes = conflictsGroup.getChildren();
        Assert.assertEquals((long)1L, (long)conflictNodes.size());
        ConflictNode conflictNode = (ConflictNode)conflictNodes.get(0);
        Conflict conflict = conflictNode.getConflict();
        Assert.assertTrue((boolean)(conflict instanceof ThreeWayComparisonGroupProvider.CompositeConflict));
        ThreeWayComparisonGroupProvider.CompositeConflict compositeConflict = (ThreeWayComparisonGroupProvider.CompositeConflict)conflict;
        Assert.assertEquals((long)2L, (long)compositeConflict.getConflicts().size());
        EList matchNodes = conflictNode.getChildren();
        Assert.assertEquals((long)2L, (long)matchNodes.size());
        MatchNode matchNodeAssociation = (MatchNode)matchNodes.get(0);
        this.checkText((TreeNode)matchNodeAssociation, "Association");
        MatchNode matchNodePropertyClass1 = (MatchNode)matchNodes.get(1);
        this.checkText((TreeNode)matchNodePropertyClass1, "Property class2_");
        EList childrenMatchNodeAssociation = matchNodeAssociation.getChildren();
        Assert.assertEquals((long)2L, (long)childrenMatchNodeAssociation.size());
        DiffNode diffNodeDeletion = (DiffNode)childrenMatchNodeAssociation.get(0);
        this.checkText((TreeNode)diffNodeDeletion, "Association Change DELETE");
        Assert.assertTrue((diffNodeDeletion.getChildren().size() > 0 ? 1 : 0) != 0);
        MatchNode matchNodePropertyAssociation = (MatchNode)childrenMatchNodeAssociation.get(1);
        this.checkText((TreeNode)matchNodePropertyAssociation, "Property class1_");
        EList childrenMatchNodePropertyAssociation = matchNodePropertyAssociation.getChildren();
        Assert.assertEquals((long)1L, (long)childrenMatchNodePropertyAssociation.size());
        DiffNode diffNodeUpdatePropertyAssociation = (DiffNode)childrenMatchNodePropertyAssociation.get(0);
        this.checkText((TreeNode)diffNodeUpdatePropertyAssociation, "class1_ [name set]");
        Assert.assertEquals((long)0L, (long)diffNodeUpdatePropertyAssociation.getChildren().size());
        EList childrenMatchNodePropertyClass1 = matchNodePropertyClass1.getChildren();
        Assert.assertEquals((long)1L, (long)childrenMatchNodePropertyClass1.size());
        DiffNode diffNodeUpdatePropertyClass1 = (DiffNode)childrenMatchNodePropertyClass1.get(0);
        this.checkText((TreeNode)diffNodeUpdatePropertyClass1, "class2_ [name set]");
        Assert.assertEquals((long)0L, (long)diffNodeUpdatePropertyClass1.getChildren().size());
    }

    protected void checkText(TreeNode childNode, String expected) {
        Assert.assertEquals((Object)expected, (Object)this.itemDelegator.getText((Object)childNode));
    }
}

