/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.tests.framework;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIPlugin;
import org.eclipse.emf.compare.ide.ui.tests.framework.EMFCompareTestConfiguration;
import org.eclipse.emf.compare.ide.ui.tests.framework.ResolutionStrategyID;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;

public abstract class AbstractCompareStatement
extends Statement {
    private static final String EXTENSION_POINT_CLASS_SELECTOR = "impl";
    private static final String EXTENSION_POINT_ID_SELECTOR = "id";
    private static final String PREFERENCES_SEPARATOR = ";";
    private static final String ID_SEPARATOR = ".";
    private static final String DIFF_EXTENSION_POINT_ID = "org.eclipse.emf.compare.rcp.diffEngine";
    private static final String EQ_EXTENSION_POINT_ID = "org.eclipse.emf.compare.rcp.equiEngine";
    private static final String REQ_EXTENSION_POINT_ID = "org.eclipse.emf.compare.rcp.reqEngine";
    private static final String CONFLICT_EXTENSION_POINT_ID = "org.eclipse.emf.compare.rcp.conflictsDetector";
    private static final List<String> DEFAULT_DISABLED_MATCH_ENGINES = Collections.emptyList();
    private static final String DEFAULT_DIFF_ENGINE = "org.eclipse.emf.compare.rcp.default.diffEngine";
    private static final String DEFAULT_EQ_ENGINE = "org.eclipse.emf.compare.rcp.default.equiEngine";
    private static final String DEFAULT_REQ_ENGINE = "org.eclipse.emf.compare.rcp.default.reqEngine";
    private static final String DEFAULT_CONFLICT_DETECTOR = "org.eclipse.emf.compare.rcp.fast.conflictDetector";
    private static final List<String> DEFAULT_DISABLED_POST_PROCESSORS = Collections.emptyList();
    protected final Object testObject;
    protected final FrameworkMethod test;
    private final IPreferenceStore rcpPreferenceStore = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.eclipse.emf.compare.rcp");
    private final IPreferenceStore uiPreferenceStore = EMFCompareIDEUIPlugin.getDefault().getPreferenceStore();
    private final ResolutionStrategyID resolutionStrategy;
    private final Class<?>[] disabledMatchEngines;
    private final Class<?> diffEngine;
    private final Class<?> eqEngine;
    private final Class<?> reqEngine;
    private final Class<?> conflictDetector;
    private final Class<?>[] disabledPostProcessors;
    private String defaultResolutionStrategy = "WORKSPACE";

    public AbstractCompareStatement(Object testObject, FrameworkMethod test, ResolutionStrategyID resolutionStrategy, EMFCompareTestConfiguration configuration) {
        this.testObject = testObject;
        this.test = test;
        this.resolutionStrategy = resolutionStrategy;
        this.disabledMatchEngines = configuration.getDisabledMatchEngines();
        this.diffEngine = configuration.getDiffEngine();
        this.eqEngine = configuration.getEqEngine();
        this.reqEngine = configuration.getReqEngine();
        this.conflictDetector = configuration.getConflictDetector();
        this.disabledPostProcessors = configuration.getDisabledPostProcessors();
        this.setEMFComparePreferencesDefaults();
    }

    protected String normalizePath(String value) {
        if (value.startsWith("/")) {
            return value.substring(1, value.length());
        }
        if (value.startsWith("./")) {
            return value.substring(2, value.length());
        }
        return value;
    }

    private void setEMFComparePreferencesDefaults() {
        this.uiPreferenceStore.setDefault("org.eclipse.emf.compare.ide.ui.preference.resolutionScope", this.defaultResolutionStrategy);
        this.rcpPreferenceStore.setDefault("org.eclipse.emf.compare.preference.match.engine", this.join(DEFAULT_DISABLED_MATCH_ENGINES, PREFERENCES_SEPARATOR));
        this.rcpPreferenceStore.setDefault("org.eclipse.emf.compare.preference.diff.engine", DEFAULT_DIFF_ENGINE);
        this.rcpPreferenceStore.setDefault("org.eclipse.emf.compare.preference.equi.engine", DEFAULT_EQ_ENGINE);
        this.rcpPreferenceStore.setDefault("org.eclipse.emf.compare.preference.req.engine", DEFAULT_REQ_ENGINE);
        this.rcpPreferenceStore.setDefault("org.eclipse.emf.compare.preference.conflict.detector", DEFAULT_CONFLICT_DETECTOR);
        this.rcpPreferenceStore.setDefault("org.eclipse.emf.compare.preference.postprocessor.disabled", this.join(DEFAULT_DISABLED_POST_PROCESSORS, PREFERENCES_SEPARATOR));
    }

    protected void restoreEMFComparePreferences() {
        this.uiPreferenceStore.setToDefault("org.eclipse.emf.compare.ide.ui.preference.resolutionScope");
        this.rcpPreferenceStore.setToDefault("org.eclipse.emf.compare.preference.match.engine");
        this.rcpPreferenceStore.setToDefault("org.eclipse.emf.compare.preference.diff.engine");
        this.rcpPreferenceStore.setToDefault("org.eclipse.emf.compare.preference.equi.engine");
        this.rcpPreferenceStore.setToDefault("org.eclipse.emf.compare.preference.req.engine");
        this.rcpPreferenceStore.setToDefault("org.eclipse.emf.compare.preference.conflict.detector");
        this.rcpPreferenceStore.setToDefault("org.eclipse.emf.compare.preference.postprocessor.disabled");
    }

    protected void setEMFComparePreferences() {
        this.setResolutionStrategyPreference();
        this.setMatchPreference();
        this.setDiffPreference();
        this.setEqPreference();
        this.setReqPreference();
        this.setConflictPreference();
        this.setPostProcessorPreference();
    }

    private void setResolutionStrategyPreference() {
        this.defaultResolutionStrategy = this.uiPreferenceStore.getString("org.eclipse.emf.compare.ide.ui.preference.resolutionScope");
        this.uiPreferenceStore.setValue("org.eclipse.emf.compare.ide.ui.preference.resolutionScope", this.resolutionStrategy.name());
    }

    private void setMatchPreference() {
        List<String> matchEngineNames = Collections.emptyList();
        Class<?>[] classArray = this.disabledMatchEngines;
        int n = this.disabledMatchEngines.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> matchEngine = classArray[n2];
            matchEngineNames.add(matchEngine.getCanonicalName());
            ++n2;
        }
        this.rcpPreferenceStore.setValue("org.eclipse.emf.compare.preference.match.engine", this.join(matchEngineNames, PREFERENCES_SEPARATOR));
    }

    private void setDiffPreference() {
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint(DIFF_EXTENSION_POINT_ID);
        IExtension[] extensions = extensionPoint.getExtensions();
        String diffEngineId = null;
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension iExtension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement iConfig = iConfigurationElementArray[n4];
                if (iConfig.getAttribute(EXTENSION_POINT_CLASS_SELECTOR).equals(this.diffEngine.getCanonicalName())) {
                    diffEngineId = iConfig.getAttribute(EXTENSION_POINT_ID_SELECTOR);
                    break;
                }
                ++n4;
            }
            ++n2;
        }
        if (diffEngineId != null) {
            this.rcpPreferenceStore.setValue("org.eclipse.emf.compare.preference.diff.engine", diffEngineId);
        }
    }

    private void setEqPreference() {
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint(EQ_EXTENSION_POINT_ID);
        IExtension[] extensions = extensionPoint.getExtensions();
        String eqEngineId = null;
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension iExtension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement iConfig = iConfigurationElementArray[n4];
                if (iConfig.getAttribute(EXTENSION_POINT_CLASS_SELECTOR).equals(this.eqEngine.getCanonicalName())) {
                    eqEngineId = iConfig.getAttribute(EXTENSION_POINT_ID_SELECTOR);
                    break;
                }
                ++n4;
            }
            ++n2;
        }
        if (eqEngineId != null) {
            this.rcpPreferenceStore.setValue("org.eclipse.emf.compare.preference.equi.engine", eqEngineId);
        }
    }

    private void setReqPreference() {
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint(REQ_EXTENSION_POINT_ID);
        IExtension[] extensions = extensionPoint.getExtensions();
        String reqEngineId = null;
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension iExtension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement iConfig = iConfigurationElementArray[n4];
                if (iConfig.getAttribute(EXTENSION_POINT_CLASS_SELECTOR).equals(this.reqEngine.getCanonicalName())) {
                    reqEngineId = iConfig.getAttribute(EXTENSION_POINT_ID_SELECTOR);
                    break;
                }
                ++n4;
            }
            ++n2;
        }
        if (reqEngineId != null) {
            this.rcpPreferenceStore.setValue("org.eclipse.emf.compare.preference.req.engine", reqEngineId);
        }
    }

    private void setConflictPreference() {
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint(CONFLICT_EXTENSION_POINT_ID);
        IExtension[] extensions = extensionPoint.getExtensions();
        String conflictDetectorId = null;
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension iExtension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement iConfig = iConfigurationElementArray[n4];
                if (iConfig.getAttribute(EXTENSION_POINT_CLASS_SELECTOR).equals(this.conflictDetector.getCanonicalName())) {
                    conflictDetectorId = iConfig.getAttribute(EXTENSION_POINT_ID_SELECTOR);
                    break;
                }
                ++n4;
            }
            ++n2;
        }
        if (conflictDetectorId != null) {
            this.rcpPreferenceStore.setValue("org.eclipse.emf.compare.preference.conflict.detector", conflictDetectorId);
        }
    }

    private void setPostProcessorPreference() {
        List<String> postProcessorNames = Collections.emptyList();
        Class<?>[] classArray = this.disabledPostProcessors;
        int n = this.disabledPostProcessors.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> postProcessor = classArray[n2];
            postProcessorNames.add(postProcessor.getCanonicalName());
            ++n2;
        }
        this.rcpPreferenceStore.setValue("org.eclipse.emf.compare.preference.postprocessor.disabled", this.join(postProcessorNames, PREFERENCES_SEPARATOR));
    }

    private String join(Collection<String> parts, String separator) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        int lastIndex = parts.size() - 1;
        for (String part : parts) {
            sb.append(part);
            if (i == lastIndex - 1) {
                sb.append(separator);
            } else if (i != lastIndex) {
                sb.append(separator);
            }
            ++i;
        }
        return sb.toString();
    }
}

