/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.match.eobject;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.emf.compare.match.eobject.EqualityHelperExtensionProvider;
import org.eclipse.emf.ecore.EPackage;

public class EqualityHelperExtensionProviderDescriptorRegistryImpl
implements EqualityHelperExtensionProvider.Descriptor.Registry {
    private final Map<String, EqualityHelperExtensionProvider.Descriptor> equalityHelperExtensionProviderDescriptors = Maps.newHashMap();
    private final Map<String, EqualityHelperExtensionProvider> cache = Maps.newHashMap();

    public static EqualityHelperExtensionProvider.Descriptor.Registry createStandaloneInstance() {
        EqualityHelperExtensionProviderDescriptorRegistryImpl registry = new EqualityHelperExtensionProviderDescriptorRegistryImpl();
        return registry;
    }

    @Override
    public EqualityHelperExtensionProvider.Descriptor put(String key, EqualityHelperExtensionProvider.Descriptor equalityHelperExtensionProvider) {
        this.cache.clear();
        return this.equalityHelperExtensionProviderDescriptors.put(key, equalityHelperExtensionProvider);
    }

    @Override
    public void clear() {
        this.equalityHelperExtensionProviderDescriptors.clear();
        this.cache.clear();
    }

    public ImmutableList<EqualityHelperExtensionProvider.Descriptor> getDescriptors() {
        return ImmutableList.copyOf(this.equalityHelperExtensionProviderDescriptors.values());
    }

    @Override
    public EqualityHelperExtensionProvider.Descriptor remove(String key) {
        this.cache.clear();
        return this.equalityHelperExtensionProviderDescriptors.remove(key);
    }

    @Override
    public EqualityHelperExtensionProvider getHighestRankingEqualityHelperExtensionProvider(EPackage ePackage) {
        EqualityHelperExtensionProvider.Descriptor highestRankingEqualityHelperExtensionProviderDescriptor;
        EqualityHelperExtensionProvider equalityHelperExtensionProvider = this.cache.get(ePackage.getNsURI());
        if (equalityHelperExtensionProvider == null && (highestRankingEqualityHelperExtensionProviderDescriptor = this.getHighestRankingEqualityHelperExtensionProviderDescriptor(ePackage.getNsURI())) != null) {
            equalityHelperExtensionProvider = highestRankingEqualityHelperExtensionProviderDescriptor.getEqualityHelperExtensionProvider();
            this.cache.put(ePackage.getNsURI(), equalityHelperExtensionProvider);
        }
        return equalityHelperExtensionProvider;
    }

    public ImmutableList<EqualityHelperExtensionProvider> getEqualityHelperExtensionProviders(EPackage ePackage) {
        ImmutableList.Builder equalityHelperExtensionProvidersBuilder = ImmutableList.builder();
        for (EqualityHelperExtensionProvider.Descriptor descriptor : this.getEqualityHelperExtensionProviderDescriptors(ePackage)) {
            equalityHelperExtensionProvidersBuilder.add((Object)descriptor.getEqualityHelperExtensionProvider());
        }
        return equalityHelperExtensionProvidersBuilder.build();
    }

    private ImmutableList<EqualityHelperExtensionProvider.Descriptor> getEqualityHelperExtensionProviderDescriptors(EPackage ePackage) {
        return this.getEqualityHelperExtensionProviderDescriptors(ePackage.getNsURI());
    }

    private ImmutableList<EqualityHelperExtensionProvider.Descriptor> getEqualityHelperExtensionProviderDescriptors(String nsURI) {
        ImmutableList.Builder equalityHelperExtensionProvidersBuilder = ImmutableList.builder();
        for (EqualityHelperExtensionProvider.Descriptor descriptor : this.getDescriptors()) {
            Pattern nsURIPattern = descriptor.getNsURI();
            if (nsURIPattern == null || !nsURIPattern.matcher(nsURI).matches()) continue;
            equalityHelperExtensionProvidersBuilder.add((Object)descriptor);
        }
        return equalityHelperExtensionProvidersBuilder.build();
    }

    private EqualityHelperExtensionProvider.Descriptor getHighestRankingEqualityHelperExtensionProviderDescriptor(String nsURI) {
        EqualityHelperExtensionProvider.Descriptor ret = null;
        UnmodifiableIterator descriptors = this.getEqualityHelperExtensionProviderDescriptors(nsURI).iterator();
        if (descriptors.hasNext()) {
            EqualityHelperExtensionProvider.Descriptor highestRanking = (EqualityHelperExtensionProvider.Descriptor)descriptors.next();
            while (descriptors.hasNext()) {
                EqualityHelperExtensionProvider.Descriptor desc = (EqualityHelperExtensionProvider.Descriptor)descriptors.next();
                if (desc.getRanking() <= highestRanking.getRanking()) continue;
                highestRanking = desc;
            }
            ret = highestRanking;
        }
        return ret;
    }
}

