/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.text;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableSet;
import com.google.common.eventbus.Subscribe;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.EventObject;
import java.util.ResourceBundle;
import java.util.Set;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareNavigator;
import org.eclipse.compare.ICompareNavigator;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.contentmergeviewer.IMergeViewerContentProvider;
import org.eclipse.compare.contentmergeviewer.TextMergeViewer;
import org.eclipse.compare.internal.CompareHandlerService;
import org.eclipse.compare.internal.MergeSourceViewer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Conflict;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.command.ICompareCommandStack;
import org.eclipse.emf.compare.command.ICompareCopyCommand;
import org.eclipse.emf.compare.domain.ICompareEditingDomain;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIPlugin;
import org.eclipse.emf.compare.ide.ui.internal.configuration.EMFCompareConfiguration;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.EMFCompareContentMergeViewerResourceBundle;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.text.EMFCompareTextMergeViewerContentProvider;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.util.DynamicObject;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.util.RedoAction;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.util.UndoAction;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.CompareInputAdapter;
import org.eclipse.emf.compare.ide.ui.mergeresolution.MergeResolutionManager;
import org.eclipse.emf.compare.internal.utils.ComparisonUtil;
import org.eclipse.emf.compare.rcp.ui.internal.configuration.ICompareEditingDomainChange;
import org.eclipse.emf.compare.rcp.ui.internal.contentmergeviewer.IModelUpdateStrategy;
import org.eclipse.emf.compare.rcp.ui.internal.util.SWTUtil;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.IMergeViewer;
import org.eclipse.emf.compare.utils.IEqualityHelper;
import org.eclipse.emf.edit.command.ChangeCommand;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.actions.ActionFactory;

public class EMFCompareTextMergeViewer
extends TextMergeViewer
implements CommandStackListener {
    private static final String BUNDLE_NAME = EMFCompareTextMergeViewer.class.getName();
    private DynamicObject fDynamicObject;
    private UndoAction fUndoAction;
    private RedoAction fRedoAction;
    private MergeResolutionManager mergeResolutionManager;

    public EMFCompareTextMergeViewer(Composite parent, EMFCompareConfiguration configuration) {
        super(parent, (CompareConfiguration)configuration);
        this.setContentProvider((IContentProvider)new EMFCompareTextMergeViewerContentProvider(configuration));
        this.editingDomainChange(null, configuration.getEditingDomain());
        configuration.getEventBus().register((Object)this);
        this.mergeResolutionManager = new MergeResolutionManager(EMFCompareIDEUIPlugin.getDefault().getMergeResolutionListenerRegistry());
    }

    @Subscribe
    public void editingDomainChange(ICompareEditingDomainChange event) {
        ICompareEditingDomain oldValue = event.getOldValue();
        ICompareEditingDomain newValue = event.getNewValue();
        this.editingDomainChange(oldValue, newValue);
    }

    public void editingDomainChange(ICompareEditingDomain oldValue, ICompareEditingDomain newValue) {
        ICompareCommandStack commandStack;
        if (oldValue != null) {
            commandStack = oldValue.getCommandStack();
            commandStack.removeCommandStackListener((CommandStackListener)this);
        }
        if (newValue != oldValue) {
            if (newValue != null) {
                commandStack = newValue.getCommandStack();
                commandStack.addCommandStackListener((CommandStackListener)this);
                this.setLeftDirty(commandStack.isLeftSaveNeeded());
                this.setRightDirty(commandStack.isRightSaveNeeded());
            }
            if (this.fUndoAction != null) {
                this.fUndoAction.setEditingDomain(newValue);
            }
            if (this.fRedoAction != null) {
                this.fRedoAction.setEditingDomain(newValue);
            }
        }
    }

    public void commandStackChanged(EventObject event) {
        if (this.fUndoAction != null) {
            this.fUndoAction.update();
        }
        if (this.fRedoAction != null) {
            this.fRedoAction.update();
        }
        if (this.getCompareConfiguration().getEditingDomain() != null) {
            ICompareCommandStack commandStack = this.getCompareConfiguration().getEditingDomain().getCommandStack();
            this.setLeftDirty(commandStack.isLeftSaveNeeded());
            this.setRightDirty(commandStack.isRightSaveNeeded());
        }
        IMergeViewerContentProvider contentProvider = (IMergeViewerContentProvider)this.getContentProvider();
        final String leftValueFromModel = this.getString((IStreamContentAccessor)contentProvider.getLeftContent(this.getInput()));
        final String rightValueFromModel = this.getString((IStreamContentAccessor)contentProvider.getRightContent(this.getInput()));
        SWTUtil.safeAsyncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                String leftValueFromWidget = EMFCompareTextMergeViewer.this.getContents(true, Charsets.UTF_8.name());
                String rightValueFromWidget = EMFCompareTextMergeViewer.this.getContents(false, Charsets.UTF_8.name());
                IEqualityHelper equalityHelper = EMFCompareTextMergeViewer.this.getCompareConfiguration().getComparison().getEqualityHelper();
                if (!equalityHelper.matchingAttributeValues((Object)leftValueFromModel, (Object)leftValueFromWidget) || !equalityHelper.matchingAttributeValues((Object)rightValueFromModel, (Object)rightValueFromWidget)) {
                    EMFCompareTextMergeViewer.this.refresh();
                }
            }
        });
    }

    private String getString(IStreamContentAccessor contentAccessor) {
        String ret = null;
        if (contentAccessor != null) {
            try {
                Throwable throwable = null;
                Object var4_5 = null;
                try (InputStream content = contentAccessor.getContents();){
                    ret = new String(ByteStreams.toByteArray((InputStream)content), Charsets.UTF_8.name());
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException | CoreException throwable) {}
        }
        return ret;
    }

    protected EMFCompareConfiguration getCompareConfiguration() {
        return (EMFCompareConfiguration)super.getCompareConfiguration();
    }

    protected boolean doSave(Object newInput, Object oldInput) {
        return false;
    }

    protected String getContents(boolean isLeft, String charsetName) {
        try {
            return new String(this.getContents(isLeft), charsetName);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public DynamicObject getDynamicObject() {
        if (this.fDynamicObject == null) {
            this.fDynamicObject = new DynamicObject((Object)this);
        }
        return this.fDynamicObject;
    }

    protected final MergeSourceViewer getAncestorSourceViewer() {
        return (MergeSourceViewer)this.getDynamicObject().get("fAncestor");
    }

    protected final MergeSourceViewer getLeftSourceViewer() {
        return (MergeSourceViewer)this.getDynamicObject().get("fLeft");
    }

    protected final MergeSourceViewer getRightSourceViewer() {
        return (MergeSourceViewer)this.getDynamicObject().get("fRight");
    }

    protected final CompareHandlerService getHandlerService() {
        return (CompareHandlerService)this.getDynamicObject().get("fHandlerService");
    }

    protected final void setHandlerService(CompareHandlerService service) {
        this.getDynamicObject().set("fHandlerService", service);
    }

    protected void createControls(Composite composite) {
        super.createControls(composite);
        this.attachListeners(this.getAncestorSourceViewer(), IMergeViewer.MergeViewerSide.ANCESTOR);
        this.attachListeners(this.getLeftSourceViewer(), IMergeViewer.MergeViewerSide.LEFT);
        this.attachListeners(this.getRightSourceViewer(), IMergeViewer.MergeViewerSide.RIGHT);
    }

    protected void attachListeners(MergeSourceViewer viewer, IMergeViewer.MergeViewerSide side) {
        if (viewer != null && (side == IMergeViewer.MergeViewerSide.LEFT || side == IMergeViewer.MergeViewerSide.RIGHT)) {
            StyledText textWidget = viewer.getSourceViewer().getTextWidget();
            textWidget.addFocusListener(new FocusListener(){

                public void focusLost(FocusEvent e) {
                    EMFCompareTextMergeViewer.this.getHandlerService().setGlobalActionHandler(ActionFactory.UNDO.getId(), null);
                    EMFCompareTextMergeViewer.this.getHandlerService().setGlobalActionHandler(ActionFactory.REDO.getId(), null);
                }

                public void focusGained(FocusEvent e) {
                    EMFCompareTextMergeViewer.this.getHandlerService().setGlobalActionHandler(ActionFactory.UNDO.getId(), (IAction)EMFCompareTextMergeViewer.this.fUndoAction);
                    EMFCompareTextMergeViewer.this.getHandlerService().setGlobalActionHandler(ActionFactory.REDO.getId(), (IAction)EMFCompareTextMergeViewer.this.fRedoAction);
                }
            });
            viewer.getSourceViewer().addTextListener(new ITextListener(){

                public void textChanged(TextEvent event) {
                    Object oldInput = EMFCompareTextMergeViewer.this.getInput();
                    if (event.getDocumentEvent() != null && EMFCompareTextMergeViewer.this.isCompareInputAdapterHoldingDiff(oldInput)) {
                        CompareInputAdapter inputAdapter = (CompareInputAdapter)((Object)oldInput);
                        IModelUpdateStrategy modelUpdateStrategy = inputAdapter.getModelUpdateStrategy();
                        Diff diff = (Diff)inputAdapter.getComparisonObject();
                        EMFCompareTextMergeViewer.this.updateModel(diff, modelUpdateStrategy, IMergeViewer.MergeViewerSide.LEFT);
                        EMFCompareTextMergeViewer.this.updateModel(diff, modelUpdateStrategy, IMergeViewer.MergeViewerSide.RIGHT);
                    }
                }
            });
        }
    }

    private boolean isCompareInputAdapterHoldingDiff(Object input) {
        return input instanceof CompareInputAdapter && ((CompareInputAdapter)((Object)input)).getComparisonObject() != null && ((CompareInputAdapter)((Object)input)).getComparisonObject() instanceof Diff;
    }

    private void updateModel(Diff diff, IModelUpdateStrategy modelUpdateStrategy, IMergeViewer.MergeViewerSide side) {
        if (this.isEditable(side) && modelUpdateStrategy.canUpdate(diff, side)) {
            String newValue = this.getCurrentValueFromViewer(side);
            Command updateCmd = modelUpdateStrategy.getModelUpdateCommand(diff, (Object)newValue, side);
            RejectAffectedDiffCommand rejectDiffsCmd = new RejectAffectedDiffCommand(diff);
            CompoundCompareCommand compoundCmd = this.createCompoundCompareCommand(side, new Command[]{updateCmd, rejectDiffsCmd});
            this.getCompareConfiguration().getEditingDomain().getCommandStack().execute((Command)compoundCmd);
        }
    }

    private boolean isEditable(IMergeViewer.MergeViewerSide side) {
        boolean isLeft = IMergeViewer.MergeViewerSide.LEFT.equals((Object)side);
        return this.getCompareConfiguration().isEditable(isLeft);
    }

    private String getCurrentValueFromViewer(IMergeViewer.MergeViewerSide side) {
        boolean isLeft = IMergeViewer.MergeViewerSide.LEFT.equals((Object)side);
        GetContentRunnable runnable = new GetContentRunnable(isLeft);
        Display.getDefault().syncExec((Runnable)runnable);
        return (String)runnable.getResult();
    }

    private CompoundCompareCommand createCompoundCompareCommand(IMergeViewer.MergeViewerSide side, Command ... commands) {
        CompoundCompareCommand compoundCommand = new CompoundCompareCommand(side);
        Command[] commandArray = commands;
        int n = commands.length;
        int n2 = 0;
        while (n2 < n) {
            Command command = commandArray[n2];
            compoundCommand.append(command);
            ++n2;
        }
        return compoundCommand;
    }

    protected void createToolItems(ToolBarManager toolBarManager) {
        super.createToolItems(toolBarManager);
        this.fRedoAction = new RedoAction(this.getCompareConfiguration().getEditingDomain());
        this.fUndoAction = new UndoAction(this.getCompareConfiguration().getEditingDomain());
        this.getHandlerService().setGlobalActionHandler(ActionFactory.UNDO.getId(), (IAction)this.fUndoAction);
        this.getHandlerService().setGlobalActionHandler(ActionFactory.REDO.getId(), (IAction)this.fRedoAction);
    }

    protected void endOfContentReached(boolean next) {
        ICompareNavigator navigator;
        Control control = this.getControl();
        if (control != null && !control.isDisposed() && (navigator = this.getCompareConfiguration().getContainer().getNavigator()) instanceof CompareNavigator && ((CompareNavigator)navigator).hasChange(next)) {
            navigator.selectChange(next);
        }
    }

    protected void navigate(boolean next) {
        ICompareNavigator navigator;
        Control control = this.getControl();
        if (control != null && !control.isDisposed() && (navigator = this.getCompareConfiguration().getContainer().getNavigator()) instanceof CompareNavigator && ((CompareNavigator)navigator).hasChange(next)) {
            navigator.selectChange(next);
        }
    }

    protected ResourceBundle getResourceBundle() {
        return new EMFCompareContentMergeViewerResourceBundle(ResourceBundle.getBundle(BUNDLE_NAME));
    }

    protected void handleDispose(DisposeEvent event) {
        this.getCompareConfiguration().getEventBus().unregister((Object)this);
        this.editingDomainChange(this.getCompareConfiguration().getEditingDomain(), null);
        this.fRedoAction = null;
        this.fUndoAction = null;
        super.handleDispose(event);
    }

    protected void flushContent(Object oldInput, IProgressMonitor monitor) {
        super.flushContent(oldInput, monitor);
        this.mergeResolutionManager.handleFlush(oldInput);
    }

    private static class CompoundCompareCommand
    extends CompoundCommand
    implements ICompareCopyCommand {
        private IMergeViewer.MergeViewerSide side;

        public CompoundCompareCommand(IMergeViewer.MergeViewerSide side) {
            this.side = side;
        }

        public boolean isLeftToRight() {
            return !IMergeViewer.MergeViewerSide.LEFT.equals((Object)this.side);
        }
    }

    private final class GetContentRunnable
    implements Runnable {
        private final boolean isLeft;
        private String result;

        private GetContentRunnable(boolean isLeft) {
            this.isLeft = isLeft;
        }

        @Override
        public void run() {
            this.result = EMFCompareTextMergeViewer.this.getContents(this.isLeft, Charsets.UTF_8.name());
        }

        public Object getResult() {
            return this.result;
        }
    }

    private static class RejectAffectedDiffCommand
    extends ChangeCommand {
        private Diff difference;

        public RejectAffectedDiffCommand(Diff difference) {
            super((Collection)ImmutableSet.builder().addAll(RejectAffectedDiffCommand.getAffectedDiff(difference)).build());
            this.difference = difference;
        }

        public void doExecute() {
            for (Diff affectedDiff : RejectAffectedDiffCommand.getAffectedDiff(this.difference)) {
                affectedDiff.setState(DifferenceState.DISCARDED);
            }
        }

        private static Set<Diff> getAffectedDiff(Diff diff) {
            EList conflicts = ComparisonUtil.getComparison((Diff)diff).getConflicts();
            for (Conflict conflict : conflicts) {
                EList conflictualDifferences = conflict.getDifferences();
                if (!conflictualDifferences.contains((Object)diff)) continue;
                return ImmutableSet.copyOf((Collection)conflictualDifferences);
            }
            return ImmutableSet.of((Object)diff);
        }
    }
}

