/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.logical.resolver;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.CachingImplicitDependencies;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.DiagnosticSupport;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.IImplicitDependencies;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.IResolutionContext;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.ResolutionUtil;
import org.eclipse.emf.compare.ide.utils.ResourceUtil;
import org.eclipse.emf.ecore.resource.URIConverter;

public abstract class AbstractResolution {
    protected final IResolutionContext context;
    protected final SubMonitor monitor;
    protected DiagnosticSupport diagnostic;
    protected final Logger logger = Logger.getLogger(this.getClass());
    protected IImplicitDependencies implicitDependencies;

    public AbstractResolution(IResolutionContext context, IProgressMonitor monitor) {
        this.context = (IResolutionContext)Preconditions.checkNotNull((Object)context);
        this.monitor = SubMonitor.convert((IProgressMonitor)monitor, (int)this.getTicks());
    }

    protected IImplicitDependencies getImplicitDependencies() {
        if (this.implicitDependencies == null) {
            this.implicitDependencies = new CachingImplicitDependencies(this.context.getImplicitDependencies());
        }
        return this.implicitDependencies;
    }

    protected int getTicks() {
        return 100;
    }

    protected <T> T call(Callable<T> callable) {
        this.diagnostic = new DiagnosticSupport();
        return this.context.getScheduler().call(callable, this.getFinalizeResolvingRunnable());
    }

    protected Runnable getFinalizeResolvingRunnable() {
        return new Runnable(){

            @Override
            public void run() {
                AbstractResolution.this.diagnostic.getDiagnostic().getSeverity();
                AbstractResolution.this.diagnostic = null;
            }
        };
    }

    protected Set<URI> asURISet(Set<IStorage> storages) {
        LinkedHashSet<URI> uris = new LinkedHashSet<URI>();
        for (IStorage storage : storages) {
            uris.add((URI)ResourceUtil.asURI().apply((Object)storage));
        }
        return uris;
    }

    protected Set<IStorage> resolveTraversal(IFile file, Set<URI> bounds) {
        LinkedHashSet traversalSet = Sets.newLinkedHashSet();
        LinkedHashSet filesToAdd = Sets.newLinkedHashSet();
        filesToAdd.add(file);
        LinkedHashSet knownURIs = Sets.newLinkedHashSet();
        while (!filesToAdd.isEmpty()) {
            LinkedHashSet filesToResolve = Sets.newLinkedHashSet();
            for (IFile newFile : filesToAdd) {
                URI baseUri = ResourceUtil.createURIFor((IFile)newFile);
                Set<URI> newURIs = this.getImplicitDependencies().of(baseUri, URIConverter.INSTANCE);
                for (URI uri : newURIs) {
                    if (!knownURIs.add(uri)) continue;
                    IFile toResolve = ResolutionUtil.getFileAt(uri);
                    Iterable<URI> dependencies = this.context.getDependencyProvider().getDependenciesOf(toResolve, bounds);
                    for (URI dep : dependencies) {
                        IFile dependentFile = ResolutionUtil.getFileAt(dep);
                        if (dependentFile != null && traversalSet.add(dependentFile) && !knownURIs.contains(dep)) {
                            filesToResolve.add(dependentFile);
                        }
                        if (!this.monitor.isCanceled()) continue;
                        throw new OperationCanceledException();
                    }
                }
            }
            filesToAdd.clear();
            filesToAdd = filesToResolve;
        }
        return traversalSet;
    }
}

