/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.internal;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.compare.internal.dmp.LineBasedDiff;
import org.eclipse.emf.compare.internal.dmp.diff_match_patch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreeWayTextDiff {
    private final boolean isLeftOrRightUnset;
    private final List<ThreeWayLineDifference> threeWayDifferences;
    private ConflictState conflictState = ConflictState.UNKNOWN;
    private String lineSeparator = "\n";
    private String merged;

    public ThreeWayTextDiff(String origin, String left, String right) {
        this.lineSeparator = this.determineLineSeparator(origin);
        this.isLeftOrRightUnset = origin != null && (left == null || right == null);
        this.threeWayDifferences = this.computeThreeWayDiffs(origin, left, right);
    }

    /*
     * Exception decompiling
     */
    private String determineLineSeparator(String string) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[DOLOOP]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private List<ThreeWayLineDifference> computeThreeWayDiffs(String origin, String left, String right) {
        TwoWayTextDiff leftDiffs = new TwoWayTextDiff(origin, left);
        TwoWayTextDiff rightDiffs = new TwoWayTextDiff(origin, right);
        LinkedList<ThreeWayLineDifference> threeWayDiffs = new LinkedList<ThreeWayLineDifference>();
        try {
            String originLine;
            LinkedList<diff_match_patch.Diff> leftDiffQueue = new LinkedList<diff_match_patch.Diff>(leftDiffs.getDifferences());
            LinkedList<diff_match_patch.Diff> rightDiffQueue = new LinkedList<diff_match_patch.Diff>(rightDiffs.getDifferences());
            BufferedReader originReader = this.createBufferedReader(this.nullToEmpty(origin));
            while ((originLine = originReader.readLine()) != null) {
                List<diff_match_patch.Diff> leftRange = this.collectDifferenceRange(originLine, leftDiffQueue);
                List<diff_match_patch.Diff> rightRange = this.collectDifferenceRange(originLine, rightDiffQueue);
                threeWayDiffs.add(new ThreeWayLineDifference(leftRange, rightRange));
            }
            if (!leftDiffQueue.isEmpty() || !rightDiffQueue.isEmpty()) {
                threeWayDiffs.add(new ThreeWayLineDifference(leftDiffQueue, rightDiffQueue));
            }
            originReader.close();
        }
        catch (IOException iOException) {}
        return threeWayDiffs;
    }

    private List<diff_match_patch.Diff> collectDifferenceRange(String originLine, LinkedList<diff_match_patch.Diff> diffQueue) {
        LinkedList<diff_match_patch.Diff> diffs = new LinkedList<diff_match_patch.Diff>();
        diff_match_patch.Diff currentDiff = diffQueue.peek();
        boolean hitEqualsOriginLine = false;
        boolean hitDeleteOriginLine = false;
        while (currentDiff != null && !hitEqualsOriginLine && !hitDeleteOriginLine) {
            hitEqualsOriginLine = this.isEqualOfLine(currentDiff, originLine);
            hitDeleteOriginLine = this.isDeleteOfLine(currentDiff, originLine);
            diffs.add(diffQueue.poll());
            currentDiff = diffQueue.peek();
        }
        while (hitDeleteOriginLine && currentDiff != null && this.isInsert(currentDiff)) {
            diffs.add(diffQueue.poll());
            currentDiff = diffQueue.peek();
        }
        return diffs;
    }

    private boolean isEqualOfLine(diff_match_patch.Diff diff, String line) {
        return diff != null && this.isEqual(diff) && line.equals(diff.text);
    }

    private boolean isDeleteOfLine(diff_match_patch.Diff diff, String line) {
        return diff != null && this.isDelete(diff) && line.equals(diff.text);
    }

    private boolean isEqual(diff_match_patch.Diff diff) {
        return diff != null && diff_match_patch.Operation.EQUAL.equals((Object)diff.operation);
    }

    private boolean isDelete(diff_match_patch.Diff diff) {
        return diff != null && diff_match_patch.Operation.DELETE.equals((Object)diff.operation);
    }

    private boolean isInsert(diff_match_patch.Diff diff) {
        return diff != null && diff_match_patch.Operation.INSERT.equals((Object)diff.operation);
    }

    public boolean isConflicting() {
        if (ConflictState.UNKNOWN.equals((Object)this.conflictState)) {
            this.conflictState = this.computeConflictState();
        }
        return ConflictState.CONFLICTING.equals((Object)this.conflictState);
    }

    private ConflictState computeConflictState() {
        for (ThreeWayLineDifference threeWayDiff : this.threeWayDifferences) {
            if (!threeWayDiff.isConflicting()) continue;
            return ConflictState.CONFLICTING;
        }
        return ConflictState.NOT_CONFLICTING;
    }

    public String getMerged() {
        if (this.merged == null) {
            this.merged = this.computeMerged();
        }
        return this.merged;
    }

    private String computeMerged() {
        StringBuilder mergeBuilder = new StringBuilder();
        for (ThreeWayLineDifference threeWayLineDifference : this.threeWayDifferences) {
            mergeBuilder.append(threeWayLineDifference.getMerged());
        }
        return this.stripTrailingNewLine(this.nullIfUnset(mergeBuilder.toString()));
    }

    private String stripTrailingNewLine(String string) {
        if (string != null && string.endsWith(this.lineSeparator)) {
            return string.substring(0, string.length() - this.lineSeparator.length());
        }
        return string;
    }

    private BufferedReader createBufferedReader(String string) {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(string.getBytes());
        return new BufferedReader(new InputStreamReader(inputStream));
    }

    private String nullIfUnset(String mergeResult) {
        if (mergeResult.length() < 1 && this.isLeftOrRightUnset) {
            return null;
        }
        return mergeResult;
    }

    private String nullToEmpty(String text) {
        if (text == null) {
            return "";
        }
        return text;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ConflictState {
        UNKNOWN,
        CONFLICTING,
        NOT_CONFLICTING;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ThreeWayLineDifference {
        private final LinkedList<diff_match_patch.Diff> leftDiffs = new LinkedList();
        private final LinkedList<diff_match_patch.Diff> rightDiffs = new LinkedList();

        public ThreeWayLineDifference(List<diff_match_patch.Diff> leftDifferences, List<diff_match_patch.Diff> rightDifferences) {
            this.leftDiffs.addAll(leftDifferences);
            this.rightDiffs.addAll(rightDifferences);
        }

        public boolean isConflicting() {
            return this.isInsertInsertConflict() || this.isDeleteUpdateConflict() || this.isUpdateUpdateConflict();
        }

        private boolean isUpdateUpdateConflict() {
            List<diff_match_patch.Diff> leftInsertsAfterDelete = this.getAllInsertsAfterDelete(this.leftDiffs);
            List<diff_match_patch.Diff> rightsInsertsAfterDelete = this.getAllInsertsAfterDelete(this.rightDiffs);
            return this.containDifferentInserts(leftInsertsAfterDelete, rightsInsertsAfterDelete);
        }

        private boolean isInsertInsertConflict() {
            List<diff_match_patch.Diff> leftInsertsBeforeOriginLine = this.getAllInsertsBeforeEqualsOrDelete(this.leftDiffs);
            List<diff_match_patch.Diff> rightInsertsBeforeOriginLine = this.getAllInsertsBeforeEqualsOrDelete(this.rightDiffs);
            return this.containDifferentInserts(leftInsertsBeforeOriginLine, rightInsertsBeforeOriginLine);
        }

        private List<diff_match_patch.Diff> getAllInsertsBeforeEqualsOrDelete(LinkedList<diff_match_patch.Diff> diffs) {
            LinkedList<diff_match_patch.Diff> inserts = new LinkedList<diff_match_patch.Diff>();
            for (diff_match_patch.Diff diff : diffs) {
                if (ThreeWayTextDiff.this.isEqual(diff) || ThreeWayTextDiff.this.isDelete(diff)) break;
                if (!ThreeWayTextDiff.this.isInsert(diff)) continue;
                inserts.add(diff);
            }
            return inserts;
        }

        private List<diff_match_patch.Diff> getAllInsertsAfterDelete(LinkedList<diff_match_patch.Diff> diffs) {
            LinkedList<diff_match_patch.Diff> inserts = new LinkedList<diff_match_patch.Diff>();
            boolean hitDeleteOrigin = false;
            for (diff_match_patch.Diff diff : diffs) {
                if (hitDeleteOrigin && ThreeWayTextDiff.this.isInsert(diff)) {
                    inserts.add(diff);
                }
                if (!ThreeWayTextDiff.this.isDelete(diff)) continue;
                hitDeleteOrigin = true;
            }
            return inserts;
        }

        private boolean containDifferentInserts(List<diff_match_patch.Diff> leftInserts, List<diff_match_patch.Diff> rightInserts) {
            Iterator<diff_match_patch.Diff> leftDiffIterator = leftInserts.iterator();
            Iterator<diff_match_patch.Diff> rightDiffIterator = rightInserts.iterator();
            while (leftDiffIterator.hasNext() && rightDiffIterator.hasNext()) {
                diff_match_patch.Diff leftDiff = leftDiffIterator.next();
                diff_match_patch.Diff rightDiff = rightDiffIterator.next();
                if (leftDiff.text.equals(rightDiff.text)) continue;
                return true;
            }
            return false;
        }

        private boolean isDeleteUpdateConflict() {
            if ((this.leftDiffs.size() > 1 || this.rightDiffs.size() > 1) && ThreeWayTextDiff.this.isDelete(this.leftDiffs.peek()) && ThreeWayTextDiff.this.isDelete(this.rightDiffs.peek())) {
                Optional<diff_match_patch.Diff> leftInsert = this.getFirstInsert(this.leftDiffs);
                Optional<diff_match_patch.Diff> rightInsert = this.getFirstInsert(this.rightDiffs);
                return leftInsert.isPresent() && !rightInsert.isPresent() || !leftInsert.isPresent() && rightInsert.isPresent();
            }
            return false;
        }

        private Optional<diff_match_patch.Diff> getFirstInsert(LinkedList<diff_match_patch.Diff> diffs) {
            for (diff_match_patch.Diff diff : diffs) {
                if (!ThreeWayTextDiff.this.isInsert(diff)) continue;
                return Optional.of((Object)diff);
            }
            return Optional.absent();
        }

        public String getMerged() {
            StringBuilder stringBuilder = new StringBuilder();
            for (diff_match_patch.Diff diff : this.mergeDifferences()) {
                stringBuilder.append(String.valueOf(diff.text) + ThreeWayTextDiff.this.lineSeparator);
            }
            return stringBuilder.toString();
        }

        private Iterable<diff_match_patch.Diff> mergeDifferences() {
            LinkedList<diff_match_patch.Diff> secondaryDiffs;
            LinkedList<diff_match_patch.Diff> primaryDiffs;
            if (this.isRightPrimaryMergeSide()) {
                primaryDiffs = this.rightDiffs;
                secondaryDiffs = this.leftDiffs;
            } else {
                primaryDiffs = this.leftDiffs;
                secondaryDiffs = this.rightDiffs;
            }
            Iterable filteredPrimaryDiffs = Iterables.filter(primaryDiffs, this.isMergedAsPrimaryDiff(secondaryDiffs));
            Iterable filteredSecondaryDiffs = Iterables.filter(secondaryDiffs, this.isMergedAsSecondaryDiff(primaryDiffs));
            return Iterables.concat((Iterable)filteredPrimaryDiffs, (Iterable)filteredSecondaryDiffs);
        }

        private boolean isRightPrimaryMergeSide() {
            int noOfLeftInsertaions;
            int noOfRightInsertions = this.getAllInsertsBeforeEqualsOrDelete(this.rightDiffs).size();
            return noOfRightInsertions > (noOfLeftInsertaions = this.getAllInsertsBeforeEqualsOrDelete(this.leftDiffs).size());
        }

        private Predicate<diff_match_patch.Diff> isMergedAsSecondaryDiff(final LinkedList<diff_match_patch.Diff> primaryDiffs) {
            return new Predicate<diff_match_patch.Diff>(){

                public boolean apply(diff_match_patch.Diff input) {
                    return !ThreeWayTextDiff.this.isDelete(input) && !ThreeWayLineDifference.this.containsEqualOrOverridingDiff(primaryDiffs, input);
                }
            };
        }

        private Predicate<diff_match_patch.Diff> isMergedAsPrimaryDiff(final LinkedList<diff_match_patch.Diff> secondaryDiffs) {
            return new Predicate<diff_match_patch.Diff>(){

                public boolean apply(diff_match_patch.Diff input) {
                    return !ThreeWayTextDiff.this.isDelete(input) && !ThreeWayLineDifference.this.containsOverridingDiff(secondaryDiffs, input);
                }
            };
        }

        private boolean containsOverridingDiff(Iterable<diff_match_patch.Diff> diffs, diff_match_patch.Diff diff) {
            for (diff_match_patch.Diff currentDiff : diffs) {
                if (!this.isOverridingDiff(diff, currentDiff)) continue;
                return true;
            }
            return false;
        }

        private boolean containsEqualOrOverridingDiff(Iterable<diff_match_patch.Diff> diffs, diff_match_patch.Diff diff) {
            for (diff_match_patch.Diff currentDiff : diffs) {
                if (!currentDiff.equals(diff) && !this.isOverridingDiff(diff, currentDiff)) continue;
                return true;
            }
            return false;
        }

        private boolean isOverridingDiff(diff_match_patch.Diff diff, diff_match_patch.Diff overridingDiff) {
            return ThreeWayTextDiff.this.isEqual(diff) && ThreeWayTextDiff.this.isDelete(overridingDiff) && overridingDiff.text.equals(diff.text);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TwoWayTextDiff {
        private final LineBasedDiff lbDiff = new LineBasedDiff();
        private final LinkedList<diff_match_patch.Diff> diffs;

        public TwoWayTextDiff(String origin, String revised) {
            String safeOrigin = ThreeWayTextDiff.this.nullToEmpty(origin);
            String safeRevised = ThreeWayTextDiff.this.nullToEmpty(revised);
            LinkedList<diff_match_patch.Diff> differences = this.lbDiff.computeLineBasedDiff(safeOrigin, safeRevised);
            this.diffs = this.flattenDifferences(differences);
        }

        private LinkedList<diff_match_patch.Diff> flattenDifferences(LinkedList<diff_match_patch.Diff> differences) {
            LinkedList<diff_match_patch.Diff> flattenedDifferences = new LinkedList<diff_match_patch.Diff>();
            for (diff_match_patch.Diff diff : differences) {
                try {
                    String line;
                    BufferedReader reader = ThreeWayTextDiff.this.createBufferedReader(diff.text);
                    while ((line = reader.readLine()) != null) {
                        flattenedDifferences.add(new diff_match_patch.Diff(diff.operation, line));
                    }
                    reader.close();
                }
                catch (IOException iOException) {}
            }
            return flattenedDifferences;
        }

        public List<diff_match_patch.Diff> getDifferences() {
            return Collections.unmodifiableList(this.diffs);
        }
    }
}

