/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.internal.merge;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.internal.utils.Graph;
import org.eclipse.emf.compare.merge.IMerger;
import org.eclipse.emf.compare.merge.IMerger2;
import org.eclipse.emf.compare.utils.EMFComparePredicates;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MergeDependenciesUtil {
    private MergeDependenciesUtil() {
    }

    public static Graph<Diff> mapDifferences(Comparison comparison, IMerger.Registry mergerRegistry, boolean mergeRightToLeft) {
        Graph<Diff> differencesGraph = new Graph<Diff>();
        Predicate<? super Diff> filter = mergeRightToLeft ? EMFComparePredicates.fromSide(DifferenceSource.RIGHT) : EMFComparePredicates.fromSide(DifferenceSource.LEFT);
        for (Diff diff : Iterables.filter(comparison.getDifferences(), filter)) {
            IMerger merger = mergerRegistry.getHighestRankingMerger(diff);
            Set<Object> directParents = merger instanceof IMerger2 ? ((IMerger2)merger).getDirectMergeDependencies(diff, mergeRightToLeft) : Collections.emptySet();
            if (directParents.isEmpty()) {
                differencesGraph.add(diff);
                continue;
            }
            for (Diff diff2 : directParents) {
                differencesGraph.addChildren(diff2, Collections.singleton(diff));
            }
        }
        return differencesGraph;
    }

    public static Set<Diff> getAllResultingMerges(Diff diff, IMerger.Registry mergerRegistry, boolean mergeRightToLeft) {
        LinkedHashSet<Diff> resultingMerges = new LinkedHashSet<Diff>();
        resultingMerges.add(diff);
        Set<Diff> relations = MergeDependenciesUtil.internalGetResultingMerges(diff, mergerRegistry, mergeRightToLeft);
        Sets.SetView difference = Sets.difference(relations, resultingMerges);
        while (!difference.isEmpty()) {
            LinkedHashSet newRelations = new LinkedHashSet(difference);
            resultingMerges.addAll(newRelations);
            relations = new LinkedHashSet<Diff>();
            for (Diff newRelation : newRelations) {
                relations.addAll(MergeDependenciesUtil.internalGetResultingMerges(newRelation, mergerRegistry, mergeRightToLeft));
            }
            difference = Sets.difference(relations, resultingMerges);
        }
        return resultingMerges;
    }

    private static Set<Diff> internalGetResultingMerges(Diff diff, IMerger.Registry mergerRegistry, boolean mergeRightToLeft) {
        Set<Object> directImplications;
        Set<Object> directParents;
        IMerger merger = mergerRegistry.getHighestRankingMerger(diff);
        if (merger instanceof IMerger2) {
            directParents = ((IMerger2)merger).getDirectMergeDependencies(diff, mergeRightToLeft);
            directImplications = ((IMerger2)merger).getDirectResultingMerges(diff, mergeRightToLeft);
        } else {
            directParents = Collections.emptySet();
            directImplications = Collections.emptySet();
        }
        return Sets.newLinkedHashSet((Iterable)Sets.union(directParents, directImplications));
    }

    public static Set<Diff> getAllResultingRejections(Diff diff, IMerger.Registry mergerRegistry, boolean mergeRightToLeft) {
        LinkedHashSet<Diff> resultingRejections = new LinkedHashSet<Diff>();
        Set<Diff> allResultingMerges = MergeDependenciesUtil.getAllResultingMerges(diff, mergerRegistry, mergeRightToLeft);
        for (Diff resulting : allResultingMerges) {
            Set<Diff> rejections = MergeDependenciesUtil.internalGetResultingRejections(resulting, mergerRegistry, mergeRightToLeft);
            Sets.SetView difference = Sets.difference(rejections, resultingRejections);
            while (!difference.isEmpty()) {
                LinkedHashSet newRejections = new LinkedHashSet(difference);
                resultingRejections.addAll(newRejections);
                rejections = new LinkedHashSet<Diff>();
                for (Diff rejected : newRejections) {
                    IMerger merger = mergerRegistry.getHighestRankingMerger(diff);
                    if (!(merger instanceof IMerger2)) continue;
                    rejections.addAll(((IMerger2)merger).getDirectMergeDependencies(rejected, mergeRightToLeft));
                    rejections.addAll(((IMerger2)merger).getDirectResultingMerges(rejected, mergeRightToLeft));
                }
                difference = Sets.difference(rejections, resultingRejections);
            }
        }
        return resultingRejections;
    }

    private static Set<Diff> internalGetResultingRejections(Diff diff, IMerger.Registry mergerRegistry, boolean mergeRightToLeft) {
        IMerger merger = mergerRegistry.getHighestRankingMerger(diff);
        if (merger instanceof IMerger2) {
            return ((IMerger2)merger).getDirectResultingRejections(diff, mergeRightToLeft);
        }
        return Collections.emptySet();
    }
}

