/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.logical;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Conflict;
import org.eclipse.emf.compare.ConflictKind;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.EMFCompare;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIMessages;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIPlugin;
import org.eclipse.emf.compare.ide.ui.internal.logical.ComparisonScopeBuilder;
import org.eclipse.emf.compare.ide.ui.internal.logical.EMFResourceMapping;
import org.eclipse.emf.compare.ide.ui.internal.logical.IdenticalResourceMinimizer;
import org.eclipse.emf.compare.ide.ui.logical.SynchronizationModel;
import org.eclipse.emf.compare.ide.utils.ResourceUtil;
import org.eclipse.emf.compare.internal.merge.MergeDependenciesUtil;
import org.eclipse.emf.compare.internal.utils.Graph;
import org.eclipse.emf.compare.internal.utils.PruningIterator;
import org.eclipse.emf.compare.merge.BatchMerger;
import org.eclipse.emf.compare.merge.IMerger;
import org.eclipse.emf.compare.rcp.EMFCompareRCPPlugin;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.mapping.IMergeContext;
import org.eclipse.team.core.mapping.IResourceMappingMerger;
import org.eclipse.team.core.mapping.provider.MergeStatus;

public class EMFResourceMappingMerger
implements IResourceMappingMerger {
    public IStatus merge(IMergeContext mergeContext, IProgressMonitor monitor) throws CoreException {
        ResourceMapping[] emfMappings = this.getEMFMappings(mergeContext);
        if (emfMappings.length <= 0) {
            return new Status(4, "org.eclipse.emf.compare.ide.ui", EMFCompareIDEUIMessages.getString("EMFResourceMappingMerger.mergeFailedGeneric"));
        }
        IStatus hasInvalidMappings = this.validateMappings(emfMappings);
        if (hasInvalidMappings.getSeverity() != 0) {
            return hasInvalidMappings;
        }
        HashSet<ResourceMapping> failingMappings = new HashSet<ResourceMapping>();
        ResourceMapping[] resourceMappingArray = emfMappings;
        int n = emfMappings.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceMapping mapping = resourceMappingArray[n2];
            SynchronizationModel syncModel = ((EMFResourceMapping)mapping).getLatestModel();
            IdenticalResourceMinimizer minimizer = new IdenticalResourceMinimizer();
            minimizer.minimize(syncModel, monitor);
            IComparisonScope scope = ComparisonScopeBuilder.create(syncModel, monitor);
            Comparison comparison = EMFCompare.builder().build().compare(scope, BasicMonitor.toMonitor((IProgressMonitor)monitor));
            IMerger.Registry mergerRegistry = EMFCompareRCPPlugin.getDefault().getMergerRegistry();
            if (this.hasRealConflict(comparison)) {
                Graph differencesGraph = MergeDependenciesUtil.mapDifferences((Comparison)comparison, (IMerger.Registry)mergerRegistry, (boolean)true);
                PruningIterator iterator = differencesGraph.breadthFirstIterator();
                Monitor emfMonitor = BasicMonitor.toMonitor((IProgressMonitor)monitor);
                while (iterator.hasNext()) {
                    Diff next = (Diff)iterator.next();
                    if (EMFComparePredicates.hasConflict((ConflictKind[])new ConflictKind[]{ConflictKind.REAL}).apply((Object)next)) {
                        iterator.prune();
                        continue;
                    }
                    if (next.getState() == DifferenceState.MERGED) continue;
                    IMerger merger = mergerRegistry.getHighestRankingMerger(next);
                    merger.copyRightToLeft(next, emfMonitor);
                }
                this.save(scope.getLeft());
                failingMappings.add(mapping);
            } else {
                BatchMerger merger = new BatchMerger(mergerRegistry, EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT));
                merger.copyAllRightToLeft((Iterable)comparison.getDifferences(), BasicMonitor.toMonitor((IProgressMonitor)monitor));
                this.save(scope.getLeft());
                for (IStorage storage : syncModel.getLeftTraversal().getStorages()) {
                    if (storage.getFullPath() == null) {
                        EMFCompareIDEUIPlugin.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.emf.compare.ide.ui", EMFCompareIDEUIMessages.getString("EMFResourceMappingMerger.mergeIncomplete")));
                        continue;
                    }
                    IDiff diff = mergeContext.getDiffTree().getDiff(storage.getFullPath());
                    if (diff == null) continue;
                    mergeContext.markAsMerged(diff, true, monitor);
                }
            }
            ++n2;
        }
        if (!failingMappings.isEmpty()) {
            ResourceMapping[] failingArray = failingMappings.toArray(new ResourceMapping[failingMappings.size()]);
            return new MergeStatus("org.eclipse.emf.compare.ide.ui", EMFCompareIDEUIMessages.getString("EMFResourceMappingMerger.mergeFailedConflicts"), failingArray);
        }
        return Status.OK_STATUS;
    }

    private IStatus validateMappings(ResourceMapping[] mappings) {
        ResourceMapping[] resourceMappingArray = mappings;
        int n = mappings.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceMapping mapping = resourceMappingArray[n2];
            if (mapping instanceof EMFResourceMapping && mapping.getModelObject() instanceof SynchronizationModel) {
                SynchronizationModel model = (SynchronizationModel)mapping.getModelObject();
                if (model.getDiagnostic().getSeverity() >= 2) {
                    return BasicDiagnostic.toIStatus((Diagnostic)model.getDiagnostic());
                }
            } else {
                return new Status(4, "org.eclipse.emf.compare.ide.ui", EMFCompareIDEUIMessages.getString("EMFResourceMappingMerger.mergeFailedInvalidMapping"));
            }
            ++n2;
        }
        return Status.OK_STATUS;
    }

    private void save(Notifier notifier) {
        if (notifier instanceof ResourceSet) {
            ResourceUtil.saveAllResources((ResourceSet)((ResourceSet)notifier), (Map)ImmutableMap.of((Object)"SAVE_ONLY_IF_CHANGED", (Object)"MEMORY_BUFFER"));
        } else if (notifier instanceof Resource) {
            ResourceUtil.saveResource((Resource)((Resource)notifier), (Map)ImmutableMap.of((Object)"SAVE_ONLY_IF_CHANGED", (Object)"MEMORY_BUFFER"));
        }
    }

    private boolean hasRealConflict(Comparison comparison) {
        for (Conflict conflict : comparison.getConflicts()) {
            if (conflict.getKind() != ConflictKind.REAL) continue;
            return true;
        }
        return false;
    }

    public ISchedulingRule getMergeRule(IMergeContext context) {
        ResourceMapping[] emfMappings = this.getEMFMappings(context);
        LinkedHashSet<IProject> impactedProjects = new LinkedHashSet<IProject>();
        ResourceMapping[] resourceMappingArray = emfMappings;
        int n = emfMappings.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceMapping mapping = resourceMappingArray[n2];
            impactedProjects.addAll(Arrays.asList(mapping.getProjects()));
            ++n2;
        }
        return MultiRule.combine((ISchedulingRule[])impactedProjects.toArray(new ISchedulingRule[impactedProjects.size()]));
    }

    private ResourceMapping[] getEMFMappings(IMergeContext context) {
        return context.getScope().getMappings("org.eclipse.emf.compare.model.provider");
    }

    public IStatus validateMerge(IMergeContext mergeContext, IProgressMonitor monitor) {
        return Status.OK_STATUS;
    }
}

