/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.merge;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.Conflict;
import org.eclipse.emf.compare.ConflictKind;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.FeatureMapChange;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.merge.IMerger;
import org.eclipse.emf.compare.merge.IMerger2;
import org.eclipse.emf.compare.utils.EMFCompareCopier;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.compare.utils.ReferenceUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.InternalEList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMerger
implements IMerger2 {
    private int ranking;
    private IMerger.Registry registry;

    @Override
    public int getRanking() {
        return this.ranking;
    }

    @Override
    public void setRanking(int r) {
        this.ranking = r;
    }

    @Override
    public IMerger.Registry getRegistry() {
        return this.registry;
    }

    @Override
    public void setRegistry(IMerger.Registry registry) {
        if (this.registry != null && registry != null) {
            throw new IllegalStateException("The registry has to be set only once.");
        }
        this.registry = registry;
    }

    @Override
    public Set<Diff> getDirectMergeDependencies(Diff diff, boolean mergeRightToLeft) {
        Diff masterEquivalence;
        LinkedHashSet<Diff> dependencies = new LinkedHashSet<Diff>();
        if (mergeRightToLeft) {
            if (DifferenceSource.LEFT == diff.getSource()) {
                dependencies.addAll((Collection<Diff>)diff.getImplies());
                dependencies.addAll((Collection<Diff>)diff.getRequiredBy());
            } else {
                dependencies.addAll((Collection<Diff>)diff.getImpliedBy());
                dependencies.addAll((Collection<Diff>)diff.getRequires());
            }
        } else if (DifferenceSource.LEFT == diff.getSource()) {
            dependencies.addAll((Collection<Diff>)diff.getImpliedBy());
            dependencies.addAll((Collection<Diff>)diff.getRequires());
        } else {
            dependencies.addAll((Collection<Diff>)diff.getImplies());
            dependencies.addAll((Collection<Diff>)diff.getRequiredBy());
        }
        dependencies.addAll((Collection<Diff>)diff.getRefinedBy());
        if (diff.getEquivalence() != null && (masterEquivalence = this.findMasterEquivalence(diff, mergeRightToLeft)) != null && masterEquivalence != diff) {
            dependencies.add(masterEquivalence);
        }
        return dependencies;
    }

    @Override
    public Set<Diff> getDirectResultingMerges(Diff target, boolean mergeRightToLeft) {
        LinkedHashSet<Diff> resulting = new LinkedHashSet<Diff>();
        if (mergeRightToLeft) {
            if (DifferenceSource.LEFT == target.getSource()) {
                resulting.addAll((Collection<Diff>)target.getImpliedBy());
            } else {
                resulting.addAll((Collection<Diff>)target.getImplies());
            }
        } else if (DifferenceSource.LEFT == target.getSource()) {
            resulting.addAll((Collection<Diff>)target.getImplies());
        } else {
            resulting.addAll((Collection<Diff>)target.getImpliedBy());
        }
        if (target.getEquivalence() != null) {
            resulting.addAll((Collection<Diff>)target.getEquivalence().getDifferences());
            resulting.remove(target);
        }
        if (target.getConflict() != null && target.getConflict().getKind() == ConflictKind.PSEUDO) {
            resulting.addAll((Collection<Diff>)target.getConflict().getDifferences());
            resulting.remove(target);
        }
        return resulting;
    }

    @Override
    public Set<Diff> getDirectResultingRejections(Diff target, boolean mergeRightToLeft) {
        LinkedHashSet<Diff> directlyImpliedRejections = new LinkedHashSet<Diff>();
        Conflict conflict = target.getConflict();
        if (conflict != null && conflict.getKind() == ConflictKind.REAL) {
            if (mergeRightToLeft && target.getSource() == DifferenceSource.RIGHT) {
                Iterables.addAll(directlyImpliedRejections, (Iterable)Iterables.filter(conflict.getDifferences(), EMFComparePredicates.fromSide(DifferenceSource.LEFT)));
            } else if (!mergeRightToLeft && target.getSource() == DifferenceSource.LEFT) {
                Iterables.addAll(directlyImpliedRejections, (Iterable)Iterables.filter(conflict.getDifferences(), EMFComparePredicates.fromSide(DifferenceSource.RIGHT)));
            }
        }
        return directlyImpliedRejections;
    }

    private Diff findMasterEquivalence(Diff diff, boolean mergeRightToLeft) {
        Diff masterDiff;
        EList<Diff> equivalentDiffs = diff.getEquivalence().getDifferences();
        Optional firstConflicting = Iterables.tryFind(equivalentDiffs, EMFComparePredicates.hasConflict(ConflictKind.REAL));
        if (firstConflicting.isPresent()) {
            masterDiff = (Diff)firstConflicting.get();
        } else if (diff instanceof ReferenceChange) {
            ReferenceChange referenceChange = (ReferenceChange)diff;
            masterDiff = this.getMasterEquivalenceForReferenceChange(referenceChange, mergeRightToLeft);
        } else {
            masterDiff = null;
        }
        return masterDiff;
    }

    private Diff getMasterEquivalenceForReferenceChange(ReferenceChange diff, boolean mergeRightToLeft) {
        Diff masterDiff = this.getMasterEquivalenceOnEOpposite(diff, mergeRightToLeft);
        if (masterDiff == null) {
            masterDiff = this.getMasterEquivalenceFeatureMap(diff);
        }
        return masterDiff;
    }

    private Diff getMasterEquivalenceOnEOpposite(ReferenceChange diff, boolean mergeRightToLeft) {
        ReferenceChange masterDiff = null;
        Iterator equivalentDiffs = diff.getEquivalence().getDifferences().iterator();
        UnmodifiableIterator eOppositeDiffs = Iterators.filter((Iterator)equivalentDiffs, EMFComparePredicates.isDiffOnEOppositeOf(diff));
        while (masterDiff == null && eOppositeDiffs.hasNext()) {
            ReferenceChange candidate = (ReferenceChange)eOppositeDiffs.next();
            if (this.isOneToManyAndAdd(diff, candidate, mergeRightToLeft)) {
                masterDiff = candidate;
                continue;
            }
            if (this.isSet(diff, mergeRightToLeft) || !this.isOneToOneAndSet(diff, candidate, mergeRightToLeft)) continue;
            masterDiff = candidate;
        }
        return masterDiff;
    }

    private Diff getMasterEquivalenceFeatureMap(ReferenceChange diff) {
        return (Diff)Iterators.tryFind((Iterator)diff.getEquivalence().getDifferences().iterator(), (Predicate)Predicates.instanceOf(FeatureMapChange.class)).orNull();
    }

    private boolean isOneToManyAndAdd(ReferenceChange diff, ReferenceChange equivalent, boolean mergeRightToLeft) {
        return !diff.getReference().isMany() && equivalent.getReference().isMany() && this.isAdd(equivalent, mergeRightToLeft);
    }

    private boolean isOneToOneAndSet(ReferenceChange diff, ReferenceChange equivalent, boolean mergeRightToLeft) {
        return !diff.getReference().isMany() && !equivalent.getReference().isMany() && this.isSet(equivalent, mergeRightToLeft);
    }

    @Override
    public void copyLeftToRight(Diff target, Monitor monitor) {
        if (target.getState() != DifferenceState.UNRESOLVED) {
            return;
        }
        target.setState(DifferenceState.MERGED);
        Set<Diff> dependencies = this.getDirectMergeDependencies(target, false);
        boolean requiresMerging = this.requiresMerging(target, false);
        for (Diff mergeMe : dependencies) {
            this.mergeDiff(mergeMe, false, monitor);
        }
        for (Diff transitiveMerge : this.getDirectResultingMerges(target, false)) {
            transitiveMerge.setState(DifferenceState.MERGED);
        }
        if (requiresMerging) {
            if (target.getSource() == DifferenceSource.LEFT) {
                this.accept(target, false);
            } else {
                this.reject(target, false);
            }
        }
    }

    @Override
    public void copyRightToLeft(Diff target, Monitor monitor) {
        if (target.getState() != DifferenceState.UNRESOLVED) {
            return;
        }
        target.setState(DifferenceState.MERGED);
        Set<Diff> dependencies = this.getDirectMergeDependencies(target, true);
        boolean requiresMerging = this.requiresMerging(target, true);
        for (Diff mergeMe : dependencies) {
            this.mergeDiff(mergeMe, true, monitor);
        }
        for (Diff transitiveMerge : this.getDirectResultingMerges(target, true)) {
            transitiveMerge.setState(DifferenceState.MERGED);
        }
        if (requiresMerging) {
            if (target.getSource() == DifferenceSource.LEFT) {
                this.reject(target, true);
            } else {
                this.accept(target, true);
            }
        }
    }

    private boolean requiresMerging(Diff target, boolean mergeRightToLeft) {
        boolean requiresMerging = true;
        if (this.isImpliedMerge(target, mergeRightToLeft)) {
            requiresMerging = false;
        } else if (target.getEquivalence() != null) {
            Diff masterEquivalence = this.findMasterEquivalence(target, mergeRightToLeft);
            requiresMerging = masterEquivalence != null && masterEquivalence != target ? false : !this.hasTransitiveImplicationBeenMerged(target, mergeRightToLeft);
        }
        return requiresMerging;
    }

    private boolean isImpliedMerge(Diff target, boolean mergeRightToLeft) {
        boolean isImpliedForDirection = mergeRightToLeft ? (DifferenceSource.LEFT == target.getSource() ? !target.getImplies().isEmpty() : !target.getImpliedBy().isEmpty()) : (DifferenceSource.LEFT == target.getSource() ? !target.getImpliedBy().isEmpty() : !target.getImplies().isEmpty());
        return isImpliedForDirection;
    }

    private boolean hasTransitiveImplicationBeenMerged(Diff target, boolean mergeRightToLeft) {
        boolean mergedThroughEquivalentImplication = false;
        Iterator equivalenceIterator = target.getEquivalence().getDifferences().iterator();
        while (!mergedThroughEquivalentImplication && equivalenceIterator.hasNext()) {
            Diff equivalent = (Diff)equivalenceIterator.next();
            if (equivalent != target && mergeRightToLeft) {
                if (target.getSource() == DifferenceSource.LEFT) {
                    mergedThroughEquivalentImplication = Iterables.any(equivalent.getImplies(), (Predicate)Predicates.in(target.getRequiredBy()));
                    continue;
                }
                mergedThroughEquivalentImplication = Iterables.any(equivalent.getImpliedBy(), (Predicate)Predicates.in(target.getRequires()));
                continue;
            }
            if (equivalent == target) continue;
            mergedThroughEquivalentImplication = target.getSource() == DifferenceSource.LEFT ? Iterables.any(equivalent.getImpliedBy(), (Predicate)Predicates.in(target.getRequires())) : Iterables.any(equivalent.getImplies(), (Predicate)Predicates.in(target.getRequiredBy()));
        }
        return mergedThroughEquivalentImplication;
    }

    protected void accept(Diff diff, boolean rightToLeft) {
    }

    protected void reject(Diff diff, boolean rightToLeft) {
    }

    @Deprecated
    protected void mergeRequiredBy(Diff diff, boolean rightToLeft, Monitor monitor) {
        for (Diff dependency : diff.getRequiredBy()) {
            this.mergeDiff(dependency, rightToLeft, monitor);
        }
    }

    @Deprecated
    protected void handleImplies(Diff diff, boolean rightToLeft, Monitor monitor) {
        for (Diff implied : diff.getImplies()) {
            implied.setState(DifferenceState.MERGED);
            this.handleImplies(implied, rightToLeft, monitor);
        }
    }

    @Deprecated
    protected void handleImpliedBy(Diff diff, boolean rightToLeft, Monitor monitor) {
    }

    @Deprecated
    protected void mergeRequires(Diff diff, boolean rightToLeft, Monitor monitor) {
        for (Diff dependency : diff.getRequires()) {
            this.mergeDiff(dependency, rightToLeft, monitor);
        }
    }

    protected void mergeDiff(Diff diff, boolean rightToLeft, Monitor monitor) {
        if (rightToLeft) {
            IMerger delegate = this.getRegistry().getHighestRankingMerger(diff);
            delegate.copyRightToLeft(diff, monitor);
        } else {
            IMerger delegate = this.getRegistry().getHighestRankingMerger(diff);
            delegate.copyLeftToRight(diff, monitor);
        }
    }

    @Deprecated
    protected boolean handleEquivalences(Diff diff, boolean rightToLeft, Monitor monitor) {
        boolean continueMerge = true;
        for (Diff equivalent : diff.getEquivalence().getDifferences()) {
            if (diff instanceof ReferenceChange && equivalent instanceof ReferenceChange) {
                ReferenceChange diffRC = (ReferenceChange)diff;
                ReferenceChange equivalentRC = (ReferenceChange)equivalent;
                if (diffRC.getReference().getEOpposite() == equivalentRC.getReference() && equivalent.getState() == DifferenceState.UNRESOLVED) {
                    boolean mergeEquivalence;
                    boolean bl = mergeEquivalence = this.isOneToManyAndAdd(diffRC, equivalentRC, rightToLeft) || this.isOneToOneAndSet(diffRC, equivalentRC, rightToLeft);
                    if (mergeEquivalence) {
                        this.mergeDiff(equivalent, rightToLeft, monitor);
                        continueMerge = false;
                    }
                }
            }
            if (diff instanceof ReferenceChange && equivalent instanceof FeatureMapChange) {
                this.mergeDiff(equivalent, rightToLeft, monitor);
                continueMerge = false;
            }
            continueMerge = rightToLeft ? (diff.getSource() == DifferenceSource.LEFT ? continueMerge && !Iterables.any(equivalent.getImplies(), (Predicate)Predicates.in(diff.getRequiredBy())) : continueMerge && !Iterables.any(equivalent.getImpliedBy(), (Predicate)Predicates.in(diff.getRequires()))) : (diff.getSource() == DifferenceSource.LEFT ? continueMerge && !Iterables.any(equivalent.getImpliedBy(), (Predicate)Predicates.in(diff.getRequires())) : continueMerge && !Iterables.any(equivalent.getImplies(), (Predicate)Predicates.in(diff.getRequiredBy())));
            equivalent.setState(DifferenceState.MERGED);
        }
        return continueMerge;
    }

    protected boolean isAdd(ReferenceChange diff, boolean rightToLeft) {
        if (rightToLeft) {
            return this.isLeftDeleteOrRightAdd(diff);
        }
        return this.isLeftAddOrRightDelete(diff);
    }

    private boolean isLeftAddOrRightDelete(ReferenceChange diff) {
        if (diff.getSource() == DifferenceSource.LEFT) {
            return diff.getKind() == DifferenceKind.ADD;
        }
        return diff.getKind() == DifferenceKind.DELETE;
    }

    private boolean isLeftDeleteOrRightAdd(ReferenceChange diff) {
        if (diff.getSource() == DifferenceSource.LEFT) {
            return diff.getKind() == DifferenceKind.DELETE;
        }
        return diff.getKind() == DifferenceKind.ADD;
    }

    private boolean isSet(ReferenceChange diff, boolean mergeRightToLeft) {
        if (diff.getKind() != DifferenceKind.CHANGE) {
            return false;
        }
        boolean isSet = false;
        Match match = diff.getMatch();
        EObject container = diff.getSource() == DifferenceSource.LEFT ? match.getLeft() : match.getRight();
        if (container == null) {
            isSet = this.isRejecting(diff, mergeRightToLeft);
        } else if (!ReferenceUtil.safeEIsSet(container, (EStructuralFeature)diff.getReference())) {
            isSet = this.isRejecting(diff, mergeRightToLeft);
        } else if (this.isRejecting(diff, mergeRightToLeft)) {
            EObject originContainer = match.getComparison().isThreeWay() ? match.getOrigin() : (mergeRightToLeft ? match.getRight() : match.getLeft());
            isSet = originContainer != null && ReferenceUtil.safeEIsSet(originContainer, (EStructuralFeature)diff.getReference());
        } else {
            isSet = true;
        }
        return isSet;
    }

    private boolean isRejecting(Diff diff, boolean mergeRightToLeft) {
        if (diff.getSource() == DifferenceSource.LEFT) {
            return mergeRightToLeft;
        }
        return !mergeRightToLeft;
    }

    protected EObject createCopy(EObject referenceObject) {
        EMFCompareCopier copier = new EMFCompareCopier();
        return copier.copy(referenceObject);
    }

    protected <E> void addAt(List<E> list, E value, int insertionIndex) {
        if (list instanceof InternalEList) {
            if (insertionIndex < 0 || insertionIndex > list.size()) {
                ((InternalEList)list).addUnique(value);
            } else {
                ((InternalEList)list).addUnique(insertionIndex, value);
            }
        } else if (insertionIndex < 0 || insertionIndex > list.size()) {
            list.add(value);
        } else {
            list.add(insertionIndex, value);
        }
    }
}

