/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.logical.resolver.registry;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IStorage;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.CrossReferenceResolutionScope;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.ThreadedModelResolver;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.registry.ModelResolverDescriptor;
import org.eclipse.emf.compare.ide.ui.logical.IModelResolver;
import org.osgi.service.prefs.Preferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ModelResolverRegistry {
    private static final String USER_RESOLVER_PREF_KEY = "org.eclipse.emf.compare.ide.ui.user.resolver";
    private static final String ENABLE_RESOLVING_PREF_KEY = "org.eclipse.emf.compare.ide.ui.enable.resolving";
    private final Preferences preferenceStore;
    private final Map<String, ModelResolverDescriptor> registeredDescriptors;
    private ThreadedModelResolver defaultResolver;

    public ModelResolverRegistry(Preferences preferenceStore) {
        this.preferenceStore = preferenceStore;
        this.registeredDescriptors = new LinkedHashMap<String, ModelResolverDescriptor>();
    }

    public List<ModelResolverDescriptor> getRegisteredDescriptors() {
        return new ArrayList<ModelResolverDescriptor>(this.registeredDescriptors.values());
    }

    public IModelResolver getBestResolverFor(IStorage sourceStorage) {
        if (!this.isEnabled()) {
            return this.defaultResolver;
        }
        ModelResolverDescriptor resolver = this.getSelectedResolver();
        if (resolver == null || !resolver.getModelResolver().canResolve(sourceStorage)) {
            for (ModelResolverDescriptor candidate : this.registeredDescriptors.values()) {
                if (resolver != null && resolver.getRanking() >= candidate.getRanking() || !candidate.getModelResolver().canResolve(sourceStorage)) continue;
                resolver = candidate;
            }
        }
        if (resolver != null) {
            return resolver.getModelResolver();
        }
        return null;
    }

    public ModelResolverDescriptor getSelectedResolver() {
        String selectedKey = this.preferenceStore.get(USER_RESOLVER_PREF_KEY, null);
        return this.registeredDescriptors.get(selectedKey);
    }

    public void setSelectedResolver(String selected) {
        this.preferenceStore.put(USER_RESOLVER_PREF_KEY, selected);
    }

    public boolean isEnabled() {
        return this.preferenceStore.getBoolean(ENABLE_RESOLVING_PREF_KEY, true);
    }

    public void toggleEnablement(boolean enabled) {
        if (!enabled) {
            this.defaultResolver.setResolutionScope(CrossReferenceResolutionScope.SELF);
        } else {
            this.defaultResolver.setResolutionScope(CrossReferenceResolutionScope.CONTAINER);
        }
        this.preferenceStore.putBoolean(ENABLE_RESOLVING_PREF_KEY, enabled);
    }

    void addResolver(String key, ModelResolverDescriptor descriptor) {
        if (ThreadedModelResolver.class.getName().equals(key)) {
            this.defaultResolver = (ThreadedModelResolver)descriptor.getModelResolver();
        }
        this.registeredDescriptors.put(key, descriptor);
    }

    ModelResolverDescriptor removeResolver(String key) {
        ModelResolverDescriptor descriptor = this.registeredDescriptors.remove(key);
        if (descriptor != null) {
            descriptor.dispose();
        }
        return descriptor;
    }

    public void clear() {
        Iterator<ModelResolverDescriptor> descriptors = this.registeredDescriptors.values().iterator();
        while (descriptors.hasNext()) {
            descriptors.next().dispose();
            descriptors.remove();
        }
    }
}

