/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.internal.utils;

import com.google.common.annotations.Beta;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.compare.ide.EMFCompareIDEPlugin;
import org.eclipse.emf.compare.ide.policy.ILoadOnDemandPolicy;
import org.eclipse.emf.compare.ide.utils.ResourceUtil;
import org.eclipse.emf.compare.ide.utils.StorageTraversal;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.InternalEList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
public final class NotLoadingResourceSet
extends ResourceSetImpl {
    public NotLoadingResourceSet(StorageTraversal traversal) {
        Set<? extends IStorage> storages = traversal.getStorages();
        this.setURIResourceMap(new HashMap(storages.size() << 1));
        for (IStorage iStorage : storages) {
            this.loadResource(iStorage, this.getLoadOptions());
        }
        ArrayList arrayList = Lists.newArrayList((Iterable)this.getResources());
        for (Resource res : arrayList) {
            this.resolve(res);
        }
    }

    public Resource getResource(URI uri, boolean loadOnDemand) {
        ILoadOnDemandPolicy.Registry registry = EMFCompareIDEPlugin.getDefault().getLoadOnDemandPolicyRegistry();
        if (registry.hasAnyAuthorizingPolicy(uri)) {
            return super.getResource(uri, true);
        }
        return super.getResource(uri, false);
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Resource loadResource(IStorage storage, Map<?, ?> options) {
        InputStream stream = null;
        Resource resource = null;
        try {
            resource = this.createResource(ResourceUtil.createURIFor(storage));
            stream = storage.getContents();
            resource.load(stream, options);
        }
        catch (IOException iOException) {
            if (stream == null) return resource;
            try {
                stream.close();
                return resource;
            }
            catch (IOException iOException2) {}
            return resource;
        }
        catch (CoreException coreException) {
            if (stream == null) return resource;
            try {
                stream.close();
                return resource;
            }
            catch (IOException iOException) {}
            return resource;
        }
        catch (WrappedException wrappedException) {
            if (stream == null) return resource;
            {
                catch (Throwable throwable) {
                    if (stream == null) throw throwable;
                    try {
                        stream.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
            }
            try {
                stream.close();
                return resource;
            }
            catch (IOException iOException) {}
            return resource;
        }
        if (stream == null) return resource;
        try {
            stream.close();
            return resource;
        }
        catch (IOException iOException) {}
        return resource;
    }

    private void resolve(Resource resource) {
        List roots = ((InternalEList)resource.getContents()).basicList();
        for (EObject eObject : roots) {
            this.resolveCrossReferences(eObject);
            TreeIterator<EObject> childContent = this.basicEAllContents(eObject);
            while (childContent.hasNext()) {
                EObject child = (EObject)childContent.next();
                this.resolveCrossReferences(child);
            }
        }
        resource.getContents().addAll((Collection)roots);
    }

    private void resolveCrossReferences(EObject eObject) {
        EList list = eObject.eCrossReferences();
        ListIterator objectChildren = ((InternalEList)list).basicListIterator();
        while (objectChildren.hasNext()) {
            URI proxyURI;
            Resource targetRes;
            EObject eObj = (EObject)objectChildren.next();
            if (!eObj.eIsProxy() || (targetRes = this.getResource((proxyURI = ((InternalEObject)eObj).eProxyURI()).trimFragment(), false)) == null) continue;
            list.get(objectChildren.previousIndex());
        }
    }

    private TreeIterator<EObject> basicEAllContents(EObject eObject) {
        return new AbstractTreeIterator<EObject>((Object)eObject, false){
            private static final long serialVersionUID = 6874121606163401152L;

            public Iterator<EObject> getChildren(Object obj) {
                return ((InternalEList)((EObject)obj).eContents()).basicIterator();
            }
        };
    }
}

