/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.command.impl;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.command.ICompareCopyCommand;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.ecore.change.util.ChangeRecorder;
import org.eclipse.emf.edit.command.ChangeCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyCommand
extends ChangeCommand
implements ICompareCopyCommand {
    private final List<Diff> differences;
    private final boolean leftToRight;

    public CopyCommand(ChangeRecorder changeRecorder, Collection<Notifier> notifiers, List<Diff> differences, boolean leftToRight) {
        super(changeRecorder, notifiers);
        this.differences = ImmutableList.copyOf(differences);
        this.leftToRight = leftToRight;
    }

    @Override
    public boolean isLeftToRight() {
        return this.leftToRight;
    }

    public Collection<?> getAffectedObjects() {
        return this.differences;
    }

    public boolean canExecute() {
        return super.canExecute() && Iterables.any(this.differences, (Predicate)EMFComparePredicates.hasState((DifferenceState[])new DifferenceState[]{DifferenceState.UNRESOLVED}));
    }

    protected void doExecute() {
        if (this.leftToRight) {
            for (Diff diff : this.differences) {
                diff.copyLeftToRight();
            }
        } else {
            for (Diff diff : this.differences) {
                diff.copyRightToLeft();
            }
        }
    }
}

