/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.editor.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.IRegion;
import org.eclipse.m2m.internal.qvt.oml.ast.binding.ASTBindingHelper;
import org.eclipse.m2m.internal.qvt.oml.cst.MappingModuleCS;
import org.eclipse.ocl.cst.CSTNode;
import org.eclipse.ocl.ecore.EcoreEnvironment;
import org.eclipse.ocl.utilities.ASTNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSTHelper {
    private CSTHelper() {
    }

    public static List<CSTNode> selectTargetedElements(CSTNode root, IRegion region) {
        ArrayList<CSTNode> elements = new ArrayList<CSTNode>();
        int startOffset = region.getOffset();
        int endOffset = startOffset + region.getLength();
        TreeIterator it = root.eAllContents();
        while (it.hasNext()) {
            CSTNode nextNode;
            EObject nextObject = (EObject)it.next();
            if (!(nextObject instanceof CSTNode) || startOffset < (nextNode = (CSTNode)nextObject).getStartOffset() || endOffset > nextNode.getEndOffset()) continue;
            elements.add(nextNode);
        }
        Collections.reverse(elements);
        return elements;
    }

    public static MappingModuleCS getModule(CSTNode nodeCS) {
        CSTNode parent = nodeCS;
        while (parent != null && !(parent instanceof MappingModuleCS)) {
            parent = parent.eContainer();
        }
        return (MappingModuleCS)parent;
    }

    public static URI getSourceFile(CSTNode nodeCS) {
        MappingModuleCS moduleCST = CSTHelper.getModule(nodeCS);
        if (moduleCST == null) {
            return null;
        }
        return ASTBindingHelper.resolveModuleFile((EObject)moduleCST);
    }

    public static EcoreEnvironment getEnvironment(CSTNode nodeCS) {
        ASTNode moduleAS;
        MappingModuleCS moduleCS = CSTHelper.getModule(nodeCS);
        if (moduleCS != null && (moduleAS = ASTBindingHelper.resolveASTNode((CSTNode)moduleCS)) != null) {
            return ASTBindingHelper.resolveEnvironment((ASTNode)moduleAS);
        }
        return null;
    }
}

