/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.editor.ui.completion;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalParserUtil;
import org.eclipse.m2m.internal.qvt.oml.common.io.CFile;
import org.eclipse.m2m.internal.qvt.oml.compiler.IImportResolver;
import org.eclipse.m2m.internal.qvt.oml.cst.ImportCS;
import org.eclipse.m2m.internal.qvt.oml.cst.LibraryImportCS;
import org.eclipse.m2m.internal.qvt.oml.cst.MappingModuleCS;
import org.eclipse.m2m.internal.qvt.oml.cst.ModuleImportCS;
import org.eclipse.m2m.internal.qvt.oml.cst.parser.QvtOpLexer;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.completion.QvtCompletionData;
import org.eclipse.ocl.cst.PathNameCS;

public class CFileData {
    private final CFile myCFile;
    private final QvtCompletionData myData;
    private final List<CFile> myImportedFiles = new ArrayList<CFile>();
    private QvtOpLexer myLexer;
    private MappingModuleCS myMappingModuleCS;
    private String myLightweightScript;

    public CFileData(CFile cFile, QvtCompletionData data) {
        this.myCFile = cFile;
        this.myData = data;
    }

    public CFile getCFile() {
        return this.myCFile;
    }

    public CFile[] getImportedFiles() {
        return this.myImportedFiles.toArray(new CFile[this.myImportedFiles.size()]);
    }

    public void addImportedFile(CFile cFile) {
        this.myImportedFiles.add(cFile);
    }

    public QvtOpLexer getLexer() {
        return this.myLexer;
    }

    public void setLexer(QvtOpLexer lexer) {
        this.myLexer = lexer;
    }

    public MappingModuleCS getMappingModuleCS() {
        return this.myMappingModuleCS;
    }

    public void setMappingModuleCS(MappingModuleCS mappingModuleCS) {
        this.myMappingModuleCS = mappingModuleCS;
        this.addImportedModules();
    }

    private void addImportedModules() {
        for (ImportCS importCS : this.myMappingModuleCS.getImports()) {
            String id = QvtOperationalParserUtil.getStringRepresentation((PathNameCS)importCS.getPathNameCS(), (String)".");
            if (importCS instanceof ModuleImportCS) {
                IImportResolver importResolver = this.myData.getQvtCompiler().getKernel().getImportResolver();
                CFile importedFile = importResolver.resolveImport(id);
                if (importedFile == null) continue;
                this.addImportedFile(importedFile);
                continue;
            }
            boolean cfr_ignored_0 = importCS instanceof LibraryImportCS;
        }
    }

    public String getLightweightScript() {
        return this.myLightweightScript;
    }

    public void setLightweightScript(String lightweightScript) {
        this.myLightweightScript = lightweightScript;
    }
}

