/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.adt.wizard.atlfile;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.m2m.atl.adt.wizard.atlfile.AtlFileScreen;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

public class AtlFileWizard
extends Wizard
implements INewWizard,
IExecutableExtension {
    protected static Logger logger = Logger.getLogger("org.eclipse.m2m.atl");
    private IConfigurationElement configElement;
    private AtlFileScreen page;
    private ISelection selection;
    private IContainer modelProject;

    public AtlFileWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.page = new AtlFileScreen(this.selection);
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        this.newProjectBuilder();
        BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.configElement);
        return true;
    }

    public void newProjectBuilder() {
        String fileName = this.page.getParameter("NAME");
        String fileType = this.page.getParameter("TYPE");
        this.modelProject = (IContainer)ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(this.page.getParameter("CONTAINER")));
        String contentFile = "";
        if (fileType.equals("module")) {
            contentFile = "module " + fileName + "; -- Module Template\n";
            contentFile = String.valueOf(contentFile) + "create " + this.page.getParameter("OUT");
            contentFile = String.valueOf(contentFile) + " from " + this.page.getParameter("IN") + ";\n";
            contentFile = String.valueOf(contentFile) + this.page.getParameter("LIB");
        } else if (fileType.equals("query")) {
            contentFile = "query " + fileName + " = ; -- Query Template\n";
            contentFile = String.valueOf(contentFile) + this.page.getParameter("LIB");
        } else if (fileType.equals("library")) {
            contentFile = "library " + fileName + "; -- Library Template\n";
        }
        this.createFile(String.valueOf(fileName) + ".atl", contentFile);
    }

    private void createFile(String fileName, String content) {
        IFile file = this.modelProject.getFile((IPath)new Path(fileName));
        try {
            InputStream stream = this.openContentStream(content);
            if (file.exists()) {
                file.setContents(stream, true, true, null);
            } else {
                file.create(stream, true, null);
            }
            stream.close();
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        catch (CoreException e1) {
            logger.log(Level.SEVERE, e1.getLocalizedMessage(), e1);
        }
    }

    private InputStream openContentStream(String contents) {
        return new ByteArrayInputStream(contents.getBytes());
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.configElement = config;
    }
}

