/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.emftvm.util;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.eclipse.m2m.atl.emftvm.CodeBlock;
import org.eclipse.m2m.atl.emftvm.ExecEnv;
import org.eclipse.m2m.atl.emftvm.util.EMFTVMUtil;
import org.eclipse.m2m.atl.emftvm.util.LazyBag;
import org.eclipse.m2m.atl.emftvm.util.LazyList;
import org.eclipse.m2m.atl.emftvm.util.LazyOrderedSet;
import org.eclipse.m2m.atl.emftvm.util.LazySet;
import org.eclipse.m2m.atl.emftvm.util.StackFrame;
import org.eclipse.m2m.atl.emftvm.util.Tuple;
import org.eclipse.m2m.atl.emftvm.util.VMException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LazyCollection<E>
implements Collection<E> {
    private static final int CUT_OFF = 31;
    protected Iterable<E> dataSource;
    protected Collection<E> cache;
    protected Map<E, Integer> occurrences;

    public LazyCollection(Iterable<E> dataSource) {
        this.dataSource = dataSource;
        this.createCache();
    }

    public LazyCollection() {
        this(null);
    }

    protected void createCache() {
        if (this.dataSource == null) {
            this.cache = Collections.emptyList();
            this.occurrences = Collections.emptyMap();
        }
    }

    @Override
    public boolean add(E o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean contains(Object o) {
        Collection<E> collection = this.cache;
        synchronized (collection) {
            if (this.cache.contains(o)) {
                return true;
            }
            if (this.dataSource == null) {
                return false;
            }
        }
        if (o == null) {
            for (E e : this) {
                if (e != null) continue;
                return true;
            }
        } else {
            for (E e : this) {
                if (!o.equals(e)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    public boolean containsAny(Collection<?> c) {
        for (Object o : c) {
            if (!this.contains(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        if (this.dataSource == null) {
            return this.cache.isEmpty();
        }
        return this.cache.isEmpty() && !this.iterator().hasNext();
    }

    @Override
    public Iterator<E> iterator() {
        if (this.dataSource == null) {
            return Collections.unmodifiableCollection(this.cache).iterator();
        }
        return new CachingIterator(this.dataSource.iterator());
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        if (this.dataSource == null) {
            return this.cache.size();
        }
        int size = 0;
        Iterator<E> i = this.iterator();
        while (i.hasNext()) {
            i.next();
            ++size;
        }
        return size;
    }

    @Override
    public Object[] toArray() {
        int size = this.size();
        if (this.dataSource == null) {
            return this.cache.toArray();
        }
        Object[] array = new Object[size];
        Iterator<E> it = this.iterator();
        int i = 0;
        while (i < array.length) {
            array[i] = it.next();
            ++i;
        }
        return array;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        int size = this.size();
        if (this.dataSource == null) {
            return this.cache.toArray(a);
        }
        Object[] r = a;
        if (r.length < size) {
            r = (Object[])Array.newInstance(r.getClass().getComponentType(), size);
        }
        Iterator<E> it = this.iterator();
        int i = 0;
        while (i < size) {
            r[i] = it.next();
            ++i;
        }
        if (r.length > size) {
            r[size] = null;
        }
        return r;
    }

    /*
     * Unable to fully structure code
     */
    public String toString() {
        try {
            return this.appendElements(new StringBuffer().append('['), null).append(']').toString();
        }
        catch (VMException e) {
            stackTrace = new StringBuffer();
            stackTrace.append(e.getClass().getName());
            stackTrace.append(": ");
            stackTrace.append(e.getLocalizedMessage());
            return stackTrace.toString();
        }
        catch (Exception e) {
            stackTrace = new StringBuffer();
            stackTrace.append(e.toString());
            var6_5 = e.getStackTrace();
            var5_6 = var6_5.length;
            var4_7 = 0;
            ** while (var4_7 < var5_6)
        }
lbl-1000:
        // 1 sources

        {
            ste = var6_5[var4_7];
            stackTrace.append("\n\t");
            stackTrace.append(ste);
            ++var4_7;
            continue;
        }
lbl27:
        // 1 sources

        return stackTrace.toString();
    }

    public abstract String asString(ExecEnv var1);

    protected StringBuffer appendElements(StringBuffer buf, ExecEnv env) {
        int index = 0;
        for (E e : this) {
            if (index > 31) {
                buf.append(", ...");
                break;
            }
            if (index++ > 0) {
                buf.append(", ");
            }
            buf.append(env == null ? e.toString() : EMFTVMUtil.toPrettyString(e, env));
        }
        return buf;
    }

    public boolean includes(E object) {
        return this.contains(object);
    }

    public boolean excludes(E object) {
        return !this.contains(object);
    }

    public synchronized int count(E object) {
        if (this.occurrences == null) {
            this.occurrences = new HashMap<E, Integer>();
            for (E e : this) {
                if (this.occurrences.containsKey(e)) {
                    this.occurrences.put(e, this.occurrences.get(e) + 1);
                    continue;
                }
                this.occurrences.put(e, 1);
            }
        }
        return this.occurrences.containsKey(object) ? this.occurrences.get(object) : 0;
    }

    public boolean includesAll(Collection<E> c2) {
        return this.containsAll(c2);
    }

    public boolean excludesAll(Collection<E> c2) {
        return !this.containsAny(c2);
    }

    public boolean notEmpty() {
        return !this.isEmpty();
    }

    public E max() {
        Number max = 0;
        boolean maxSet = false;
        for (E e : this) {
            if (e instanceof Integer) {
                max = maxSet ? Math.max(max, (Integer)e) : (Integer)e;
                maxSet = true;
                continue;
            }
            if (e instanceof Long) {
                max = maxSet ? Math.max(((Number)max).longValue(), (Long)e) : (Long)e;
                maxSet = true;
                continue;
            }
            if (e instanceof Float) {
                max = Float.valueOf(maxSet ? Math.max(((Number)max).floatValue(), ((Float)e).floatValue()) : ((Float)e).floatValue());
                maxSet = true;
                continue;
            }
            if (e instanceof Double) {
                max = maxSet ? Math.max(((Number)max).doubleValue(), (Double)e) : (Double)e;
                maxSet = true;
                continue;
            }
            throw new IllegalArgumentException(String.format("Cannot calculate max on %s", e));
        }
        if (!maxSet) {
            throw new IllegalArgumentException("Cannot calculate the maximum of an empty collection");
        }
        return (E)max;
    }

    public E min() {
        Number min = 0;
        boolean minSet = false;
        for (E e : this) {
            if (e instanceof Integer) {
                min = minSet ? Math.min(min, (Integer)e) : (Integer)e;
                minSet = true;
                continue;
            }
            if (e instanceof Long) {
                min = minSet ? Math.min(((Number)min).longValue(), (Long)e) : (Long)e;
                minSet = true;
                continue;
            }
            if (e instanceof Float) {
                min = Float.valueOf(minSet ? Math.min(((Number)min).floatValue(), ((Float)e).floatValue()) : ((Float)e).floatValue());
                minSet = true;
                continue;
            }
            if (e instanceof Double) {
                min = minSet ? Math.min(((Number)min).doubleValue(), (Double)e) : (Double)e;
                minSet = true;
                continue;
            }
            throw new IllegalArgumentException(String.format("Cannot calculate min on %s", e));
        }
        if (!minSet) {
            throw new IllegalArgumentException("Cannot calculate the minimum of an empty collection");
        }
        return (E)min;
    }

    public E sum() {
        Number sum = 0;
        for (E e : this) {
            if (e instanceof Integer) {
                sum = sum + (Integer)e;
                continue;
            }
            if (e instanceof Long) {
                sum = ((Number)sum).longValue() + (Long)e;
                continue;
            }
            if (e instanceof Float) {
                sum = Float.valueOf(((Number)sum).floatValue() + ((Float)e).floatValue());
                continue;
            }
            if (e instanceof Double) {
                sum = (double)((Number)sum).longValue() + (Double)e;
                continue;
            }
            throw new IllegalArgumentException(String.format("Cannot calculate sum on %s", e));
        }
        return (E)sum;
    }

    public <T> LazySet<Tuple> product(final Iterable<T> c2) {
        final LazyCollection c1 = this;
        return new LazySet<Tuple>(new Iterable<Tuple>(){

            @Override
            public Iterator<Tuple> iterator() {
                return new ReadOnlyIterator<Tuple>(c1){
                    final Iterator<E> c1it;
                    E lastc1;
                    boolean lastc1Set;
                    Iterator<T> c2it;
                    {
                        this.c1it = iterable.iterator();
                        this.c2it = iterable2.iterator();
                    }

                    @Override
                    public Tuple next() {
                        Object lastc2;
                        if (!this.lastc1Set) {
                            this.lastc1 = this.c1it.next();
                            this.lastc1Set = true;
                        }
                        if (this.c2it.hasNext()) {
                            lastc2 = this.c2it.next();
                        } else {
                            this.lastc1 = this.c1it.next();
                            this.c2it = c2.iterator();
                            lastc2 = this.c2it.next();
                        }
                        HashMap<String, Object> tupleValues = new HashMap<String, Object>(2);
                        tupleValues.put("first", this.lastc1);
                        tupleValues.put("second", lastc2);
                        return new Tuple(tupleValues);
                    }

                    @Override
                    public boolean hasNext() {
                        if (this.c2it.hasNext()) {
                            return true;
                        }
                        if (this.c1it.hasNext()) {
                            this.lastc1 = this.c1it.next();
                            this.c2it = c2.iterator();
                            return this.c2it.hasNext();
                        }
                        return false;
                    }
                };
            }
        });
    }

    public LazyBag<E> asBag() {
        return new LazyBag(this);
    }

    public LazyList<E> asSequence() {
        return new LazyList(this);
    }

    public LazySet<E> asSet() {
        return new LazySet(this);
    }

    public LazyOrderedSet<E> asOrderedSet() {
        return new LazyOrderedSet(this);
    }

    public abstract LazyCollection<E> including(E var1);

    public abstract LazyCollection<E> including(E var1, int var2);

    public abstract LazyCollection<E> includingAll(Collection<E> var1);

    public abstract LazyCollection<E> includingAll(Collection<E> var1, int var2);

    public abstract LazyCollection<E> excluding(E var1);

    public abstract LazyCollection<E> excludingAll(Collection<E> var1);

    public abstract LazyCollection<E> includingRange(E var1, E var2);

    public boolean forAll(CodeBlock condition) {
        StackFrame frame = condition.getParentFrame();
        condition.setParentFrame(null);
        for (E e : this) {
            if (((Boolean)condition.execute(frame.getSubFrame(condition, new Object[]{e}))).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public boolean forAll2(CodeBlock condition) {
        StackFrame frame = condition.getParentFrame();
        condition.setParentFrame(null);
        for (E e : this) {
            for (E e2 : this) {
                if (((Boolean)condition.execute(frame.getSubFrame(condition, new Object[]{e, e2}))).booleanValue()) continue;
                return false;
            }
        }
        return true;
    }

    public boolean exists(CodeBlock condition) {
        StackFrame frame = condition.getParentFrame();
        condition.setParentFrame(null);
        for (E e : this) {
            if (!((Boolean)condition.execute(frame.getSubFrame(condition, new Object[]{e}))).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public boolean exists2(CodeBlock condition) {
        StackFrame frame = condition.getParentFrame();
        condition.setParentFrame(null);
        for (E e : this) {
            for (E e2 : this) {
                if (!((Boolean)condition.execute(frame.getSubFrame(condition, new Object[]{e, e2}))).booleanValue()) continue;
                return true;
            }
        }
        return false;
    }

    public <T> T iterate(T initialValue, CodeBlock updater) {
        StackFrame frame = updater.getParentFrame();
        updater.setParentFrame(null);
        Object acc = initialValue;
        for (E e : this) {
            acc = updater.execute(frame.getSubFrame(updater, new Object[]{e, acc}));
        }
        return acc;
    }

    public boolean isUnique(CodeBlock body) {
        StackFrame parentFrame = body.getParentFrame();
        body.setParentFrame(null);
        HashSet<Object> values = new HashSet<Object>(this.size());
        for (E e : this) {
            Object value = body.execute(parentFrame.getSubFrame(body, new Object[]{e}));
            if (values.contains(value)) {
                return false;
            }
            values.add(value);
        }
        return true;
    }

    public E any(CodeBlock body) throws NoSuchElementException {
        StackFrame parentFrame = body.getParentFrame();
        body.setParentFrame(null);
        for (E e : this) {
            if (!((Boolean)body.execute(parentFrame.getSubFrame(body, new Object[]{e}))).booleanValue()) continue;
            return e;
        }
        return null;
    }

    public boolean one(CodeBlock body) {
        boolean result = false;
        StackFrame frame = body.getParentFrame();
        body.setParentFrame(null);
        for (E e : this) {
            if (!((Boolean)body.execute(frame.getSubFrame(body, new Object[]{e}))).booleanValue()) continue;
            if (result) {
                return false;
            }
            result = true;
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class AppendIterator
    extends WrappedIterator {
        protected final E object;
        protected boolean beforeTail;

        public AppendIterator(E object) {
            this.beforeTail = true;
            this.object = object;
        }

        @Override
        public boolean hasNext() {
            assert (this.beforeTail || !this.inner.hasNext());
            return this.beforeTail;
        }

        @Override
        public E next() {
            if (this.inner.hasNext()) {
                return this.inner.next();
            }
            if (this.beforeTail) {
                this.beforeTail = false;
                return this.object;
            }
            throw new NoSuchElementException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CachingIterator
    extends ReadOnlyIterator<E> {
        protected final Iterator<E> inner;
        protected int i;

        public CachingIterator(Iterator<E> inner) {
            this.inner = inner;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean hasNext() {
            Collection collection = LazyCollection.this.cache;
            synchronized (collection) {
                if (this.i < LazyCollection.this.cache.size()) {
                    return true;
                }
                if (LazyCollection.this.dataSource == null) {
                    return false;
                }
            }
            boolean hasNext = this.inner.hasNext();
            if (!hasNext) {
                LazyCollection.this.dataSource = null;
                assert (this.i == LazyCollection.this.cache.size());
            }
            return hasNext;
        }

        @Override
        public E next() {
            Object next = this.inner.next();
            this.updateCache(next);
            return next;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void updateCache(E next) {
            Collection collection = LazyCollection.this.cache;
            synchronized (collection) {
                if (++this.i > LazyCollection.this.cache.size()) {
                    assert (LazyCollection.this.dataSource != null);
                    LazyCollection.this.cache.add(next);
                } else assert (LazyCollection.this.cache.contains(next));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CachingSetIterator
    extends CachingIterator {
        protected final Set<E> returnedValues;
        protected E next;
        protected boolean nextSet;

        public CachingSetIterator() {
            super(LazyCollection.this.dataSource.iterator());
            this.returnedValues = new HashSet();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean hasNext() {
            Collection collection = LazyCollection.this.cache;
            synchronized (collection) {
                if (this.i < LazyCollection.this.cache.size()) {
                    return true;
                }
                if (LazyCollection.this.dataSource == null) {
                    return false;
                }
            }
            if (!this.nextSet && this.inner.hasNext()) {
                this.next = this.inner.next();
                this.nextSet = true;
            }
            while (this.nextSet && this.returnedValues.contains(this.next) && this.inner.hasNext()) {
                this.next = this.inner.next();
            }
            if (this.nextSet && !this.returnedValues.contains(this.next)) {
                return true;
            }
            boolean bl = false;
            boolean hasNext = bl;
            if (hasNext) return hasNext;
            LazyCollection.this.dataSource = null;
            if ($assertionsDisabled) return hasNext;
            if (this.i == LazyCollection.this.cache.size()) return hasNext;
            throw new AssertionError();
        }

        @Override
        public E next() {
            if (!this.nextSet) {
                this.next = this.inner.next();
            } else {
                this.nextSet = false;
            }
            while (this.returnedValues.contains(this.next)) {
                this.next = this.inner.next();
            }
            assert (!this.nextSet && !this.returnedValues.contains(this.next));
            this.returnedValues.add(this.next);
            this.updateCache(this.next);
            return this.next;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CollectIterator<T>
    extends ReadOnlyIterator<T> {
        protected final Iterator<?> inner;
        protected final CodeBlock function;
        protected final StackFrame parentFrame;

        public CollectIterator(Iterable<?> inner, CodeBlock function, StackFrame parentFrame) {
            this.inner = inner.iterator();
            this.function = function;
            this.parentFrame = parentFrame;
        }

        @Override
        public boolean hasNext() {
            return this.inner.hasNext();
        }

        @Override
        public T next() {
            return (T)this.function.execute(this.parentFrame.getSubFrame(this.function, this.inner.next()));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ExcludingIterator
    extends CachingIterator {
        protected final E object;
        protected E next;
        protected boolean nextSet;

        public ExcludingIterator(E object) {
            super(LazyCollection.this.dataSource.iterator());
            this.object = object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean hasNext() {
            Collection collection = LazyCollection.this.cache;
            synchronized (collection) {
                if (this.i < LazyCollection.this.cache.size()) {
                    return true;
                }
                if (LazyCollection.this.dataSource == null) {
                    return false;
                }
            }
            if (!this.nextSet && this.inner.hasNext()) {
                this.next = this.inner.next();
                this.nextSet = true;
            }
            while (this.nextSet && (this.object == null ? this.next == null : this.object.equals(this.next)) && this.inner.hasNext()) {
                this.next = this.inner.next();
            }
            if (this.nextSet && (this.object == null ? this.next != null : !this.object.equals(this.next))) {
                return true;
            }
            boolean bl = false;
            boolean hasNext = bl;
            if (hasNext) return hasNext;
            LazyCollection.this.dataSource = null;
            if ($assertionsDisabled) return hasNext;
            if (this.i == LazyCollection.this.cache.size()) return hasNext;
            throw new AssertionError();
        }

        @Override
        public E next() {
            if (!this.nextSet) {
                this.next = this.inner.next();
            } else {
                this.nextSet = false;
            }
            while (!(this.object == null ? this.next != null : !this.object.equals(this.next))) {
                this.next = this.inner.next();
            }
            assert (!this.nextSet && !(this.object == null ? this.next == null : this.object.equals(this.next)));
            this.updateCache(this.next);
            return this.next;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class FilterIterator
    extends CachingIterator {
        protected final CodeBlock condition;
        protected final StackFrame parentFrame;
        protected E next;
        protected boolean nextSet;
        protected boolean nextIncluded;

        public FilterIterator(CodeBlock condition, StackFrame parentFrame) {
            super(LazyCollection.this.dataSource.iterator());
            this.condition = condition;
            this.parentFrame = parentFrame;
        }

        protected abstract boolean include(E var1);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean hasNext() {
            Collection collection = LazyCollection.this.cache;
            synchronized (collection) {
                if (this.i < LazyCollection.this.cache.size()) {
                    return true;
                }
                if (LazyCollection.this.dataSource == null) {
                    return false;
                }
            }
            if (!this.nextSet && this.inner.hasNext()) {
                this.next = this.inner.next();
                this.nextSet = true;
                this.nextIncluded = this.include(this.next);
            }
            while (this.nextSet && !this.nextIncluded && this.inner.hasNext()) {
                this.next = this.inner.next();
                this.nextIncluded = this.include(this.next);
            }
            if (this.nextSet && this.nextIncluded) {
                return true;
            }
            boolean bl = false;
            boolean hasNext = bl;
            if (hasNext) return hasNext;
            LazyCollection.this.dataSource = null;
            if ($assertionsDisabled) return hasNext;
            if (this.i == LazyCollection.this.cache.size()) return hasNext;
            throw new AssertionError();
        }

        @Override
        public E next() {
            if (!this.nextSet) {
                this.next = this.inner.next();
                this.nextIncluded = this.include(this.next);
            } else {
                this.nextSet = false;
            }
            while (!this.nextIncluded) {
                this.next = this.inner.next();
                this.nextIncluded = this.include(this.next);
            }
            assert (!this.nextSet && this.nextIncluded);
            this.updateCache(this.next);
            return this.next;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FlattenIterator
    extends ReadOnlyIterator<Object> {
        protected final Iterator<?> inner;
        protected Iterator<?> current;
        protected Object next;
        protected boolean nextSet;

        public FlattenIterator(Iterable<?> inner) {
            this.inner = inner.iterator();
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public boolean hasNext() {
            block3: {
                if (this.nextSet) break block3;
                if (this.current == null || !this.current.hasNext()) ** GOTO lbl20
                this.next = this.current.next();
                this.nextSet = true;
                break block3;
lbl-1000:
                // 1 sources

                {
                    this.next = this.inner.next();
                    if (this.next instanceof Set) {
                        this.current = new FlattenSetIterator((Set)this.next);
                        if (!this.current.hasNext()) continue;
                        this.next = this.current.next();
                        this.nextSet = true;
                        continue;
                    }
                    if (this.next instanceof Iterable) {
                        this.current = new FlattenIterator((Iterable)this.next);
                        if (!this.current.hasNext()) continue;
                        this.next = this.current.next();
                        this.nextSet = true;
                        continue;
                    }
                    this.nextSet = true;
lbl20:
                    // 6 sources

                    ** while (!this.nextSet && this.inner.hasNext())
                }
            }
            return this.nextSet;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public Object next() {
            block5: {
                block4: {
                    if (this.nextSet) break block4;
                    if (this.current == null || !this.current.hasNext()) ** GOTO lbl19
                    this.next = this.current.next();
                    break block5;
lbl-1000:
                    // 1 sources

                    {
                        this.next = this.inner.next();
                        if (this.next instanceof Set) {
                            this.current = new FlattenSetIterator((Set)this.next);
                            if (!this.current.hasNext()) continue;
                            this.next = this.current.next();
                            this.nextSet = true;
                            continue;
                        }
                        if (this.next instanceof Iterable) {
                            this.current = new FlattenIterator((Iterable)this.next);
                            if (!this.current.hasNext()) continue;
                            this.next = this.current.next();
                            this.nextSet = true;
                            continue;
                        }
                        this.nextSet = true;
lbl19:
                        // 6 sources

                        ** while (!this.nextSet)
                    }
lbl20:
                    // 1 sources

                    this.nextSet = false;
                    break block5;
                }
                this.nextSet = false;
            }
            if (!FlattenIterator.$assertionsDisabled && this.nextSet) {
                throw new AssertionError();
            }
            return this.next;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FlattenSetIterator
    extends ReadOnlyIterator<Object> {
        protected final Iterator<?> inner;
        protected final Set<?> returnedValues;
        protected Iterator<?> current;
        protected Object next;
        protected boolean nextSet;

        public FlattenSetIterator(Iterable<?> inner) {
            this.inner = inner.iterator();
            this.returnedValues = this.inner instanceof CachingSetIterator ? ((CachingSetIterator)inner.iterator()).returnedValues : new HashSet();
        }

        @Override
        public boolean hasNext() {
            while (!this.nextSet || this.returnedValues.contains(this.next)) {
                if (this.current != null && this.current.hasNext()) {
                    this.next = this.current.next();
                    this.nextSet = true;
                    continue;
                }
                if (!this.inner.hasNext()) break;
                this.nextSet = false;
                this.next = this.inner.next();
                if (this.next instanceof Set) {
                    this.current = new FlattenSetIterator((Set)this.next);
                    if (!this.current.hasNext()) continue;
                    this.next = this.current.next();
                    this.nextSet = true;
                    continue;
                }
                if (this.next instanceof Iterable) {
                    this.current = new FlattenIterator((Iterable)this.next);
                    if (!this.current.hasNext()) continue;
                    this.next = this.current.next();
                    this.nextSet = true;
                    continue;
                }
                this.nextSet = true;
            }
            return this.nextSet && !this.returnedValues.contains(this.next);
        }

        @Override
        public Object next() {
            while (!this.nextSet || this.returnedValues.contains(this.next)) {
                if (this.current != null && this.current.hasNext()) {
                    this.next = this.current.next();
                    this.nextSet = true;
                } else {
                    this.nextSet = false;
                    this.next = this.inner.next();
                    if (this.next instanceof Set) {
                        this.current = new FlattenSetIterator((Set)this.next);
                        if (this.current.hasNext()) {
                            this.next = this.current.next();
                            this.nextSet = true;
                        }
                    } else if (this.next instanceof Iterable) {
                        this.current = new FlattenIterator((Iterable)this.next);
                        if (this.current.hasNext()) {
                            this.next = this.current.next();
                            this.nextSet = true;
                        }
                    } else {
                        this.nextSet = true;
                    }
                }
                this.nextSet = true;
            }
            this.nextSet = false;
            assert (!this.nextSet && !this.returnedValues.contains(this.next));
            return this.next;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IntegerRangeListIterator
    extends ReadOnlyListIterator<Integer> {
        protected final int first;
        protected final int last;
        protected int index;

        public IntegerRangeListIterator(int first, int last) {
            this(first, last, 0);
        }

        public IntegerRangeListIterator(int first, int last, int index) {
            if (first > last) {
                throw new IllegalArgumentException(String.format("The first element of a range (%d) cannot be greater than the last (%d)", first, last));
            }
            this.first = first;
            this.last = last;
            if (index > last - first + 1) {
                throw new IndexOutOfBoundsException(Integer.toString(index));
            }
            this.index = index;
        }

        @Override
        public boolean hasNext() {
            return this.index <= this.last - this.first;
        }

        @Override
        public Integer next() {
            return this.first + this.index++;
        }

        @Override
        public boolean hasPrevious() {
            return this.index > 0;
        }

        @Override
        public Integer previous() {
            return this.first + --this.index;
        }

        @Override
        public int nextIndex() {
            return this.index;
        }

        @Override
        public int previousIndex() {
            return this.index - 1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class IntersectionIterator
    extends CachingIterator {
        protected final Collection<E> s;
        protected E next;
        protected boolean nextSet;

        public IntersectionIterator(Collection<E> s) {
            super(LazyCollection.this.dataSource.iterator());
            this.s = s;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean hasNext() {
            Collection collection = LazyCollection.this.cache;
            synchronized (collection) {
                if (this.i < LazyCollection.this.cache.size()) {
                    return true;
                }
                if (LazyCollection.this.dataSource == null) {
                    return false;
                }
            }
            if (!this.nextSet && this.inner.hasNext()) {
                this.next = this.inner.next();
                this.nextSet = true;
            }
            while (this.nextSet && !this.s.contains(this.next) && this.inner.hasNext()) {
                this.next = this.inner.next();
            }
            if (this.nextSet && this.s.contains(this.next)) {
                return true;
            }
            boolean bl = false;
            boolean hasNext = bl;
            if (hasNext) return hasNext;
            LazyCollection.this.dataSource = null;
            if ($assertionsDisabled) return hasNext;
            if (this.i == LazyCollection.this.cache.size()) return hasNext;
            throw new AssertionError();
        }

        @Override
        public E next() {
            if (!this.nextSet) {
                this.next = this.inner.next();
            } else {
                this.nextSet = false;
            }
            while (!this.s.contains(this.next)) {
                this.next = this.inner.next();
            }
            assert (!this.nextSet && this.s.contains(this.next));
            this.updateCache(this.next);
            return this.next;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     * Exception performing whole class analysis.
     */
    public class IteratorToListIterator
    extends CachingIterator
    implements ListIterator<E> {
        final /* synthetic */ LazyCollection this$0;

        public IteratorToListIterator(LazyCollection lazyCollection) {
            this.this$0 = lazyCollection;
            super(lazyCollection.iterator());
        }

        /*
         * Unable to fully structure code
         */
        public IteratorToListIterator(LazyCollection var1_1, int index) {
            this.this$0 = var1_1;
            super(var1_1.iterator());
            if (index >= 0) ** GOTO lbl7
            throw new IndexOutOfBoundsException();
lbl-1000:
            // 1 sources

            {
                this.next();
lbl7:
                // 2 sources

                ** while (this.nextIndex() < index)
            }
lbl8:
            // 1 sources

        }

        @Override
        public void add(E o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(E o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasPrevious() {
            return this.i > 0;
        }

        @Override
        public E next() {
            if (this.i < this.this$0.cache.size()) {
                return ((List)this.this$0.cache).get(this.i++);
            }
            Object next = this.inner.next();
            this.updateCache(next);
            return next;
        }

        @Override
        public int nextIndex() {
            return this.i;
        }

        @Override
        public E previous() {
            if (this.i > 0) {
                return ((List)this.this$0.cache).get(--this.i);
            }
            throw new NoSuchElementException();
        }

        @Override
        public int previousIndex() {
            return this.i - 1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LongRangeListIterator
    extends ReadOnlyListIterator<Long> {
        protected final long first;
        protected final long last;
        protected int index;

        public LongRangeListIterator(long first, long last) {
            this(first, last, 0);
        }

        public LongRangeListIterator(long first, long last, int index) {
            if (first > last) {
                throw new IllegalArgumentException(String.format("The first element of a range (%d) cannot be greater than the last (%d)", first, last));
            }
            this.first = first;
            this.last = last;
            if ((long)index > last - first + 1L) {
                throw new IndexOutOfBoundsException(Integer.toString(index));
            }
            this.index = index;
        }

        @Override
        public boolean hasNext() {
            return (long)this.index <= this.last - this.first;
        }

        @Override
        public Long next() {
            return this.first + (long)this.index++;
        }

        @Override
        public boolean hasPrevious() {
            return this.index > 0;
        }

        @Override
        public Long previous() {
            return this.first + (long)(--this.index);
        }

        @Override
        public int nextIndex() {
            return this.index;
        }

        @Override
        public int previousIndex() {
            return this.index - 1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class ReadOnlyIterator<E>
    implements Iterator<E> {
        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class ReadOnlyListIterator<E>
    extends ReadOnlyIterator<E>
    implements ListIterator<E> {
        @Override
        public void add(E o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(E o) {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class RejectIterator
    extends FilterIterator {
        public RejectIterator(CodeBlock condition, StackFrame parentFrame) {
            super(condition, parentFrame);
        }

        @Override
        protected final boolean include(E element) {
            return (Boolean)this.condition.execute(this.parentFrame.getSubFrame(this.condition, new Object[]{this.next})) == false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ReverseIterator
    extends ReadOnlyIterator<E> {
        protected int index;

        public ReverseIterator(int lastIndex) {
            this.index = lastIndex;
        }

        @Override
        public boolean hasNext() {
            return this.index >= 0;
        }

        @Override
        public E next() {
            return ((List)LazyCollection.this.dataSource).get(this.index--);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ReverseListIterator
    extends ReadOnlyListIterator<E> {
        protected final int lastIndex;
        protected int index;

        public ReverseListIterator(int lastIndex) {
            this.index = lastIndex;
            this.lastIndex = lastIndex;
        }

        public ReverseListIterator(int lastIndex, int index) {
            this.lastIndex = lastIndex;
            this.index = index;
            if (index < 0 || index > lastIndex) {
                throw new IndexOutOfBoundsException(String.valueOf(index));
            }
        }

        @Override
        public boolean hasNext() {
            return this.index >= 0;
        }

        @Override
        public E next() {
            return ((List)LazyCollection.this.dataSource).get(this.index--);
        }

        @Override
        public int nextIndex() {
            return this.lastIndex - this.index;
        }

        @Override
        public boolean hasPrevious() {
            return this.index < this.lastIndex;
        }

        @Override
        public E previous() {
            return ((List)LazyCollection.this.dataSource).get(++this.index);
        }

        @Override
        public int previousIndex() {
            return this.lastIndex - this.index - 1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SelectIterator
    extends FilterIterator {
        public SelectIterator(CodeBlock condition, StackFrame parentFrame) {
            super(condition, parentFrame);
        }

        @Override
        protected final boolean include(E element) {
            return (Boolean)this.condition.execute(this.parentFrame.getSubFrame(this.condition, new Object[]{this.next}));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SubListIterator
    extends ReadOnlyIterator<E> {
        protected final int toIndex;
        protected int i;

        public SubListIterator(int fromIndex, int toIndex) {
            this.i = fromIndex;
            this.toIndex = toIndex;
            assert (LazyCollection.this.dataSource instanceof List);
        }

        @Override
        public boolean hasNext() {
            return this.i < this.toIndex;
        }

        @Override
        public E next() {
            return ((List)LazyCollection.this.dataSource).get(this.i++);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SubListListIterator
    extends ReadOnlyListIterator<E> {
        protected final int fromIndex;
        protected final int toIndex;
        protected int i;

        public SubListListIterator(int fromIndex, int toIndex) {
            this.i = fromIndex;
            this.fromIndex = fromIndex;
            this.toIndex = toIndex;
            assert (LazyCollection.this.dataSource instanceof List);
        }

        public SubListListIterator(int fromIndex, int toIndex, int index) {
            this.fromIndex = fromIndex;
            this.toIndex = toIndex;
            this.i = index;
            if (fromIndex > index || index >= toIndex) {
                throw new IndexOutOfBoundsException(String.valueOf(index));
            }
            assert (LazyCollection.this.dataSource instanceof List);
        }

        @Override
        public boolean hasNext() {
            return this.i < this.toIndex;
        }

        @Override
        public E next() {
            return ((List)LazyCollection.this.dataSource).get(this.i++);
        }

        @Override
        public int nextIndex() {
            return this.i;
        }

        @Override
        public boolean hasPrevious() {
            return this.i > this.fromIndex;
        }

        @Override
        public E previous() {
            return ((List)LazyCollection.this.dataSource).get(--this.i);
        }

        @Override
        public int previousIndex() {
            return this.i - 1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SubtractionIterator
    extends CachingIterator {
        protected final Collection<E> s;
        protected E next;
        protected boolean nextSet;

        public SubtractionIterator(Collection<E> s) {
            super(LazyCollection.this.dataSource.iterator());
            this.s = s;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean hasNext() {
            Collection collection = LazyCollection.this.cache;
            synchronized (collection) {
                if (this.i < LazyCollection.this.cache.size()) {
                    return true;
                }
                if (LazyCollection.this.dataSource == null) {
                    return false;
                }
            }
            if (!this.nextSet && this.inner.hasNext()) {
                this.next = this.inner.next();
                this.nextSet = true;
            }
            while (this.nextSet && this.s.contains(this.next) && this.inner.hasNext()) {
                this.next = this.inner.next();
            }
            if (this.nextSet && !this.s.contains(this.next)) {
                return true;
            }
            boolean bl = false;
            boolean hasNext = bl;
            if (hasNext) return hasNext;
            LazyCollection.this.dataSource = null;
            if ($assertionsDisabled) return hasNext;
            if (this.i == LazyCollection.this.cache.size()) return hasNext;
            throw new AssertionError();
        }

        @Override
        public E next() {
            if (!this.nextSet) {
                this.next = this.inner.next();
            } else {
                this.nextSet = false;
            }
            while (this.s.contains(this.next)) {
                this.next = this.inner.next();
            }
            assert (!this.nextSet && !this.s.contains(this.next));
            this.updateCache(this.next);
            return this.next;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class UnionIterator
    extends WrappedIterator {
        protected final Iterable<E> s;
        protected Iterator<E> added;
        protected boolean innerNext;

        public UnionIterator(Iterable<E> s) {
            this.s = s;
        }

        @Override
        public boolean hasNext() {
            if (this.added == null) {
                this.innerNext = this.inner.hasNext();
                if (this.innerNext) {
                    return true;
                }
                this.added = this.s.iterator();
            }
            return this.added.hasNext();
        }

        @Override
        public E next() {
            if (this.added == null) {
                if (this.innerNext || this.inner.hasNext()) {
                    this.innerNext = false;
                    return this.inner.next();
                }
                this.added = this.s.iterator();
            }
            return this.added.next();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class UnionSetIterator
    extends CachingSetIterator {
        protected final Iterable<E> s;
        protected Iterator<E> added;
        protected boolean innerNext;

        public UnionSetIterator(Iterable<E> s) {
            this.s = s;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean hasNext() {
            Collection collection = LazyCollection.this.cache;
            synchronized (collection) {
                if (this.i < LazyCollection.this.cache.size()) {
                    return true;
                }
                if (LazyCollection.this.dataSource == null) {
                    return false;
                }
            }
            if (this.added == null) {
                this.innerNext = this.inner.hasNext();
                if (this.innerNext) {
                    return true;
                }
                this.added = this.s.iterator();
                this.nextSet = false;
            }
            if (!this.nextSet && this.added.hasNext()) {
                this.next = this.added.next();
                this.nextSet = true;
            }
            while (this.nextSet && this.returnedValues.contains(this.next) && this.added.hasNext()) {
                this.next = this.added.next();
            }
            if (this.nextSet && !this.returnedValues.contains(this.next)) {
                return true;
            }
            boolean bl = false;
            boolean hasNext = bl;
            if (hasNext) return hasNext;
            LazyCollection.this.dataSource = null;
            if ($assertionsDisabled) return hasNext;
            if (this.i == LazyCollection.this.cache.size()) return hasNext;
            throw new AssertionError();
        }

        @Override
        public E next() {
            if (this.added == null) {
                if (this.innerNext || this.inner.hasNext()) {
                    this.innerNext = false;
                    this.next = this.inner.next();
                    this.returnedValues.add(this.next);
                    this.updateCache(this.next);
                    return this.next;
                }
                this.added = this.s.iterator();
                this.nextSet = false;
            }
            if (!this.nextSet) {
                this.next = this.added.next();
            } else {
                this.nextSet = false;
            }
            while (this.returnedValues.contains(this.next)) {
                this.next = this.added.next();
            }
            assert (!this.nextSet && !this.returnedValues.contains(this.next));
            this.returnedValues.add(this.next);
            this.updateCache(this.next);
            return this.next;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class WrappedIterator
    extends ReadOnlyIterator<E> {
        protected final Iterator<E> inner;

        public WrappedIterator() {
            this.inner = LazyCollection.this.dataSource.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.inner.hasNext();
        }

        @Override
        public E next() {
            return this.inner.next();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class WrappedListIterator
    extends ReadOnlyListIterator<E> {
        protected final ListIterator<E> inner;

        public WrappedListIterator() {
            this.inner = ((List)LazyCollection.this.dataSource).listIterator();
        }

        public WrappedListIterator(int index) {
            this.inner = ((List)LazyCollection.this.dataSource).listIterator(index);
        }

        @Override
        public boolean hasNext() {
            return this.inner.hasNext();
        }

        @Override
        public boolean hasPrevious() {
            return this.inner.hasPrevious();
        }

        @Override
        public E next() {
            return this.inner.next();
        }

        @Override
        public int nextIndex() {
            return this.inner.nextIndex();
        }

        @Override
        public E previous() {
            return this.inner.previous();
        }

        @Override
        public int previousIndex() {
            return this.inner.previousIndex();
        }
    }
}

