/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.tests.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WikiOutputter {
    private static final String TESTS_PATH = "results/tests.properties";
    private static final String HEADER_PATH = "results/header.txt";
    private static final String WIKI_PATH = "results/wiki_table.txt";
    private static final String BOTTOM_PATH = "results/bottom.txt";
    private static final String EMFVM_DATA_PATH = "results/EMFVM_results.xml";
    private static final String VM_DATA_PATH = "results/VM_results.xml";
    private static Map<String, String> directories = new HashMap<String, String>();

    private WikiOutputter() {
    }

    public static void main(String[] args) {
        try {
            Map<String, String> vmResults = WikiOutputter.initResults(VM_DATA_PATH);
            Map<String, String> emfVMResults = WikiOutputter.initResults(EMFVM_DATA_PATH);
            FileWriter fw = new FileWriter(WIKI_PATH);
            fw.write(WikiOutputter.getFragment(HEADER_PATH));
            Properties tests = new Properties();
            FileInputStream fis = new FileInputStream(new File(TESTS_PATH));
            tests.load(fis);
            for (Map.Entry<Object, Object> test : tests.entrySet()) {
                String testName = (String)test.getKey();
                String comment = (String)test.getValue();
                String emfVMTime = emfVMResults.get(testName);
                String vmTime = vmResults.get(testName);
                String directory = directories.get(testName);
                if (directory == null) continue;
                fw.write("|-\n");
                fw.write("! colspan=1 | [http://dev.eclipse.org/viewcvs/index.cgi/org.eclipse.m2m/org.eclipse.m2m.atl/tests" + directory.replaceAll("\\\\", "/") + "?root=Modeling_Project " + testName + "]\n");
                fw.write("! colspan=1 | <b style=\"color:green\">PASS</b>\n");
                fw.write("! colspan=1 | " + vmTime + "s.\n");
                fw.write("! colspan=1 | " + emfVMTime + "s.\n");
                fw.write("! colspan=1 | " + comment + "\n");
            }
            fw.write("|-\n");
            fw.write("! colspan=2 | Total time : \n");
            fw.write("! colspan=1 | " + new Double(vmResults.get("TOTAL")).floatValue() + "s.\n");
            fw.write("! colspan=1 | " + new Double(emfVMResults.get("TOTAL")).floatValue() + "s.\n");
            fw.write("|}\n\nTests realized on " + new Date() + " with :\n");
            fw.write(WikiOutputter.getFragment(BOTTOM_PATH));
            fw.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
    }

    private static Map<String, String> initResults(String path) throws SAXException, ParserConfigurationException, IOException {
        HashMap<String, String> res = new HashMap<String, String>();
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        Document doc = docBuilder.parse(new File(path));
        Element rootElement = doc.getDocumentElement();
        NodeList childs = rootElement.getChildNodes();
        int i = 0;
        while (i < childs.getLength()) {
            Node node = childs.item(i);
            if (node instanceof Element) {
                Element element = (Element)node;
                String name = element.getAttribute("name");
                res.put(name, element.getAttribute("time"));
                if (directories.get(name) == null) {
                    directories.put(name, element.getAttribute("directory"));
                }
            }
            ++i;
        }
        return res;
    }

    private static String getFragment(String path) throws IOException {
        StringBuffer content = new StringBuffer();
        BufferedReader reader = new BufferedReader(new FileReader(path));
        char[] buf = new char[1024];
        int numRead = 0;
        while ((numRead = reader.read(buf)) != -1) {
            String readData = String.valueOf(buf, 0, numRead);
            content.append(readData);
            buf = new char[1024];
        }
        reader.close();
        return content.toString();
    }
}

