/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.tests.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.diff.metamodel.DiffModel;
import org.eclipse.emf.compare.diff.service.DiffService;
import org.eclipse.emf.compare.match.metamodel.MatchModel;
import org.eclipse.emf.compare.match.service.MatchService;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ModelUtils {
    private static final String ENCODING_PROPERTY = "file.encoding";
    private static ResourceSet resourceSet = new ResourceSetImpl();

    private ModelUtils() {
    }

    public static Resource load(File file) throws IOException {
        Resource.Factory.Registry reg;
        Object resourceFactory;
        URI modelURI = URI.createFileURI((String)file.getPath());
        String fileExtension = modelURI.fileExtension();
        if (fileExtension == null || fileExtension.length() == 0) {
            fileExtension = "*";
        }
        if ((resourceFactory = (reg = Resource.Factory.Registry.INSTANCE).getExtensionToFactoryMap().get(fileExtension)) != null) {
            resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put(fileExtension, resourceFactory);
        } else {
            resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put(fileExtension, new XMIResourceFactoryImpl());
        }
        Resource result = resourceSet.createResource(modelURI);
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("ENCODING", System.getProperty(ENCODING_PROPERTY));
        result.load(options);
        return result;
    }

    private static Set<EObject> getElementsByType(Resource extent, String type) {
        HashSet<EObject> ret = new HashSet<EObject>();
        TreeIterator i = extent.getAllContents();
        while (i.hasNext()) {
            EObject eo = (EObject)i.next();
            if (!eo.eClass().getName().equals(type)) continue;
            ret.add(eo);
        }
        return ret;
    }

    public static void registerMetamodel(URI metamodelURI) throws IOException {
        if (EPackage.Registry.INSTANCE.getEPackage(metamodelURI.toString()) != null) {
            return;
        }
        EcoreResourceFactoryImpl myEcoreFactory = new EcoreResourceFactoryImpl();
        Resource mmExtent = myEcoreFactory.createResource(metamodelURI);
        mmExtent.load((InputStream)new FileInputStream(metamodelURI.toFileString()), Collections.EMPTY_MAP);
        for (EPackage ePackage : ModelUtils.getElementsByType(mmExtent, "EPackage")) {
            String nsURI = ePackage.getNsURI();
            if (nsURI == null) {
                nsURI = ePackage.getName();
                ePackage.setNsURI(nsURI);
            }
            EPackage.Registry.INSTANCE.put((Object)nsURI, (Object)ePackage);
        }
        for (EObject eObject : ModelUtils.getElementsByType(mmExtent, "EDataType")) {
            EStructuralFeature sf = eObject.eClass().getEStructuralFeature("name");
            String tname = (String)eObject.eGet(sf);
            String icn = null;
            if (tname.equals("Boolean")) {
                icn = "java.lang.Boolean";
            } else if (tname.equals("Double") || tname.equals("Real")) {
                icn = "java.lang.Double";
            } else if (tname.equals("Float")) {
                icn = "java.lang.Float";
            } else if (tname.equals("Integer")) {
                icn = "java.lang.Integer";
            } else if (tname.equals("String")) {
                icn = "java.lang.String";
            }
            if (icn == null) continue;
            sf = eObject.eClass().getEStructuralFeature("instanceClassName");
            eObject.eSet(sf, (Object)icn);
        }
    }

    public static void save(EObject root, String path) throws IOException {
        URI modelURI = URI.createURI((String)path);
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
        Resource newModelResource = resourceSet.createResource(modelURI);
        newModelResource.getContents().add((Object)root);
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("ENCODING", System.getProperty(ENCODING_PROPERTY));
        newModelResource.save(options);
    }

    public static String serialize(EObject root) throws IOException {
        if (root == null) {
            throw new NullPointerException("ModelUtils.NullSaveRoot");
        }
        XMIResourceImpl newResource = new XMIResourceImpl();
        StringWriter writer = new StringWriter();
        newResource.getContents().add((Object)root);
        newResource.save((Writer)writer, Collections.EMPTY_MAP);
        return writer.toString();
    }

    public static DiffModel compareModels(File leftUri, File rightUri, boolean ignoreIds, boolean delete) throws IOException, InterruptedException {
        Resource leftModel = ModelUtils.load(leftUri);
        Resource rightModel = ModelUtils.load(rightUri);
        DiffModel res = ModelUtils.compareModels(leftModel, rightModel, ignoreIds);
        if (delete) {
            leftUri.delete();
        }
        return res;
    }

    public static DiffModel compareModels(Resource leftModel, Resource rightModel, boolean ignoreIds) throws IOException, InterruptedException {
        HashMap<String, Boolean> options = new HashMap<String, Boolean>();
        if (ignoreIds) {
            options.put("match.ignore.xmi.id", Boolean.TRUE);
        }
        MatchModel inputMatch = MatchService.doResourceMatch((Resource)leftModel, (Resource)rightModel, options);
        return DiffService.doDiff((MatchModel)inputMatch);
    }
}

