/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.am3.tools.tge.outline;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.am3.core.AM3Handler;
import org.eclipse.am3.tools.tge.TextualGenericEditorPlugin;
import org.eclipse.am3.tools.tge.editor.TextualGenericEditor;
import org.eclipse.am3.tools.tge.outline.ContentProvider;
import org.eclipse.am3.tools.tge.outline.DocumentOffsetCount;
import org.eclipse.am3.tools.tge.outline.LabelProvider;
import org.eclipse.am3.tools.tge.outline.OutlineContent;
import org.eclipse.am3.tools.tge.outline.OutlineNode;
import org.eclipse.am3.tools.tge.outline.SelectionChangedListener;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.m2m.atl.engine.vm.nativelib.AMN;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMInteger;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModelElement;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMOclAny;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMSequence;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMString;
import org.eclipse.m2m.atl.ocl.core.OclHelper;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;

public class TextualGenericEditorContentOutlinePage
extends ContentOutlinePage {
    private DocumentOffsetCount help;
    protected ListenerList selectionChangedListeners = new ListenerList();
    private TreeViewer viewer;
    private TextualGenericEditor textEditor;
    private SelectionChangedListener selectionChangedListener;
    private IEditorInput editorInput;
    private OutlineContent outlineContent;
    private boolean allFilesForOutlinePresents = false;
    private AM3Handler outlineHandler;
    private String languageMetamodelUri;
    private String languageMetamodelName;
    private String ebnfInjectorUri;
    private String classNamePrefix;
    private int antlrVersion;
    private static OclHelper getOutlineOfEditorRelation = new OclHelper("editor.relationEnds->collect(e | e.relation)->select(e | e.oclIsKindOf(AM3!OutlineOfEditor))->first()", Arrays.asList("editor"));

    public TextualGenericEditorContentOutlinePage(TextualGenericEditor textEditor, IEditorInput editorInput, IDocumentProvider documentProvider) {
        this.textEditor = textEditor;
        this.editorInput = editorInput;
        this.help = new DocumentOffsetCount(textEditor);
        this.outlineContent = new OutlineContent(this.help, this, textEditor);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.viewer = this.getTreeViewer();
        this.selectionChangedListener = new SelectionChangedListener((ITextEditor)this.textEditor);
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this.selectionChangedListener);
        this.viewer.setContentProvider((IContentProvider)new ContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(this));
        this.viewer.setInput((Object)this.createOutline(this.editorInput));
        this.selectionChangedListener.fullStop();
        this.viewer.expandToLevel(2);
        if (this.allFilesForOutlinePresents) {
            this.selectionChangedListener.start();
        }
    }

    public void update() {
        this.help.updateInput();
        this.getControl().setRedraw(false);
        this.getTreeViewer().setInput((Object)this.createOutline(this.editorInput));
        this.getTreeViewer().expandToLevel(2);
        this.updateSelection();
        this.getControl().setRedraw(true);
    }

    public OutlineNode createOutline(IEditorInput aEditorInput) {
        LinkedList missingFiles = this.areThereMissingFiles();
        this.allFilesForOutlinePresents = missingFiles.isEmpty();
        if (this.allFilesForOutlinePresents) {
            this.outlineContent.init();
            this.selectionChangedListener.start();
            return this.outlineContent.languageParser(aEditorInput);
        }
        this.selectionChangedListener.fullStop();
        return this.createMissingFileOutline(missingFiles);
    }

    public OutlineNode createErrorOutline(String msg) {
        OutlineNode noderoot = new OutlineNode("root");
        noderoot.addChild(new OutlineNode(msg, "../list_file_missing.gif"));
        this.allFilesForOutlinePresents = false;
        this.selectionChangedListener.fullStop();
        return noderoot;
    }

    private OutlineNode createMissingFileOutline(LinkedList missing) {
        OutlineNode noderoot = new OutlineNode("root");
        OutlineNode fileMissing = new OutlineNode("Files missing", "../list_file_missing.gif");
        noderoot.addChild(fileMissing);
        int i = 0;
        while (i < missing.size()) {
            fileMissing.addChild(new OutlineNode((String)missing.get(i), "../file_missing.gif"));
            ++i;
        }
        return noderoot;
    }

    public void updateSelection() {
        IWorkbenchPart part = TextualGenericEditorPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getPartService().getActivePart();
        if (!(part instanceof TextualGenericEditor)) {
            return;
        }
        if (this.selectionChangedListener != null && this.allFilesForOutlinePresents) {
            this.selectionChangedListener.stopListener(true);
            this.doSetSelection(this.textEditor.cursorPosition());
            this.selectionChangedListener.stopListener(false);
        }
    }

    public void doSetSelectionLocation(String location) {
        if (!this.viewer.getTree().isDisposed()) {
            String[] coor = location.split("-")[0].split(":");
            int line = Integer.parseInt(coor[0].trim());
            int column = Integer.parseInt(coor[1].trim());
            OutlineNode root = (OutlineNode)this.viewer.getInput();
            OutlineNode select = root.findPosition(this.help.getPositionTab1(line, column).getOffset());
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)select), true);
        }
    }

    private void doSetSelection(String cursorPosition) {
        if (cursorPosition != null && !this.viewer.getTree().isDisposed()) {
            String[] coor = cursorPosition.split(":");
            int line = Integer.parseInt(coor[0].trim());
            int column = Integer.parseInt(coor[1].trim());
            OutlineNode root = (OutlineNode)this.viewer.getInput();
            OutlineNode select = root.findPosition(this.help.getPosition(line, column).getOffset());
            if (select != null) {
                this.viewer.setSelection((ISelection)new StructuredSelection((Object)select), true);
            }
        }
    }

    public LinkedList areThereMissingFiles() {
        LinkedList<String> missingFiles = new LinkedList<String>();
        this.initHandler(this.textEditor.getEditorArtifact());
        if (this.outlineHandler == null) {
            missingFiles.add("Outline.ecore");
        }
        if (this.languageMetamodelUri == null) {
            missingFiles.add("Language Metamodel");
        }
        return missingFiles;
    }

    public void initHandler(ASMModelElement editorArtifact) {
        try {
            ASMOclAny outlineOfEditorRelation = getOutlineOfEditorRelation.eval(Arrays.asList(editorArtifact), this.textEditor.getModels());
            if (outlineOfEditorRelation instanceof ASMModelElement) {
                ASMSequence relationEnds = (ASMSequence)outlineOfEditorRelation.get(null, "relationEnds");
                Iterator it = relationEnds.iterator();
                while (it.hasNext()) {
                    ASMModelElement currentRelationEnd = (ASMModelElement)it.next();
                    ASMModelElement artifact = (ASMModelElement)currentRelationEnd.get(null, "artifact");
                    if (artifact.getType().getName().equals("AM3!Outline")) {
                        String outlineModelUri = TextualGenericEditor.getArtifactUri(artifact);
                        ASMOclAny cls = TextualGenericEditor.getMetamodel.eval(Arrays.asList(artifact), this.textEditor.getModels());
                        if (!(cls instanceof ASMModelElement)) continue;
                        String outlineMetamodelUri = TextualGenericEditor.getArtifactUri((ASMModelElement)cls);
                        this.outlineHandler = new AM3Handler(outlineMetamodelUri, outlineModelUri);
                        continue;
                    }
                    if (artifact.getType().getName().equals("AM3!Metamodel")) {
                        this.languageMetamodelUri = TextualGenericEditor.getArtifactUri(artifact);
                        this.languageMetamodelName = AMN.getString((ASMModelElement)artifact, (String)"name");
                        continue;
                    }
                    if (!artifact.getType().getName().equals("AM3!EBNFInjector")) continue;
                    this.classNamePrefix = ((ASMString)artifact.get(null, "classNamePrefix")).getSymbol();
                    this.antlrVersion = 2;
                    ASMOclAny antlrVersion_ = AMN.get((ASMModelElement)artifact, (String)"antlrVersion");
                    if (antlrVersion_ instanceof ASMInteger) {
                        this.antlrVersion = ((ASMInteger)antlrVersion_).getSymbol();
                    }
                    this.ebnfInjectorUri = TextualGenericEditor.getArtifactUri(artifact);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getClassNamePrefix() {
        return this.classNamePrefix;
    }

    public int getAntlrVersion() {
        return this.antlrVersion;
    }

    public String getLanguageMetamodelUri() {
        return this.languageMetamodelUri;
    }

    public String getLanguageMetamodelName() {
        return this.languageMetamodelName;
    }

    public AM3Handler getOutlineHandler() {
        return this.outlineHandler;
    }

    public String getEBNFInjectorUri() {
        return this.ebnfInjectorUri;
    }

    public OutlineContent getContent() {
        return this.outlineContent;
    }
}

