/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.motioncalculator;

import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.lsat.motioncalculator.MotionProfileParameter;

public final class MotionProfile
implements Serializable {
    private static final long serialVersionUID = 2661785996931068260L;
    private final String key;
    private final String name;
    private boolean defaultProfile;
    private final URL url;
    private final List<MotionProfileParameter> parameters = new ArrayList<MotionProfileParameter>();

    public MotionProfile(String key, String name, URL url, Collection<MotionProfileParameter> parameters) {
        this.key = key;
        this.name = name;
        this.url = url;
        List parameterKeys = parameters.stream().map(MotionProfileParameter::getKey).collect(Collectors.toList());
        HashSet parameterKeysSet = new HashSet(parameterKeys);
        if (parameterKeys.size() != parameterKeysSet.size()) {
            parameterKeys.removeAll(parameterKeysSet);
            throw new IllegalArgumentException("Parameter keys should be unique: " + String.valueOf(parameterKeys));
        }
        for (MotionProfileParameter parameter : parameters) {
            this.parameters.add(parameter);
        }
    }

    public String getKey() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    public URL getUrl() {
        return this.url;
    }

    public boolean isDefaultProfile() {
        return this.defaultProfile;
    }

    public void setDefaultProfile(boolean defaultProfile) {
        this.defaultProfile = defaultProfile;
    }

    public Collection<MotionProfileParameter> getParameters() {
        return Collections.unmodifiableCollection(this.parameters);
    }

    public MotionProfileParameter getParameter(String key) {
        return this.parameters.stream().filter(p -> p.getKey().equals(key)).findFirst().orElse(null);
    }

    public String toString() {
        return this.getName();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.parameters == null ? 0 : this.parameters.hashCode());
        result = 31 * result + (this.url == null ? 0 : this.url.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MotionProfile other = (MotionProfile)obj;
        if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.parameters == null ? other.parameters != null : !this.parameters.equals(other.parameters)) {
            return false;
        }
        return !(this.url == null ? other.url != null : !this.url.equals(other.url));
    }
}

