/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.Geometry;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swtchart.Resources;

public class ClickBindingHelpDialog
extends Window {
    private static final int POPUP_FONT_SIZEFACTOR_KEY_LABEL = 2;
    private static final int POPUP_FONT_SIZEFACTOR_KEY = 3;
    private static final int MARGIN_BOTTOM = 25;
    private final List<Resource> resources = new ArrayList<Resource>(3);
    private final int timeToClose;
    private String shortcut;
    private String name;
    private String description;
    private boolean readyToClose = true;

    public ClickBindingHelpDialog(Shell parentShell, int timeToClose) {
        super(parentShell);
        this.timeToClose = timeToClose;
        this.setShellStyle(16396);
    }

    public void setShortcut(String shortcut, String shortcutText, String shortcutDescription) {
        this.shortcut = shortcut;
        this.name = shortcutText;
        this.description = shortcutDescription;
    }

    public int open() {
        this.scheduleClose();
        Shell shell = this.getShell();
        if (shell == null || shell.isDisposed()) {
            this.create();
            shell = this.getShell();
        }
        this.constrainShellSize();
        shell.setVisible(true);
        return 0;
    }

    private void scheduleClose() {
        this.readyToClose = true;
        Display.getDefault().timerExec(this.timeToClose, () -> {
            if (this.readyToClose && this.getShell() != null && !this.getShell().isDisposed()) {
                this.close();
            }
        });
    }

    public boolean close() {
        boolean closed = super.close();
        for (Resource resource : this.resources) {
            resource.dispose();
        }
        this.resources.clear();
        return closed;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        Color color = Resources.getColor((String)"66,66,66");
        newShell.setBackground(color);
        newShell.setAlpha(170);
    }

    protected Control createContents(Composite parent) {
        Font shortcutFont;
        FontData fontData;
        Font font = JFaceResources.getDialogFont();
        FontData[] defaultFontData = font.getFontData();
        Color foregroundColor = parent.getDisplay().getSystemColor(1);
        Composite contents = new Composite(parent, 0);
        GridLayoutFactory.swtDefaults().applyTo(contents);
        contents.setBackground(parent.getBackground());
        Object primaryText = null;
        if (this.shortcut != null && this.name != null) {
            primaryText = this.shortcut + " \u2013 " + this.name;
        } else if (this.shortcut != null) {
            primaryText = this.shortcut;
        } else if (this.name != null) {
            primaryText = this.name;
        }
        if (primaryText != null) {
            Label shortcutLabel = new Label(contents, 0x1000000);
            GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).applyTo((Control)shortcutLabel);
            fontData = new FontData(defaultFontData[0].getName(), defaultFontData[0].getHeight() * 3, 1);
            shortcutFont = new Font((Device)this.getShell().getDisplay(), fontData);
            this.resources.add((Resource)shortcutFont);
            shortcutLabel.setBackground(parent.getBackground());
            shortcutLabel.setForeground(foregroundColor);
            shortcutLabel.setFont(shortcutFont);
            shortcutLabel.setText((String)primaryText);
        }
        if (this.description != null) {
            Label shortcutDescriptionLabel = new Label(contents, 0x1000000);
            GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).applyTo((Control)shortcutDescriptionLabel);
            fontData = new FontData(defaultFontData[0].getName(), (int)((double)defaultFontData[0].getHeight() * 1.3), 0);
            shortcutFont = new Font((Device)this.getShell().getDisplay(), fontData);
            this.resources.add((Resource)shortcutFont);
            shortcutDescriptionLabel.setFont(shortcutFont);
            shortcutDescriptionLabel.setBackground(parent.getBackground());
            shortcutDescriptionLabel.setForeground(foregroundColor);
            shortcutDescriptionLabel.setText(this.description);
        }
        return contents;
    }

    protected Point getInitialLocation(Point initialSize) {
        Composite parent = this.getShell().getParent();
        Rectangle parentBounds = parent.getBounds();
        Monitor monitor = parent.getMonitor();
        Rectangle monitorBounds = monitor.getClientArea();
        Point centerPoint = Geometry.centerPoint((Rectangle)parent.getBounds());
        return new Point(centerPoint.x - initialSize.x / 2, Math.max(monitorBounds.y, parentBounds.y + parentBounds.height - initialSize.y - 25));
    }
}

