/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import org.mandas.docker.client.messages.Event;

public class EventReader
implements Closeable {
    private final ObjectMapper objectMapper;
    private JsonParser parser;
    private final InputStream stream;

    public EventReader(InputStream stream, ObjectMapper objectMapper) {
        this.stream = stream;
        this.objectMapper = objectMapper;
    }

    public Event nextMessage() throws IOException {
        if (this.parser == null) {
            this.parser = this.objectMapper.getFactory().createParser(this.stream);
        }
        if (this.parser.isClosed()) {
            return null;
        }
        if (this.parser.nextToken() == null) {
            return null;
        }
        return (Event)this.parser.readValueAs(Event.class);
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }
}

