/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.events;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swtchart.extensions.core.BaseChart;
import org.eclipse.swtchart.extensions.events.AbstractHandledEventProcessor;
import org.eclipse.swtchart.extensions.events.IHandledEventProcessor;

public class SelectHideSeriesEvent
extends AbstractHandledEventProcessor
implements IHandledEventProcessor {
    private int hideMask = SWT.MOD3;

    @Override
    public int getEvent() {
        return 1;
    }

    @Override
    public int getButton() {
        return 1;
    }

    @Override
    public int getStateMask() {
        return SWT.MOD1;
    }

    @Override
    public void handleEvent(BaseChart baseChart, Event event) {
        if ((event.stateMask & this.hideMask) == this.hideMask) {
            String selectedSeriesId = baseChart.getSelectedseriesId(event);
            if (selectedSeriesId.equals("")) {
                this.showClickbindingHelp(baseChart, "Unhide", "Display all series again.");
                baseChart.resetSeriesSettings();
            } else {
                this.showClickbindingHelp(baseChart, "Hide", "Hide the selected series.");
                baseChart.hideSeries(selectedSeriesId);
                baseChart.redraw();
            }
        } else {
            String selectedSeriesId = baseChart.getSelectedseriesId(event);
            if (selectedSeriesId.equals("")) {
                this.showClickbindingHelp(baseChart, "Unselect", "Deselect a series.");
                baseChart.resetSeriesSettings();
            } else {
                this.showClickbindingHelp(baseChart, "Select", "Select series.");
                baseChart.selectSeries(selectedSeriesId);
                baseChart.redraw();
            }
        }
    }
}

