/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.rpm.core.utils;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.linuxtools.rpm.core.utils.BufferedProcessInputStream;
import org.eclipse.linuxtools.rpm.core.utils.Messages;
import org.eclipse.linuxtools.tools.launch.core.factory.RuntimeProcessFactory;
import org.eclipse.osgi.util.NLS;

public class Utils {
    public static BufferedProcessInputStream runCommandToInputStream(String ... command) throws IOException {
        return Utils.runCommandToInputStream(null, command);
    }

    private static BufferedProcessInputStream runCommandToInputStream(IProject project, String ... command) throws IOException {
        Process p = RuntimeProcessFactory.getFactory().exec(command, project);
        return new BufferedProcessInputStream(p);
    }

    public static IStatus runCommand(OutputStream outStream, IProject project, String ... command) throws IOException {
        return Utils.watchProcess(outStream, RuntimeProcessFactory.getFactory().exec(command, project));
    }

    public static IStatus watchProcess(OutputStream outStream, Process child) {
        BufferedInputStream in = new BufferedInputStream(new SequenceInputStream(child.getInputStream(), child.getErrorStream()));
        Thread readinJob = new Thread(() -> {
            try {
                int i;
                while ((i = in.read()) != -1) {
                    outStream.write(i);
                }
                outStream.flush();
                outStream.close();
                in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
        readinJob.start();
        boolean canceled = false;
        try {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
            child.waitFor();
        }
        catch (InterruptedException e) {
            child.destroy();
            canceled = true;
        }
        while (readinJob.isAlive()) {
            try {
                readinJob.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (canceled) {
            return Status.CANCEL_STATUS;
        }
        if (child.exitValue() != 0) {
            return Status.error((String)NLS.bind((String)Messages.Utils_NON_ZERO_RETURN_CODE, (Object)child.exitValue()));
        }
        return Status.OK_STATUS;
    }

    public static String runCommandToString(String ... command) throws IOException {
        return Utils.runCommandToString(null, command);
    }

    public static String runCommandToString(IProject project, String ... command) throws IOException {
        BufferedProcessInputStream in = Utils.runCommandToInputStream(project, command);
        return Utils.inputStreamToString(in);
    }

    private static String inputStreamToString(InputStream stream) throws IOException {
        int c;
        StringBuilder retStr = new StringBuilder();
        while ((c = stream.read()) != -1) {
            retStr.append((char)c);
        }
        stream.close();
        return retStr.toString();
    }
}

