/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.astview.views;

import java.util.List;
import org.eclipse.jdt.astview.views.ASTAttribute;
import org.eclipse.jdt.astview.views.Binding;
import org.eclipse.jdt.astview.views.BindingProperty;
import org.eclipse.jdt.astview.views.Error;
import org.eclipse.jdt.astview.views.ExceptionAttribute;
import org.eclipse.jdt.astview.views.JavaElement;
import org.eclipse.jdt.astview.views.NodeProperty;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.EditorsUI;

public class ASTViewLabelProvider
extends LabelProvider
implements IColorProvider,
IFontProvider {
    private int fSelectionStart = -1;
    private int fSelectionLength = -1;
    private final Color fBlue;
    private final Color fRed;
    private final Color fDarkGray;
    private final Color fDarkGreen;
    private final Color fDarkRed;
    private final Font fBold;
    private final Font fAllocatedBoldItalic;
    private final Color fLightRed;
    private Color fSelectedElemBGColor;

    public ASTViewLabelProvider() {
        FontData[] fontData;
        Display display = Display.getCurrent();
        this.fRed = display.getSystemColor(3);
        this.fDarkGray = display.getSystemColor(16);
        this.fBlue = display.getSystemColor(10);
        this.fDarkGreen = display.getSystemColor(6);
        this.fDarkRed = display.getSystemColor(4);
        this.fSelectedElemBGColor = new Color((Device)display, 232, 242, 254);
        String currLineColor = EditorsUI.getPreferenceStore().getString("currentLineColor");
        String[] rgb = currLineColor.split(",");
        if (rgb.length == 3) {
            try {
                this.fSelectedElemBGColor = new Color((Device)display, Integer.parseInt(rgb[0]), Integer.parseInt(rgb[1]), Integer.parseInt(rgb[2]));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.fLightRed = new Color((Device)display, 255, 190, 190);
        this.fBold = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getFontRegistry().getBold("org.eclipse.jface.defaultfont");
        FontData[] fontDataArray = fontData = this.fBold.getFontData();
        int n = fontData.length;
        int n2 = 0;
        while (n2 < n) {
            FontData fd = fontDataArray[n2];
            fd.setStyle(fd.getStyle() | 2);
            ++n2;
        }
        this.fAllocatedBoldItalic = new Font((Device)display, fontData);
    }

    public void setSelectedRange(int start, int length) {
        this.fSelectionStart = start;
        this.fSelectionLength = length;
        this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)this));
    }

    public String getText(Object obj) {
        StringBuffer buf = new StringBuffer();
        if (obj instanceof ASTNode) {
            this.getNodeType((ASTNode)obj, buf);
        } else if (obj instanceof ASTAttribute) {
            buf.append(((ASTAttribute)obj).getLabel());
        }
        return buf.toString();
    }

    private void getNodeType(ASTNode node, StringBuffer buf) {
        buf.append(Signature.getSimpleName((String)node.getClass().getName()));
        buf.append(" [");
        buf.append(node.getStartPosition());
        buf.append("+");
        buf.append(node.getLength());
        buf.append(']');
        if ((node.getFlags() & 1) != 0) {
            buf.append(" (malformed)");
        }
        if ((node.getFlags() & 8) != 0) {
            buf.append(" (recovered)");
        }
    }

    public Image getImage(Object obj) {
        if (obj instanceof ASTNode) {
            return null;
        }
        if (obj instanceof ASTAttribute) {
            return ((ASTAttribute)obj).getImage();
        }
        return null;
    }

    public Color getForeground(Object element) {
        if (element instanceof Error) {
            return this.fRed;
        }
        if (element instanceof ExceptionAttribute && ((ExceptionAttribute)element).getException() != null) {
            return this.fRed;
        }
        if (element instanceof ASTNode) {
            ASTNode node = (ASTNode)element;
            if ((node.getFlags() & 1) != 0) {
                return this.fRed;
            }
            return this.fDarkGray;
        }
        if (element instanceof Binding) {
            Binding binding = (Binding)element;
            if (!binding.isRelevant()) {
                return this.fDarkGray;
            }
            return this.fBlue;
        }
        if (element instanceof NodeProperty) {
            return null;
        }
        if (element instanceof BindingProperty) {
            BindingProperty binding = (BindingProperty)element;
            if (!binding.isRelevant()) {
                return this.fDarkGray;
            }
            return this.fBlue;
        }
        if (element instanceof JavaElement) {
            JavaElement javaElement = (JavaElement)element;
            if (javaElement.getJavaElement() == null || !javaElement.getJavaElement().exists()) {
                return this.fRed;
            }
            return this.fDarkGreen;
        }
        return this.fDarkRed;
    }

    public Color getBackground(Object element) {
        if (this.isNotProperlyNested(element)) {
            return this.fLightRed;
        }
        if (this.fSelectionStart != -1 && this.isInside(element)) {
            return this.fSelectedElemBGColor;
        }
        return null;
    }

    private boolean isNotProperlyNested(Object element) {
        if (element instanceof ASTNode) {
            ASTNode node = (ASTNode)element;
            int start = node.getStartPosition();
            int end = start + node.getLength();
            ASTNode parent = node.getParent();
            if (parent != null) {
                int parentstart = parent.getStartPosition();
                int parentend = parentstart + parent.getLength();
                if (start < parentstart || end > parentend) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isInsideNode(ASTNode node) {
        int start = node.getStartPosition();
        int end = start + node.getLength();
        return start <= this.fSelectionStart && this.fSelectionStart + this.fSelectionLength <= end;
    }

    private boolean isInside(Object element) {
        if (element instanceof ASTNode) {
            return this.isInsideNode((ASTNode)element);
        }
        if (element instanceof NodeProperty) {
            NodeProperty property = (NodeProperty)element;
            Object object = property.getNode();
            if (object instanceof ASTNode) {
                return this.isInsideNode((ASTNode)object);
            }
            if (object instanceof List) {
                for (Object child : (List)object) {
                    if (!this.isInside(child)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public Font getFont(Object element) {
        if (element instanceof ASTNode) {
            ASTNode node = (ASTNode)element;
            if ((node.getFlags() & 8) != 0) {
                return this.fAllocatedBoldItalic;
            }
            return this.fBold;
        }
        return null;
    }

    public void dispose() {
        super.dispose();
        this.fAllocatedBoldItalic.dispose();
    }
}

