/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.january.DatasetException;
import org.eclipse.january.asserts.TestUtils;
import org.eclipse.january.dataset.Dataset;
import org.eclipse.january.dataset.DatasetFactory;
import org.eclipse.january.dataset.DatasetUtils;
import org.eclipse.january.dataset.DoubleDataset;
import org.eclipse.january.dataset.IDataset;
import org.eclipse.january.dataset.ILazyDataset;
import org.eclipse.january.dataset.IntegerDataset;
import org.eclipse.january.dataset.LazyDataset;
import org.eclipse.january.dataset.Random;
import org.eclipse.january.dataset.ShapeUtils;
import org.eclipse.january.dataset.Slice;
import org.eclipse.january.dataset.SliceND;
import org.eclipse.january.metadata.AxesMetadata;
import org.eclipse.january.metadata.MetadataFactory;
import org.eclipse.january.metadata.MetadataType;
import org.junit.Assert;
import org.junit.Test;

public class LazyDatasetTest {
    private void setShape(String msg, boolean well, LazyDataset l, int ... shape) {
        try {
            l.setShape(shape);
            if (well) {
                TestUtils.verbosePrintf((String)"Succeeded setting shape for %s\n", (Object[])new Object[]{msg});
            } else {
                Assert.fail((String)("Should have thrown exception for " + msg));
            }
        }
        catch (IllegalArgumentException iae) {
            if (well) {
                Assert.fail((String)("Unexpected exception for " + msg));
            } else {
                TestUtils.verbosePrintf((String)"Correctly failed setting shape for %s\n", (Object[])new Object[]{msg});
            }
        }
        catch (Exception e) {
            msg = String.valueOf(msg) + ": " + e.getMessage();
            if (well) {
                Assert.fail((String)("Unexpected exception for " + msg));
            }
            Assert.fail((String)("Thrown wrong exception for " + msg));
        }
    }

    @Test
    public void testSetShape() {
        LazyDataset ld = new LazyDataset(null, "", IntegerDataset.class, new int[]{1, 2, 3, 4});
        this.setShape("check on same rank", true, ld, 1, 2, 3, 4);
        this.setShape("check on same rank", false, ld, 1, 2, 3, 5);
        this.setShape("check on greater rank", true, ld, 1, 1, 1, 2, 3, 4);
        this.setShape("check on greater rank", false, ld, 1, 2, 2, 3, 5);
        this.setShape("check on greater rank", false, ld, 2, 1, 2, 3, 4);
        this.setShape("check on greater rank", true, ld, 2, 3, 4, 1, 1, 1);
        this.setShape("check on greater rank", true, ld, 1, 1, 2, 3, 4, 1, 1, 1);
        this.setShape("check on greater rank", false, ld, 2, 3, 4, 5);
        this.setShape("check on lesser rank", true, ld, 2, 3, 4);
        this.setShape("check on lesser rank", false, ld, 3, 4);
        this.setShape("check on lesser rank", false, ld, 2, 3);
        ld = new LazyDataset(null, "", IntegerDataset.class, new int[]{2, 3, 4, 1});
        this.setShape("check on lesser rank", true, ld, 2, 3, 4);
        ld = new LazyDataset(null, "", IntegerDataset.class, new int[]{1, 2, 3, 4, 1});
        this.setShape("check on lesser rank", true, ld, 2, 3, 4);
    }

    @Test
    public void testGetSlice() throws Exception {
        int[] shape = new int[]{1, 2, 3, 4};
        DoubleDataset d = Random.randn((int[])shape);
        LazyDataset ld = LazyDataset.createLazyDataset((Dataset)d);
        Slice[] sliceArray = new Slice[4];
        sliceArray[1] = new Slice(Integer.valueOf(1));
        sliceArray[3] = new Slice(Integer.valueOf(1), Integer.valueOf(3));
        Slice[] slice = sliceArray;
        Assert.assertEquals((String)"Full slice", (Object)d, (Object)ld.getSlice(new Slice[0]));
        Assert.assertEquals((String)"Full slice", (Object)d, (Object)ld.getSlice(new Slice[]{null}));
        Assert.assertEquals((String)"Full slice", (Object)d, (Object)ld.getSlice(new Slice[]{null, null}));
        Assert.assertEquals((String)"Full slice", (Object)d, (Object)ld.getSlice(null, null));
        Assert.assertEquals((String)"Full slice", (Object)d, (Object)ld.getSlice(null, null, null));
        Assert.assertEquals((String)"Full slice", (Object)d, (Object)ld.getSlice(null, null, new int[]{1, 1, 1, 1}));
        Assert.assertEquals((String)"Full slice", (Object)d, (Object)ld.getSlice(new int[4], null, new int[]{1, 1, 1, 1}));
        Assert.assertEquals((String)"Full slice", (Object)d, (Object)ld.getSlice(new int[4], new int[]{1, 2, 3, 4}, new int[]{1, 1, 1, 1}));
        Assert.assertEquals((String)"Part slice", (Object)d.getSlice(slice), (Object)ld.getSlice(slice));
        ld.setShape(new int[]{1, 1, 1, 2, 3, 4});
        Dataset nd = d.getView(true);
        nd.setShape(new int[]{1, 1, 1, 2, 3, 4});
        Assert.assertEquals((String)"Full slice", (Object)nd, (Object)ld.getSlice(new Slice[0]));
        Slice[] sliceArray2 = new Slice[6];
        sliceArray2[3] = new Slice(Integer.valueOf(1));
        sliceArray2[5] = new Slice(Integer.valueOf(1), Integer.valueOf(3));
        slice = sliceArray2;
        Assert.assertEquals((String)"Part slice", (Object)nd.getSlice(slice), (Object)ld.getSlice(slice));
        ld.setShape(new int[]{2, 3, 4});
        nd = d.getView(true);
        nd.setShape(new int[]{2, 3, 4});
        Assert.assertEquals((String)"Full slice", (Object)nd, (Object)ld.getSlice(new Slice[0]));
        Slice[] sliceArray3 = new Slice[3];
        sliceArray3[0] = new Slice(Integer.valueOf(1));
        sliceArray3[2] = new Slice(Integer.valueOf(1), Integer.valueOf(3));
        slice = sliceArray3;
        Assert.assertEquals((String)"Part slice", (Object)nd.getSlice(slice), (Object)ld.getSlice(slice));
        ld.setShape(new int[]{2, 3, 4, 1, 1, 1});
        nd = d.getView(true);
        nd.setShape(new int[]{2, 3, 4, 1, 1, 1});
        Assert.assertEquals((String)"Full slice", (Object)nd, (Object)ld.getSlice(new Slice[0]));
        Slice[] sliceArray4 = new Slice[6];
        sliceArray4[0] = new Slice(Integer.valueOf(1));
        sliceArray4[2] = new Slice(Integer.valueOf(1), Integer.valueOf(3));
        slice = sliceArray4;
        Assert.assertEquals((String)"Part slice", (Object)nd.getSlice(slice), (Object)ld.getSlice(slice));
        ld.setShape(new int[]{1, 2, 3, 4, 1, 1, 1});
        nd = d.getView(true);
        nd.setShape(new int[]{1, 2, 3, 4, 1, 1, 1});
        Assert.assertEquals((String)"Full slice", (Object)nd, (Object)ld.getSlice(new Slice[0]));
        Slice[] sliceArray5 = new Slice[7];
        sliceArray5[1] = new Slice(Integer.valueOf(1));
        sliceArray5[3] = new Slice(Integer.valueOf(1), Integer.valueOf(3));
        slice = sliceArray5;
        Assert.assertEquals((String)"Part slice", (Object)nd.getSlice(slice), (Object)ld.getSlice(slice));
        ld.setShape(shape);
        Slice[] sliceArray6 = new Slice[4];
        sliceArray6[0] = new Slice(null, null, Integer.valueOf(-1));
        slice = sliceArray6;
        nd = ld.getSlice(slice);
        Assert.assertEquals((String)"Full negative slice", (Object)d.getSlice(slice), (Object)nd);
        Slice[] sliceArray7 = new Slice[4];
        sliceArray7[3] = new Slice(null, null, Integer.valueOf(-1));
        slice = sliceArray7;
        nd = ld.getSlice(slice);
        Assert.assertEquals((String)"Full negative slice", (Object)d.getSlice(slice), (Object)nd);
        try {
            ld.getSlice(new SliceND(null));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            System.out.println("As expected: " + e);
        }
        try {
            ld.getSlice(new SliceND(new int[0]));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            System.out.println("As expected: " + e);
        }
        try {
            ld.getSlice(new SliceND(new int[2]));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            System.out.println("As expected: " + e);
        }
        nd = ld.getSlice(new SliceND(ld.getShape()));
        Assert.assertEquals((String)"Full slice", (Object)d.getSlice(new Slice[0]), (Object)nd);
    }

    @Test
    public void testGetSliceView() throws Exception {
        int[] shape = new int[]{6, 2, 4, 1};
        DoubleDataset d = Random.randn((int[])shape);
        LazyDataset ld = LazyDataset.createLazyDataset((Dataset)d);
        Slice[] sliceArray = new Slice[4];
        sliceArray[0] = new Slice(Integer.valueOf(1), null, Integer.valueOf(3));
        sliceArray[1] = new Slice(Integer.valueOf(1));
        sliceArray[2] = new Slice(Integer.valueOf(1), Integer.valueOf(3));
        Slice[] slice = sliceArray;
        LazyDataset l = ld.getSliceView(null, shape, null);
        TestUtils.verbosePrintf((String)"%s\n", (Object[])new Object[]{l.toString()});
        Assert.assertEquals((String)"Full slice", (Object)d, (Object)l.getSlice(new Slice[0]));
        l = ld.getSliceView(slice);
        TestUtils.verbosePrintf((String)"%s\n", (Object[])new Object[]{l.toString()});
        Assert.assertEquals((String)"Part slice", (Object)d.getSlice(slice), (Object)l.getSlice(new Slice[0]));
        l = ld.getSliceView(new Slice[0]);
        TestUtils.verbosePrintf((String)"%s\n", (Object[])new Object[]{l.toString()});
        Assert.assertEquals((String)"Full slice", (Object)d, (Object)l.getSlice(new Slice[0]));
        l = ld.getSliceView(slice);
        TestUtils.verbosePrintf((String)"%s\n", (Object[])new Object[]{l.toString()});
        Assert.assertEquals((String)"Part slice", (Object)d.getSlice(slice), (Object)l.getSlice(new Slice[0]));
        l = ld.getSliceView(new Slice[0]);
        l.squeezeEnds();
        Assert.assertEquals((String)"Full slice", (long)3L, (long)l.getSlice(new Slice[0]).getRank());
        Slice[] sliceArray2 = new Slice[4];
        sliceArray2[0] = new Slice(null, null, Integer.valueOf(-1));
        slice = sliceArray2;
        l = ld.getSliceView(slice);
        Assert.assertEquals((String)"Full negative slice", (Object)d.getSlice(slice), (Object)l.getSlice(new Slice[0]));
        Slice[] sliceArray3 = new Slice[4];
        sliceArray3[3] = new Slice(null, null, Integer.valueOf(-1));
        slice = sliceArray3;
        l = ld.getSliceView(slice);
        Assert.assertEquals((String)"Full negative slice", (Object)d.getSlice(slice), (Object)l.getSlice(new Slice[0]));
        try {
            ld.getSliceView(new SliceND(null));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            System.out.println("As expected: " + e);
        }
        try {
            ld.getSliceView(new SliceND(new int[0]));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            System.out.println("As expected: " + e);
        }
        try {
            ld.getSliceView(new SliceND(new int[2]));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            System.out.println("As expected: " + e);
        }
        l = ld.getSliceView(new SliceND(ld.getShape()));
        Assert.assertEquals((String)"Full slice", (Object)d, (Object)l.getSlice(new Slice[0]));
    }

    @Test
    public void testShape() throws DatasetException {
        DoubleDataset data = Random.rand((int[])new int[]{1, 2, 3, 4});
        data.setName("random");
        LazyDataset ld = LazyDataset.createLazyDataset((Dataset)data);
        ld.setShape(new int[]{1, 1, 2, 3, 4, 1});
        Assert.assertArrayEquals((int[])new int[]{1, 1, 2, 3, 4, 1}, (int[])ld.getShape());
        TestUtils.assertDatasetEquals((Dataset)data.reshape(new int[]{1, 1, 2, 3, 4, 1}), (Dataset)ld.getSlice(new Slice[0]), (boolean)true, (double)1.0E-14, (double)1.0E-14);
        LazyDataset tld = ld.getSliceView(new Slice[0]);
        Assert.assertArrayEquals((int[])new int[]{1, 1, 2, 3, 4, 1}, (int[])tld.getShape());
        TestUtils.assertDatasetEquals((Dataset)data.reshape(new int[]{1, 1, 2, 3, 4, 1}), (Dataset)tld.getSlice(new Slice[0]), (boolean)true, (double)1.0E-14, (double)1.0E-14);
        ld.setShape(new int[]{1, 2, 3, 4});
        tld = ld.getSliceView(new Slice[0]);
        ld.setShape(new int[]{1, 1, 2, 3, 4, 1});
        Assert.assertArrayEquals((int[])new int[]{1, 1, 2, 3, 4, 1}, (int[])ld.getShape());
        Assert.assertArrayEquals((int[])new int[]{1, 2, 3, 4}, (int[])tld.getShape());
        TestUtils.assertDatasetEquals((Dataset)data.reshape(new int[]{1, 1, 2, 3, 4, 1}), (Dataset)ld.getSlice(new Slice[0]), (boolean)true, (double)1.0E-14, (double)1.0E-14);
        TestUtils.assertDatasetEquals((Dataset)data.reshape(new int[]{1, 1, 2, 3, 4, 1}), (Dataset)ld.getSliceView(new Slice[0]).getSlice(new Slice[0]), (boolean)true, (double)1.0E-14, (double)1.0E-14);
        tld.setShape(new int[]{1, 1, 2, 3, 4, 1});
        Assert.assertArrayEquals((int[])new int[]{1, 1, 2, 3, 4, 1}, (int[])tld.getShape());
        TestUtils.assertDatasetEquals((Dataset)data.reshape(new int[]{1, 1, 2, 3, 4, 1}), (Dataset)tld.getSlice(new Slice[0]), (boolean)true, (double)1.0E-14, (double)1.0E-14);
        TestUtils.assertDatasetEquals((Dataset)data.reshape(new int[]{1, 1, 2, 3, 4, 1}), (Dataset)tld.getSliceView(new Slice[0]).getSlice(new Slice[0]), (boolean)true, (double)1.0E-14, (double)1.0E-14);
        LazyDataset uld = tld.getSliceView(new Slice[0]);
        Assert.assertArrayEquals((int[])new int[]{1, 1, 2, 3, 4, 1}, (int[])uld.getShape());
        TestUtils.assertDatasetEquals((Dataset)data.reshape(new int[]{1, 1, 2, 3, 4, 1}), (Dataset)uld.getSlice(new Slice[0]), (boolean)true, (double)1.0E-14, (double)1.0E-14);
        TestUtils.assertDatasetEquals((Dataset)data.reshape(new int[]{1, 1, 2, 3, 4, 1}), (Dataset)uld.getSliceView(new Slice[0]).getSlice(new Slice[0]), (boolean)true, (double)1.0E-14, (double)1.0E-14);
        uld.setShape(new int[]{2, 3, 4});
        Assert.assertArrayEquals((int[])new int[]{2, 3, 4}, (int[])uld.getShape());
        TestUtils.assertDatasetEquals((Dataset)data.reshape(new int[]{2, 3, 4}), (Dataset)uld.getSlice(new Slice[0]), (boolean)true, (double)1.0E-14, (double)1.0E-14);
        TestUtils.assertDatasetEquals((Dataset)data.reshape(new int[]{2, 3, 4}), (Dataset)uld.getSliceView(new Slice[0]).getSlice(new Slice[0]), (boolean)true, (double)1.0E-14, (double)1.0E-14);
        Slice[] sliceArray = new Slice[4];
        sliceArray[3] = new Slice(Integer.valueOf(1), null, Integer.valueOf(2));
        Slice[] slice = sliceArray;
        ld.setShape(new int[]{1, 2, 3, 4});
        tld = ld.getSliceView(slice);
        tld.squeezeEnds();
        TestUtils.assertDatasetEquals((Dataset)data.getSliceView(slice).squeezeEnds(), (Dataset)tld.getSlice(new Slice[0]), (boolean)true, (double)1.0E-14, (double)1.0E-14);
        TestUtils.assertDatasetEquals((Dataset)data.getSliceView(slice).squeezeEnds(), (Dataset)tld.getSliceView(new Slice[0]).getSlice(new Slice[0]), (boolean)true, (double)1.0E-14, (double)1.0E-14);
    }

    @Test
    public void testTranspose() throws DatasetException {
        DoubleDataset data = Random.rand((int[])new int[]{1, 2, 3, 4});
        data.setName("random");
        LazyDataset ld = LazyDataset.createLazyDataset((Dataset)data);
        LazyDataset tld = ld.getTransposedView(new int[]{3, 1, 0, 2});
        Assert.assertEquals((long)tld.getSize(), (long)ld.getSize());
        Assert.assertArrayEquals((int[])new int[]{4, 2, 1, 3}, (int[])tld.getShape());
        TestUtils.assertDatasetEquals((Dataset)data.getTransposedView(new int[]{3, 1, 0, 2}), (Dataset)tld.getSlice(new Slice[0]), (boolean)true, (double)1.0E-14, (double)1.0E-14);
        TestUtils.assertDatasetEquals((Dataset)data.transpose(new int[]{3, 1, 0, 2}), (Dataset)tld.getSlice(new Slice[0]), (boolean)true, (double)1.0E-14, (double)1.0E-14);
        LazyDataset uld = tld.getTransposedView(new int[]{3, 2, 1, 0});
        Assert.assertArrayEquals((int[])new int[]{3, 1, 2, 4}, (int[])uld.getShape());
        TestUtils.assertDatasetEquals((Dataset)data.getTransposedView(new int[]{3, 1, 0, 2}).getTransposedView(new int[]{3, 2, 1, 0}), (Dataset)uld.getSlice(new Slice[0]), (boolean)true, (double)1.0E-14, (double)1.0E-14);
        Assert.assertArrayEquals((int[])new int[]{3, 1, 2, 4}, (int[])ld.getTransposedView(new int[]{2, 0, 1, 3}).getShape());
        TestUtils.assertDatasetEquals((Dataset)data.getTransposedView(new int[]{2, 0, 1, 3}), (Dataset)uld.getSlice(new Slice[0]), (boolean)true, (double)1.0E-14, (double)1.0E-14);
        tld.setShape(new int[]{1, 4, 2, 1, 3, 1});
        Assert.assertArrayEquals((int[])new int[]{1, 4, 2, 1, 3, 1}, (int[])tld.getShape());
        TestUtils.assertDatasetEquals((Dataset)data.getTransposedView(new int[]{3, 1, 0, 2}).reshape(new int[]{1, 4, 2, 1, 3, 1}), (Dataset)tld.getSlice(new Slice[0]), (boolean)true, (double)1.0E-14, (double)1.0E-14);
        ld.setShape(new int[]{1, 1, 2, 3, 4, 1});
        tld = ld.getTransposedView(new int[]{3, 1, 0, 2, 4, 5});
        Assert.assertArrayEquals((int[])new int[]{3, 1, 1, 2, 4, 1}, (int[])tld.getShape());
        TestUtils.assertDatasetEquals((Dataset)data.reshape(new int[]{1, 1, 2, 3, 4, 1}).getTransposedView(new int[]{3, 1, 0, 2, 4, 5}), (Dataset)tld.getSlice(new Slice[0]), (boolean)true, (double)1.0E-14, (double)1.0E-14);
        ld.setShape(new int[]{1, 2, 3, 4});
        tld = ld.getSliceView(new Slice[]{null, null, null, new Slice(Integer.valueOf(1), null, Integer.valueOf(2))});
        TestUtils.assertDatasetEquals((Dataset)data.getSliceView(new Slice[]{null, null, null, new Slice(Integer.valueOf(1), null, Integer.valueOf(2))}), (Dataset)tld.getSlice(new Slice[0]), (boolean)true, (double)1.0E-14, (double)1.0E-14);
        TestUtils.assertDatasetEquals((Dataset)data.getSliceView(new Slice[]{null, null, null, new Slice(Integer.valueOf(1), null, Integer.valueOf(2))}), (Dataset)tld.getSliceView(new Slice[0]).getSlice(new Slice[0]), (boolean)true, (double)1.0E-14, (double)1.0E-14);
        uld = tld.getTransposedView(new int[]{3, 1, 0, 2});
        Assert.assertEquals((long)tld.getSize(), (long)uld.getSize());
        Assert.assertArrayEquals((int[])new int[]{2, 2, 1, 3}, (int[])uld.getShape());
        TestUtils.assertDatasetEquals((Dataset)data.getSliceView(new Slice[]{null, null, null, new Slice(Integer.valueOf(1), null, Integer.valueOf(2))}).getTransposedView(new int[]{3, 1, 0, 2}), (Dataset)uld.getSlice(new Slice[0]), (boolean)true, (double)1.0E-14, (double)1.0E-14);
        tld = ld.getTransposedView(new int[]{3, 1, 0, 2});
        TestUtils.assertDatasetEquals((Dataset)data.getTransposedView(new int[]{3, 1, 0, 2}), (Dataset)tld.getSlice(new Slice[0]), (boolean)true, (double)1.0E-14, (double)1.0E-14);
        TestUtils.assertDatasetEquals((Dataset)data.getTransposedView(new int[]{3, 1, 0, 2}), (Dataset)tld.getSliceView(new Slice[0]).getSlice(new Slice[0]), (boolean)true, (double)1.0E-14, (double)1.0E-14);
        LazyDataset vld = tld.getSliceView(new Slice[]{new Slice(Integer.valueOf(1), null, Integer.valueOf(2))});
        Assert.assertEquals((long)12L, (long)vld.getSize());
        Assert.assertArrayEquals((int[])new int[]{2, 2, 1, 3}, (int[])vld.getShape());
        TestUtils.assertDatasetEquals((Dataset)data.getTransposedView(new int[]{3, 1, 0, 2}).getSliceView(new Slice[]{new Slice(Integer.valueOf(1), null, Integer.valueOf(2))}), (Dataset)vld.getSlice(new Slice[0]), (boolean)true, (double)1.0E-14, (double)1.0E-14);
        tld.setShape(new int[]{1, 4, 2, 1, 3, 1});
        TestUtils.assertDatasetEquals((Dataset)data.getTransposedView(new int[]{3, 1, 0, 2}).reshape(new int[]{1, 4, 2, 1, 3, 1}), (Dataset)tld.getSlice(new Slice[0]), (boolean)true, (double)1.0E-14, (double)1.0E-14);
        TestUtils.assertDatasetEquals((Dataset)data.getTransposedView(new int[]{3, 1, 0, 2}).reshape(new int[]{1, 4, 2, 1, 3, 1}), (Dataset)tld.getSliceView(new Slice[0]).getSlice(new Slice[0]), (boolean)true, (double)1.0E-14, (double)1.0E-14);
        uld = tld.getTransposedView(new int[0]);
        Assert.assertArrayEquals((int[])new int[]{1, 3, 1, 2, 4, 1}, (int[])uld.getShape());
        TestUtils.assertDatasetEquals((Dataset)data.getTransposedView(new int[]{3, 1, 0, 2}).reshape(new int[]{1, 4, 2, 1, 3, 1}).getTransposedView(new int[0]), (Dataset)uld.getSlice(new Slice[0]), (boolean)true, (double)1.0E-14, (double)1.0E-14);
        uld.setShape(new int[]{3, 1, 2, 4, 1});
        Assert.assertArrayEquals((int[])new int[]{3, 1, 2, 4, 1}, (int[])uld.getShape());
        TestUtils.assertDatasetEquals((Dataset)data.getTransposedView(new int[]{3, 1, 0, 2}).reshape(new int[]{1, 4, 2, 1, 3, 1}).getTransposedView(new int[0]).reshape(new int[]{3, 1, 2, 4, 1}), (Dataset)uld.getSlice(new Slice[0]), (boolean)true, (double)1.0E-14, (double)1.0E-14);
    }

    @Test
    public void testSlicePadRankSlice() throws DatasetException {
        DoubleDataset data = Random.rand((int[])new int[]{10});
        data.setName("random");
        LazyDataset ld = LazyDataset.createLazyDataset((Dataset)data);
        LazyDataset sv = ld.getSliceView(new int[1], new int[]{5}, null);
        sv.setShape(new int[]{1, 1, 5});
        LazyDataset view = sv.getSliceView(new int[3], new int[]{1, 1, 4}, null);
        TestUtils.assertDatasetEquals((Dataset)data.getSliceView(new Slice[]{new Slice(Integer.valueOf(5))}).reshape(new int[]{1, 1, 5}).getSliceView(new Slice[]{null, null, new Slice(Integer.valueOf(4))}), (Dataset)view.getSlice(new Slice[0]), (boolean)true, (double)1.0E-14, (double)1.0E-14);
    }

    @Test
    public void testMultipleTransposeAndShape() throws DatasetException {
        DoubleDataset d = Random.rand((int[])new int[]{3, 2, 1, 5});
        LazyDataset l = LazyDataset.createLazyDataset((Dataset)((Dataset)d));
        ILazyDataset td = d.getTransposedView(new int[]{2, 0, 3, 1});
        ILazyDataset tl = l.getTransposedView(new int[]{2, 0, 3, 1});
        TestUtils.assertDatasetEquals((Dataset)DatasetUtils.sliceAndConvertLazyDataset((ILazyDataset)td), (Dataset)DatasetUtils.sliceAndConvertLazyDataset((ILazyDataset)tl));
        td.setShape(new int[]{3, 5, 1, 1, 2});
        tl.setShape(new int[]{3, 5, 1, 1, 2});
        TestUtils.assertDatasetEquals((Dataset)DatasetUtils.sliceAndConvertLazyDataset((ILazyDataset)td), (Dataset)DatasetUtils.sliceAndConvertLazyDataset((ILazyDataset)tl));
        ILazyDataset ttd = td.getTransposedView(new int[]{1, 3, 4, 2, 0});
        ILazyDataset ttl = tl.getTransposedView(new int[]{1, 3, 4, 2, 0});
        TestUtils.assertDatasetEquals((Dataset)DatasetUtils.sliceAndConvertLazyDataset((ILazyDataset)ttd), (Dataset)DatasetUtils.sliceAndConvertLazyDataset((ILazyDataset)ttl));
        ttd.setShape(new int[]{5, 2, 1, 1, 1, 3, 1, 1, 1});
        ttl.setShape(new int[]{5, 2, 1, 1, 1, 3, 1, 1, 1});
        TestUtils.assertDatasetEquals((Dataset)DatasetUtils.sliceAndConvertLazyDataset((ILazyDataset)ttd), (Dataset)DatasetUtils.sliceAndConvertLazyDataset((ILazyDataset)ttl));
        ttd = ttd.getTransposedView(new int[]{5, 7, 1, 3, 2, 8, 6, 4, 0});
        ttl = ttl.getTransposedView(new int[]{5, 7, 1, 3, 2, 8, 6, 4, 0});
        TestUtils.assertDatasetEquals((Dataset)DatasetUtils.sliceAndConvertLazyDataset((ILazyDataset)ttd), (Dataset)DatasetUtils.sliceAndConvertLazyDataset((ILazyDataset)ttl));
    }

    @Test
    public void testSqueezedSliceView() throws DatasetException {
        DoubleDataset data = Random.rand((int[])new int[]{2, 10});
        data.setName("random");
        LazyDataset ld = LazyDataset.createLazyDataset((Dataset)data);
        LazyDataset sv = ld.getSliceView(new Slice[]{new Slice(Integer.valueOf(1), Integer.valueOf(2))});
        Dataset s = DatasetUtils.sliceAndConvertLazyDataset((ILazyDataset)sv);
        s.squeezeEnds();
        TestUtils.assertDatasetEquals((Dataset)data.getSlice(new Slice[]{new Slice(Integer.valueOf(1), Integer.valueOf(2))}).squeeze(), (Dataset)s);
        sv.squeezeEnds();
        TestUtils.assertDatasetEquals((Dataset)data.getSlice(new Slice[]{new Slice(Integer.valueOf(1), Integer.valueOf(2))}).squeeze(), (Dataset)sv.getSlice(new Slice[0]));
    }

    @Test
    public void testTPT() throws DatasetException {
        this.testOps(new Operator(LDOp.TRANSPOSE, 4, 1, 0, 2, 3), new Operator(LDOp.SHAPE, 2, 0, 0, 0, -1, 0, 1), new Operator(LDOp.TRANSPOSE, 1, 4, 6, 0, 5, 3, 2));
    }

    @Test
    public void testTGT() throws DatasetException {
        this.testOps(new Operator(LDOp.TRANSPOSE, 4, 1, 0, 2, 3), new Operator(LDOp.SLICE, 4, -1, 0, -2), new Operator(LDOp.TRANSPOSE, 1, 4, 0, 3, 2));
    }

    @Test
    public void testTSG() throws DatasetException {
        this.testOps(new Operator(LDOp.TRANSPOSE, 4, 1, 0, 2, 3), new Operator(LDOp.SHAPEL, 3), new Operator(LDOp.SLICE, 3, 3, 0, -2));
    }

    @Test
    public void testTTSG() throws DatasetException {
        this.testOps(new Operator(LDOp.TRANSPOSE, 4, 1, 0, 2, 3), new Operator(LDOp.TRANSPOSE, 1, 2, 3, 4, 0), new Operator(LDOp.SHAPEL, 1), new Operator(LDOp.SLICE, 0, -1, 0, -1));
    }

    @Test
    public void testTTQT() throws DatasetException {
        this.testOps(new Operator(LDOp.TRANSPOSE, 4, 1, 0, 2, 3), new Operator(LDOp.TRANSPOSE, 4, 1, 0, 2, 3), new Operator(LDOp.SQUEEZE, new int[0]), new Operator(LDOp.TRANSPOSE, 4, 1, 0, 2, 3));
    }

    @Test
    public void testSTQT() throws DatasetException {
        this.testOps(new Operator(LDOp.SHAPEL, 2), new Operator(LDOp.TRANSPOSE, 4, 1, 0, 2, 3), new Operator(LDOp.SQUEEZE, new int[0]), new Operator(LDOp.TRANSPOSE, 4, 1, 0, 2, 3));
    }

    @Test
    public void testSGST() throws DatasetException {
        this.testOps(new Operator(LDOp.SHAPEL, 2), new Operator(LDOp.SLICE, 0, -1, 0, -1), new Operator(LDOp.SHAPEL, 2), new Operator(LDOp.TRANSPOSE, 4, 1, 0, 2, 3));
    }

    @Test
    public void testS() throws DatasetException {
        this.testOps(new Operator(LDOp.SLICE, 0, 1), new Operator(LDOp.SQUEEZE, new int[0]), new Operator(LDOp.TRANSPOSE, 2, 3, 4, 1, 0), new Operator(LDOp.TRANSPOSE, 4, 1, 0, 2, 3));
    }

    private void testOps(Operator ... ops) throws DatasetException {
        DoubleDataset d = Random.rand((int[])new int[]{2, 3, 1, 4, 5});
        d.setName("random");
        LazyDataset l = LazyDataset.createLazyDataset((Dataset)((Dataset)d));
        Operator[] operatorArray = ops;
        int n = ops.length;
        int n2 = 0;
        while (n2 < n) {
            Operator o = operatorArray[n2];
            System.out.println(o + ": " + d);
            d = o.apply((ILazyDataset)d);
            if (d == null) break;
            System.out.println("\t\t\t -> " + d);
            l = o.apply((ILazyDataset)l);
            System.out.println("\t\t\t -> " + l);
            TestUtils.assertDatasetEquals((Dataset)DatasetUtils.sliceAndConvertLazyDataset((ILazyDataset)d), (Dataset)DatasetUtils.sliceAndConvertLazyDataset((ILazyDataset)l));
            ++n2;
        }
    }

    private static Operator createOperator(LDOp op, int[] pShapeL, int[] pShapeR, int[] pSlice, int[] pTranspose) {
        switch (op) {
            case SHAPEL: {
                return new Operator(op, pShapeL);
            }
            case SHAPER: {
                return new Operator(op, pShapeR);
            }
            case SLICE: {
                return new Operator(op, pSlice);
            }
            case SQUEEZE: {
                return new Operator(op, new int[0]);
            }
            case TRANSPOSE: {
                return new Operator(op, pTranspose);
            }
        }
        return new Operator(op, null);
    }

    @Test
    public void testAll() throws DatasetException {
        int[][][] nArrayArray = new int[4][][];
        int[][] nArrayArray2 = new int[4][];
        nArrayArray2[0] = new int[]{2};
        nArrayArray2[1] = new int[]{3};
        nArrayArray2[2] = new int[]{2, 1};
        int[] nArray = new int[5];
        nArray[0] = 4;
        nArray[1] = 1;
        nArray[3] = 2;
        nArray[4] = 3;
        nArrayArray2[3] = nArray;
        nArrayArray[0] = nArrayArray2;
        int[][] nArrayArray3 = new int[4][];
        nArrayArray3[0] = new int[]{3};
        nArrayArray3[1] = new int[]{1};
        nArrayArray3[2] = new int[]{-2, 1, -1, 2};
        int[] nArray2 = new int[5];
        nArray2[0] = 1;
        nArray2[1] = 2;
        nArray2[2] = 3;
        nArray2[3] = 4;
        nArrayArray3[3] = nArray2;
        nArrayArray[1] = nArrayArray3;
        int[][] nArrayArray4 = new int[4][];
        nArrayArray4[0] = new int[]{1};
        nArrayArray4[1] = new int[]{2};
        int[] nArray3 = new int[2];
        nArray3[1] = 1;
        nArrayArray4[2] = nArray3;
        int[] nArray4 = new int[5];
        nArray4[0] = 2;
        nArray4[1] = 3;
        nArray4[2] = 4;
        nArray4[3] = 1;
        nArrayArray4[3] = nArray4;
        nArrayArray[2] = nArrayArray4;
        int[][] nArrayArray5 = new int[4][];
        nArrayArray5[0] = new int[]{4};
        nArrayArray5[1] = new int[]{2};
        int[] nArray5 = new int[4];
        nArray5[1] = -1;
        nArray5[3] = -1;
        nArrayArray5[2] = nArray5;
        int[] nArray6 = new int[5];
        nArray6[0] = 3;
        nArray6[2] = 2;
        nArray6[3] = 4;
        nArray6[4] = 1;
        nArrayArray5[3] = nArray6;
        nArrayArray[3] = nArrayArray5;
        int[][][] pAll = nArrayArray;
        int n = pAll.length;
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < n) {
                int k = 0;
                while (k < n) {
                    int l = 0;
                    while (l < n) {
                        this.testAll(pAll[i], pAll[j], pAll[k], pAll[l]);
                        ++l;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    private void testAll(int[][] p1, int[][] p2, int[][] p3, int[][] p4) throws DatasetException {
        DoubleDataset d0 = Random.rand((int[])new int[]{2, 3, 1, 4, 5});
        d0.setName("random");
        LazyDataset l0 = LazyDataset.createLazyDataset((Dataset)d0);
        AxesMetadata am = (AxesMetadata)MetadataFactory.createMetadata(AxesMetadata.class, (Object[])new Object[]{5});
        DoubleDataset axisB = DatasetFactory.createRange((double)-1.5, (double)1.0, (double)1.0);
        am.setAxis(1, new ILazyDataset[]{axisB});
        Dataset axisE = DatasetFactory.createFromObject((Object)new double[]{6.0, 5.0, 3.0, 2.0, 0.0});
        am.setAxis(4, new ILazyDataset[]{axisE});
        l0.addMetadata((MetadataType)am);
        LDOp[] lDOpArray = LDOp.values();
        int n = lDOpArray.length;
        int n2 = 0;
        while (n2 < n) {
            LDOp op1 = lDOpArray[n2];
            if (op1 != LDOp.SHAPE) {
                Operator o1 = LazyDatasetTest.createOperator(op1, p1[0], p1[1], p1[2], p1[3]);
                TestUtils.verbosePrintln((String)o1.toString());
                ILazyDataset d1 = o1.apply((ILazyDataset)d0);
                ILazyDataset l1 = o1.apply((ILazyDataset)l0);
                TestUtils.verbosePrintln((String)("\t\t -> " + Arrays.toString(l1.getShape())));
                TestUtils.assertDatasetEquals((Dataset)DatasetUtils.sliceAndConvertLazyDataset((ILazyDataset)d1), (Dataset)DatasetUtils.sliceAndConvertLazyDataset((ILazyDataset)l1));
                TestUtils.assertDatasetEquals((Dataset)DatasetUtils.sliceAndConvertLazyDataset((ILazyDataset)d1), (Dataset)DatasetUtils.convertToDataset((IDataset)l1.getSlice(null)));
                LDOp[] lDOpArray2 = LDOp.values();
                int n3 = lDOpArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    LDOp op2 = lDOpArray2[n4];
                    if (op2 != LDOp.SHAPE) {
                        Operator o2 = LazyDatasetTest.createOperator(op2, p2[0], p2[1], p2[2], p2[3]);
                        TestUtils.verbosePrintln((String)("\t" + o2));
                        ILazyDataset d2 = o2.apply(d1);
                        ILazyDataset l2 = o2.apply(l1);
                        TestUtils.verbosePrintln((String)("\t\t\t -> " + Arrays.toString(l2.getShape())));
                        TestUtils.assertDatasetEquals((Dataset)DatasetUtils.sliceAndConvertLazyDataset((ILazyDataset)d2), (Dataset)DatasetUtils.sliceAndConvertLazyDataset((ILazyDataset)l2));
                        TestUtils.assertDatasetEquals((Dataset)DatasetUtils.sliceAndConvertLazyDataset((ILazyDataset)d2), (Dataset)DatasetUtils.convertToDataset((IDataset)l2.getSlice(null)));
                        LDOp[] lDOpArray3 = LDOp.values();
                        int n5 = lDOpArray3.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            LDOp op3 = lDOpArray3[n6];
                            if (op3 != LDOp.SHAPE) {
                                Operator o3 = LazyDatasetTest.createOperator(op3, p3[0], p3[1], p3[2], p3[3]);
                                TestUtils.verbosePrintln((String)("\t\t" + o3));
                                ILazyDataset d3 = o3.apply(d2);
                                ILazyDataset l3 = o3.apply(l2);
                                TestUtils.verbosePrintln((String)("\t\t\t\t -> " + Arrays.toString(l3.getShape())));
                                TestUtils.assertDatasetEquals((Dataset)DatasetUtils.sliceAndConvertLazyDataset((ILazyDataset)d3), (Dataset)DatasetUtils.sliceAndConvertLazyDataset((ILazyDataset)l3));
                                TestUtils.assertDatasetEquals((Dataset)DatasetUtils.sliceAndConvertLazyDataset((ILazyDataset)d3), (Dataset)DatasetUtils.convertToDataset((IDataset)l3.getSlice(null)));
                                LDOp[] lDOpArray4 = LDOp.values();
                                int n7 = lDOpArray4.length;
                                int n8 = 0;
                                while (n8 < n7) {
                                    LDOp op4 = lDOpArray4[n8];
                                    if (op4 != LDOp.SHAPE) {
                                        Operator o4 = LazyDatasetTest.createOperator(op4, p4[0], p4[1], p4[2], p4[3]);
                                        TestUtils.verbosePrintln((String)("\t\t\t" + o4));
                                        ILazyDataset d4 = o4.apply(d3);
                                        if (d4 != null) {
                                            ILazyDataset l4 = o4.apply(l3);
                                            TestUtils.verbosePrintln((String)("\t\t\t\t -> " + Arrays.toString(l4.getShape())));
                                            TestUtils.assertDatasetEquals((Dataset)DatasetUtils.sliceAndConvertLazyDataset((ILazyDataset)d4), (Dataset)DatasetUtils.sliceAndConvertLazyDataset((ILazyDataset)l4));
                                            TestUtils.assertDatasetEquals((Dataset)DatasetUtils.sliceAndConvertLazyDataset((ILazyDataset)d4), (Dataset)DatasetUtils.convertToDataset((IDataset)l4.getSlice(null)));
                                        }
                                    }
                                    ++n8;
                                }
                            }
                            ++n6;
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    static enum LDOp {
        TRANSPOSE{

            @Override
            public ILazyDataset operate(ILazyDataset a, int ... p) {
                block4: {
                    int d;
                    int r;
                    block3: {
                        r = a.getRank();
                        d = r - p.length;
                        if (d <= 0) break block3;
                        p = Arrays.copyOf(p, r);
                        int i = r - d;
                        while (i < r) {
                            p[i] = i;
                            ++i;
                        }
                        break block4;
                    }
                    if (d >= 0) break block4;
                    p = Arrays.copyOf(p, r);
                    Integer[] q = new Integer[r];
                    int i = 0;
                    while (i < r) {
                        q[i] = i;
                        ++i;
                    }
                    final int[] fp = p;
                    Arrays.sort(q, new Comparator<Integer>(){

                        @Override
                        public int compare(Integer o1, Integer o2) {
                            return Integer.compare(fp[o1], fp[o2]);
                        }
                    });
                    int i2 = 0;
                    while (i2 < r) {
                        p[q[i2].intValue()] = i2;
                        ++i2;
                    }
                }
                return a.getTransposedView(p);
            }
        }
        ,
        SHAPE{

            @Override
            public ILazyDataset operate(ILazyDataset a, int ... p) {
                int d = 0;
                int[] nArray = p;
                int n = p.length;
                int n2 = 0;
                while (n2 < n) {
                    int i = nArray[n2];
                    d += i;
                    ++n2;
                }
                a = a.getSliceView(new Slice[0]);
                a.setShape(ShapeUtils.padShape((int[])p, (int)(d + a.getRank()), (int[])a.getShape()));
                return a;
            }
        }
        ,
        SHAPEL{

            @Override
            public ILazyDataset operate(ILazyDataset a, int ... p) {
                int d;
                int[] np = new int[a.getRank() + 1];
                np[0] = d = p[0];
                a = a.getSliceView(new Slice[0]);
                a.setShape(ShapeUtils.padShape((int[])np, (int)(d + a.getRank()), (int[])a.getShape()));
                return a;
            }
        }
        ,
        SHAPER{

            @Override
            public ILazyDataset operate(ILazyDataset a, int ... p) {
                int d;
                int[] np = new int[a.getRank() + 1];
                np[a.getRank()] = d = p[0];
                a = a.getSliceView(new Slice[0]);
                a.setShape(ShapeUtils.padShape((int[])np, (int)(d + a.getRank()), (int[])a.getShape()));
                return a;
            }
        }
        ,
        SLICE{

            /*
             * Unable to fully structure code
             */
            @Override
            public ILazyDataset operate(ILazyDataset a, int ... p) {
                block11: {
                    s = null;
                    switch (p.length) {
                        case 4: {
                            s = new Slice(Integer.valueOf(p[1]), Integer.valueOf(p[2]), Integer.valueOf(p[3]));
                            break;
                        }
                        case 3: {
                            s = new Slice(Integer.valueOf(p[1]), Integer.valueOf(p[2]));
                            break;
                        }
                        case 2: {
                            s = new Slice(null, Integer.valueOf(p[1]));
                            break;
                        }
                    }
                    ss = new Slice[a.getRank()];
                    shape = a.getShape();
                    d = p[0];
                    if (d >= 0) ** GOTO lbl31
                    d += shape.length;
                    while (d >= 0) {
                        if (s.getStart() != null && (b = s.getStart().intValue()) > 0 && b >= shape[d]) {
                            --d;
                            continue;
                        }
                        if (s.getStop() != null && (e = s.getStop().intValue()) > 0 && e > shape[d]) {
                            --d;
                            continue;
                        }
                        break block11;
                    }
                    break block11;
lbl-1000:
                    // 1 sources

                    {
                        if (s.getStart() != null && (b = s.getStart().intValue()) > 0 && b >= shape[d]) {
                            ++d;
                            continue;
                        }
                        if (s.getStop() == null || (e = s.getStop().intValue()) <= 0 || e <= shape[d]) break;
                        ++d;
lbl31:
                        // 3 sources

                        ** while (d < shape.length)
                    }
                }
                if (d < 0 || d >= shape.length) {
                    return null;
                }
                ss[d] = s;
                return a.getSliceView(ss);
            }
        }
        ,
        SQUEEZE{

            @Override
            public ILazyDataset operate(ILazyDataset a, int ... p) {
                a = a.getSliceView(new Slice[0]);
                a.squeezeEnds();
                return a;
            }
        };


        abstract ILazyDataset operate(ILazyDataset var1, int ... var2);
    }

    static class Operator {
        private LDOp op;
        private int[] p;

        public Operator(LDOp op, int ... p) {
            this.op = op;
            this.p = p;
        }

        public ILazyDataset apply(ILazyDataset a) {
            return this.op.operate(a, this.p);
        }

        public String toString() {
            return String.valueOf(this.op.toString()) + ": " + Arrays.toString(this.p);
        }
    }
}

