/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import java.util.ArrayList;
import org.apache.commons.math3.complex.Complex;
import org.eclipse.january.asserts.TestUtils;
import org.eclipse.january.dataset.ComplexDoubleDataset;
import org.eclipse.january.dataset.Dataset;
import org.eclipse.january.dataset.DatasetFactory;
import org.eclipse.january.dataset.DoubleDataset;
import org.eclipse.january.dataset.IndexIterator;
import org.eclipse.january.dataset.InterfaceUtils;
import org.eclipse.january.dataset.Maths;
import org.eclipse.january.dataset.Slice;
import org.junit.Assert;
import org.junit.Test;

public class ComplexDoubleDatasetTest {
    @Test
    public void testConstructor() {
        Assert.assertEquals((long)0L, (long)new ComplexDoubleDataset().getSize());
        Assert.assertEquals((long)0L, (long)DatasetFactory.createFromObject((Object)new Complex(1.0, 1.0)).getRank());
        double[] da = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0};
        ComplexDoubleDataset a = new ComplexDoubleDataset(da, new int[0]);
        Assert.assertTrue((String)"Interface", (boolean)ComplexDoubleDataset.class.isAssignableFrom(a.getClass()));
        Assert.assertEquals((long)2L, (long)a.getElementsPerItem());
        Assert.assertEquals((long)16L, (long)a.getItemBytes());
        IndexIterator it = a.getIterator();
        int i = 0;
        while (it.hasNext()) {
            Assert.assertEquals((double)(i * 2), (double)a.getElementDoubleAbs(it.index), (double)(1.0E-5 * (double)i));
            ++i;
        }
        ComplexDoubleDataset b = new ComplexDoubleDataset(da, new int[]{3, 2});
        it = b.getIterator();
        int i2 = 0;
        while (it.hasNext()) {
            Assert.assertEquals((double)(i2 * 2), (double)b.getElementDoubleAbs(it.index), (double)(1.0E-5 * (double)i2));
            ++i2;
        }
        ComplexDoubleDataset c = new ComplexDoubleDataset((Dataset)a.getSliceView(new int[]{1}, null, new int[]{2}));
        it = c.getIterator();
        int i3 = 0;
        while (it.hasNext()) {
            Assert.assertEquals((double)(4 * i3 + 2), (double)c.getElementDoubleAbs(it.index), (double)(1.0E-5 * (double)i3));
            ++i3;
        }
        ArrayList<Complex> list = new ArrayList<Complex>();
        list.add(new Complex(0.5, 1.0));
        ComplexDoubleDataset z = ComplexDoubleDataset.createFromObject(list);
        Assert.assertEquals((double)0.5, (double)z.getComplex(0).getReal(), (double)1.0E-6);
        Assert.assertEquals((double)1.0, (double)z.getComplex(0).getImaginary(), (double)1.0E-6);
        Dataset aa = Maths.abs((Object)a);
        Assert.assertTrue((String)"Interface", (boolean)DoubleDataset.class.isAssignableFrom(aa.getClass()));
        Assert.assertEquals((long)1L, (long)aa.getElementsPerItem());
        Assert.assertEquals((long)8L, (long)aa.getItemBytes());
        a.hashCode();
        b.hashCode();
        c.hashCode();
        z.hashCode();
        aa.hashCode();
        Class<?> clazz = a.getClass();
        Assert.assertEquals((Object)false, (Object)InterfaceUtils.isElemental(clazz));
        Assert.assertEquals((Object)true, (Object)InterfaceUtils.isCompound(clazz));
        Assert.assertEquals((Object)false, (Object)InterfaceUtils.isInteger(clazz));
        Assert.assertEquals((Object)true, (Object)InterfaceUtils.isNumerical(clazz));
        Assert.assertEquals((Object)true, (Object)InterfaceUtils.isFloating(clazz));
        Assert.assertEquals((Object)true, (Object)InterfaceUtils.isComplex(clazz));
    }

    @Test
    public void testGetter() {
        double[] da = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0};
        ComplexDoubleDataset a = new ComplexDoubleDataset(da, new int[0]);
        int l = da.length / 2;
        int i = 0;
        while (i < l) {
            Assert.assertEquals((double)(2 * i), (double)a.getComplex(i).getReal(), (double)(1.0E-5 * (double)i));
            Assert.assertEquals((double)(2 * i + 1), (double)a.getComplex(i).getImaginary(), (double)(1.0E-5 * (double)i));
            ++i;
        }
        i = 0;
        while (i < l) {
            int r = l - 1 - i;
            Assert.assertEquals((double)(2 * r), (double)a.getComplex(-(i + 1)).getReal(), (double)(1.0E-5 * (double)i));
            Assert.assertEquals((double)(2 * r + 1), (double)a.getComplex(-(i + 1)).getImaginary(), (double)(1.0E-5 * (double)i));
            ++i;
        }
        ComplexDoubleDataset sv = (ComplexDoubleDataset)a.getSliceView(new Slice[]{new Slice(Integer.valueOf(1), Integer.valueOf(4))});
        ComplexDoubleDataset sc = (ComplexDoubleDataset)a.getSlice(new Slice[]{new Slice(Integer.valueOf(1), Integer.valueOf(4))});
        l = sc.getSize();
        int i2 = 0;
        while (i2 < l) {
            Complex r = sc.getComplex(-(i2 + 1));
            Complex q = sv.getComplex(-(i2 + 1));
            Assert.assertEquals((double)r.getReal(), (double)q.getReal(), (double)(1.0E-5 * r.getReal()));
            Assert.assertEquals((double)r.getImaginary(), (double)q.getImaginary(), (double)(1.0E-5 * r.getImaginary()));
            ++i2;
        }
    }

    @Test
    public void testStats() {
        Dataset a = DatasetFactory.createRange(ComplexDoubleDataset.class, (double)12.0);
        Assert.assertEquals((double)5.5, (double)((Complex)a.mean(new boolean[0])).getReal(), (double)1.0E-6);
        Assert.assertEquals((double)0.0, (double)((Complex)a.mean(new boolean[0])).getImaginary(), (double)1.0E-6);
        Assert.assertEquals((double)13.0, (double)a.variance(), (double)1.0E-6);
        Assert.assertEquals((double)3.605551275463989, (double)a.stdDeviation(), (double)1.0E-6);
        a.iadd((Object)new Complex(0.0, 0.5));
        Assert.assertEquals((double)5.5, (double)((Complex)a.mean(new boolean[0])).getReal(), (double)1.0E-6);
        Assert.assertEquals((double)0.5, (double)((Complex)a.mean(new boolean[0])).getImaginary(), (double)1.0E-6);
        Assert.assertEquals((double)13.0, (double)a.variance(), (double)1.0E-6);
        Assert.assertEquals((double)3.605551275463989, (double)a.stdDeviation(), (double)1.0E-6);
    }

    @Test
    public void testSubclassing() {
        double[] da = new double[]{0.0, 0.5, 1.0, 1.5, 2.0, 2.5, 3.0, 3.5, 4.0, 4.5, 5.0, 5.5, 6.0, 6.5, 7.0, 7.5, 8.0, 8.5, 9.0, 9.5, 10.0, 10.5, 11.0, 11.5};
        ComplexDoubleDataset a = new ComplexDoubleDataset(da, new int[0]);
        ComplexDoubleDataset2 b = new ComplexDoubleDataset2(a);
        TestUtils.assertDatasetEquals((Dataset)a, (Dataset)b);
    }

    static class ComplexDoubleDataset2
    extends ComplexDoubleDataset {
        private static final long serialVersionUID = 1L;

        public ComplexDoubleDataset2(ComplexDoubleDataset dataset) {
            super(dataset);
        }
    }
}

