/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import org.eclipse.january.dataset.BroadcastIterator;
import org.eclipse.january.dataset.BroadcastUtils;
import org.eclipse.january.dataset.Dataset;

public class ContiguousPairIterator
extends BroadcastIterator {
    private final int aMax;
    private final int aStep;
    private final int bMax;
    private final int bStep;
    private final int oStep;

    public ContiguousPairIterator(Dataset a, Dataset b, Dataset o, boolean createIfNull) {
        super(a, b, o);
        this.aStep = a.getElementsPerItem();
        this.aMax = a.getSize() * this.aStep;
        this.bStep = b.getElementsPerItem();
        this.bMax = b.getSize() * this.bStep;
        if (this.outputA) {
            this.oStep = this.aStep;
        } else if (this.outputB) {
            this.oStep = this.bStep;
        } else if (o != null) {
            this.oStep = o.getElementsPerItem();
        } else if (createIfNull) {
            this.oDataset = BroadcastUtils.createDataset(a, b, a.getShapeRef());
            this.oStep = this.oDataset.getElementsPerItem();
        } else {
            this.oStep = 1;
        }
        this.maxShape = a.getShape();
        this.reset();
    }

    @Override
    public boolean hasNext() {
        this.aIndex += this.aStep;
        this.bIndex += this.bStep;
        this.oIndex = this.outputA ? this.aIndex : (this.outputB ? this.bIndex : (this.oIndex += this.oStep));
        if (this.aIndex >= this.aMax || this.bIndex >= this.bMax) {
            return false;
        }
        if (this.read) {
            if (this.asDouble) {
                this.aDouble = this.aDataset.getElementDoubleAbs(this.aIndex);
                this.bDouble = this.bDataset.getElementDoubleAbs(this.bIndex);
            } else {
                this.aLong = this.aDataset.getElementLongAbs(this.aIndex);
                this.bLong = this.bDataset.getElementLongAbs(this.bIndex);
            }
        }
        return true;
    }

    @Override
    public int[] getPos() {
        return null;
    }

    @Override
    public void reset() {
        this.aIndex = -this.aStep;
        this.bIndex = -this.bStep;
        this.oIndex = -this.oStep;
        if (this.read) {
            this.storeCurrentValues();
        }
    }
}

