/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import java.util.Arrays;
import org.apache.commons.math3.complex.Complex;
import org.eclipse.january.dataset.AbstractCompoundDataset;
import org.eclipse.january.dataset.BroadcastIterator;
import org.eclipse.january.dataset.BroadcastSelfIterator;
import org.eclipse.january.dataset.CompoundDataset;
import org.eclipse.january.dataset.DTypeUtils;
import org.eclipse.january.dataset.Dataset;
import org.eclipse.january.dataset.DatasetFactory;
import org.eclipse.january.dataset.DatasetUtils;
import org.eclipse.january.dataset.DoubleDataset;
import org.eclipse.january.dataset.IDataset;
import org.eclipse.january.dataset.IndexIterator;
import org.eclipse.january.dataset.IntegerIterator;
import org.eclipse.january.dataset.IntegersIterator;
import org.eclipse.january.dataset.PositionIterator;
import org.eclipse.january.dataset.ShapeUtils;
import org.eclipse.january.dataset.Slice;
import org.eclipse.january.dataset.SliceIterator;

public class CompoundDoubleDataset
extends AbstractCompoundDataset {
    private static final long serialVersionUID = -6891075135217265625L;
    protected double[] data;

    @Override
    protected void setData() {
        this.data = (double[])this.odata;
    }

    protected double[] createArray(int size) {
        double[] array = null;
        try {
            array = new double[this.isize * size];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            logger.error("The size of the dataset ({}) that is being created is too large and there is not enough memory to hold it.", (Object)size);
            throw new OutOfMemoryError("The dimensions given are too large, and there is not enough memory available in the Java Virtual Machine");
        }
        return array;
    }

    @Override
    public int getDType() {
        return 600;
    }

    CompoundDoubleDataset() {
    }

    CompoundDoubleDataset(int itemSize) {
        this.isize = itemSize;
    }

    CompoundDoubleDataset(int itemSize, int[] shape) {
        this.isize = itemSize;
        if (shape != null) {
            this.size = ShapeUtils.calcSize(shape);
            this.shape = (int[])shape.clone();
            try {
                this.data = this.createArray(this.size);
                this.odata = this.data;
            }
            catch (Throwable t) {
                logger.error("Could not create a dataset of shape {}", (Object)Arrays.toString(shape), (Object)t);
                throw new IllegalArgumentException(t);
            }
        }
    }

    CompoundDoubleDataset(CompoundDoubleDataset dataset) {
        this.isize = dataset.isize;
        CompoundDoubleDataset.copyToView(dataset, this, true, true);
        try {
            if (dataset.stride == null) {
                this.data = (double[])dataset.data.clone();
                this.odata = this.data;
            } else {
                this.offset = 0;
                this.stride = null;
                this.base = null;
                this.data = this.createArray(this.size);
                this.odata = this.data;
                IndexIterator iter = dataset.getIterator();
                int j = 0;
                while (iter.hasNext()) {
                    int i = 0;
                    while (i < this.isize) {
                        this.data[j++] = dataset.data[iter.index + i];
                        ++i;
                    }
                }
            }
        }
        catch (Throwable t) {
            logger.error("Could not create a dataset of shape {}", (Object)Arrays.toString(this.shape), (Object)t);
            throw new IllegalArgumentException(t);
        }
    }

    CompoundDoubleDataset(CompoundDataset dataset) {
        CompoundDoubleDataset.copyToView(dataset, this, true, false);
        this.offset = 0;
        this.stride = null;
        this.base = null;
        this.isize = dataset.getElementsPerItem();
        try {
            this.data = this.createArray(this.size);
            this.odata = this.data;
        }
        catch (Throwable t) {
            logger.error("Could not create a dataset of shape {}", (Object)Arrays.toString(this.shape), (Object)t);
            throw new IllegalArgumentException(t);
        }
        IndexIterator iter = dataset.getIterator();
        int j = 0;
        while (iter.hasNext()) {
            int i = 0;
            while (i < this.isize) {
                this.data[j++] = dataset.getElementDoubleAbs(iter.index + i);
                ++i;
            }
        }
    }

    CompoundDoubleDataset(int itemSize, double[] data, int ... shape) {
        this.isize = itemSize;
        if (data != null) {
            if (shape == null || shape.length == 0 && data.length > this.isize) {
                shape = new int[]{data.length / this.isize};
            }
            this.size = ShapeUtils.calcSize(shape);
            if (this.size * this.isize != data.length) {
                throw new IllegalArgumentException(String.format("Shape %s is not compatible with size of data array, %d", Arrays.toString(shape), data.length / this.isize));
            }
            this.shape = this.size == 0 ? null : (int[])shape.clone();
            this.data = data;
            this.odata = data;
        }
    }

    CompoundDoubleDataset(Dataset ... datasets) {
        if (datasets.length < 1) {
            throw new IllegalArgumentException("Array of datasets must have length greater than zero");
        }
        int i = 1;
        while (i < datasets.length) {
            datasets[0].checkCompatibility(datasets[i]);
            ++i;
        }
        this.isize = datasets.length;
        this.size = ShapeUtils.calcSize(datasets[0].getShapeRef());
        this.shape = datasets[0].getShape();
        try {
            this.data = this.createArray(this.size);
            this.odata = this.data;
        }
        catch (Throwable t) {
            logger.error("Could not create a dataset of shape {}", (Object)Arrays.toString(this.shape), (Object)t);
            throw new IllegalArgumentException(t);
        }
        IndexIterator[] iters = new IndexIterator[this.isize];
        int i2 = 0;
        while (i2 < datasets.length) {
            iters[i2] = datasets[i2].getIterator();
            ++i2;
        }
        int j = 0;
        while (iters[0].hasNext()) {
            this.data[j++] = datasets[0].getElementDoubleAbs(iters[0].index);
            int i3 = 1;
            while (i3 < datasets.length) {
                iters[i3].hasNext();
                this.data[j++] = datasets[i3].getElementDoubleAbs(iters[i3].index);
                ++i3;
            }
        }
    }

    CompoundDoubleDataset(int itemSize, boolean repeat, Dataset dataset) {
        this.isize = itemSize;
        this.size = dataset.getSize();
        this.shape = dataset.getShape();
        this.name = new String(dataset.getName());
        try {
            this.data = this.createArray(this.size);
            this.odata = this.data;
        }
        catch (Throwable t) {
            logger.error("Could not create a dataset of shape {}", (Object)Arrays.toString(this.shape), (Object)t);
            throw new IllegalArgumentException(t);
        }
        int os = dataset.getElementsPerItem();
        IndexIterator iter = dataset.getIterator();
        if (repeat) {
            int i = 0;
            while (iter.hasNext()) {
                double v = dataset.getElementDoubleAbs(iter.index);
                int k = 0;
                while (k < this.isize) {
                    this.data[i++] = v;
                    ++k;
                }
            }
        } else {
            int kmax = Math.min(this.isize, os);
            int i = 0;
            while (iter.hasNext()) {
                int k = 0;
                while (k < kmax) {
                    this.data[i + k] = dataset.getElementDoubleAbs(iter.index + k);
                    ++k;
                }
                i += this.isize;
            }
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getRank() == 0 && !this.getClass().equals(obj.getClass())) {
            return true;
        }
        CompoundDoubleDataset other = (CompoundDoubleDataset)obj;
        IndexIterator iter = this.getIterator();
        IndexIterator oiter = other.getIterator();
        while (iter.hasNext() && oiter.hasNext()) {
            int j = 0;
            while (j < this.isize) {
                if (this.data[iter.index + j] != other.data[oiter.index + j]) {
                    return false;
                }
                ++j;
            }
        }
        return true;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public CompoundDoubleDataset clone() {
        return new CompoundDoubleDataset(this);
    }

    static CompoundDoubleDataset createFromObject(Object obj) {
        DoubleDataset result = DoubleDataset.createFromObject(obj);
        return (CompoundDoubleDataset)DatasetUtils.createCompoundDatasetFromLastAxis(result, true);
    }

    public static CompoundDoubleDataset createFromObject(int itemSize, Object obj) {
        DoubleDataset result = DoubleDataset.createFromObject(obj);
        return new CompoundDoubleDataset(itemSize, result.getData(), null);
    }

    static CompoundDoubleDataset createRange(int itemSize, double stop) {
        return CompoundDoubleDataset.createRange(itemSize, 0.0, stop, 1.0);
    }

    static CompoundDoubleDataset createRange(int itemSize, double start, double stop, double step) {
        int size = CompoundDoubleDataset.calcSteps(start, stop, step);
        CompoundDoubleDataset result = new CompoundDoubleDataset(itemSize, new int[]{size});
        int i = 0;
        while (i < size) {
            result.data[i * result.isize] = start + (double)i * step;
            ++i;
        }
        return result;
    }

    static CompoundDoubleDataset ones(int itemSize, int ... shape) {
        return new CompoundDoubleDataset(itemSize, shape).fill(1);
    }

    public static CompoundDoubleDataset createCompoundDatasetWithLastDimension(Dataset a, boolean shareData) {
        int[] nArray;
        if (a.getElementsPerItem() != 1) {
            logger.error("Need a single-element dataset");
            throw new IllegalArgumentException("Need a single-element dataset");
        }
        if (a.getDType() != 6) {
            logger.error("Dataset type must be double");
            throw new IllegalArgumentException("Dataset type must be double");
        }
        int[] shape = a.getShapeRef();
        if (shape == null) {
            return new CompoundDoubleDataset(0);
        }
        int rank = shape.length - 1;
        int is = rank < 0 ? 1 : shape[rank];
        CompoundDoubleDataset result = new CompoundDoubleDataset(is);
        if (rank > 0) {
            nArray = Arrays.copyOf(shape, rank);
        } else if (rank < 0) {
            nArray = new int[]{};
        } else {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 1;
        }
        result.shape = nArray;
        result.size = ShapeUtils.calcSize(result.shape);
        result.odata = shareData ? a.getBuffer() : a.clone().getBuffer();
        result.setName(a.getName());
        result.setData();
        return result;
    }

    @Override
    public DoubleDataset asNonCompoundDataset(boolean shareData) {
        DoubleDataset result = new DoubleDataset();
        int is = this.getElementsPerItem();
        int rank = is == 1 ? this.shape.length : this.shape.length + 1;
        int[] nshape = Arrays.copyOf(this.shape, rank);
        if (is != 1) {
            nshape[rank - 1] = is;
        }
        result.shape = nshape;
        result.size = ShapeUtils.calcSize(nshape);
        result.odata = shareData ? this.data : (double[])this.data.clone();
        result.setName(this.name);
        result.setData();
        return result;
    }

    @Override
    public CompoundDoubleDataset fill(Object obj) {
        this.setDirty();
        double[] vr = DTypeUtils.toDoubleArray(obj, this.isize);
        IndexIterator iter = this.getIterator();
        while (iter.hasNext()) {
            int i = 0;
            while (i < this.isize) {
                this.data[iter.index + i] = vr[i];
                ++i;
            }
        }
        return this;
    }

    public double[] getData() {
        return this.data;
    }

    @Override
    protected int getBufferLength() {
        if (this.data == null) {
            return 0;
        }
        return this.data.length;
    }

    @Override
    public CompoundDoubleDataset getView(boolean deepCopyMetadata) {
        CompoundDoubleDataset view = new CompoundDoubleDataset(this.isize);
        CompoundDoubleDataset.copyToView(this, view, true, deepCopyMetadata);
        view.setData();
        return view;
    }

    public double[] getAbs(int index) {
        double[] result = new double[this.isize];
        int i = 0;
        while (i < this.isize) {
            result[i] = this.data[index + i];
            ++i;
        }
        return result;
    }

    public void getAbs(int index, double[] values) {
        int i = 0;
        while (i < this.isize) {
            values[i] = this.data[index + i];
            ++i;
        }
    }

    @Override
    public boolean getElementBooleanAbs(int index) {
        int i = 0;
        while (i < this.isize) {
            if (this.data[index + i] == 0.0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public double getElementDoubleAbs(int index) {
        return this.data[index];
    }

    @Override
    public long getElementLongAbs(int index) {
        return (long)this.data[index];
    }

    @Override
    protected void setItemDirect(int dindex, int sindex, Object src) {
        this.setDirty();
        double[] dsrc = (double[])src;
        int i = 0;
        while (i < this.isize) {
            this.data[dindex + i] = dsrc[sindex + i];
            ++i;
        }
    }

    public void setAbs(int index, double[] val) {
        this.setDirty();
        int i = 0;
        while (i < this.isize) {
            this.data[index + i] = val[i];
            ++i;
        }
    }

    public void setAbs(int index, double val) {
        this.setDirty();
        this.data[index] = val;
    }

    @Override
    public Object getObject() {
        return this.getDoubleArray();
    }

    @Override
    public Object getObject(int i) {
        return this.getDoubleArray(i);
    }

    @Override
    public Object getObject(int i, int j) {
        return this.getDoubleArray(i, j);
    }

    @Override
    public Object getObject(int ... pos) {
        return this.getDoubleArray(pos);
    }

    @Override
    public byte[] getByteArray() {
        byte[] result = new byte[this.isize];
        int index = this.getFirst1DIndex();
        int k = 0;
        while (k < this.isize) {
            result[k] = (byte)this.data[index + k];
            ++k;
        }
        return result;
    }

    @Override
    public byte[] getByteArray(int i) {
        byte[] result = new byte[this.isize];
        int index = this.get1DIndex(i);
        int k = 0;
        while (k < this.isize) {
            result[k] = (byte)this.data[index + k];
            ++k;
        }
        return result;
    }

    @Override
    public byte[] getByteArray(int i, int j) {
        byte[] result = new byte[this.isize];
        int index = this.get1DIndex(i, j);
        int k = 0;
        while (k < this.isize) {
            result[k] = (byte)this.data[index + k];
            ++k;
        }
        return result;
    }

    @Override
    public byte[] getByteArray(int ... pos) {
        byte[] result = new byte[this.isize];
        int index = this.get1DIndex(pos);
        int k = 0;
        while (k < this.isize) {
            result[k] = (byte)this.data[index + k];
            ++k;
        }
        return result;
    }

    @Override
    public short[] getShortArray() {
        short[] result = new short[this.isize];
        int index = this.getFirst1DIndex();
        int k = 0;
        while (k < this.isize) {
            result[k] = (short)this.data[index + k];
            ++k;
        }
        return result;
    }

    @Override
    public short[] getShortArray(int i) {
        short[] result = new short[this.isize];
        int index = this.get1DIndex(i);
        int k = 0;
        while (k < this.isize) {
            result[k] = (short)this.data[index + k];
            ++k;
        }
        return result;
    }

    @Override
    public short[] getShortArray(int i, int j) {
        short[] result = new short[this.isize];
        int index = this.get1DIndex(i, j);
        int k = 0;
        while (k < this.isize) {
            result[k] = (short)this.data[index + k];
            ++k;
        }
        return result;
    }

    @Override
    public short[] getShortArray(int ... pos) {
        short[] result = new short[this.isize];
        int index = this.get1DIndex(pos);
        int k = 0;
        while (k < this.isize) {
            result[k] = (short)this.data[index + k];
            ++k;
        }
        return result;
    }

    @Override
    public int[] getIntArray() {
        int[] result = new int[this.isize];
        int index = this.getFirst1DIndex();
        int k = 0;
        while (k < this.isize) {
            result[k] = (int)this.data[index + k];
            ++k;
        }
        return result;
    }

    @Override
    public int[] getIntArray(int i) {
        int[] result = new int[this.isize];
        int index = this.get1DIndex(i);
        int k = 0;
        while (k < this.isize) {
            result[k] = (int)this.data[index + k];
            ++k;
        }
        return result;
    }

    @Override
    public int[] getIntArray(int i, int j) {
        int[] result = new int[this.isize];
        int index = this.get1DIndex(i, j);
        int k = 0;
        while (k < this.isize) {
            result[k] = (int)this.data[index + k];
            ++k;
        }
        return result;
    }

    @Override
    public int[] getIntArray(int ... pos) {
        int[] result = new int[this.isize];
        int index = this.get1DIndex(pos);
        int k = 0;
        while (k < this.isize) {
            result[k] = (int)this.data[index + k];
            ++k;
        }
        return result;
    }

    @Override
    public long[] getLongArray() {
        long[] result = new long[this.isize];
        int index = this.getFirst1DIndex();
        int k = 0;
        while (k < this.isize) {
            result[k] = (long)this.data[index + k];
            ++k;
        }
        return result;
    }

    @Override
    public long[] getLongArray(int i) {
        long[] result = new long[this.isize];
        int index = this.get1DIndex(i);
        int k = 0;
        while (k < this.isize) {
            result[k] = (long)this.data[index + k];
            ++k;
        }
        return result;
    }

    @Override
    public long[] getLongArray(int i, int j) {
        long[] result = new long[this.isize];
        int index = this.get1DIndex(i, j);
        int k = 0;
        while (k < this.isize) {
            result[k] = (long)this.data[index + k];
            ++k;
        }
        return result;
    }

    @Override
    public long[] getLongArray(int ... pos) {
        long[] result = new long[this.isize];
        int index = this.get1DIndex(pos);
        int k = 0;
        while (k < this.isize) {
            result[k] = (long)this.data[index + k];
            ++k;
        }
        return result;
    }

    @Override
    public float[] getFloatArray() {
        float[] result = new float[this.isize];
        int index = this.getFirst1DIndex();
        int k = 0;
        while (k < this.isize) {
            result[k] = (float)this.data[index + k];
            ++k;
        }
        return result;
    }

    @Override
    public float[] getFloatArray(int i) {
        float[] result = new float[this.isize];
        int index = this.get1DIndex(i);
        int k = 0;
        while (k < this.isize) {
            result[k] = (float)this.data[index + k];
            ++k;
        }
        return result;
    }

    @Override
    public float[] getFloatArray(int i, int j) {
        float[] result = new float[this.isize];
        int index = this.get1DIndex(i, j);
        int k = 0;
        while (k < this.isize) {
            result[k] = (float)this.data[index + k];
            ++k;
        }
        return result;
    }

    @Override
    public float[] getFloatArray(int ... pos) {
        float[] result = new float[this.isize];
        int index = this.get1DIndex(pos);
        int k = 0;
        while (k < this.isize) {
            result[k] = (float)this.data[index + k];
            ++k;
        }
        return result;
    }

    @Override
    public double[] getDoubleArray() {
        double[] result = new double[this.isize];
        int index = this.getFirst1DIndex();
        int k = 0;
        while (k < this.isize) {
            result[k] = this.data[index + k];
            ++k;
        }
        return result;
    }

    @Override
    public double[] getDoubleArray(int i) {
        double[] result = new double[this.isize];
        int index = this.get1DIndex(i);
        int k = 0;
        while (k < this.isize) {
            result[k] = this.data[index + k];
            ++k;
        }
        return result;
    }

    @Override
    public double[] getDoubleArray(int i, int j) {
        double[] result = new double[this.isize];
        int index = this.get1DIndex(i, j);
        int k = 0;
        while (k < this.isize) {
            result[k] = this.data[index + k];
            ++k;
        }
        return result;
    }

    @Override
    public double[] getDoubleArray(int ... pos) {
        double[] result = new double[this.isize];
        int index = this.get1DIndex(pos);
        int k = 0;
        while (k < this.isize) {
            result[k] = this.data[index + k];
            ++k;
        }
        return result;
    }

    @Override
    public void getDoubleArrayAbs(int index, double[] darray) {
        int i = 0;
        while (i < this.isize) {
            darray[i] = this.data[index + i];
            ++i;
        }
    }

    @Override
    public String getString() {
        return this.getStringAbs(this.getFirst1DIndex());
    }

    @Override
    public String getString(int i) {
        return this.getStringAbs(this.get1DIndex(i));
    }

    @Override
    public String getString(int i, int j) {
        return this.getStringAbs(this.get1DIndex(i, j));
    }

    @Override
    public String getString(int ... pos) {
        return this.getStringAbs(this.get1DIndex(pos));
    }

    @Override
    protected double getFirstValue() {
        return this.data[this.getFirst1DIndex()];
    }

    @Override
    protected double getFirstValue(int i) {
        return this.data[this.get1DIndex(i)];
    }

    @Override
    protected double getFirstValue(int i, int j) {
        return this.data[this.get1DIndex(i, j)];
    }

    @Override
    protected double getFirstValue(int ... pos) {
        return this.data[this.get1DIndex(pos)];
    }

    @Override
    public Object getObjectAbs(int index) {
        double[] result = new double[this.isize];
        int i = 0;
        while (i < this.isize) {
            result[i] = this.data[index + i];
            ++i;
        }
        return result;
    }

    @Override
    public String getStringAbs(int index) {
        StringBuilder s = new StringBuilder();
        s.append('(');
        s.append(this.stringFormat == null ? String.format("%.8g", this.data[index]) : this.stringFormat.format(this.data[index]));
        int i = 1;
        while (i < this.isize) {
            s.append(' ');
            s.append(this.stringFormat == null ? String.format("%.8g", this.data[index + i]) : this.stringFormat.format(this.data[index + i]));
            ++i;
        }
        s.append(')');
        return s.toString();
    }

    @Override
    public void setObjectAbs(int index, Object obj) {
        double[] oa = DTypeUtils.toDoubleArray(obj, this.isize);
        this.setAbs(index, oa);
    }

    @Override
    public void set(Object obj) {
        this.setItem(DTypeUtils.toDoubleArray(obj, this.isize));
    }

    @Override
    public void set(Object obj, int i) {
        this.setItem(DTypeUtils.toDoubleArray(obj, this.isize), i);
    }

    @Override
    public void set(Object obj, int i, int j) {
        this.setItem(DTypeUtils.toDoubleArray(obj, this.isize), i, j);
    }

    @Override
    public void set(Object obj, int ... pos) {
        if (pos == null || pos.length == 0 && this.shape.length > 0) {
            pos = new int[this.shape.length];
        }
        this.setItem(DTypeUtils.toDoubleArray(obj, this.isize), pos);
    }

    public void setItem(double[] d) {
        if (d.length > this.isize) {
            throw new IllegalArgumentException("Array is larger than number of elements in an item");
        }
        this.setAbs(this.getFirst1DIndex(), d);
    }

    public void setItem(double[] d, int i) {
        if (d.length > this.isize) {
            throw new IllegalArgumentException("Array is larger than number of elements in an item");
        }
        this.setAbs(this.get1DIndex(i), d);
    }

    public void setItem(double[] d, int i, int j) {
        if (d.length > this.isize) {
            throw new IllegalArgumentException("Array is larger than number of elements in an item");
        }
        this.setAbs(this.get1DIndex(i, j), d);
    }

    public void setItem(double[] d, int ... pos) {
        if (d.length > this.isize) {
            throw new IllegalArgumentException("Array is larger than number of elements in an item");
        }
        this.setAbs(this.get1DIndex(pos), d);
    }

    private void setDoubleArrayAbs(int index, double[] d) {
        int i = 0;
        while (i < this.isize) {
            this.data[index + i] = d[i];
            ++i;
        }
    }

    @Override
    public void resize(int ... newShape) {
        double[] ndata;
        this.setDirty();
        IndexIterator iter = this.getIterator();
        int nsize = ShapeUtils.calcSize(newShape);
        try {
            ndata = this.createArray(nsize);
        }
        catch (Throwable t) {
            logger.error("Could not create a dataset of shape {}", (Object)Arrays.toString(this.shape), (Object)t);
            throw new IllegalArgumentException(t);
        }
        int i = 0;
        while (iter.hasNext() && i < nsize) {
            int j = 0;
            while (j < this.isize) {
                ndata[i++] = this.data[iter.index + j];
                ++j;
            }
        }
        this.data = ndata;
        this.odata = ndata;
        this.size = nsize;
        this.shape = newShape;
        this.stride = null;
        this.offset = 0;
        this.base = null;
    }

    @Override
    public CompoundDoubleDataset getSlice(SliceIterator siter) {
        CompoundDoubleDataset result = new CompoundDoubleDataset(this.isize, siter.getShape());
        double[] rdata = result.data;
        IndexIterator riter = result.getIterator();
        while (siter.hasNext() && riter.hasNext()) {
            int i = 0;
            while (i < this.isize) {
                rdata[riter.index + i] = this.data[siter.index + i];
                ++i;
            }
        }
        result.setName(String.valueOf(this.name) + '[' + Slice.createString(siter.shape, siter.start, siter.stop, siter.step) + ']');
        return result;
    }

    @Override
    public DoubleDataset getElementsView(int element) {
        if (element < 0) {
            element += this.isize;
        }
        if (element < 0 || element > this.isize) {
            throw new IllegalArgumentException(String.format("Invalid choice of element: %d/%d", element, this.isize));
        }
        DoubleDataset view = new DoubleDataset(this.shape);
        CompoundDoubleDataset.copyToView(this, view, true, true);
        view.setData();
        if (view.stride == null) {
            int[] offset = new int[1];
            view.stride = CompoundDoubleDataset.createStrides(this, offset);
            view.offset = offset[0] + element;
            view.base = this.base == null ? this : this.base;
        } else {
            view.offset += element;
        }
        return view;
    }

    @Override
    public DoubleDataset getElements(int element) {
        DoubleDataset elements = new DoubleDataset(this.shape);
        this.copyElements(elements, element);
        return elements;
    }

    @Override
    public void copyElements(Dataset destination, int element) {
        if (element < 0) {
            element += this.isize;
        }
        if (element < 0 || element > this.isize) {
            throw new IllegalArgumentException(String.format("Invalid choice of element: %d/%d", element, this.isize));
        }
        if (this.getElementClass() != destination.getElementClass()) {
            throw new IllegalArgumentException("Element class of destination does not match this dataset");
        }
        IndexIterator it = this.getIterator(element);
        double[] elements = ((DoubleDataset)destination).data;
        destination.setDirty();
        int n = 0;
        while (it.hasNext()) {
            elements[n] = this.data[it.index];
            ++n;
        }
    }

    @Override
    public void setElements(Dataset source, int element) {
        this.setDirty();
        if (element < 0) {
            element += this.isize;
        }
        if (element < 0 || element > this.isize) {
            throw new IllegalArgumentException(String.format("Invalid choice of element: %d/%d", element, this.isize));
        }
        if (this.getElementClass() != source.getElementClass()) {
            throw new IllegalArgumentException("Element class of destination does not match this dataset");
        }
        IndexIterator it = this.getIterator(element);
        double[] elements = ((DoubleDataset)source).data;
        int n = 0;
        while (it.hasNext()) {
            this.data[it.index] = elements[n];
            ++n;
        }
    }

    @Override
    public void fillDataset(Dataset result, IndexIterator iter) {
        this.setDirty();
        IndexIterator riter = result.getIterator();
        double[] rdata = ((CompoundDoubleDataset)result).data;
        while (riter.hasNext() && iter.hasNext()) {
            int i = 0;
            while (i < this.isize) {
                rdata[riter.index + i] = this.data[iter.index + i];
                ++i;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public CompoundDoubleDataset setByBoolean(Object o, Dataset selection) {
        block10: {
            block9: {
                this.setDirty();
                if (!(o instanceof Dataset)) break block9;
                ds = (Dataset)o;
                length = ((Number)selection.sum(new boolean[0])).intValue();
                if (length != ds.getSize()) {
                    throw new IllegalArgumentException("Number of true items in selection does not match number of items in dataset");
                }
                iter = ds.getIterator();
                biter = this.getBooleanIterator(selection);
                if (!(ds instanceof AbstractCompoundDataset)) ** GOTO lbl25
                if (this.isize == ds.getElementsPerItem()) ** GOTO lbl17
                throw new IllegalArgumentException("Input dataset is not compatible with slice");
lbl-1000:
                // 1 sources

                {
                    i = 0;
                    while (i < this.isize) {
                        this.data[biter.index + i] = ds.getElementDoubleAbs(iter.index + i);
                        ++i;
                    }
lbl17:
                    // 2 sources

                    ** while (biter.hasNext() && iter.hasNext())
                }
lbl18:
                // 1 sources

                break block10;
lbl-1000:
                // 1 sources

                {
                    this.data[biter.index] = ds.getElementDoubleAbs(iter.index);
                    i = 1;
                    while (i < this.isize) {
                        this.data[biter.index + i] = 0.0;
                        ++i;
                    }
lbl25:
                    // 2 sources

                    ** while (biter.hasNext() && iter.hasNext())
                }
lbl26:
                // 1 sources

                break block10;
            }
            try {
                vr = DTypeUtils.toDoubleArray(o, this.isize);
                biter = this.getBooleanIterator(selection);
                while (biter.hasNext()) {
                    i = 0;
                    while (i < this.isize) {
                        this.data[biter.index + i] = vr[i];
                        ++i;
                    }
                }
            }
            catch (IllegalArgumentException v0) {
                throw new IllegalArgumentException("Object for setting is not a dataset or number");
            }
        }
        return this;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public CompoundDoubleDataset setBy1DIndex(Object o, Dataset index) {
        block11: {
            block10: {
                this.setDirty();
                if (!(o instanceof Dataset)) break block10;
                ds = (Dataset)o;
                if (index.getSize() != ds.getSize()) {
                    throw new IllegalArgumentException("Number of items in selection does not match number of items in dataset");
                }
                oiter = ds.getIterator();
                iter = new IntegerIterator(index, this.size, this.isize);
                if (!(ds instanceof AbstractCompoundDataset)) ** GOTO lbl30
                if (this.isize != ds.getElementsPerItem()) {
                    throw new IllegalArgumentException("Input dataset is not compatible with slice");
                }
                temp = new double[this.isize];
                while (iter.hasNext() && oiter.hasNext()) {
                    ((AbstractCompoundDataset)ds).getDoubleArrayAbs(oiter.index, temp);
                    this.setDoubleArrayAbs(iter.index, temp);
                }
                while (iter.hasNext() && oiter.hasNext()) {
                    i = 0;
                    while (i < this.isize) {
                        this.data[iter.index + i] = ds.getElementDoubleAbs(oiter.index + i);
                        ++i;
                    }
                }
                break block11;
lbl-1000:
                // 1 sources

                {
                    this.data[iter.index] = ds.getElementDoubleAbs(oiter.index);
                    i = 1;
                    while (i < this.isize) {
                        this.data[iter.index + i] = 0.0;
                        ++i;
                    }
lbl30:
                    // 2 sources

                    ** while (iter.hasNext() && oiter.hasNext())
                }
lbl31:
                // 1 sources

                break block11;
            }
            try {
                vr = DTypeUtils.toDoubleArray(o, this.isize);
                iter = new IntegerIterator(index, this.size, this.isize);
                while (iter.hasNext()) {
                    this.setAbs(iter.index, vr);
                }
            }
            catch (IllegalArgumentException v0) {
                throw new IllegalArgumentException("Object for setting is not a dataset or number");
            }
        }
        return this;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public CompoundDoubleDataset setByIndexes(Object o, Object ... indexes) {
        block9: {
            block8: {
                this.setDirty();
                iter = new IntegersIterator(this.shape, indexes);
                pos = iter.getPos();
                if (!(o instanceof Dataset)) break block8;
                ds = (Dataset)o;
                if (ShapeUtils.calcSize(iter.getShape()) != ds.getSize()) {
                    throw new IllegalArgumentException("Number of items in selection does not match number of items in dataset");
                }
                oiter = ds.getIterator();
                if (!(ds instanceof AbstractCompoundDataset)) ** GOTO lbl25
                if (this.isize != ds.getElementsPerItem()) {
                    throw new IllegalArgumentException("Input dataset is not compatible with slice");
                }
                temp = new double[this.isize];
                while (iter.hasNext() && oiter.hasNext()) {
                    ((AbstractCompoundDataset)ds).getDoubleArray(temp, pos);
                    this.setDoubleArrayAbs(this.get1DIndex(pos), temp);
                }
                break block9;
lbl-1000:
                // 1 sources

                {
                    n = this.get1DIndex(pos);
                    this.data[n] = ds.getElementDoubleAbs(oiter.index);
                    i = 1;
                    while (i < this.isize) {
                        this.data[n + i] = 0.0;
                        ++i;
                    }
lbl25:
                    // 2 sources

                    ** while (iter.hasNext() && oiter.hasNext())
                }
lbl26:
                // 1 sources

                break block9;
            }
            try {
                vr = DTypeUtils.toDoubleArray(o, this.isize);
                while (iter.hasNext()) {
                    this.setAbs(this.get1DIndex(pos), vr);
                }
            }
            catch (IllegalArgumentException v0) {
                throw new IllegalArgumentException("Object for setting is not a dataset or number");
            }
        }
        return this;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    CompoundDoubleDataset setSlicedView(Dataset view, Dataset d) {
        block5: {
            this.setDirty();
            it = BroadcastSelfIterator.createIterator(view, d);
            is = view.getElementsPerItem();
            if (is <= 1) ** GOTO lbl24
            if (d.getElementsPerItem() != 1) ** GOTO lbl21
            while (it.hasNext()) {
                this.data[it.aIndex] = bv = it.bDouble;
                j = 1;
                while (j < is) {
                    this.data[it.aIndex + j] = bv;
                    ++j;
                }
            }
            break block5;
lbl-1000:
            // 1 sources

            {
                this.data[it.aIndex] = it.bDouble;
                j = 1;
                while (j < is) {
                    this.data[it.aIndex + j] = d.getElementDoubleAbs(it.bIndex + j);
                    ++j;
                }
lbl21:
                // 2 sources

                ** while (it.hasNext())
            }
lbl22:
            // 1 sources

            break block5;
lbl-1000:
            // 1 sources

            {
                this.data[it.aIndex] = it.bDouble;
lbl24:
                // 2 sources

                ** while (it.hasNext())
            }
        }
        return this;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public CompoundDoubleDataset setSlice(Object o, IndexIterator siter) {
        block15: {
            block13: {
                block14: {
                    this.setDirty();
                    if (!(o instanceof IDataset)) break block13;
                    ds = (IDataset)o;
                    oshape = ds.getShape();
                    if (!ShapeUtils.areShapesCompatible(siter.getShape(), oshape)) {
                        throw new IllegalArgumentException(String.format("Input dataset is not compatible with slice: %s cf %s", new Object[]{Arrays.toString(oshape), Arrays.toString(siter.getShape())}));
                    }
                    if (!(ds instanceof Dataset)) break block14;
                    ads = (Dataset)ds;
                    oiter = ads.getIterator();
                    if (!(ds instanceof AbstractCompoundDataset)) ** GOTO lbl26
                    if (this.isize == ads.getElementsPerItem()) ** GOTO lbl18
                    throw new IllegalArgumentException("Input dataset is not compatible with slice");
lbl-1000:
                    // 1 sources

                    {
                        i = 0;
                        while (i < this.isize) {
                            this.data[siter.index + i] = ads.getElementDoubleAbs(oiter.index + i);
                            ++i;
                        }
lbl18:
                        // 2 sources

                        ** while (siter.hasNext() && oiter.hasNext())
                    }
lbl19:
                    // 1 sources

                    break block15;
lbl-1000:
                    // 1 sources

                    {
                        this.data[siter.index] = ads.getElementDoubleAbs(oiter.index);
                        i = 1;
                        while (i < this.isize) {
                            this.data[siter.index + i] = 0.0;
                            ++i;
                        }
lbl26:
                        // 2 sources

                        ** while (siter.hasNext() && oiter.hasNext())
                    }
lbl27:
                    // 1 sources

                    break block15;
                }
                oiter = new PositionIterator(oshape);
                pos = oiter.getPos();
                if (ds.getElementsPerItem() != 1) ** GOTO lbl47
                while (siter.hasNext() && oiter.hasNext()) {
                    this.data[siter.index] = ds.getDouble(pos);
                    i = 1;
                    while (i < this.isize) {
                        this.data[siter.index + i] = 0.0;
                        ++i;
                    }
                }
                break block15;
lbl-1000:
                // 1 sources

                {
                    val = DTypeUtils.toDoubleArray(ds.getObject(pos), this.isize);
                    i = 0;
                    while (i < this.isize) {
                        this.data[siter.index + i] = val[i];
                        ++i;
                    }
lbl47:
                    // 2 sources

                    ** while (siter.hasNext() && oiter.hasNext())
                }
lbl48:
                // 1 sources

                break block15;
            }
            try {
                vr = DTypeUtils.toDoubleArray(o, this.isize);
                while (siter.hasNext()) {
                    i = 0;
                    while (i < this.isize) {
                        this.data[siter.index + i] = vr[i];
                        ++i;
                    }
                }
            }
            catch (IllegalArgumentException v0) {
                throw new IllegalArgumentException("Object for setting slice is not a dataset or number");
            }
        }
        return this;
    }

    @Override
    public void copyItemsFromAxes(int[] pos, boolean[] axes, Dataset dest) {
        double[] ddata = (double[])dest.getBuffer();
        if (dest.getElementsPerItem() != this.isize) {
            throw new IllegalArgumentException(String.format("Destination dataset is incompatible as it has %d elements per item not %d", dest.getElementsPerItem(), this.isize));
        }
        SliceIterator siter = this.getSliceIteratorFromAxes(pos, axes);
        int[] sshape = ShapeUtils.squeezeShape(siter.getShape(), false);
        IndexIterator diter = dest.getSliceIterator(null, sshape, null);
        if (ddata.length < ShapeUtils.calcSize(sshape)) {
            throw new IllegalArgumentException("destination array is not large enough");
        }
        dest.setDirty();
        while (siter.hasNext() && diter.hasNext()) {
            int i = 0;
            while (i < this.isize) {
                ddata[diter.index + i] = this.data[siter.index + i];
                ++i;
            }
        }
    }

    @Override
    public void setItemsOnAxes(int[] pos, boolean[] axes, Object src) {
        this.setDirty();
        double[] sdata = (double[])src;
        SliceIterator siter = this.getSliceIteratorFromAxes(pos, axes);
        if (sdata.length < ShapeUtils.calcSize(siter.getShape())) {
            throw new IllegalArgumentException("source array is not large enough");
        }
        int i = 0;
        while (siter.hasNext()) {
            int j = 0;
            while (j < this.isize) {
                this.data[siter.index + j] = sdata[this.isize * i + j];
                ++j;
            }
            ++i;
        }
    }

    @Override
    public boolean containsNans() {
        IndexIterator iter = this.getIterator();
        while (iter.hasNext()) {
            int i = 0;
            while (i < this.isize) {
                if (Double.isNaN(this.data[iter.index + i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    @Override
    public boolean containsInfs() {
        IndexIterator iter = this.getIterator();
        while (iter.hasNext()) {
            int i = 0;
            while (i < this.isize) {
                if (Double.isInfinite(this.data[iter.index + i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    @Override
    public boolean containsInvalidNumbers() {
        IndexIterator iter = this.getIterator();
        while (iter.hasNext()) {
            int i = 0;
            while (i < this.isize) {
                double x = this.data[iter.index + i];
                if (Double.isNaN(x) || Double.isInfinite(x)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public CompoundDoubleDataset iadd(Object b) {
        block20: {
            block23: {
                block22: {
                    block18: {
                        block21: {
                            block19: {
                                this.setDirty();
                                bds = b instanceof Dataset != false ? (Dataset)b : DatasetFactory.createFromObject(b);
                                useLong = bds.getElementClass().equals(Long.class);
                                is = bds.getElementsPerItem();
                                if (bds.getSize() != 1) break block18;
                                it = this.getIterator();
                                if (is != 1) break block19;
                                if (useLong) {
                                    lb = bds.getElementLongAbs(0);
                                    while (it.hasNext()) {
                                        i = 0;
                                        while (i < this.isize) {
                                            v0 = it.index + i;
                                            this.data[v0] = this.data[v0] + (double)lb;
                                            ++i;
                                        }
                                    }
                                } else {
                                    db = bds.getElementDoubleAbs(0);
                                    while (it.hasNext()) {
                                        i = 0;
                                        while (i < this.isize) {
                                            v1 = it.index + i;
                                            this.data[v1] = this.data[v1] + db;
                                            ++i;
                                        }
                                    }
                                }
                                break block20;
                            }
                            if (is != this.isize) break block21;
                            if (!useLong) ** GOTO lbl47
                            while (it.hasNext()) {
                                i = 0;
                                while (i < this.isize) {
                                    v2 = it.index + i;
                                    this.data[v2] = this.data[v2] + (double)bds.getElementLongAbs(i);
                                    ++i;
                                }
                            }
                            break block20;
lbl-1000:
                            // 1 sources

                            {
                                i = 0;
                                while (i < this.isize) {
                                    v3 = it.index + i;
                                    this.data[v3] = this.data[v3] + bds.getElementDoubleAbs(i);
                                    ++i;
                                }
lbl47:
                                // 2 sources

                                ** while (it.hasNext())
                            }
lbl48:
                            // 1 sources

                            break block20;
                        }
                        throw new IllegalArgumentException("Argument does not have same number of elements per item or is not a non-compound dataset");
                    }
                    it = BroadcastSelfIterator.createIterator(this, bds);
                    it.setOutputDouble(useLong == false);
                    if (is != 1) break block22;
                    if (!useLong) ** GOTO lbl77
                    while (it.hasNext()) {
                        lb = it.bLong;
                        v4 = it.aIndex;
                        this.data[v4] = this.data[v4] + (double)lb;
                        i = 1;
                        while (i < this.isize) {
                            v5 = it.aIndex + i;
                            this.data[v5] = this.data[v5] + (double)lb;
                            ++i;
                        }
                    }
                    break block20;
lbl-1000:
                    // 1 sources

                    {
                        db = it.bDouble;
                        v6 = it.aIndex;
                        this.data[v6] = this.data[v6] + db;
                        i = 1;
                        while (i < this.isize) {
                            v7 = it.aIndex + i;
                            this.data[v7] = this.data[v7] + db;
                            ++i;
                        }
lbl77:
                        // 2 sources

                        ** while (it.hasNext())
                    }
lbl78:
                    // 1 sources

                    break block20;
                }
                if (is != this.isize) break block23;
                if (!useLong) ** GOTO lbl101
                while (it.hasNext()) {
                    v8 = it.aIndex;
                    this.data[v8] = this.data[v8] + (double)it.bLong;
                    i = 1;
                    while (i < this.isize) {
                        v9 = it.aIndex + i;
                        this.data[v9] = this.data[v9] + (double)bds.getElementLongAbs(it.bIndex + i);
                        ++i;
                    }
                }
                break block20;
lbl-1000:
                // 1 sources

                {
                    v10 = it.aIndex;
                    this.data[v10] = this.data[v10] + it.bDouble;
                    i = 1;
                    while (i < this.isize) {
                        v11 = it.aIndex + i;
                        this.data[v11] = this.data[v11] + bds.getElementDoubleAbs(it.bIndex + i);
                        ++i;
                    }
lbl101:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl102:
                // 1 sources

                break block20;
            }
            throw new IllegalArgumentException("Argument does not have same number of elements per item or is not a non-compound dataset");
        }
        return this;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public CompoundDoubleDataset isubtract(Object b) {
        block20: {
            block23: {
                block22: {
                    block18: {
                        block21: {
                            block19: {
                                this.setDirty();
                                bds = b instanceof Dataset != false ? (Dataset)b : DatasetFactory.createFromObject(b);
                                useLong = bds.getElementClass().equals(Long.class);
                                is = bds.getElementsPerItem();
                                if (bds.getSize() != 1) break block18;
                                it = this.getIterator();
                                if (is != 1) break block19;
                                if (useLong) {
                                    lb = bds.getElementLongAbs(0);
                                    while (it.hasNext()) {
                                        i = 0;
                                        while (i < this.isize) {
                                            v0 = it.index + i;
                                            this.data[v0] = this.data[v0] - (double)lb;
                                            ++i;
                                        }
                                    }
                                } else {
                                    db = bds.getElementDoubleAbs(0);
                                    while (it.hasNext()) {
                                        i = 0;
                                        while (i < this.isize) {
                                            v1 = it.index + i;
                                            this.data[v1] = this.data[v1] - db;
                                            ++i;
                                        }
                                    }
                                }
                                break block20;
                            }
                            if (is != this.isize) break block21;
                            if (!useLong) ** GOTO lbl47
                            while (it.hasNext()) {
                                i = 0;
                                while (i < this.isize) {
                                    v2 = it.index + i;
                                    this.data[v2] = this.data[v2] - (double)bds.getElementLongAbs(i);
                                    ++i;
                                }
                            }
                            break block20;
lbl-1000:
                            // 1 sources

                            {
                                i = 0;
                                while (i < this.isize) {
                                    v3 = it.index + i;
                                    this.data[v3] = this.data[v3] - bds.getElementDoubleAbs(i);
                                    ++i;
                                }
lbl47:
                                // 2 sources

                                ** while (it.hasNext())
                            }
lbl48:
                            // 1 sources

                            break block20;
                        }
                        throw new IllegalArgumentException("Argument does not have same number of elements per item or is not a non-compound dataset");
                    }
                    it = BroadcastSelfIterator.createIterator(this, bds);
                    it.setOutputDouble(useLong == false);
                    if (is != 1) break block22;
                    if (!useLong) ** GOTO lbl77
                    while (it.hasNext()) {
                        lb = it.bLong;
                        v4 = it.aIndex;
                        this.data[v4] = this.data[v4] + (double)lb;
                        i = 1;
                        while (i < this.isize) {
                            v5 = it.aIndex + i;
                            this.data[v5] = this.data[v5] - (double)lb;
                            ++i;
                        }
                    }
                    break block20;
lbl-1000:
                    // 1 sources

                    {
                        db = it.bDouble;
                        v6 = it.aIndex;
                        this.data[v6] = this.data[v6] + db;
                        i = 1;
                        while (i < this.isize) {
                            v7 = it.aIndex + i;
                            this.data[v7] = this.data[v7] - db;
                            ++i;
                        }
lbl77:
                        // 2 sources

                        ** while (it.hasNext())
                    }
lbl78:
                    // 1 sources

                    break block20;
                }
                if (is != this.isize) break block23;
                if (!useLong) ** GOTO lbl101
                while (it.hasNext()) {
                    v8 = it.aIndex;
                    this.data[v8] = this.data[v8] + (double)it.bLong;
                    i = 1;
                    while (i < this.isize) {
                        v9 = it.aIndex + i;
                        this.data[v9] = this.data[v9] - (double)bds.getElementLongAbs(it.bIndex + i);
                        ++i;
                    }
                }
                break block20;
lbl-1000:
                // 1 sources

                {
                    v10 = it.aIndex;
                    this.data[v10] = this.data[v10] + it.bDouble;
                    i = 1;
                    while (i < this.isize) {
                        v11 = it.aIndex + i;
                        this.data[v11] = this.data[v11] - bds.getElementDoubleAbs(it.bIndex + i);
                        ++i;
                    }
lbl101:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl102:
                // 1 sources

                break block20;
            }
            throw new IllegalArgumentException("Argument does not have same number of elements per item or is not a non-compound dataset");
        }
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public CompoundDoubleDataset imultiply(Object b) {
        this.setDirty();
        Dataset bds = b instanceof Dataset ? (Dataset)b : DatasetFactory.createFromObject(b);
        boolean useLong = bds.getElementClass().equals(Long.class);
        int is = bds.getElementsPerItem();
        if (bds.getSize() == 1) {
            IndexIterator it = this.getIterator();
            if (useLong) {
                if (is == 1) {
                    long lb = bds.getElementLongAbs(0);
                    while (it.hasNext()) {
                        int i = 0;
                        while (i < this.isize) {
                            int n = it.index + i;
                            this.data[n] = this.data[n] * (double)lb;
                            ++i;
                        }
                    }
                    return this;
                } else {
                    if (is != this.isize) throw new IllegalArgumentException("Argument does not have same number of elements per item or is not a non-compound dataset");
                    while (it.hasNext()) {
                        int i = 0;
                        while (i < this.isize) {
                            int n = it.index + i;
                            this.data[n] = this.data[n] * (double)bds.getElementLongAbs(i);
                            ++i;
                        }
                    }
                }
                return this;
            } else if (is == 1) {
                double db = bds.getElementDoubleAbs(0);
                while (it.hasNext()) {
                    int i = 0;
                    while (i < this.isize) {
                        int n = it.index + i;
                        this.data[n] = this.data[n] * db;
                        ++i;
                    }
                }
                return this;
            } else {
                if (is != this.isize) throw new IllegalArgumentException("Argument does not have same number of elements per item or is not a non-compound dataset");
                while (it.hasNext()) {
                    int i = 0;
                    while (i < this.isize) {
                        int n = it.index + i;
                        this.data[n] = this.data[n] * bds.getElementDoubleAbs(i);
                        ++i;
                    }
                }
            }
            return this;
        } else {
            BroadcastSelfIterator it = BroadcastSelfIterator.createIterator(this, bds);
            it.setOutputDouble(!useLong);
            if (useLong) {
                if (is == 1) {
                    while (it.hasNext()) {
                        double lb = it.bLong;
                        int i = 0;
                        while (i < this.isize) {
                            int n = it.aIndex + i;
                            this.data[n] = this.data[n] * lb;
                            ++i;
                        }
                    }
                    return this;
                } else {
                    if (is != this.isize) throw new IllegalArgumentException("Argument does not have same number of elements per item or is not a non-compound dataset");
                    while (it.hasNext()) {
                        int n = it.aIndex;
                        this.data[n] = this.data[n] * (double)it.bLong;
                        int i = 1;
                        while (i < this.isize) {
                            int n2 = it.aIndex + i;
                            this.data[n2] = this.data[n2] * (double)bds.getElementLongAbs(it.bIndex + i);
                            ++i;
                        }
                    }
                }
                return this;
            } else if (is == 1) {
                while (it.hasNext()) {
                    double db = it.bDouble;
                    int i = 0;
                    while (i < this.isize) {
                        int n = it.aIndex + i;
                        this.data[n] = this.data[n] * db;
                        ++i;
                    }
                }
                return this;
            } else {
                if (is != this.isize) throw new IllegalArgumentException("Argument does not have same number of elements per item or is not a non-compound dataset");
                while (it.hasNext()) {
                    int n = it.aIndex;
                    this.data[n] = this.data[n] * it.bDouble;
                    int i = 1;
                    while (i < this.isize) {
                        int n3 = it.aIndex + i;
                        this.data[n3] = this.data[n3] * bds.getElementDoubleAbs(it.bIndex + i);
                        ++i;
                    }
                }
            }
        }
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public CompoundDoubleDataset idivide(Object b) {
        this.setDirty();
        Dataset bds = b instanceof Dataset ? (Dataset)b : DatasetFactory.createFromObject(b);
        boolean useLong = bds.getElementClass().equals(Long.class);
        int is = bds.getElementsPerItem();
        if (bds.getSize() == 1) {
            IndexIterator it = this.getIterator();
            if (useLong) {
                if (is == 1) {
                    long lb = bds.getElementLongAbs(0);
                    while (it.hasNext()) {
                        int i = 0;
                        while (i < this.isize) {
                            int n = it.index + i;
                            this.data[n] = this.data[n] / (double)lb;
                            ++i;
                        }
                    }
                    return this;
                } else {
                    if (is != this.isize) throw new IllegalArgumentException("Argument does not have same number of elements per item or is not a non-compound dataset");
                    while (it.hasNext()) {
                        int i = 0;
                        while (i < this.isize) {
                            long lb = bds.getElementLongAbs(i);
                            int n = it.index + i;
                            this.data[n] = this.data[n] / (double)lb;
                            ++i;
                        }
                    }
                }
                return this;
            } else if (is == 1) {
                double db = bds.getElementDoubleAbs(0);
                while (it.hasNext()) {
                    int i = 0;
                    while (i < this.isize) {
                        int n = it.index + i;
                        this.data[n] = this.data[n] / db;
                        ++i;
                    }
                }
                return this;
            } else {
                if (is != this.isize) throw new IllegalArgumentException("Argument does not have same number of elements per item or is not a non-compound dataset");
                while (it.hasNext()) {
                    int i = 0;
                    while (i < this.isize) {
                        double db = bds.getElementDoubleAbs(i);
                        int n = it.index + i;
                        this.data[n] = this.data[n] / db;
                        ++i;
                    }
                }
            }
            return this;
        } else {
            BroadcastSelfIterator it = BroadcastSelfIterator.createIterator(this, bds);
            it.setOutputDouble(!useLong);
            if (useLong) {
                if (is == 1) {
                    while (it.hasNext()) {
                        long lb = it.bLong;
                        int i = 0;
                        while (i < this.isize) {
                            int n = it.aIndex + i;
                            this.data[n] = this.data[n] / (double)lb;
                            ++i;
                        }
                    }
                    return this;
                } else {
                    if (is != this.isize) throw new IllegalArgumentException("Argument does not have same number of elements per item or is not a non-compound dataset");
                    while (it.hasNext()) {
                        int i = 0;
                        while (i < this.isize) {
                            long lb = bds.getElementLongAbs(it.bIndex + i);
                            int n = it.aIndex + i;
                            this.data[n] = this.data[n] / (double)lb;
                            ++i;
                        }
                    }
                }
                return this;
            } else if (is == 1) {
                while (it.hasNext()) {
                    double db = it.bDouble;
                    int i = 0;
                    while (i < this.isize) {
                        int n = it.aIndex + i;
                        this.data[n] = this.data[n] / db;
                        ++i;
                    }
                }
                return this;
            } else {
                if (is != this.isize) throw new IllegalArgumentException("Argument does not have same number of elements per item or is not a non-compound dataset");
                while (it.hasNext()) {
                    int i = 0;
                    while (i < this.isize) {
                        double db = bds.getElementDoubleAbs(it.bIndex + i);
                        int n = it.aIndex + i;
                        this.data[n] = this.data[n] / db;
                        ++i;
                    }
                }
            }
        }
        return this;
    }

    @Override
    public CompoundDoubleDataset ifloor() {
        this.setDirty();
        IndexIterator it = this.getIterator();
        while (it.hasNext()) {
            int i = 0;
            while (i < this.isize) {
                this.data[it.index + i] = Math.floor(this.data[it.index] + (double)i);
                ++i;
            }
        }
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public CompoundDoubleDataset iremainder(Object b) {
        this.setDirty();
        Dataset bds = b instanceof Dataset ? (Dataset)b : DatasetFactory.createFromObject(b);
        boolean useLong = bds.getElementClass().equals(Long.class);
        int is = bds.getElementsPerItem();
        if (bds.getSize() == 1) {
            IndexIterator it = this.getIterator();
            if (useLong) {
                if (is == 1) {
                    long lb = bds.getElementLongAbs(0);
                    while (it.hasNext()) {
                        int i = 0;
                        while (i < this.isize) {
                            int n = it.index + i;
                            this.data[n] = this.data[n] % (double)lb;
                            ++i;
                        }
                    }
                    return this;
                } else {
                    if (is != this.isize) throw new IllegalArgumentException("Argument does not have same number of elements per item or is not a non-compound dataset");
                    while (it.hasNext()) {
                        int i = 0;
                        while (i < this.isize) {
                            int n = it.index + i;
                            this.data[n] = this.data[n] % (double)bds.getElementLongAbs(i);
                            ++i;
                        }
                    }
                }
                return this;
            } else if (is == 1) {
                double db = bds.getElementDoubleAbs(0);
                while (it.hasNext()) {
                    int i = 0;
                    while (i < this.isize) {
                        int n = it.index + i;
                        this.data[n] = this.data[n] % db;
                        ++i;
                    }
                }
                return this;
            } else {
                if (is != this.isize) throw new IllegalArgumentException("Argument does not have same number of elements per item or is not a non-compound dataset");
                while (it.hasNext()) {
                    int i = 0;
                    while (i < this.isize) {
                        int n = it.index + i;
                        this.data[n] = this.data[n] % bds.getElementDoubleAbs(i);
                        ++i;
                    }
                }
            }
            return this;
        } else {
            BroadcastSelfIterator it = BroadcastSelfIterator.createIterator(this, bds);
            it.setOutputDouble(!useLong);
            if (useLong) {
                if (is == 1) {
                    while (it.hasNext()) {
                        long lb = it.bLong;
                        int i = 0;
                        while (i < this.isize) {
                            int n = it.aIndex + i;
                            this.data[n] = this.data[n] % (double)lb;
                            ++i;
                        }
                    }
                    return this;
                } else {
                    if (is != this.isize) throw new IllegalArgumentException("Argument does not have same number of elements per item or is not a non-compound dataset");
                    while (it.hasNext()) {
                        int i = 0;
                        while (i < this.isize) {
                            long lb = bds.getElementLongAbs(it.bIndex + i);
                            int n = it.aIndex + i;
                            this.data[n] = this.data[n] % (double)lb;
                            ++i;
                        }
                    }
                }
                return this;
            } else if (is == 1) {
                while (it.hasNext()) {
                    double db = it.bDouble;
                    int i = 0;
                    while (i < this.isize) {
                        int n = it.aIndex + i;
                        this.data[n] = this.data[n] % db;
                        ++i;
                    }
                }
                return this;
            } else {
                if (is != this.isize) throw new IllegalArgumentException("Argument does not have same number of elements per item or is not a non-compound dataset");
                while (it.hasNext()) {
                    int i = 0;
                    while (i < this.isize) {
                        double db = bds.getElementDoubleAbs(it.bIndex + i);
                        int n = it.aIndex + i;
                        this.data[n] = this.data[n] % db;
                        ++i;
                    }
                }
            }
        }
        return this;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public CompoundDoubleDataset ipower(Object b) {
        block20: {
            block19: {
                this.setDirty();
                bds = b instanceof Dataset != false ? (Dataset)b : DatasetFactory.createFromObject(b);
                is = bds.getElementsPerItem();
                if (bds.getSize() != 1) break block19;
                vr = bds.getElementDoubleAbs(0);
                it = this.getIterator();
                if (bds.isComplex()) {
                    vi = bds.getElementDoubleAbs(1);
                    if (vi == 0.0) {
                        while (it.hasNext()) {
                            i = 0;
                            while (i < this.isize) {
                                this.data[it.index + i] = v = Math.pow(this.data[it.index + i], vr);
                                ++i;
                            }
                        }
                    } else {
                        zv = new Complex(vr, vi);
                        while (it.hasNext()) {
                            i = 0;
                            while (i < this.isize) {
                                zd = new Complex(this.data[it.index + i], 0.0);
                                this.data[it.index + i] = v = zd.pow(zv).getReal();
                                ++i;
                            }
                        }
                    }
                } else if (is == 1) {
                    while (it.hasNext()) {
                        i = 0;
                        while (i < this.isize) {
                            this.data[it.index + i] = v = Math.pow(this.data[it.index + i], vr);
                            ++i;
                        }
                    }
                } else if (is == this.isize) {
                    while (it.hasNext()) {
                        i = 0;
                        while (i < this.isize) {
                            this.data[it.index + i] = v = Math.pow(this.data[it.index + i], bds.getElementDoubleAbs(i));
                            ++i;
                        }
                    }
                }
                break block20;
            }
            it = BroadcastIterator.createIterator(this, bds);
            it.setOutputDouble(true);
            if (!bds.isComplex()) ** GOTO lbl66
            while (it.hasNext()) {
                zv = new Complex(it.bDouble, bds.getElementDoubleAbs(it.bIndex + 1));
                this.data[it.aIndex] = v = new Complex(it.aDouble, 0.0).pow(zv).getReal();
                i = 1;
                while (i < this.isize) {
                    this.data[it.aIndex + i] = v = new Complex(this.data[it.aIndex + i], 0.0).pow(zv).getReal();
                    ++i;
                }
            }
            break block20;
lbl-1000:
            // 1 sources

            {
                this.data[it.aIndex] = v = Math.pow(it.aDouble, it.bDouble);
                i = 1;
                while (i < this.isize) {
                    this.data[it.aIndex + i] = v = Math.pow(this.data[it.aIndex + i], bds.getElementDoubleAbs(it.bIndex + i));
                    ++i;
                }
lbl66:
                // 2 sources

                ** while (it.hasNext())
            }
        }
        return this;
    }

    @Override
    public double residual(Object b, Dataset w, boolean ignoreNaNs) {
        Dataset bds = b instanceof Dataset ? (Dataset)b : DatasetFactory.createFromObject(b);
        BroadcastIterator it = BroadcastIterator.createIterator(this, bds);
        it.setOutputDouble(true);
        double sum = 0.0;
        double comp = 0.0;
        int bis = bds.getElementsPerItem();
        if (bis == 1) {
            if (w == null) {
                while (it.hasNext()) {
                    double db = it.bDouble;
                    double diff = it.aDouble - db;
                    if (ignoreNaNs) {
                        if (Double.isNaN(diff)) continue;
                        boolean skip = false;
                        int i = 1;
                        while (i < this.isize) {
                            if (Double.isNaN(this.data[it.aIndex + i])) {
                                skip = true;
                                break;
                            }
                            ++i;
                        }
                        if (skip) continue;
                    }
                    double err = diff * diff - comp;
                    double temp = sum + err;
                    comp = temp - sum - err;
                    sum = temp;
                    int i = 1;
                    while (i < this.isize) {
                        diff = this.data[it.aIndex + i] - db;
                        err = diff * diff - comp;
                        temp = sum + err;
                        comp = temp - sum - err;
                        sum = temp;
                        ++i;
                    }
                }
            } else {
                IndexIterator itw = w.getIterator();
                while (it.hasNext() && itw.hasNext()) {
                    double db = it.bDouble;
                    double diff = it.aDouble - db;
                    if (ignoreNaNs) {
                        if (Double.isNaN(diff)) continue;
                        boolean skip = false;
                        int i = 1;
                        while (i < this.isize) {
                            if (Double.isNaN(this.data[it.aIndex + i])) {
                                skip = true;
                                break;
                            }
                            ++i;
                        }
                        if (skip) continue;
                    }
                    double dw = w.getElementDoubleAbs(itw.index);
                    double err = diff * diff * dw - comp;
                    double temp = sum + err;
                    comp = temp - sum - err;
                    sum = temp;
                    int i = 1;
                    while (i < this.isize) {
                        diff = this.data[it.aIndex + i] - db;
                        err = diff * diff * dw - comp;
                        temp = sum + err;
                        comp = temp - sum - err;
                        sum = temp;
                        ++i;
                    }
                }
            }
        } else if (w == null) {
            while (it.hasNext()) {
                double diff = it.aDouble - it.bDouble;
                if (ignoreNaNs) {
                    if (Double.isNaN(diff)) continue;
                    boolean skip = false;
                    int i = 1;
                    while (i < this.isize) {
                        if (Double.isNaN(this.data[it.aIndex + i]) || Double.isNaN(bds.getElementDoubleAbs(it.bIndex + i))) {
                            skip = true;
                            break;
                        }
                        ++i;
                    }
                    if (skip) continue;
                }
                double err = diff * diff - comp;
                double temp = sum + err;
                comp = temp - sum - err;
                sum = temp;
                int i = 1;
                while (i < this.isize) {
                    diff = this.data[it.aIndex + i] - bds.getElementDoubleAbs(it.bIndex + i);
                    err = diff * diff - comp;
                    temp = sum + err;
                    comp = temp - sum - err;
                    sum = temp;
                    ++i;
                }
            }
        } else {
            IndexIterator itw = w.getIterator();
            while (it.hasNext() && itw.hasNext()) {
                double diff = it.aDouble - it.bDouble;
                if (ignoreNaNs) {
                    if (Double.isNaN(diff)) continue;
                    boolean skip = false;
                    int i = 1;
                    while (i < this.isize) {
                        if (Double.isNaN(this.data[it.aIndex + i]) || Double.isNaN(bds.getElementDoubleAbs(it.bIndex + i))) {
                            skip = true;
                            break;
                        }
                        ++i;
                    }
                    if (skip) continue;
                }
                double dw = w.getElementDoubleAbs(itw.index);
                double err = diff * diff * dw - comp;
                double temp = sum + err;
                comp = temp - sum - err;
                sum = temp;
                int i = 1;
                while (i < this.isize) {
                    diff = this.data[it.aIndex + i] - bds.getElementDoubleAbs(it.bIndex + i);
                    err = diff * diff * dw - comp;
                    temp = sum + err;
                    comp = temp - sum - err;
                    sum = temp;
                    ++i;
                }
            }
        }
        return sum;
    }
}

