/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import java.io.Serializable;
import org.eclipse.january.asserts.TestUtils;
import org.eclipse.january.dataset.Dataset;
import org.eclipse.january.dataset.DatasetFactory;
import org.eclipse.january.dataset.ILazyDataset;
import org.eclipse.january.dataset.LazyMaths;
import org.eclipse.january.dataset.Maths;
import org.junit.Test;

public class LazyMathsTest {
    @Test
    public void testSum() throws Exception {
        Dataset a = DatasetFactory.createRange((double)100.0, (int)6);
        TestUtils.assertDatasetEquals((Dataset)a.sum(0, new boolean[0]), (Dataset)LazyMaths.sum((ILazyDataset)a, (int)0), (double)1.0E-9, (double)1.0E-15);
        a.setShape(new int[]{10, 10});
        TestUtils.assertDatasetEquals((Dataset)a.sum(0, new boolean[0]), (Dataset)LazyMaths.sum((ILazyDataset)a, (int)0), (double)1.0E-9, (double)1.0E-15);
        TestUtils.assertDatasetEquals((Dataset)a.sum(1, new boolean[0]), (Dataset)LazyMaths.sum((ILazyDataset)a, (int)1), (double)1.0E-9, (double)1.0E-15);
        a.setShape(new int[]{4, 5, 5});
        TestUtils.assertDatasetEquals((Dataset)a.sum(0, new boolean[0]), (Dataset)LazyMaths.sum((ILazyDataset)a, (int)0), (double)1.0E-9, (double)1.0E-15);
        TestUtils.assertDatasetEquals((Dataset)a.sum(1, new boolean[0]), (Dataset)LazyMaths.sum((ILazyDataset)a, (int)1), (double)1.0E-9, (double)1.0E-15);
        TestUtils.assertDatasetEquals((Dataset)a.sum(2, new boolean[0]), (Dataset)LazyMaths.sum((ILazyDataset)a, (int)2), (double)1.0E-9, (double)1.0E-15);
        a.setShape(new int[]{4, 5, 1, 5});
        TestUtils.assertDatasetEquals((Dataset)a.sum(0, new boolean[0]), (Dataset)LazyMaths.sum((ILazyDataset)a, (int)0), (double)1.0E-9, (double)1.0E-15);
        TestUtils.assertDatasetEquals((Dataset)a.sum(1, new boolean[0]), (Dataset)LazyMaths.sum((ILazyDataset)a, (int)1), (double)1.0E-9, (double)1.0E-15);
        TestUtils.assertDatasetEquals((Dataset)a.sum(2, new boolean[0]), (Dataset)LazyMaths.sum((ILazyDataset)a, (int)2), (double)1.0E-9, (double)1.0E-15);
        TestUtils.assertDatasetEquals((Dataset)a.sum(3, new boolean[0]), (Dataset)LazyMaths.sum((ILazyDataset)a, (int)3), (double)1.0E-9, (double)1.0E-15);
    }

    @Test
    public void testSumIgnoreAxes() throws Exception {
        Dataset a = DatasetFactory.createRange((double)100.0, (int)6);
        a.setShape(new int[]{10, 10});
        TestUtils.assertDatasetEquals((Dataset)a.sum(0, new boolean[0]), (Dataset)LazyMaths.sum((ILazyDataset)a, (int[])new int[]{1}), (double)1.0E-9, (double)1.0E-15);
        TestUtils.assertDatasetEquals((Dataset)a.sum(1, new boolean[0]), (Dataset)LazyMaths.sum((ILazyDataset)a, (int[])new int[1]), (double)1.0E-9, (double)1.0E-15);
        a.setShape(new int[]{4, 5, 5});
        TestUtils.assertDatasetEquals((Dataset)a.sum(0, new boolean[0]), (Dataset)LazyMaths.sum((ILazyDataset)a, (int[])new int[]{1, 2}), (double)1.0E-9, (double)1.0E-15);
        TestUtils.assertDatasetEquals((Dataset)a.sum(1, new boolean[0]), (Dataset)LazyMaths.sum((ILazyDataset)a, (int[])new int[]{0, 2}), (double)1.0E-9, (double)1.0E-15);
        TestUtils.assertDatasetEquals((Dataset)a.sum(2, new boolean[0]), (Dataset)LazyMaths.sum((ILazyDataset)a, (int[])new int[]{0, 1}), (double)1.0E-9, (double)1.0E-15);
        a.setShape(new int[]{4, 5, 1, 5});
        TestUtils.assertDatasetEquals((Dataset)a.sum(0, new boolean[0]), (Dataset)LazyMaths.sum((ILazyDataset)a, (int[])new int[]{1, 2, 3}), (double)1.0E-9, (double)1.0E-15);
        TestUtils.assertDatasetEquals((Dataset)a.sum(1, new boolean[0]), (Dataset)LazyMaths.sum((ILazyDataset)a, (int[])new int[]{0, 2, 3}), (double)1.0E-9, (double)1.0E-15);
        TestUtils.assertDatasetEquals((Dataset)a.sum(2, new boolean[0]), (Dataset)LazyMaths.sum((ILazyDataset)a, (int[])new int[]{0, 1, 3}), (double)1.0E-9, (double)1.0E-15);
        TestUtils.assertDatasetEquals((Dataset)a.sum(3, new boolean[0]), (Dataset)LazyMaths.sum((ILazyDataset)a, (int[])new int[]{0, 1, 2}), (double)1.0E-9, (double)1.0E-15);
        TestUtils.assertDatasetEquals((Dataset)a.sum(0, new boolean[0]).sum(0, new boolean[0]), (Dataset)LazyMaths.sum((ILazyDataset)a, (boolean)false, (int[])new int[]{0, 1}), (double)1.0E-9, (double)1.0E-15);
        TestUtils.assertDatasetEquals((Dataset)a.sum(1, new boolean[0]).sum(0, new boolean[0]), (Dataset)LazyMaths.sum((ILazyDataset)a, (boolean)false, (int[])new int[]{1, 0}), (double)1.0E-9, (double)1.0E-15);
        TestUtils.assertDatasetEquals((Dataset)a.sum(1, new boolean[0]).sum(0, new boolean[0]), (Dataset)LazyMaths.sum((ILazyDataset)a, (boolean)false, (int[])new int[]{0, 1}), (double)1.0E-9, (double)1.0E-15);
        TestUtils.assertDatasetEquals((Dataset)a.sum(3, new boolean[0]).sum(2, new boolean[0]).sum(0, new boolean[0]), (Dataset)LazyMaths.sum((ILazyDataset)a, (boolean)false, (int[])new int[]{0, 3, 2}), (double)1.0E-9, (double)1.0E-15);
    }

    @Test
    public void testProduct() throws Exception {
        Dataset a = DatasetFactory.createRange((double)100.0, (int)6);
        a.iadd((Object)1.0);
        a.idivide((Object)100.0);
        TestUtils.assertDatasetEquals((Dataset)a.product(0, new boolean[0]), (Dataset)LazyMaths.product((ILazyDataset)a, (int)0), (double)1.0E-9, (double)1.0E-15);
        a.setShape(new int[]{10, 10});
        TestUtils.assertDatasetEquals((Dataset)a.product(0, new boolean[0]), (Dataset)LazyMaths.product((ILazyDataset)a, (int)0), (double)1.0E-9, (double)1.0E-15);
        TestUtils.assertDatasetEquals((Dataset)a.product(1, new boolean[0]), (Dataset)LazyMaths.product((ILazyDataset)a, (int)1), (double)1.0E-9, (double)1.0E-15);
        a.setShape(new int[]{4, 5, 5});
        TestUtils.assertDatasetEquals((Dataset)a.product(0, new boolean[0]), (Dataset)LazyMaths.product((ILazyDataset)a, (int)0), (double)1.0E-9, (double)1.0E-15);
        TestUtils.assertDatasetEquals((Dataset)a.product(1, new boolean[0]), (Dataset)LazyMaths.product((ILazyDataset)a, (int)1), (double)1.0E-9, (double)1.0E-15);
        TestUtils.assertDatasetEquals((Dataset)a.product(2, new boolean[0]), (Dataset)LazyMaths.product((ILazyDataset)a, (int)2), (double)1.0E-9, (double)1.0E-15);
        a.setShape(new int[]{4, 5, 1, 5});
        TestUtils.assertDatasetEquals((Dataset)a.product(0, new boolean[0]), (Dataset)LazyMaths.product((ILazyDataset)a, (int)0), (double)1.0E-9, (double)1.0E-15);
        TestUtils.assertDatasetEquals((Dataset)a.product(1, new boolean[0]), (Dataset)LazyMaths.product((ILazyDataset)a, (int)1), (double)1.0E-9, (double)1.0E-15);
        TestUtils.assertDatasetEquals((Dataset)a.product(2, new boolean[0]), (Dataset)LazyMaths.product((ILazyDataset)a, (int)2), (double)1.0E-9, (double)1.0E-15);
        TestUtils.assertDatasetEquals((Dataset)a.product(3, new boolean[0]), (Dataset)LazyMaths.product((ILazyDataset)a, (int)3), (double)1.0E-9, (double)1.0E-15);
    }

    @Test
    public void testMeanIgnore() throws Exception {
        Dataset a = DatasetFactory.createRange((double)100.0, (int)6);
        a.setShape(new int[]{10, 10});
        TestUtils.assertDatasetEquals((Dataset)a.mean(1, new boolean[0]), (Dataset)LazyMaths.mean((ILazyDataset)a, (int[])new int[]{0}), (double)1.0E-9, (double)1.0E-15);
        TestUtils.assertDatasetEquals((Dataset)a.mean(0, new boolean[0]), (Dataset)LazyMaths.mean((ILazyDataset)a, (int[])new int[]{1}), (double)1.0E-9, (double)1.0E-15);
        a.setShape(new int[]{4, 5, 5});
        TestUtils.assertDatasetEquals((Dataset)a.mean(2, new boolean[0]).mean(1, new boolean[0]), (Dataset)LazyMaths.mean((ILazyDataset)a, (int[])new int[]{0}), (double)1.0E-9, (double)1.0E-15);
        TestUtils.assertDatasetEquals((Dataset)a.mean(2, new boolean[0]), (Dataset)LazyMaths.mean((ILazyDataset)a, (int[])new int[]{0, 1}), (double)1.0E-9, (double)1.0E-15);
        TestUtils.assertDatasetEquals((Dataset)a.mean(0, new boolean[0]), (Dataset)LazyMaths.mean((ILazyDataset)a, (int[])new int[]{1, 2}), (double)1.0E-9, (double)1.0E-15);
        a.setShape(new int[]{4, 5, 1, 5});
        TestUtils.assertDatasetEquals((Dataset)a.mean(3, new boolean[0]).mean(2, new boolean[0]), (Dataset)LazyMaths.mean((ILazyDataset)a, (int[])new int[]{0, 1}), (double)1.0E-9, (double)1.0E-15);
        TestUtils.assertDatasetEquals((Dataset)a.mean(3, new boolean[0]).mean(2, new boolean[0]).mean(1, new boolean[0]), (Dataset)LazyMaths.mean((ILazyDataset)a, (int[])new int[]{0}), (double)1.0E-9, (double)1.0E-15);
        TestUtils.assertDatasetEquals((Dataset)a.mean(3, new boolean[0]).squeeze(), (Dataset)LazyMaths.mean((ILazyDataset)a, (int[])new int[]{0, 1, 2}), (double)1.0E-9, (double)1.0E-15);
        TestUtils.assertDatasetEquals((Dataset)a.mean(0, new boolean[0]).mean(0, new boolean[0]).squeeze(), (Dataset)LazyMaths.mean((ILazyDataset)a, (int[])new int[]{2, 3}), (double)1.0E-9, (double)1.0E-15);
        Dataset er = DatasetFactory.createRange((double)100.0, (int)6);
        a.setShape(new int[]{10, 10});
        er.setShape(new int[]{10, 10});
        a.setErrorBuffer((Serializable)er);
        Dataset e = Maths.sqrt((Object)er.sum(1, new boolean[0])).idivide((Object)10);
        TestUtils.assertDatasetEquals((Dataset)e, (Dataset)LazyMaths.mean((ILazyDataset)a, (int[])new int[]{0}).getErrors(), (double)1.0E-9, (double)1.0E-15);
    }
}

