/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.methodvalidation;

import jakarta.validation.ConstraintViolation;
import jakarta.validation.ValidationException;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.tests.methodvalidation.constraint.MyCrossParameterConstraint;
import org.hibernate.beanvalidation.tck.tests.methodvalidation.model.Address;
import org.hibernate.beanvalidation.tck.tests.methodvalidation.model.ContainerElementsOrder;
import org.hibernate.beanvalidation.tck.tests.methodvalidation.model.Customer;
import org.hibernate.beanvalidation.tck.tests.methodvalidation.model.Email;
import org.hibernate.beanvalidation.tck.tests.methodvalidation.model.Item;
import org.hibernate.beanvalidation.tck.tests.methodvalidation.model.OrderLine;
import org.hibernate.beanvalidation.tck.tests.methodvalidation.model.ProductCategory;
import org.hibernate.beanvalidation.tck.util.ConstraintViolationAssert;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="4.0.0")
public class ValidateReturnValueTest
extends AbstractTCKTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)ValidateReturnValueTest.webArchiveBuilder().withTestClass(ValidateReturnValueTest.class)).withPackage(MyCrossParameterConstraint.class.getPackage())).withClass(Address.class)).withClass(Customer.class)).withClass(Email.class)).withClass(Item.class)).withClass(OrderLine.class)).withClass(ContainerElementsOrder.class)).withClass(ProductCategory.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="validationapi-validatorapi-methodlevelvalidationmethods", id="d"), @SpecAssertion(section="validationapi-validatorapi-methodlevelvalidationmethods", id="e"), @SpecAssertion(section="validationapi-constraintviolation", id="d"), @SpecAssertion(section="validationapi-constraintviolation", id="e"), @SpecAssertion(section="validationapi-constraintviolation", id="f"), @SpecAssertion(section="validationapi-constraintviolation", id="g"), @SpecAssertion(section="validationapi-constraintviolation", id="h"), @SpecAssertion(section="validationapi-constraintviolation", id="i")})
    public void testOneViolation() throws Exception {
        String methodName = "getAddress";
        Customer object = new Customer();
        Method method = Customer.class.getMethod(methodName, new Class[0]);
        String returnValue = "B";
        Set violations = this.getExecutableValidator().validateReturnValue((Object)object, method, (Object)returnValue, new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Size.class).withPropertyPath(ConstraintViolationAssert.pathWith().method(methodName).returnValue()));
        ConstraintViolation violation = (ConstraintViolation)violations.iterator().next();
        Assert.assertEquals((Object)violation.getRootBean(), (Object)object);
        Assert.assertEquals((Object)violation.getRootBeanClass(), Customer.class);
        Assert.assertEquals((Object)violation.getLeafBean(), (Object)object);
        Assert.assertEquals((Object)violation.getInvalidValue(), (Object)returnValue);
        Assert.assertNull((Object)violation.getExecutableParameters());
        Assert.assertEquals((Object)violation.getExecutableReturnValue(), (Object)returnValue);
    }

    @Test
    @SpecAssertion(section="validationapi-validatorapi-methodlevelvalidationmethods", id="e")
    public void testTwoViolations() throws Exception {
        String methodName = "getFirstName";
        Customer object = new Customer();
        Method method = Customer.class.getMethod(methodName, String.class);
        String returnValue = "S";
        Set violations = this.getExecutableValidator().validateReturnValue((Object)object, method, (Object)returnValue, new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Size.class).withPropertyPath(ConstraintViolationAssert.pathWith().method(methodName).returnValue()), ConstraintViolationAssert.violationOf(Pattern.class).withPropertyPath(ConstraintViolationAssert.pathWith().method(methodName).returnValue()));
    }

    @Test
    @SpecAssertion(section="validationapi-validatorapi-methodlevelvalidationmethods", id="e")
    public void testTwoConstraintsOfSameType() throws Exception {
        String methodName = "getLastName";
        Customer object = new Customer();
        Method method = Customer.class.getMethod(methodName, CharSequence.class);
        String returnValue = "S";
        Set violations = this.getExecutableValidator().validateReturnValue((Object)object, method, (Object)returnValue, new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Size.class).withPropertyPath(ConstraintViolationAssert.pathWith().method(methodName).returnValue()), ConstraintViolationAssert.violationOf(Size.class).withPropertyPath(ConstraintViolationAssert.pathWith().method(methodName).returnValue()));
    }

    @Test
    @SpecAssertion(section="validationapi-validatorapi-methodlevelvalidationmethods", id="e")
    public void testNoViolations() throws Exception {
        Customer object = new Customer();
        Method method = Customer.class.getMethod("getFirstName", String.class);
        String returnValue = "aaa";
        Set violations = this.getExecutableValidator().validateReturnValue((Object)object, method, (Object)returnValue, new Class[0]);
        ConstraintViolationAssert.assertNoViolations(violations);
    }

    @Test
    @SpecAssertion(section="validationapi-validatorapi-methodlevelvalidationmethods", id="e")
    public void testValidationWithGroup() throws Exception {
        String methodName = "getLastName";
        Customer object = new Customer();
        Method method = Customer.class.getMethod(methodName, Long.TYPE);
        String returnValue = "S";
        Set violations = this.getExecutableValidator().validateReturnValue((Object)object, method, (Object)returnValue, new Class[0]);
        ConstraintViolationAssert.assertNoViolations(violations);
        violations = this.getExecutableValidator().validateReturnValue((Object)object, method, (Object)returnValue, new Class[]{Customer.Extended.class});
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Size.class).withPropertyPath(ConstraintViolationAssert.pathWith().method(methodName).returnValue()));
    }

    @Test
    @SpecAssertion(section="validationapi-validatorapi-methodlevelvalidationmethods", id="e")
    public void testValidationWithSeveralGroups() throws Exception {
        String methodName = "getAllData";
        Customer object = new Customer();
        Method method = Customer.class.getMethod(methodName, Date.class);
        String returnValue = "S";
        Set violations = this.getExecutableValidator().validateReturnValue((Object)object, method, (Object)returnValue, new Class[0]);
        ConstraintViolationAssert.assertNoViolations(violations);
        violations = this.getExecutableValidator().validateReturnValue((Object)object, method, (Object)returnValue, new Class[]{Customer.Basic.class, Customer.Extended.class});
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Size.class).withPropertyPath(ConstraintViolationAssert.pathWith().method(methodName).returnValue()), ConstraintViolationAssert.violationOf(Pattern.class).withPropertyPath(ConstraintViolationAssert.pathWith().method(methodName).returnValue()));
    }

    @Test(expectedExceptions={ValidationException.class})
    @SpecAssertion(section="validationapi-validatorapi-methodlevelvalidationmethods", id="d")
    public void testUnexpectedType() throws Exception {
        String methodName = "getValue";
        Email object = new Email();
        Method method = Email.class.getMethod(methodName, new Class[0]);
        String returnValue = "S";
        this.getExecutableValidator().validateReturnValue((Object)object, method, (Object)returnValue, new Class[0]);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    @SpecAssertion(section="validationapi-validatorapi-methodlevelvalidationmethods", id="f")
    public void testNullPassedForObjectCausesException() throws Exception {
        Object object = null;
        Method method = Customer.class.getMethod("getAddress", new Class[0]);
        Object returnValue = null;
        this.getExecutableValidator().validateReturnValue(object, method, returnValue, new Class[0]);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    @SpecAssertion(section="validationapi-validatorapi-methodlevelvalidationmethods", id="f")
    public void testNullPassedForMethodCausesException() throws Exception {
        Customer object = new Customer();
        Method method = null;
        Object returnValue = null;
        this.getExecutableValidator().validateReturnValue((Object)object, method, returnValue, new Class[0]);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    @SpecAssertion(section="validationapi-validatorapi-methodlevelvalidationmethods", id="f")
    public void testNullPassedForGroupsCausesException() throws Exception {
        Customer object = new Customer();
        Method method = Customer.class.getMethod("getAddress", new Class[0]);
        Object returnValue = null;
        this.getExecutableValidator().validateReturnValue((Object)object, method, returnValue, (Class[])null);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    @SpecAssertion(section="validationapi-validatorapi-methodlevelvalidationmethods", id="f")
    public void testNullPassedAsSingleGroupCausesException() throws Exception {
        Customer object = new Customer();
        Method method = Customer.class.getMethod("getAddress", new Class[0]);
        Object returnValue = null;
        this.getExecutableValidator().validateReturnValue((Object)object, method, returnValue, new Class[]{null});
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="validationapi-constraintviolation", id="f"), @SpecAssertion(section="validationapi-constraintviolation", id="g"), @SpecAssertion(section="validationapi-constraintviolation", id="h"), @SpecAssertion(section="validationapi-constraintviolation", id="i")})
    public void testOneViolationForCascadedValidation() throws Exception {
        String methodName = "getItem";
        OrderLine object = new OrderLine(null);
        Item returnValue = new Item("foo");
        Method method = OrderLine.class.getMethod(methodName, new Class[0]);
        Set violations = this.getExecutableValidator().validateReturnValue((Object)object, method, (Object)returnValue, new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Size.class).withInvalidValue("foo").withPropertyPath(ConstraintViolationAssert.pathWith().method(methodName).returnValue().property("name")));
        ConstraintViolation violation = (ConstraintViolation)violations.iterator().next();
        Assert.assertEquals((Object)violation.getLeafBean(), (Object)returnValue);
        Assert.assertNull((Object)violation.getExecutableParameters());
        Assert.assertEquals((Object)violation.getExecutableReturnValue(), (Object)returnValue);
    }

    @Test
    @SpecAssertion(section="validationapi-constraintviolation", id="f")
    public void testContainerElementLeafBean() throws NoSuchMethodException, SecurityException {
        Method method = ContainerElementsOrder.class.getMethod("getOrder", new Class[0]);
        Item invalidItem = new Item("s");
        HashMap<ProductCategory, List<OrderLine>> invalidLines = new HashMap<ProductCategory, List<OrderLine>>();
        invalidLines.put(null, Arrays.asList(new OrderLine(new Item("item name"))));
        invalidLines.put(ProductCategory.MUSIC, Arrays.asList(new OrderLine(invalidItem)));
        ContainerElementsOrder invalidOrder = new ContainerElementsOrder("order name", invalidLines);
        Set violations = this.getExecutableValidator().validateReturnValue((Object)invalidOrder, method, (Object)invalidOrder, new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class).withLeafBean(invalidOrder), ConstraintViolationAssert.violationOf(Size.class).withLeafBean(invalidItem));
    }
}

