/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.synchronizer.factory;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.diff.metamodel.AttributeChange;
import org.eclipse.emf.compare.diff.metamodel.AttributeChangeLeftTarget;
import org.eclipse.emf.compare.diff.metamodel.AttributeOrderChange;
import org.eclipse.emf.compare.diff.metamodel.DiffElement;
import org.eclipse.emf.compare.diff.metamodel.ModelElementChange;
import org.eclipse.emf.compare.diff.metamodel.ModelElementChangeLeftTarget;
import org.eclipse.emf.compare.diff.metamodel.ModelElementChangeRightTarget;
import org.eclipse.emf.compare.diff.metamodel.ReferenceChange;
import org.eclipse.emf.compare.diff.metamodel.ReferenceChangeLeftTarget;
import org.eclipse.emf.compare.diff.metamodel.ReferenceChangeRightTarget;
import org.eclipse.emf.compare.diff.metamodel.ReferenceOrderChange;
import org.eclipse.emf.compare.diff.metamodel.ResourceDiff;
import org.eclipse.emf.compare.diff.metamodel.UpdateReference;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.mylyn.docs.intent.client.synchronizer.factory.SynchronizerMessageProvider;
import org.eclipse.mylyn.docs.intent.collab.common.logger.IIntentLogger;
import org.eclipse.mylyn.docs.intent.collab.common.logger.IntentLogger;
import org.eclipse.mylyn.docs.intent.core.compiler.AttributeChangeStatus;
import org.eclipse.mylyn.docs.intent.core.compiler.CompilationMessageType;
import org.eclipse.mylyn.docs.intent.core.compiler.CompilationStatus;
import org.eclipse.mylyn.docs.intent.core.compiler.CompilationStatusSeverity;
import org.eclipse.mylyn.docs.intent.core.compiler.CompilerFactory;
import org.eclipse.mylyn.docs.intent.core.compiler.InstructionTraceabilityEntry;
import org.eclipse.mylyn.docs.intent.core.compiler.ModelElementChangeStatus;
import org.eclipse.mylyn.docs.intent.core.compiler.ReferenceChangeStatus;
import org.eclipse.mylyn.docs.intent.core.compiler.SynchronizerChangeState;
import org.eclipse.mylyn.docs.intent.core.compiler.TraceabilityIndexEntry;
import org.eclipse.mylyn.docs.intent.core.document.IntentGenericElement;
import org.eclipse.mylyn.docs.intent.core.modelingunit.InstanciationInstruction;
import org.eclipse.mylyn.docs.intent.core.modelingunit.NativeValueForStructuralFeature;
import org.eclipse.mylyn.docs.intent.core.modelingunit.NewObjectValueForStructuralFeature;
import org.eclipse.mylyn.docs.intent.core.modelingunit.ReferenceValueForStructuralFeature;
import org.eclipse.mylyn.docs.intent.core.modelingunit.ValueForStructuralFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SynchronizerStatusFactory {
    private SynchronizerStatusFactory() {
    }

    public static List<CompilationStatus> createStatusFromDiffElement(TraceabilityIndexEntry indexEntry, DiffElement difference) {
        ArrayList<CompilationStatus> statusList = new ArrayList<CompilationStatus>();
        if (difference.getSubDiffElements().isEmpty()) {
            AttributeChangeStatus status = null;
            if (difference instanceof AttributeChange) {
                status = SynchronizerStatusFactory.createStatusFromAttributeChange(indexEntry, (AttributeChange)difference);
            } else if (difference instanceof ReferenceChange) {
                status = SynchronizerStatusFactory.createStatusFromReferenceChange(indexEntry, (ReferenceChange)difference);
            } else if (difference instanceof ModelElementChange) {
                status = SynchronizerStatusFactory.createStatusFromModelElementChange(indexEntry, (ModelElementChange)difference);
            } else if (difference instanceof ResourceDiff) {
                status = CompilerFactory.eINSTANCE.createResourceChangeStatus();
            }
            if (status != null) {
                if (difference instanceof ReferenceOrderChange || difference instanceof AttributeOrderChange) {
                    status.setSeverity(CompilationStatusSeverity.INFO);
                    status.setType(CompilationMessageType.SYNCHRONIZER_INFO);
                } else {
                    status.setSeverity(CompilationStatusSeverity.WARNING);
                    status.setType(CompilationMessageType.SYNCHRONIZER_WARNING);
                }
                status.setMessage(SynchronizerMessageProvider.createMessageFromDiffElement(difference));
                status.setWorkingCopyResourceURI(indexEntry.getResourceDeclaration().getUri().toString());
                status.setCompiledResourceURI(indexEntry.getGeneratedResourcePath());
                if (status.getTarget() == null) {
                    IntentLogger.getInstance().log(IIntentLogger.LogType.WARNING, "CANNOT FIND ANY INSTRUCTION FOR " + difference.eClass().getName() + ": " + difference);
                    status.setTarget((IntentGenericElement)indexEntry.getResourceDeclaration());
                }
                statusList.add((CompilationStatus)status);
            } else {
                IntentLogger.getInstance().log(IIntentLogger.LogType.WARNING, "CANNOT HANDLE DIFFERENCE " + difference.eClass().getName() + ": " + difference);
            }
        } else {
            for (DiffElement subDifference : difference.getSubDiffElements()) {
                statusList.addAll(SynchronizerStatusFactory.createStatusFromDiffElement(indexEntry, subDifference));
            }
        }
        return statusList;
    }

    private static ModelElementChangeStatus createStatusFromModelElementChange(TraceabilityIndexEntry indexEntry, ModelElementChange difference) {
        ModelElementChangeStatus status = CompilerFactory.eINSTANCE.createModelElementChangeStatus();
        switch (difference.eClass().getClassifierID()) {
            case 9: {
                status.setChangeState(SynchronizerChangeState.COMPILED_TARGET);
                ModelElementChangeLeftTarget letTargetDiff = (ModelElementChangeLeftTarget)difference;
                status.setCompiledElement(letTargetDiff.getLeftElement());
                status.setWorkingCopyParentURIFragment(EcoreUtil.getURI((EObject)letTargetDiff.getRightParent()).toString());
                status.setTarget(SynchronizerStatusFactory.getInstructionFromCompiledElement(indexEntry, letTargetDiff.getLeftElement()));
                break;
            }
            case 10: {
                status.setChangeState(SynchronizerChangeState.WORKING_COPY_TARGET);
                ModelElementChangeRightTarget rightTargetDiff = (ModelElementChangeRightTarget)difference;
                status.setWorkingCopyElementURIFragment(EcoreUtil.getURI((EObject)rightTargetDiff.getRightElement()).toString());
                status.setCompiledParent(rightTargetDiff.getLeftParent());
                status.setTarget(SynchronizerStatusFactory.getInstructionFromCompiledElement(indexEntry, rightTargetDiff.getLeftParent()));
                break;
            }
            case 11: {
                status.setChangeState(SynchronizerChangeState.UPDATE);
                break;
            }
            default: {
                status = null;
            }
        }
        return status;
    }

    private static String createURIFragment(EObject eo) {
        if (eo != null) {
            return EcoreUtil.getURI((EObject)eo).toString();
        }
        return null;
    }

    private static ReferenceChangeStatus createStatusFromReferenceChange(TraceabilityIndexEntry indexEntry, ReferenceChange difference) {
        EObject compiledElement = difference.getLeftElement();
        IntentGenericElement target = null;
        ReferenceChangeStatus status = CompilerFactory.eINSTANCE.createReferenceChangeStatus();
        status.setCompiledElement(compiledElement);
        status.setFeatureName(difference.getReference().getName());
        status.setWorkingCopyElementURIFragment(EcoreUtil.getURI((EObject)difference.getRightElement()).toString());
        switch (difference.eClass().getClassifierID()) {
            case 21: {
                status.setChangeState(SynchronizerChangeState.WORKING_COPY_TARGET);
                status.setCompiledTarget(((ReferenceChangeRightTarget)difference).getLeftTarget());
                status.setWorkingCopyTargetURIFragment(SynchronizerStatusFactory.createURIFragment(((ReferenceChangeRightTarget)difference).getRightTarget()));
                break;
            }
            case 23: {
                status.setChangeState(SynchronizerChangeState.ORDER);
                break;
            }
            case 20: {
                status.setChangeState(SynchronizerChangeState.COMPILED_TARGET);
                target = SynchronizerStatusFactory.getInstructionFromAffectation(indexEntry, compiledElement, (EStructuralFeature)difference.getReference(), ((ReferenceChangeLeftTarget)difference).getLeftTarget());
                status.setCompiledTarget(((ReferenceChangeLeftTarget)difference).getLeftTarget());
                status.setWorkingCopyTargetURIFragment(SynchronizerStatusFactory.createURIFragment(((ReferenceChangeLeftTarget)difference).getRightTarget()));
                break;
            }
            case 22: {
                UpdateReference updateDifference = (UpdateReference)difference;
                status.setChangeState(SynchronizerChangeState.UPDATE);
                target = SynchronizerStatusFactory.getInstructionFromAffectation(indexEntry, compiledElement, (EStructuralFeature)difference.getReference(), difference.getLeftElement().eGet((EStructuralFeature)difference.getReference()));
                EObject leftTarget = (EObject)updateDifference.getLeftElement().eGet((EStructuralFeature)updateDifference.getReference());
                EObject rightTarget = (EObject)updateDifference.getRightElement().eGet((EStructuralFeature)updateDifference.getReference());
                status.setCompiledTarget(leftTarget);
                if (rightTarget == null) break;
                status.setWorkingCopyTargetURIFragment(SynchronizerStatusFactory.createURIFragment(rightTarget));
                break;
            }
            default: {
                status = null;
            }
        }
        if (status != null) {
            if (target == null && compiledElement != null) {
                target = SynchronizerStatusFactory.getInstructionFromCompiledElement(indexEntry, compiledElement);
            }
            status.setTarget(target);
        }
        return status;
    }

    private static AttributeChangeStatus createStatusFromAttributeChange(TraceabilityIndexEntry indexEntry, AttributeChange difference) {
        EObject compiledElement = difference.getLeftElement();
        IntentGenericElement target = null;
        AttributeChangeStatus status = CompilerFactory.eINSTANCE.createAttributeChangeStatus();
        status.setCompiledElement(compiledElement);
        status.setFeatureName(difference.getAttribute().getName());
        status.setWorkingCopyElementURIFragment(EcoreUtil.getURI((EObject)difference.getRightElement()).toString());
        switch (difference.eClass().getClassifierID()) {
            case 16: {
                status.setChangeState(SynchronizerChangeState.WORKING_COPY_TARGET);
                break;
            }
            case 17: {
                status.setChangeState(SynchronizerChangeState.ORDER);
                break;
            }
            case 15: {
                status.setChangeState(SynchronizerChangeState.COMPILED_TARGET);
                target = SynchronizerStatusFactory.getInstructionFromAffectation(indexEntry, difference.getLeftElement(), (EStructuralFeature)difference.getAttribute(), ((AttributeChangeLeftTarget)difference).getLeftTarget());
                break;
            }
            case 18: {
                status.setChangeState(SynchronizerChangeState.UPDATE);
                target = SynchronizerStatusFactory.getInstructionFromAffectation(indexEntry, compiledElement, (EStructuralFeature)difference.getAttribute(), compiledElement.eGet((EStructuralFeature)difference.getAttribute()));
                break;
            }
            default: {
                status = null;
            }
        }
        if (status != null) {
            if (target == null && compiledElement != null) {
                target = SynchronizerStatusFactory.getInstructionFromCompiledElement(indexEntry, compiledElement);
            }
            status.setTarget(target);
        }
        return status;
    }

    private static IntentGenericElement getInstructionFromCompiledElement(TraceabilityIndexEntry indexEntry, EObject compiledElement) {
        EList instructionEntries = (EList)indexEntry.getContainedElementToInstructions().get((Object)compiledElement);
        if (instructionEntries != null) {
            for (InstructionTraceabilityEntry entry : instructionEntries) {
                IntentGenericElement instruction = entry.getInstruction();
                if (!(instruction instanceof InstanciationInstruction)) continue;
                return instruction;
            }
        }
        return null;
    }

    private static IntentGenericElement getInstructionFromAffectation(TraceabilityIndexEntry indexEntry, EObject compiledElement, EStructuralFeature feature, Object diffValue) {
        EList instructionEntries = (EList)indexEntry.getContainedElementToInstructions().get((Object)compiledElement);
        if (instructionEntries != null) {
            for (InstructionTraceabilityEntry entry : instructionEntries) {
                EList values = (EList)entry.getFeatures().get((Object)feature.getName());
                if (values == null) continue;
                for (ValueForStructuralFeature value : values) {
                    boolean isRefValueEquals;
                    Object compiledValue = SynchronizerStatusFactory.getCompiledValue(indexEntry, value);
                    boolean isNativeValueEquals = value instanceof NativeValueForStructuralFeature && diffValue != null && diffValue.toString().equals(compiledValue);
                    boolean isRefValue = value instanceof ReferenceValueForStructuralFeature || value instanceof NewObjectValueForStructuralFeature;
                    boolean refValueEquals = diffValue == null && compiledValue == null || diffValue != null && diffValue.equals(compiledValue);
                    boolean bl = isRefValueEquals = isRefValue && refValueEquals;
                    if (!isNativeValueEquals && !isRefValueEquals) continue;
                    return value;
                }
            }
        }
        return null;
    }

    private static Object getCompiledValue(TraceabilityIndexEntry indexEntry, ValueForStructuralFeature value) {
        String res = null;
        switch (value.eClass().getClassifierID()) {
            case 15: {
                res = ((NativeValueForStructuralFeature)value).getValue().replaceAll("\"", "");
                break;
            }
            case 17: {
                InstanciationInstruction referencedInstanciation = ((ReferenceValueForStructuralFeature)value).getReferencedElement().getReferencedElement();
                if (referencedInstanciation != null) {
                    res = SynchronizerStatusFactory.getCompiledElement(indexEntry, referencedInstanciation);
                    break;
                }
                res = ((ReferenceValueForStructuralFeature)value).getReferencedMetaType();
                break;
            }
            case 16: {
                InstanciationInstruction instanciation = ((NewObjectValueForStructuralFeature)value).getValue();
                if (instanciation == null) break;
                res = SynchronizerStatusFactory.getCompiledElement(indexEntry, instanciation);
                break;
            }
        }
        return res;
    }

    private static EObject getCompiledElement(TraceabilityIndexEntry indexEntry, InstanciationInstruction instantiation) {
        for (Map.Entry entry : indexEntry.getContainedElementToInstructions().entrySet()) {
            for (InstructionTraceabilityEntry instructionEntry : (EList)entry.getValue()) {
                IntentGenericElement instruction = instructionEntry.getInstruction();
                if (!(instruction instanceof InstanciationInstruction) || !instantiation.equals(instruction)) continue;
                return (EObject)entry.getKey();
            }
        }
        return null;
    }
}

