/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.services.pptx;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.regex.Pattern;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gendoc.document.parser.documents.Document;
import org.eclipse.gendoc.document.parser.documents.openoffice.OpenOfficeParser;
import org.eclipse.gendoc.document.parser.pptx.PPTXDocument;
import org.eclipse.gendoc.document.parser.pptx.PPTXNamespaceContext;
import org.eclipse.gendoc.documents.IAdditionalResourceService;
import org.eclipse.gendoc.documents.IDocumentService;
import org.eclipse.gendoc.documents.ITableService;
import org.eclipse.gendoc.documents.XMLDocumentService;
import org.eclipse.gendoc.services.exception.DocumentServiceException;
import org.eclipse.gendoc.services.exception.InvalidContentException;
import org.eclipse.gendoc.services.pptx.Activator;
import org.eclipse.gendoc.services.pptx.PPTXAdditionalResourceService;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PPTXDocumentService
extends XMLDocumentService
implements IDocumentService {
    private static final boolean DEBUG = System.getProperty("debug") != null;
    private String serviceId;
    private PPTXAdditionalResourceService additionalResourceService = new PPTXAdditionalResourceService();

    public String getServiceId() {
        return this.serviceId;
    }

    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    public void saveDocument(Document doc, String path) throws DocumentServiceException {
        if (!(doc instanceof PPTXDocument)) {
            throw new DocumentServiceException("Document is not a valid DOCX document.");
        }
        PPTXDocument document = (PPTXDocument)doc;
        try {
            document.jumpToStart();
            do {
                OpenOfficeParser p = document.getXMLParser();
                DOMSource domSource = new DOMSource(p.getDocument());
                if (p.getKind() != Document.CONFIGURATION.content) continue;
                StreamResult fluxDestination = new StreamResult(p.getXmlFile());
                TransformerFactory transformBuilder = TransformerFactory.newInstance();
                Transformer transformer = transformBuilder.newTransformer();
                transformer.setOutputProperty("encoding", "UTF-8");
                transformer.setOutputProperty("indent", "no");
                transformer.transform(domSource, fluxDestination);
                if (!DEBUG) continue;
                StringWriter swr = new StringWriter();
                transformer.setOutputProperty("indent", "yes");
                transformer.transform(domSource, new StreamResult(swr));
                swr.flush();
                Activator.getDefault().getLog().log((IStatus)new Status(1, "org.eclipse.gendoc.services.pptx", "/ppt/" + document.getXMLParser().getXmlFile().getName() + ":\n" + swr.toString()));
            } while (document.jumpToNextFile());
            for (OpenOfficeParser p : document.getSubdocuments()) {
                DOMSource domSource = new DOMSource(p.getDocument());
                StreamResult fluxDestination = new StreamResult(p.getXmlFile());
                TransformerFactory transformBuilder = TransformerFactory.newInstance();
                Transformer transformer = transformBuilder.newTransformer();
                transformer.setOutputProperty("encoding", "UTF-8");
                transformer.setOutputProperty("indent", "no");
                transformer.transform(domSource, fluxDestination);
                if (!DEBUG) continue;
                StringWriter swr = new StringWriter();
                transformer.setOutputProperty("indent", "yes");
                transformer.transform(domSource, new StreamResult(swr));
                swr.flush();
                Activator.getDefault().getLog().log((IStatus)new Status(1, "org.eclipse.gendoc.services.pptx", String.valueOf(p.getXmlFile().getAbsolutePath().replace(document.getUnzipLocationDocumentFile().getAbsolutePath(), "")) + ":\n" + swr.toString()));
            }
            document.zipToLocation(path);
        }
        catch (TransformerConfigurationException e1) {
            e1.printStackTrace();
        }
        catch (TransformerException e2) {
            e2.printStackTrace();
        }
    }

    public String getListLabel() {
        return null;
    }

    public boolean isList(String label) {
        return false;
    }

    public String getListId(Node n) {
        return null;
    }

    public String getContinueList(Node currentNode, String idList) throws InvalidContentException {
        return null;
    }

    public boolean isListItem(String label) {
        return false;
    }

    public String getTableLabel() {
        return null;
    }

    public boolean isTable(String label) {
        return false;
    }

    public boolean isRow(String label) {
        return false;
    }

    public boolean isCell(String label) {
        return false;
    }

    public Pattern getNobrReplacePattern() {
        return null;
    }

    public String format(String input) {
        return input;
    }

    public PPTXNamespaceContext getNameSpaceContext() {
        return new PPTXNamespaceContext();
    }

    public String getNamingSpaceURL() {
        return this.getNameSpaceContext().getPrefixMapping();
    }

    public String getTextStyle() {
        return "a:t";
    }

    public boolean isPara(String label) {
        return "a:p".equals(label) || "gendoc:ref".equals(label);
    }

    public String[] getTextTagLabels() {
        return new String[0];
    }

    public IAdditionalResourceService getAdditionalResourceService() {
        return this.additionalResourceService;
    }

    protected Node cleanTags(Node currentNode, List<String> tagLabels, Node baseNode) throws InvalidContentException {
        String[] separated;
        if (baseNode == null) {
            return null;
        }
        StringBuffer newNodeContent = new StringBuffer(this.extractNodeTextValue(baseNode));
        while (baseNode != null && !this.containsOneOf(tagLabels, newNodeContent.toString())) {
            if ((baseNode = this.findNodeWithStartTag(baseNode, currentNode)) == null) continue;
            newNodeContent = new StringBuffer(this.extractNodeTextValue(baseNode));
        }
        if (baseNode == null) {
            return null;
        }
        boolean isCompleteTag = this.containsFullTags(newNodeContent.toString(), tagLabels);
        if (!isCompleteTag) {
            NodeList followingNodes = this.getNextNodes(baseNode, baseNode.getNodeName());
            ArrayList<Node> nodesToRemove = new ArrayList<Node>();
            if (followingNodes != null) {
                int i = 0;
                while (i < followingNodes.getLength()) {
                    String textValue = this.extractNodeTextValue(followingNodes.item(i));
                    newNodeContent.append(textValue);
                    Node nodeToRemove = this.getBestAscendantUntil(currentNode, followingNodes.item(i));
                    if (!nodesToRemove.contains(nodeToRemove)) {
                        nodesToRemove.add(nodeToRemove);
                    }
                    if (this.containsFullTags(newNodeContent.toString(), tagLabels)) {
                        isCompleteTag = true;
                        break;
                    }
                    ++i;
                }
                for (Node nodeToRemove : nodesToRemove) {
                    if (nodeToRemove == null || !currentNode.equals(nodeToRemove.getParentNode())) continue;
                    currentNode.removeChild(nodeToRemove);
                }
            }
        }
        if ((separated = this.asText(baseNode).split(String.valueOf(XML_TAG_START) + "|" + XML_TAG_END)) != null && separated.length > 1) {
            newNodeContent.insert(0, String.valueOf(XML_TAG_START) + separated[1] + XML_TAG_END);
            newNodeContent.append(String.valueOf(XML_TAG_START) + separated[separated.length - 1] + XML_TAG_END);
        } else {
            newNodeContent.append(this.asText(baseNode));
        }
        String nodeContent = this.cleanXMLContent(newNodeContent.toString());
        Node result = this.injectNode(baseNode, nodeContent);
        baseNode.getParentNode().removeChild(baseNode);
        return result;
    }

    protected boolean areSimilarTags(String tagName1, String tagName2) {
        return false;
    }

    protected String containsSimilarTag(Stack<String> tagStack, String tagName) {
        return null;
    }

    public String getRowLabel() {
        return null;
    }

    public String getCellLabel() {
        return null;
    }

    public ITableService getTableService() {
        return null;
    }
}

