/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.testing;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.name.Named;
import java.io.InputStream;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.xtext.common.types.access.jdt.IJavaProjectProvider;
import org.eclipse.xtext.common.types.access.jdt.JdtTypeProviderFactory;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.ui.testing.ContentAssistProcessorTestBuilder;
import org.eclipse.xtext.ui.testing.util.IResourcesSetupUtil;
import org.eclipse.xtext.ui.testing.util.ResourceLoadHelper;
import org.eclipse.xtext.util.StringInputStream;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.XExpression;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public abstract class AbstractXbaseContentAssistTest
extends Assert
implements ResourceLoadHelper,
IJavaProjectProvider {
    @Inject
    protected IWorkspace workspace;
    protected String fileExtension;
    private boolean demandFeatureComputation = false;
    protected static String[] KEYWORDS_AND_STATICS = new String[]{"if", "while", "for", "do", "true", "false", "typeof", "try", "switch", "new", "throw", "return", "null", "emptyList", "emptySet", "emptyMap", "newArrayOfSize()", "newBooleanArrayOfSize()", "newByteArrayOfSize()", "newShortArrayOfSize()", "newCharArrayOfSize()", "newIntArrayOfSize()", "newLongArrayOfSize()", "newFloatArrayOfSize()", "newDoubleArrayOfSize()", "newImmutableList()", "newImmutableSet()", "newImmutableMap()", "newArrayList()", "newLinkedList()", "newHashSet()", "newLinkedHashSet()", "newTreeSet()", "newHashMap()", "newLinkedHashMap()", "newTreeMap()", "print()", "println", "println()", "synchronized"};
    protected static String[] STRING_OPERATORS = new String[]{"===", "!==", "==", "!=", "+", "<=", "<=>", ">=", "<", ">", "->", "=>", "?:"};
    protected static String[] CAST_INSTANCEOF = new String[]{"as", "instanceof"};
    protected static String[] STRING_FEATURES;
    protected static String[] STATIC_STRING_FEATURES;
    protected static String[] BIGDECIMAL_FEATURES;
    protected static String[] STATIC_BIGDECIMAL_FEATURES;
    protected static String[] CLASS_FEATURES;
    protected static String[] STATIC_CLASS_FEATURES;

    @Before
    public void setUp() throws Exception {
        this.getInjector().injectMembers((Object)this);
        this.initFeatures();
    }

    @After
    public void tearDown() throws Exception {
        if (this.doCleanWorkspace()) {
            IResourcesSetupUtil.cleanWorkspace();
        }
        if (this.demandFeatureComputation) {
            STATIC_CLASS_FEATURES = null;
            STATIC_STRING_FEATURES = null;
            STATIC_BIGDECIMAL_FEATURES = null;
            CLASS_FEATURES = null;
            STRING_FEATURES = null;
            BIGDECIMAL_FEATURES = null;
            this.demandFeatureComputation = false;
        }
    }

    protected boolean doCleanWorkspace() {
        return true;
    }

    protected abstract Injector getInjector();

    public abstract IJavaProject getJavaProject(ResourceSet var1);

    public <T> T get(Class<T> clazz) {
        return (T)this.getInjector().getInstance(clazz);
    }

    protected XExpression expression(String string) throws Exception {
        XtextResource resource = this.getResourceFor((InputStream)new StringInputStream(string));
        AbstractXbaseContentAssistTest.assertEquals((String)resource.getErrors().toString(), (long)0L, (long)resource.getErrors().size());
        XExpression result = (XExpression)resource.getContents().get(0);
        return result;
    }

    protected final XtextResourceSet getResourceSet() {
        XtextResourceSet resourceSet = this.get(XtextResourceSet.class);
        JdtTypeProviderFactory typeProviderFactory = new JdtTypeProviderFactory((IJavaProjectProvider)this);
        typeProviderFactory.findOrCreateTypeProvider((ResourceSet)resourceSet);
        resourceSet.setClasspathURIContext((Object)this.getJavaProject((ResourceSet)resourceSet));
        return resourceSet;
    }

    public final XtextResource getResourceFor(InputStream stream) {
        try {
            XtextResource result = (XtextResource)this.getResourceSet().createResource(URI.createURI((String)("Test." + this.fileExtension)));
            result.load(stream, null);
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Inject
    protected void setExtensions(@Named(value="file.extensions") String extensions) {
        this.fileExtension = extensions.split(",")[0];
    }

    @Test
    public void testEmptyInput() throws Exception {
        this.newBuilder().assertText(this.getKeywordsAndStatics());
    }

    protected String[] getKeywordsAndStatics() {
        return KEYWORDS_AND_STATICS;
    }

    protected void initFeatures() {
        if (STRING_FEATURES != null) {
            return;
        }
        this.demandFeatureComputation = true;
        AbstractXbaseContentAssistTest.doInitFeatures(this.getJavaProject((ResourceSet)this.getResourceSet()));
    }

    protected static void doInitFeatures(IJavaProject javaProject) {
        try {
            AbstractXbaseContentAssistTest.doInitStringFeatures(javaProject);
            AbstractXbaseContentAssistTest.doInitClassFeatures(javaProject);
            AbstractXbaseContentAssistTest.doInitBigDecimalFeatures(javaProject);
        }
        catch (JavaModelException e) {
            throw new RuntimeException(e);
        }
    }

    protected static void doInitStringFeatures(IJavaProject javaProject) throws JavaModelException {
        IType stringType = javaProject.findType(String.class.getName());
        HashSet featuresOrTypes = Sets.newHashSet();
        ArrayList features = Lists.newArrayList();
        ArrayList staticFeatures = Lists.newArrayList();
        AbstractXbaseContentAssistTest.addMethods(stringType, features, staticFeatures, featuresOrTypes);
        features.remove("compareTo()");
        HashSet featuresAsSet = Sets.newHashSet((Iterable)features);
        HashSet staticFeaturesAsSet = Sets.newHashSet((Iterable)staticFeatures);
        HashSet types = Sets.newHashSet();
        AbstractXbaseContentAssistTest.addFields(stringType, features, staticFeatures, featuresAsSet, staticFeaturesAsSet, types);
        features.add("toFirstLower");
        features.add("toFirstUpper");
        features.add("nullOrEmpty");
        features.add("identityEquals()");
        STRING_FEATURES = features.toArray(new String[features.size()]);
        STATIC_STRING_FEATURES = staticFeatures.toArray(new String[staticFeatures.size()]);
    }

    protected static void doInitBigDecimalFeatures(IJavaProject javaProject) throws JavaModelException {
        IType bigDecimalType = javaProject.findType(BigDecimal.class.getName());
        HashSet featuresOrTypes = Sets.newHashSet();
        ArrayList features = Lists.newArrayList();
        ArrayList staticFeatures = Lists.newArrayList();
        AbstractXbaseContentAssistTest.addMethods(bigDecimalType, features, staticFeatures, featuresOrTypes);
        features.remove("compareTo()");
        HashSet featuresAsSet = Sets.newHashSet((Iterable)features);
        HashSet staticFeaturesAsSet = Sets.newHashSet((Iterable)staticFeatures);
        HashSet types = Sets.newHashSet();
        AbstractXbaseContentAssistTest.addFields(bigDecimalType, features, staticFeatures, featuresAsSet, staticFeaturesAsSet, types);
        features.add("identityEquals()");
        BIGDECIMAL_FEATURES = features.toArray(new String[features.size()]);
        STATIC_BIGDECIMAL_FEATURES = staticFeatures.toArray(new String[staticFeatures.size()]);
    }

    protected static void doInitClassFeatures(IJavaProject javaProject) throws JavaModelException {
        IType classType = javaProject.findType(Class.class.getName());
        HashSet featuresOrTypes = Sets.newHashSet();
        ArrayList features = Lists.newArrayList();
        ArrayList staticFeatures = Lists.newArrayList();
        AbstractXbaseContentAssistTest.addMethods(classType, features, staticFeatures, featuresOrTypes);
        HashSet featuresAsSet = Sets.newHashSet((Iterable)features);
        HashSet staticFeaturesAsSet = Sets.newHashSet((Iterable)staticFeatures);
        HashSet types = Sets.newHashSet();
        AbstractXbaseContentAssistTest.addFields(classType, features, staticFeatures, featuresAsSet, staticFeaturesAsSet, types);
        features.add("identityEquals()");
        CLASS_FEATURES = features.toArray(new String[features.size()]);
        STATIC_CLASS_FEATURES = staticFeatures.toArray(new String[staticFeatures.size()]);
    }

    protected static void addFields(IType type, List<String> features, List<String> staticFeatures, Set<String> featuresAsSet, Set<String> staticFeaturesAsSet, Set<String> types) throws JavaModelException {
        if (types.add(type.getFullyQualifiedName())) {
            String[] interfaceNames;
            IField[] iFieldArray = type.getFields();
            int n = iFieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                IField field = iFieldArray[n2];
                Set<String> asSet = featuresAsSet;
                List<String> list = features;
                if (Modifier.isStatic(field.getFlags())) {
                    list = staticFeatures;
                    asSet = staticFeaturesAsSet;
                }
                if (Flags.isPublic((int)field.getFlags()) && asSet.add(field.getElementName())) {
                    list.add(field.getElementName());
                }
                ++n2;
            }
            String superclassName = type.getSuperclassName();
            if (superclassName != null) {
                int idx = superclassName.indexOf(60);
                if (idx != -1) {
                    superclassName = superclassName.substring(0, idx);
                }
                IType superType = type.getJavaProject().findType(superclassName);
                AbstractXbaseContentAssistTest.addFields(superType, features, staticFeatures, featuresAsSet, staticFeaturesAsSet, types);
            }
            String[] stringArray = interfaceNames = type.getSuperInterfaceNames();
            int n3 = interfaceNames.length;
            int n4 = 0;
            while (n4 < n3) {
                String interfaceName = stringArray[n4];
                int idx = interfaceName.indexOf(60);
                if (idx != -1) {
                    interfaceName = interfaceName.substring(0, idx);
                }
                IType superInterface = type.getJavaProject().findType(interfaceName);
                AbstractXbaseContentAssistTest.addFields(superInterface, features, staticFeatures, featuresAsSet, staticFeaturesAsSet, types);
                ++n4;
            }
        }
    }

    protected static void addMethods(IType type, List<String> features, List<String> staticFeatures, Set<String> featuresOrTypes) throws JavaModelException {
        if (featuresOrTypes.add(type.getFullyQualifiedName())) {
            String[] interfaceNames;
            IMethod[] iMethodArray = type.getMethods();
            int n = iMethodArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMethod method = iMethodArray[n2];
                List<String> list = features;
                if (Flags.isStatic((int)method.getFlags())) {
                    list = staticFeatures;
                }
                String methodName = method.getElementName();
                if (!(!Flags.isPublic((int)method.getFlags()) || method.isConstructor() || "<clinit>".equals(methodName) || "<init>".equals(methodName) || Flags.isSynthetic((int)method.getFlags()))) {
                    String propertyName;
                    if (method.getParameterTypes().length == 0) {
                        if (methodName.startsWith("get") && methodName.length() > 3) {
                            propertyName = Strings.toFirstLower((String)methodName.substring(3));
                            if (featuresOrTypes.add(String.valueOf(propertyName) + method.getSignature())) {
                                list.add(propertyName);
                            }
                        } else if (methodName.startsWith("is") && methodName.length() > 2) {
                            propertyName = Strings.toFirstLower((String)methodName.substring(2));
                            if (featuresOrTypes.add(String.valueOf(propertyName) + method.getSignature())) {
                                list.add(propertyName);
                            }
                        } else if (featuresOrTypes.add(String.valueOf(methodName) + method.getSignature())) {
                            list.add(methodName);
                        }
                    } else if (method.getParameterTypes().length == 1) {
                        if (methodName.startsWith("set") && methodName.length() > 3) {
                            propertyName = String.valueOf(Strings.toFirstLower((String)methodName.substring(3))) + " = value";
                            if (featuresOrTypes.add(String.valueOf(propertyName) + method.getSignature())) {
                                list.add(propertyName);
                            }
                        } else if (featuresOrTypes.add(String.valueOf(methodName = String.valueOf(methodName) + "()") + method.getSignature())) {
                            list.add(methodName);
                        }
                    } else if (featuresOrTypes.add(String.valueOf(methodName = String.valueOf(methodName) + "()") + method.getSignature())) {
                        list.add(methodName);
                    }
                }
                ++n2;
            }
            String superclassName = type.getSuperclassName();
            if (superclassName != null) {
                int idx = superclassName.indexOf(60);
                if (idx != -1) {
                    superclassName = superclassName.substring(0, idx);
                }
                IType superType = type.getJavaProject().findType(superclassName);
                AbstractXbaseContentAssistTest.addMethods(superType, features, staticFeatures, featuresOrTypes);
            }
            String[] stringArray = interfaceNames = type.getSuperInterfaceNames();
            int n3 = interfaceNames.length;
            int n4 = 0;
            while (n4 < n3) {
                String interfaceName = stringArray[n4];
                int idx = interfaceName.indexOf(60);
                if (idx != -1) {
                    interfaceName = interfaceName.substring(0, idx);
                }
                IType superInterface = type.getJavaProject().findType(interfaceName);
                AbstractXbaseContentAssistTest.addMethods(superInterface, features, staticFeatures, featuresOrTypes);
                ++n4;
            }
        }
    }

    public String[] getStringFeatures() {
        return STRING_FEATURES;
    }

    public String[] getStaticStringFeatures() {
        return STATIC_STRING_FEATURES;
    }

    public String[] getBigDecimalFeatures() {
        return BIGDECIMAL_FEATURES;
    }

    public String[] getStaticBigDecimalFeatures() {
        return STATIC_BIGDECIMAL_FEATURES;
    }

    public String[] getClassFeatures() {
        return CLASS_FEATURES;
    }

    public String[] getStaticClassFeatures() {
        return STATIC_CLASS_FEATURES;
    }

    protected String[] expect(String[] ... arrays) {
        ArrayList expectation = Lists.newArrayList();
        String[][] stringArray = arrays;
        int n = arrays.length;
        int n2 = 0;
        while (n2 < n) {
            String[] array = stringArray[n2];
            expectation.addAll(Arrays.asList(array));
            ++n2;
        }
        return expectation.toArray(new String[expectation.size()]);
    }

    @Test
    public void testOnStringLiteral_01() throws Exception {
        this.newBuilder().append("''").assertText(this.expect(STRING_OPERATORS, CAST_INSTANCEOF));
    }

    @Test
    public void testOnStringLiteral_02() throws Exception {
        this.newBuilder().append("''.").assertText(this.getStringFeatures());
    }

    @Test
    public void testOnStringLiteral_03() throws Exception {
        this.newBuilder().append("''.").assertTextAtCursorPosition(".", this.expect(STRING_OPERATORS, CAST_INSTANCEOF));
    }

    @Test
    public void testOnStringLiteral_04() throws Exception {
        this.newBuilder().append("''+''").assertTextAtCursorPosition("+", this.expect(STRING_OPERATORS, CAST_INSTANCEOF));
    }

    @Test
    public void testOnStringLiteral_05() throws Exception {
        this.newBuilder().append("''+''").assertTextAtCursorPosition("+''", 1, this.expect({"+"}, this.getKeywordsAndStatics()));
    }

    @Test
    public void testOnStringLiteral_06() throws Exception {
        this.newBuilder().append("''==''").assertTextAtCursorPosition("==", 1, new String[]{"==", "=>", "==="});
    }

    @Test
    public void testOnStringLiteral_07() throws Exception {
        this.newBuilder().append("''==''").assertTextAtCursorPosition("==", 2, this.expect({"==", "==="}, this.getKeywordsAndStatics()));
    }

    @Test
    public void testOnStringLiteral_08() throws Exception {
        this.newBuilder().append("''<=''").assertTextAtCursorPosition("<=", 1, this.expect({"<", "<=", "<=>"}, this.getKeywordsAndStatics()));
    }

    @Test
    public void testOnStringLiteral_09() throws Exception {
        this.newBuilder().append("''<=''").assertTextAtCursorPosition("<=", 2, this.expect({"<=", "<=>"}, this.getKeywordsAndStatics()));
    }

    @Test
    public void testOnStringLiteral_10() throws Exception {
        this.newBuilder().append("'' ").assertText(this.expect(STRING_OPERATORS, CAST_INSTANCEOF));
    }

    @Test
    public void testOnStringLiteral_11() throws Exception {
        this.newBuilder().append("''. ").assertText(this.getStringFeatures());
    }

    @Test
    public void testOnStringLiteral_12() throws Exception {
        this.newBuilder().append("'' .").assertTextAtCursorPosition(".", this.expect(STRING_OPERATORS, CAST_INSTANCEOF));
    }

    @Test
    public void testOnStringLiteral_13() throws Exception {
        this.newBuilder().append("'' + ''").assertTextAtCursorPosition("+", this.expect(STRING_OPERATORS, CAST_INSTANCEOF));
    }

    @Test
    public void testOnStringLiteral_14() throws Exception {
        this.newBuilder().append("'' + ''").assertTextAtCursorPosition("+ ''", 2, this.getKeywordsAndStatics());
        this.newBuilder().append("'' + ''").assertTextAtCursorPosition("+ ''", 1, this.expect({"+"}, this.getKeywordsAndStatics()));
    }

    @Test
    public void testOnStringLiteral_15() throws Exception {
        this.newBuilder().append("'' == ''").assertTextAtCursorPosition("==", 1, new String[]{"==", "=>", "==="});
    }

    @Test
    public void testOnStringLiteral_16() throws Exception {
        this.newBuilder().append("'' == ''").assertTextAtCursorPosition("==", 2, this.expect({"==", "==="}, this.getKeywordsAndStatics()));
        this.newBuilder().append("'' == ''").assertTextAtCursorPosition("==", 3, this.getKeywordsAndStatics());
    }

    @Test
    public void testOnStringLiteral_17() throws Exception {
        this.newBuilder().append("'' <= ''").assertTextAtCursorPosition("<=", 1, this.expect({"<", "<=", "<=>"}, this.getKeywordsAndStatics()));
    }

    @Test
    public void testOnStringLiteral_18() throws Exception {
        this.newBuilder().append("'' <= ''").assertTextAtCursorPosition("<=", 2, this.expect({"<=", "<=>"}, this.getKeywordsAndStatics()));
        this.newBuilder().append("'' <= ''").assertTextAtCursorPosition("<=", 3, this.getKeywordsAndStatics());
    }

    @Test
    public void testOnStringLiteral_19() throws Exception {
        this.newBuilder().append("''.toString").assertText(this.expect(STRING_OPERATORS, {"toString"}));
    }

    @Test
    public void testOnStringLiteral_20() throws Exception {
        this.newBuilder().append("''.toString.").assertText(this.getStringFeatures());
    }

    @Test
    public void testOnStringLiteral_21() throws Exception {
        this.newBuilder().append("''.toString.").assertTextAtCursorPosition("g.", 1, this.expect(STRING_OPERATORS, {"toString"}));
    }

    @Test
    public void testOnStringLiteral_22() throws Exception {
        this.newBuilder().append("''.toString+''").assertTextAtCursorPosition("+", this.expect(STRING_OPERATORS, {"toString"}));
    }

    @Test
    public void testOnStringLiteral_23() throws Exception {
        this.newBuilder().append("''.toString+''").assertTextAtCursorPosition("+''", 1, this.expect({"+"}, this.getKeywordsAndStatics()));
    }

    @Test
    public void testOnStringLiteral_24() throws Exception {
        this.newBuilder().append("''.toString==''").assertTextAtCursorPosition("==", 1, this.expect({"===", "==", "=>"}, this.getKeywordsAndStatics()));
    }

    @Test
    public void testOnStringLiteral_25() throws Exception {
        this.newBuilder().append("''.toString==''").assertTextAtCursorPosition("==", 2, this.expect({"==", "==="}, this.getKeywordsAndStatics()));
    }

    @Test
    public void testOnStringLiteral_26() throws Exception {
        this.newBuilder().append("''.toString<=''").assertTextAtCursorPosition("<=", 1, this.expect({"<", "<=", "<=>"}, this.getKeywordsAndStatics()));
    }

    @Test
    public void testOnStringLiteral_27() throws Exception {
        this.newBuilder().append("''.toString<=''").assertTextAtCursorPosition("<=", 2, this.expect({"<=", "<=>"}, this.getKeywordsAndStatics()));
    }

    @Test
    public void testOnStringLiteral_28() throws Exception {
        this.newBuilder().append("''.toString.toString").assertTextAtCursorPosition(".", this.expect(STRING_OPERATORS, CAST_INSTANCEOF));
    }

    @Test
    public void testOnStringLiteral_29() throws Exception {
        this.newBuilder().append("''.toString.toString.toString").assertTextAtCursorPosition("g.", 1, this.expect(STRING_OPERATORS, {"toString"}));
    }

    @Test
    public void testOnStringLiteral_30() throws Exception {
        this.newBuilder().append("('')").assertText(this.expect(STRING_OPERATORS, CAST_INSTANCEOF));
    }

    @Test
    public void testOnStringLiteral_31() throws Exception {
        this.newBuilder().append("('').").assertText(this.getStringFeatures());
    }

    @Test
    public void testOnStringLiteral_32() throws Exception {
        this.newBuilder().append("(''.toString)").assertText(this.expect(STRING_OPERATORS, CAST_INSTANCEOF));
    }

    @Test
    public void testOnStringLiteral_33() throws Exception {
        this.newBuilder().append("(''.toString )").assertTextAtCursorPosition(")", this.expect(STRING_OPERATORS, CAST_INSTANCEOF));
    }

    @Test
    public void testOnStringLiteral_34() throws Exception {
        this.newBuilder().append("''.toString ").assertText(this.expect(STRING_OPERATORS, CAST_INSTANCEOF));
    }

    @Test
    public void testOnStringLiteral_35() throws Exception {
        this.newBuilder().append("''.toString .").assertTextAtCursorPosition("g .", 2, this.expect(STRING_OPERATORS, CAST_INSTANCEOF));
    }

    @Test
    public void testOnStringLiteral_36() throws Exception {
        this.newBuilder().append("''.toString +''").assertTextAtCursorPosition("+", this.expect(STRING_OPERATORS, CAST_INSTANCEOF));
    }

    @Test
    public void testOnStringLiteral_37() throws Exception {
        this.newBuilder().append("''.toString ==''").assertTextAtCursorPosition("==", 1, this.expect({"==", "===", "=>"}, this.getKeywordsAndStatics()));
    }

    @Test
    public void testOnStringLiteral_38() throws Exception {
        this.newBuilder().append("''.toString.toString").assertTextAtCursorPosition("g.", 1, this.expect(STRING_OPERATORS, {"toString"}));
    }

    @Test
    public void testOnStringLiteral_39() throws Exception {
        this.newBuilder().append("''.invalid = ''").assertTextAtCursorPosition(".", 1, this.getStringFeatures());
    }

    @Test
    public void testOnStringLiteral_40() throws Exception {
        this.newBuilder().append("''.length = 'invalid'").assertTextAtCursorPosition("le", 2, new String[]{"length"});
    }

    @Test
    public void testOnVoidMethod_01() throws Exception {
        this.newBuilder().append("(null as java.util.List).clear ").assertText(new String[0]);
    }

    @Test
    public void testAfterBinaryOperation_01() throws Exception {
        this.newBuilder().append("''+''").assertText(this.expect(STRING_OPERATORS, CAST_INSTANCEOF));
    }

    @Test
    public void testAfterBinaryOperation_02() throws Exception {
        this.newBuilder().append("'' + ''+''").assertTextAtCursorPosition("''+", 2, this.expect(STRING_OPERATORS, CAST_INSTANCEOF));
    }

    @Test
    public void testAfterBinaryOperation_03() throws Exception {
        this.newBuilder().append("(''+'')").assertText(this.expect(STRING_OPERATORS, CAST_INSTANCEOF));
    }

    @Test
    public void testAfterBinaryOperation_04() throws Exception {
        this.newBuilder().append("(''+'').").assertText(this.getStringFeatures());
    }

    @Test
    public void testAfterBinaryOperation_05() throws Exception {
        this.newBuilder().append("((''+''))").assertText(this.expect(STRING_OPERATORS, CAST_INSTANCEOF));
    }

    @Test
    public void testAfterBinaryOperation_06() throws Exception {
        this.newBuilder().append("((''+''))").assertTextAtCursorPosition("))", 1, this.expect(STRING_OPERATORS, CAST_INSTANCEOF));
    }

    @Test
    public void testAfterBinaryOperation_07() throws Exception {
        this.newBuilder().append("((''+''))").assertTextAtCursorPosition("))", this.expect(STRING_OPERATORS, CAST_INSTANCEOF));
    }

    @Test
    public void testAfterBinaryOperation_08() throws Exception {
        this.newBuilder().append("((''+(''.bytes)))").assertTextAtCursorPosition(")", new String[]{"==", "===", "!=", "!==", "+=", "-=", "+", "->", "=>", "?:", "bytes"});
    }

    @Test
    public void testAfterBinaryOperation_09() throws Exception {
        this.newBuilder().append("((''+''.bytes))").assertTextAtCursorPosition(")", new String[]{"==", "===", "!=", "!==", "+=", "-=", "+", "->", "=>", "?:", "bytes"});
    }

    @Test
    public void testAfterBinaryOperation_10() throws Exception {
        this.newBuilder().append("((''+null))").assertTextAtCursorPosition(")", new String[]{"null", "!=", "!==", "==", "===", "->", "=>", "+", "?:", "<", "<=", "<=>", ">=", ">"});
    }

    @Ignore(value="TODO binary operator precedence is not implemented in CA yet")
    @Test
    public void testAfterBinaryOperation_11() throws Exception {
        this.newBuilder().append("''+1").assertText(this.expect(STRING_OPERATORS, CAST_INSTANCEOF));
    }

    @Test
    public void testStaticFeatures_01() throws Exception {
        this.newBuilder().append("String::").assertText(this.getStaticStringFeatures());
    }

    @Test
    public void testStaticFeatures_02() throws Exception {
        this.newBuilder().append("String.").assertText(this.expect(this.getStaticStringFeatures(), this.getClassFeatures()));
    }

    @Test
    public void testNestedTypes_01() throws Exception {
        this.newBuilder().append("java.util.Map.").assertText(this.expect({"Entry"}, this.getClassFeatures()));
    }

    @Test
    public void testNull() throws Exception {
        this.newBuilder().append("null").assertText(new String[]{"null", "!=", "!==", "+", "==", "===", "->", "?:", "=>", "%", "*", "**", "-", "+=", "-=", "/", "<", "<=", "<=>", ">=", ">", "++", "--"});
    }

    @Test
    public void testForLoop_01() throws Exception {
        this.newBuilder().append("for (String s: null) ").assertText(this.expect({"s"}, this.getKeywordsAndStatics()));
    }

    @Test
    public void testForLoop_02() throws Exception {
        this.newBuilder().append("for (String string: null) string").assertTextAtCursorPosition(") string", 6, new String[]{"string"});
    }

    @Test
    public void testForLoop_03() throws Exception {
        this.newBuilder().append("for (String string: null) ''+").assertText(this.expect({"string", "+"}, this.getKeywordsAndStatics()));
    }

    @Test
    public void testForLoop_04() throws Exception {
        this.newBuilder().append("for (String string: ").assertText(this.getKeywordsAndStatics());
    }

    @Test
    public void testForLoop_05() throws Exception {
        this.newBuilder().append("for (String string: )").assertTextAtCursorPosition(")", this.getKeywordsAndStatics());
    }

    @Test
    public void testClosure_01() throws Exception {
        this.newBuilder().append("[String a, String b|").assertText(this.expect({"a", "b"}, this.getKeywordsAndStatics(), {"val", "var"}));
    }

    @Test
    public void testClosure_02() throws Exception {
        this.newBuilder().append("#['a', 'b'].filter[it==it]").assertTextAtCursorPosition("it==", this.expect({"it", "var", "val", "self"}, this.getKeywordsAndStatics(), this.getStringFeatures()));
    }

    @Test
    public void testClosure_03() throws Exception {
        this.newBuilder().append("{val slow = #['a', 'b'].filter[it==it] }").assertTextAtCursorPosition("it==", this.expect({"it", "var", "val", "self"}, this.getKeywordsAndStatics(), this.getStringFeatures()));
    }

    @Test
    public void testClosure_04() throws Exception {
        this.newBuilder().append("{val slow = #[0bd, 1bd].filter[i > 0]}").assertTextAtCursorPosition("i ", this.expect({"it", "var", "val", "self"}, this.getKeywordsAndStatics(), this.getBigDecimalFeatures()));
    }

    @Test
    public void testCatchParameter_01() throws Exception {
        this.newBuilder().append("try {} catch(NullPointerException e) e").assertTextAtCursorPosition(") e", 2, this.expect({"e"}, this.getKeywordsAndStatics()));
    }

    @Test
    public void testCatchParameter_02() throws Exception {
        this.newBuilder().append("try {} catch(NullPointerException e) ").assertText(this.expect({"e"}, this.getKeywordsAndStatics()));
    }

    @Test
    public void testCamelCase_01() throws Exception {
        this.newBuilder().append("newLLis").assertText(new String[]{"newLinkedList()"});
    }

    @Test
    public void testCamelCase_02() throws Exception {
        this.newBuilder().append("new ArrBloQu").assertText(new String[]{"java.util.concurrent.ArrayBlockingQueue"});
    }

    @Test
    public void testCamelCase_03() throws Exception {
        this.newBuilder().append("new ArrBloQu").assertText(new String[]{"java.util.concurrent.ArrayBlockingQueue"});
    }

    @Test
    public void testSwitchOnEnum_01() throws Exception {
        this.newBuilder().append("switch java.lang.annotation.RetentionPolicy.SOURCE { case ").assertText(this.expect({"SOURCE", "CLASS", "RUNTIME"}, this.getKeywordsAndStatics()));
    }

    @Test
    public void testSwitchOnEnum_02() throws Exception {
        this.newBuilder().append("switch java.lang.annotation.RetentionPolicy.SOURCE { case SOUR").assertProposal("SOURCE");
    }

    @Test
    public void testSwitchOnEnum_03() throws Exception {
        this.newBuilder().append("switch java.lang.annotation.RetentionPolicy.SOURCE { case SOURCE: ").assertText(this.getKeywordsAndStatics());
    }

    protected final ContentAssistProcessorTestBuilder newBuilder() throws Exception {
        String suffix;
        ContentAssistProcessorTestBuilder builder = new ContentAssistProcessorTestBuilder(this.getInjector(), this){

            public ContentAssistProcessorTestBuilder assertTextAtCursorPosition(String cursorPosition, String ... expectedText) throws Exception {
                return this.assertTextAtCursorPosition(this.getModel().indexOf(cursorPosition, AbstractXbaseContentAssistTest.this.getPrefix().length()), expectedText);
            }

            public ContentAssistProcessorTestBuilder assertTextAtCursorPosition(String cursorPosition, int offset, String ... expectedText) throws Exception {
                return this.assertTextAtCursorPosition(this.getModel().indexOf(cursorPosition, AbstractXbaseContentAssistTest.this.getPrefix().length()) + offset, expectedText);
            }
        };
        String prefix = this.getPrefix();
        if (prefix.length() > 0) {
            builder = builder.appendNl(prefix);
        }
        if ((suffix = this.getSuffix()).length() > 0) {
            builder = builder.appendSuffix(suffix);
        }
        return builder;
    }

    protected String getPrefix() {
        return "";
    }

    protected String getSuffix() {
        return "";
    }
}

