/**
 * Copyright (c) 2016, 2017 Inria and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Inria - initial API and implementation
 */
package org.eclipse.gemoc.xdsmlframework.commons;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@SuppressWarnings("all")
public class DynamicAnnotationHelper {
  public final static String DYNAMIC_ANNOTATION_URI = "aspect";
  
  private static boolean isDynamic(final EModelElement o) {
    EList<EAnnotation> _eAnnotations = o.getEAnnotations();
    final Function1<EAnnotation, Boolean> _function = new Function1<EAnnotation, Boolean>() {
      @Override
      public Boolean apply(final EAnnotation a) {
        String _source = a.getSource();
        return Boolean.valueOf(_source.equals(DynamicAnnotationHelper.DYNAMIC_ANNOTATION_URI));
      }
    };
    return IterableExtensions.<EAnnotation>exists(_eAnnotations, _function);
  }
  
  public static boolean isDynamic(final EClass c) {
    return DynamicAnnotationHelper.isDynamic(((EModelElement) c));
  }
  
  public static boolean isDynamic(final EStructuralFeature p) {
    return (DynamicAnnotationHelper.isDynamic(((EModelElement) p)) || DynamicAnnotationHelper.isDynamic(p.getEContainingClass()));
  }
  
  public static EAnnotation createDynamicAnnotation() {
    final EAnnotation dynamicAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
    dynamicAnnotation.setSource(DynamicAnnotationHelper.DYNAMIC_ANNOTATION_URI);
    return dynamicAnnotation;
  }
}
