/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.diverse.k3.al.annotationprocessor;

import com.google.common.base.Objects;
import fr.inria.diverse.k3.al.annotationprocessor.Abstract;
import fr.inria.diverse.k3.al.annotationprocessor.AspectMappingBuilder;
import fr.inria.diverse.k3.al.annotationprocessor.Helper;
import fr.inria.diverse.k3.al.annotationprocessor.OverrideAspectMethod;
import fr.inria.diverse.k3.al.annotationprocessor.SortMethod;
import fr.inria.diverse.k3.al.annotationprocessor.Step;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.xtend.lib.macro.AbstractClassProcessor;
import org.eclipse.xtend.lib.macro.CodeGenerationContext;
import org.eclipse.xtend.lib.macro.RegisterGlobalsContext;
import org.eclipse.xtend.lib.macro.TransformationContext;
import org.eclipse.xtend.lib.macro.declaration.AnnotationReference;
import org.eclipse.xtend.lib.macro.declaration.AnnotationTypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.ClassDeclaration;
import org.eclipse.xtend.lib.macro.declaration.CompilationStrategy;
import org.eclipse.xtend.lib.macro.declaration.CompilationUnit;
import org.eclipse.xtend.lib.macro.declaration.Element;
import org.eclipse.xtend.lib.macro.declaration.FieldDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MethodDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableClassDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableConstructorDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableElement;
import org.eclipse.xtend.lib.macro.declaration.MutableFieldDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableMethodDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableParameterDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableTypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.ParameterDeclaration;
import org.eclipse.xtend.lib.macro.declaration.Type;
import org.eclipse.xtend.lib.macro.declaration.TypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.TypeReference;
import org.eclipse.xtend.lib.macro.declaration.Visibility;
import org.eclipse.xtend.lib.macro.expression.Expression;
import org.eclipse.xtend.lib.macro.file.Path;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class AspectProcessor
extends AbstractClassProcessor {
    private Map<MutableClassDeclaration, List<MutableClassDeclaration>> listResMap = CollectionLiterals.newHashMap((Pair[])new Pair[0]);
    private final AspectMappingBuilder aspectMappingBuilder = new AspectMappingBuilder();
    public static final String CTX_NAME = "AspectContext";
    public static final String PROP_NAME = "AspectProperties";
    public static final String OVERRIDE_METHOD = OverrideAspectMethod.class.getSimpleName();
    public static final String STEP = Step.class.getSimpleName();
    public static final String PROP_VAR_NAME = "_self_";
    public static final String SELF_VAR_NAME = "_self";
    public static final String PRIV_PREFIX = "_privk3_";
    public static final String PRIV_CONSTRUCTOR_POSTFIX = "_constructor_initializer";
    private List<? extends MutableClassDeclaration> mclasses = null;

    public void doRegisterGlobals(ClassDeclaration annotatedClass, RegisterGlobalsContext context) {
        TypeReference type = Helper.getAnnotationAspectType((TypeDeclaration)annotatedClass);
        if (type != null) {
            String className = type.getSimpleName();
            String _qualifiedName = annotatedClass.getQualifiedName();
            String _plus = String.valueOf(_qualifiedName) + className;
            String _plus_1 = String.valueOf(_plus) + PROP_NAME;
            context.registerClass(_plus_1);
            String _qualifiedName_1 = annotatedClass.getQualifiedName();
            String _plus_2 = String.valueOf(_qualifiedName_1) + className;
            String _plus_3 = String.valueOf(_plus_2) + CTX_NAME;
            context.registerClass(_plus_3);
        }
    }

    public void doTransform(List<? extends MutableClassDeclaration> classes, @Extension TransformationContext context) {
        HashMap superclass = CollectionLiterals.newHashMap((Pair[])new Pair[0]);
        HashMap dispatchmethod = CollectionLiterals.newHashMap((Pair[])new Pair[0]);
        this.mclasses = classes;
        this.initSuperclass(classes, context, superclass);
        this.initDispatchmethod(superclass, dispatchmethod, context);
        for (MutableClassDeclaration mutableClassDeclaration : classes) {
            List<MutableClassDeclaration> listRes = Helper.sortByClassInheritance(mutableClassDeclaration, classes, context);
            Functions.Function1<MutableClassDeclaration, String> _function = new Functions.Function1<MutableClassDeclaration, String>(){

                public String apply(MutableClassDeclaration it) {
                    return it.getSimpleName();
                }
            };
            List inheritList = ListExtensions.map(listRes, (Functions.Function1)_function);
            this.listResMap.put(mutableClassDeclaration, listRes);
            TypeReference typeRef = Helper.getAnnotationAspectType((TypeDeclaration)mutableClassDeclaration);
            if (typeRef == null) {
                context.addError((Element)mutableClassDeclaration, "The aspectized class cannot be resolved.");
                continue;
            }
            String className = typeRef.getSimpleName();
            String identifier = typeRef.getName();
            HashMap bodies = CollectionLiterals.newHashMap((Pair[])new Pair[0]);
            this.fieldsProcessing(context, mutableClassDeclaration, className, identifier, bodies);
            this.methodsProcessing(mutableClassDeclaration, context, identifier, bodies, dispatchmethod, inheritList, className);
            this.constructorsProcessing(mutableClassDeclaration, context, identifier, bodies, dispatchmethod, inheritList, className);
            this.aspectContextMaker(context, mutableClassDeclaration, className, identifier);
        }
        this.aspectMappingBuilder.readCurrentMapping(classes, context);
        this.aspectMappingBuilder.cleanUnusedMapping(context);
        this.aspectMappingBuilder.addMappingForAnnotatedSourceElements();
    }

    public void doGenerateCode(List<? extends ClassDeclaration> annotatedSourceElements, @Extension CodeGenerationContext context) {
        this.aspectMappingBuilder.writePropertyFile(context);
        for (ClassDeclaration classDeclaration : annotatedSourceElements) {
            TypeReference typeRef = Helper.getAnnotationAspectType((TypeDeclaration)classDeclaration);
            final StringBuilder stAspectJ = new StringBuilder();
            boolean doGenerate = false;
            String _name = typeRef.getName();
            String _name_1 = typeRef.getName();
            int _lastIndexOf = _name_1.lastIndexOf(".");
            CharSequence _subSequence = _name.subSequence(0, _lastIndexOf);
            String _plus = "package " + _subSequence;
            String _plus_1 = String.valueOf(_plus) + ";\n";
            stAspectJ.append(_plus_1);
            String _simpleName = typeRef.getSimpleName();
            String _plus_2 = "public aspect AspectJ" + _simpleName;
            String _plus_3 = String.valueOf(_plus_2) + "{\n";
            stAspectJ.append(_plus_3);
            Iterable _declaredMethods = classDeclaration.getDeclaredMethods();
            for (final MethodDeclaration m : _declaredMethods) {
                boolean _not;
                Functions.Function1<AnnotationReference, Boolean> _function;
                Iterable _annotations = m.getAnnotations();
                boolean _exists = IterableExtensions.exists((Iterable)_annotations, (Functions.Function1)(_function = new Functions.Function1<AnnotationReference, Boolean>(){

                    public Boolean apply(AnnotationReference it) {
                        AnnotationTypeDeclaration _annotationTypeDeclaration = it.getAnnotationTypeDeclaration();
                        String _simpleName = _annotationTypeDeclaration.getSimpleName();
                        return Objects.equal((Object)_simpleName, (Object)"ReplaceAspectMethod");
                    }
                }));
                if (!_exists) continue;
                doGenerate = true;
                TypeReference _returnType = m.getReturnType();
                String _simpleName_1 = _returnType.getSimpleName();
                String _plus_4 = String.valueOf(_simpleName_1) + " around (";
                String _name_2 = typeRef.getName();
                String _plus_5 = String.valueOf(_plus_4) + _name_2;
                String _plus_6 = String.valueOf(_plus_5) + " self)  :target (self) && (call ( ";
                TypeReference _returnType_1 = m.getReturnType();
                String _name_3 = _returnType_1.getName();
                String _plus_7 = String.valueOf(_plus_6) + _name_3;
                String _plus_8 = String.valueOf(_plus_7) + " ";
                String _name_4 = typeRef.getName();
                String _plus_9 = String.valueOf(_plus_8) + _name_4;
                String _plus_10 = String.valueOf(_plus_9) + ".";
                String _simpleName_2 = m.getSimpleName();
                String _plus_11 = String.valueOf(_plus_10) + _simpleName_2;
                String _plus_12 = String.valueOf(_plus_11) + "( ";
                stAspectJ.append(_plus_12);
                Iterable _parameters = m.getParameters();
                Consumer<ParameterDeclaration> _function_1 = new Consumer<ParameterDeclaration>(){

                    @Override
                    public void accept(ParameterDeclaration p) {
                        boolean _not;
                        TypeReference _type = p.getType();
                        String _name = _type.getName();
                        stAspectJ.append(_name);
                        Iterable _parameters = m.getParameters();
                        ParameterDeclaration _last = (ParameterDeclaration)IterableExtensions.last((Iterable)_parameters);
                        boolean _equals = _last.equals(p);
                        boolean bl = _not = !_equals;
                        if (_not) {
                            stAspectJ.append(",");
                        }
                    }
                };
                _parameters.forEach(_function_1);
                stAspectJ.append(" ) ) ) { ");
                TypeReference _returnType_2 = m.getReturnType();
                String _name_5 = _returnType_2.getName();
                boolean _equals = "void".equals(_name_5);
                boolean bl = _not = !_equals;
                if (_not) {
                    stAspectJ.append("return ");
                }
                String _qualifiedName = classDeclaration.getQualifiedName();
                String _plus_13 = String.valueOf(_qualifiedName) + ".";
                String _simpleName_3 = m.getSimpleName();
                String _plus_14 = String.valueOf(_plus_13) + _simpleName_3;
                String _plus_15 = String.valueOf(_plus_14) + "(self";
                stAspectJ.append(_plus_15);
                int i = 0;
                while (i < IterableExtensions.size((Iterable)m.getParameters())) {
                    Iterable _parameters_1 = m.getParameters();
                    ParameterDeclaration _get = ((ParameterDeclaration[])Conversions.unwrapArray((Object)_parameters_1, ParameterDeclaration.class))[i];
                    TypeReference _type = _get.getType();
                    String _name_6 = _type.getName();
                    String _plus_16 = ",(" + _name_6;
                    String _plus_17 = String.valueOf(_plus_16) + ")thisJoinPoint.getArgs()[";
                    String _plus_18 = String.valueOf(_plus_17) + Integer.valueOf(i);
                    String _plus_19 = String.valueOf(_plus_18) + "]";
                    stAspectJ.append(_plus_19);
                    ++i;
                }
                stAspectJ.append(" );}\n");
            }
            Iterable _declaredFields = classDeclaration.getDeclaredFields();
            for (FieldDeclaration a : _declaredFields) {
                Functions.Function1<AnnotationReference, Boolean> _function_2;
                Iterable _annotations_1 = a.getAnnotations();
                boolean _exists_1 = IterableExtensions.exists((Iterable)_annotations_1, (Functions.Function1)(_function_2 = new Functions.Function1<AnnotationReference, Boolean>(){

                    public Boolean apply(AnnotationReference it) {
                        AnnotationTypeDeclaration _annotationTypeDeclaration = it.getAnnotationTypeDeclaration();
                        String _simpleName = _annotationTypeDeclaration.getSimpleName();
                        return Objects.equal((Object)_simpleName, (Object)"SynchroField");
                    }
                }));
                if (!_exists_1) continue;
                doGenerate = true;
                String _name_6 = typeRef.getName();
                String _plus_16 = "void around (" + _name_6;
                String _plus_17 = String.valueOf(_plus_16) + " self)  :target (self) &&  call ( void ";
                String _simpleName_4 = typeRef.getSimpleName();
                String _plus_18 = String.valueOf(_plus_17) + _simpleName_4;
                String _plus_19 = String.valueOf(_plus_18) + ".";
                stAspectJ.append(_plus_19);
                String _simpleName_5 = a.getSimpleName();
                String _firstUpper = StringExtensions.toFirstUpper((String)_simpleName_5);
                String _plus_20 = "set" + _firstUpper;
                String _plus_21 = String.valueOf(_plus_20) + "(";
                TypeReference _type = a.getType();
                String _name_7 = _type.getName();
                String _plus_22 = String.valueOf(_plus_21) + _name_7;
                String _plus_23 = String.valueOf(_plus_22) + ")){";
                stAspectJ.append(_plus_23);
                String _qualifiedName_1 = classDeclaration.getQualifiedName();
                String _plus_24 = String.valueOf(_qualifiedName_1) + ".";
                String _simpleName_6 = a.getSimpleName();
                String _plus_25 = String.valueOf(_plus_24) + _simpleName_6;
                String _plus_26 = String.valueOf(_plus_25) + "(self, (";
                TypeReference _type_1 = a.getType();
                String _name_8 = _type_1.getName();
                String _plus_27 = String.valueOf(_plus_26) + _name_8;
                String _plus_28 = String.valueOf(_plus_27) + ")thisJoinPoint.getArgs()[0]);";
                stAspectJ.append(_plus_28);
                stAspectJ.append("proceed(self);\n}\n");
                String _name_9 = typeRef.getName();
                String _plus_29 = "void around (" + _name_9;
                String _plus_30 = String.valueOf(_plus_29) + " self)  :target (self) &&  call ( void ";
                String _qualifiedName_2 = classDeclaration.getQualifiedName();
                String _plus_31 = String.valueOf(_plus_30) + _qualifiedName_2;
                String _plus_32 = String.valueOf(_plus_31) + ".";
                stAspectJ.append(_plus_32);
                String _simpleName_7 = a.getSimpleName();
                String _plus_33 = String.valueOf(_simpleName_7) + "(";
                String _name_10 = typeRef.getName();
                String _plus_34 = String.valueOf(_plus_33) + _name_10;
                String _plus_35 = String.valueOf(_plus_34) + ",";
                TypeReference _type_2 = a.getType();
                String _name_11 = _type_2.getName();
                String _plus_36 = String.valueOf(_plus_35) + _name_11;
                String _plus_37 = String.valueOf(_plus_36) + ")){";
                stAspectJ.append(_plus_37);
                String _simpleName_8 = a.getSimpleName();
                String _firstUpper_1 = StringExtensions.toFirstUpper((String)_simpleName_8);
                String _plus_38 = "self.set" + _firstUpper_1;
                String _plus_39 = String.valueOf(_plus_38) + "( (";
                TypeReference _type_3 = a.getType();
                String _name_12 = _type_3.getName();
                String _plus_40 = String.valueOf(_plus_39) + _name_12;
                String _plus_41 = String.valueOf(_plus_40) + ")thisJoinPoint.getArgs()[0]);";
                stAspectJ.append(_plus_41);
                stAspectJ.append("proceed(self);\n}\n");
            }
            stAspectJ.append("\n}\n");
            CompilationUnit _compilationUnit = classDeclaration.getCompilationUnit();
            Path filePath = _compilationUnit.getFilePath();
            Path _targetFolder = context.getTargetFolder(filePath);
            String _name_13 = typeRef.getName();
            String _name_14 = typeRef.getName();
            int _lastIndexOf_1 = _name_14.lastIndexOf(".");
            CharSequence _subSequence_1 = _name_13.subSequence(0, _lastIndexOf_1);
            String _string = _subSequence_1.toString();
            String _replace = _string.replace(".", "/");
            Path targetFilePathFolder = _targetFolder.append(_replace);
            context.mkdir(targetFilePathFolder);
            Path _targetFolder_1 = context.getTargetFolder(filePath);
            String _name_15 = typeRef.getName();
            String _name_16 = typeRef.getName();
            int _lastIndexOf_2 = _name_16.lastIndexOf(".");
            CharSequence _subSequence_2 = _name_15.subSequence(0, _lastIndexOf_2);
            String _string_1 = _subSequence_2.toString();
            String _replace_1 = _string_1.replace(".", "/");
            String _plus_42 = String.valueOf(_replace_1) + "/AspectJ";
            String _simpleName_9 = typeRef.getSimpleName();
            String _plus_43 = String.valueOf(_plus_42) + _simpleName_9;
            String _plus_44 = String.valueOf(_plus_43) + ".aj";
            Path targetFilePath = _targetFolder_1.append(_plus_44);
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)"// AspectJ classes that have been aspectized and name");
            _builder.newLine();
            String _string_2 = stAspectJ.toString();
            _builder.append((Object)_string_2, "");
            String contents = _builder.toString();
            if (!doGenerate) continue;
            context.setContents(targetFilePath, (CharSequence)contents);
        }
    }

    private void methodProcessingAddSelfStatic(MutableMethodDeclaration m, String identifier, @Extension TransformationContext cxt) {
        if (IterableExtensions.isEmpty((Iterable)m.getParameters()) || !Objects.equal((Object)((MutableParameterDeclaration)IterableExtensions.head((Iterable)m.getParameters())).getSimpleName(), (Object)SELF_VAR_NAME)) {
            ArrayList<Pair> l = new ArrayList<Pair>();
            Iterable _parameters = m.getParameters();
            for (MutableParameterDeclaration p1 : _parameters) {
                String _simpleName = p1.getSimpleName();
                TypeReference _type = p1.getType();
                Pair _pair = new Pair((Object)_simpleName, (Object)_type);
                l.add(_pair);
            }
            boolean _isAbstract = m.isAbstract();
            if (_isAbstract) {
                Type _findTypeGlobally = cxt.findTypeGlobally(Abstract.class);
                AnnotationReference _newAnnotationReference = cxt.newAnnotationReference(_findTypeGlobally);
                m.addAnnotation(_newAnnotationReference);
            }
            Iterable _parameters_1 = m.getParameters();
            List _list = IterableExtensions.toList((Iterable)_parameters_1);
            _list.clear();
            TypeReference _newTypeReference = cxt.newTypeReference(identifier, new TypeReference[0]);
            m.addParameter(SELF_VAR_NAME, _newTypeReference);
            for (Pair param : l) {
                String _key = (String)param.getKey();
                TypeReference _value = (TypeReference)param.getValue();
                m.addParameter(_key, _value);
            }
        }
        m.setStatic(true);
    }

    private void methodProcessingAddSuper(final MutableMethodDeclaration m, final MutableClassDeclaration clazz, String aspectizedClassName, final @Extension TransformationContext cxt) {
        Functions.Function1<MethodDeclaration, Boolean> _function_3;
        boolean _isEmpty;
        boolean _tripleEquals;
        boolean _not;
        Functions.Function1<AnnotationReference, Boolean> _function;
        Iterable _annotations = m.getAnnotations();
        boolean _exists = IterableExtensions.exists((Iterable)_annotations, (Functions.Function1)(_function = new Functions.Function1<AnnotationReference, Boolean>(){

            public Boolean apply(AnnotationReference it) {
                AnnotationTypeDeclaration _annotationTypeDeclaration = it.getAnnotationTypeDeclaration();
                String _simpleName = _annotationTypeDeclaration.getSimpleName();
                return Objects.equal((Object)_simpleName, (Object)OVERRIDE_METHOD);
            }
        }));
        boolean bl = _not = !_exists;
        if (_not) {
            return;
        }
        List<TypeReference> _annotationWithType = Helper.getAnnotationWithType((TypeDeclaration)clazz);
        Functions.Function1<TypeReference, ClassDeclaration> _function_1 = new Functions.Function1<TypeReference, ClassDeclaration>(){

            public ClassDeclaration apply(TypeReference cl) {
                String _name = cl.getName();
                Type _findTypeGlobally = cxt.findTypeGlobally(_name);
                return (ClassDeclaration)_findTypeGlobally;
            }
        };
        List _map = ListExtensions.map(_annotationWithType, (Functions.Function1)_function_1);
        Iterable _filterNull = IterableExtensions.filterNull((Iterable)_map);
        Set superClasses = IterableExtensions.toSet((Iterable)_filterNull);
        ClassDeclaration _xifexpression = null;
        TypeReference _extendedClass = clazz.getExtendedClass();
        boolean bl2 = _tripleEquals = _extendedClass == null;
        if (_tripleEquals) {
            _xifexpression = null;
        } else {
            TypeReference _extendedClass_1 = clazz.getExtendedClass();
            String _name = _extendedClass_1.getName();
            Type _findTypeGlobally = cxt.findTypeGlobally(_name);
            _xifexpression = (ClassDeclaration)_findTypeGlobally;
        }
        ClassDeclaration superCl = _xifexpression;
        if (superCl != null) {
            superClasses.add(superCl);
        }
        if (_isEmpty = superClasses.isEmpty()) {
            return;
        }
        Functions.Function1<ClassDeclaration, MethodDeclaration> _function_2 = new Functions.Function1<ClassDeclaration, MethodDeclaration>(){

            public MethodDeclaration apply(ClassDeclaration sc) {
                return Helper.findMethod(sc, m, cxt);
            }
        };
        Iterable _map_1 = IterableExtensions.map((Iterable)superClasses, (Functions.Function1)_function_2);
        Iterable _filterNull_1 = IterableExtensions.filterNull((Iterable)_map_1);
        Iterable superMeths = IterableExtensions.filter((Iterable)_filterNull_1, (Functions.Function1)(_function_3 = new Functions.Function1<MethodDeclaration, Boolean>(){

            public Boolean apply(MethodDeclaration it) {
                Functions.Function1<AnnotationReference, Boolean> _function;
                Iterable _annotations = it.getAnnotations();
                AnnotationReference _findFirst = (AnnotationReference)IterableExtensions.findFirst((Iterable)_annotations, (Functions.Function1)(_function = new Functions.Function1<AnnotationReference, Boolean>(){

                    public Boolean apply(AnnotationReference it) {
                        AnnotationTypeDeclaration _annotationTypeDeclaration = it.getAnnotationTypeDeclaration();
                        String _simpleName = _annotationTypeDeclaration.getSimpleName();
                        return Objects.equal((Object)_simpleName, (Object)"Abstract");
                    }
                }));
                return _findFirst == null;
            }
        }));
        int _size = IterableExtensions.size((Iterable)superMeths);
        final boolean multiSuper = _size > 1;
        Consumer<MethodDeclaration> _function_4 = new Consumer<MethodDeclaration>(){

            @Override
            public void accept(final MethodDeclaration sm) {
                TypeDeclaration _declaringType = sm.getDeclaringType();
                String _aspectedClassName = Helper.getAspectedClassName(_declaringType);
                String[] _split = _aspectedClassName.split("\\.");
                final String superAspectedClassName = (String)IterableExtensions.last((Iterable)((Iterable)Conversions.doWrapArray((Object)_split)));
                String _xifexpression = null;
                _xifexpression = multiSuper ? "super_" + superAspectedClassName + "_" : "super_";
                String superNamePrefix = _xifexpression;
                String _simpleName = m.getSimpleName();
                String _plus = String.valueOf(superNamePrefix) + _simpleName;
                Procedures.Procedure1<MutableMethodDeclaration> _function = new Procedures.Procedure1<MutableMethodDeclaration>(){

                    public void apply(MutableMethodDeclaration it) {
                        final StringBuilder paramsList = new StringBuilder();
                        it.setVisibility(Visibility.PRIVATE);
                        it.setStatic(true);
                        TypeReference _returnType = m.getReturnType();
                        it.setReturnType(_returnType);
                        Iterable _parameters = m.getParameters();
                        for (MutableParameterDeclaration p : _parameters) {
                            String _simpleName = p.getSimpleName();
                            TypeReference _type = p.getType();
                            it.addParameter(_simpleName, _type);
                        }
                        Iterable _parameters_1 = m.getParameters();
                        Functions.Function1<MutableParameterDeclaration, String> _function = new Functions.Function1<MutableParameterDeclaration, String>(){

                            public String apply(MutableParameterDeclaration it) {
                                return it.getSimpleName();
                            }
                        };
                        Iterable _map = IterableExtensions.map((Iterable)_parameters_1, (Functions.Function1)_function);
                        String _join = IterableExtensions.join((Iterable)_map, (CharSequence)",");
                        paramsList.append(_join);
                        CompilationStrategy _function_1 = new CompilationStrategy(){

                            public CharSequence compile(CompilationStrategy.CompilationContext it) {
                                boolean _notEquals;
                                StringConcatenation _builder = new StringConcatenation();
                                _builder.append((Object)"final ");
                                TypeDeclaration _declaringType = sm.getDeclaringType();
                                TypeReference _newTypeReference = cxt.newTypeReference((Type)_declaringType, new TypeReference[0]);
                                String _name = _newTypeReference.getName();
                                String _plus = String.valueOf(_name) + superAspectedClassName;
                                String _plus_1 = String.valueOf(_plus) + AspectProcessor.PROP_NAME;
                                _builder.append((Object)_plus_1, "");
                                _builder.append((Object)" ");
                                _builder.append((Object)AspectProcessor.PROP_VAR_NAME, "");
                                _builder.append((Object)" = ");
                                TypeDeclaration _declaringType_1 = sm.getDeclaringType();
                                TypeReference _newTypeReference_1 = cxt.newTypeReference((Type)_declaringType_1, new TypeReference[0]);
                                String _name_1 = _newTypeReference_1.getName();
                                String _plus_2 = String.valueOf(_name_1) + superAspectedClassName;
                                String _plus_3 = String.valueOf(_plus_2) + AspectProcessor.CTX_NAME;
                                _builder.append((Object)_plus_3, "");
                                _builder.append((Object)".getSelf(");
                                _builder.append((Object)AspectProcessor.SELF_VAR_NAME, "");
                                _builder.append((Object)");");
                                _builder.newLineIfNotEmpty();
                                TypeReference _returnType = sm.getReturnType();
                                String _name_2 = _returnType.getName();
                                boolean bl = _notEquals = !Objects.equal((Object)_name_2, (Object)"void");
                                if (_notEquals) {
                                    _builder.append((Object)"return ");
                                }
                                _builder.append((Object)" ");
                                TypeDeclaration _declaringType_2 = sm.getDeclaringType();
                                TypeReference _newTypeReference_2 = cxt.newTypeReference((Type)_declaringType_2, new TypeReference[0]);
                                String _name_3 = _newTypeReference_2.getName();
                                _builder.append((Object)_name_3, "");
                                _builder.append((Object)".");
                                String _simpleName = m.getSimpleName();
                                String _plus_4 = AspectProcessor.PRIV_PREFIX + _simpleName;
                                _builder.append((Object)_plus_4, "");
                                _builder.append((Object)"(");
                                _builder.append((Object)AspectProcessor.PROP_VAR_NAME, "");
                                _builder.append((Object)", ");
                                _builder.append((Object)paramsList, "");
                                _builder.append((Object)");");
                                _builder.newLineIfNotEmpty();
                                return _builder;
                            }
                        };
                        it.setBody(_function_1);
                        cxt.setPrimarySourceElement((MutableElement)it, (Element)m);
                    }
                };
                clazz.addMethod(_plus, (Procedures.Procedure1)_function);
            }
        };
        superMeths.forEach(_function_4);
    }

    private void methodProcessingAddHidden(final MutableMethodDeclaration m, String identifier, @Extension TransformationContext cxt) {
        MutableClassDeclaration cl;
        Functions.Function1<AnnotationReference, Boolean> _function;
        Iterable _annotations = m.getAnnotations();
        boolean _exists = IterableExtensions.exists((Iterable)_annotations, (Functions.Function1)(_function = new Functions.Function1<AnnotationReference, Boolean>(){

            public Boolean apply(AnnotationReference it) {
                AnnotationTypeDeclaration _annotationTypeDeclaration = it.getAnnotationTypeDeclaration();
                String _simpleName = _annotationTypeDeclaration.getSimpleName();
                return Objects.equal((Object)_simpleName, (Object)"ReplaceAspectMethod");
            }
        }));
        if (_exists && (cl = cxt.findClass(identifier)) != null) {
            Iterable _declaredMethods = cl.getDeclaredMethods();
            Functions.Function1<MutableMethodDeclaration, Boolean> _function_1 = new Functions.Function1<MutableMethodDeclaration, Boolean>(){

                public Boolean apply(MutableMethodDeclaration m2) {
                    return Objects.equal((Object)m2.getSimpleName(), (Object)m.getSimpleName()) && IterableExtensions.size((Iterable)m2.getParameters()) == IterableExtensions.size((Iterable)m.getParameters()) - 1;
                }
            };
            MutableMethodDeclaration m2 = (MutableMethodDeclaration)IterableExtensions.findFirst((Iterable)_declaredMethods, (Functions.Function1)_function_1);
            String _simpleName = m.getSimpleName();
            String _plus = "_hidden_" + _simpleName;
            m2.setSimpleName(_plus);
        }
    }

    private void methodProcessingAddPriv(final MutableMethodDeclaration m, final MutableClassDeclaration clazz, final String aspectizedClassName, final Map<MutableMethodDeclaration, String> bodies, final @Extension TransformationContext cxt) {
        String _simpleName = m.getSimpleName();
        String _plus = PRIV_PREFIX + _simpleName;
        Procedures.Procedure1<MutableMethodDeclaration> _function = new Procedures.Procedure1<MutableMethodDeclaration>(){

            public void apply(MutableMethodDeclaration it) {
                cxt.setPrimarySourceElement((MutableElement)it, (Element)m);
                it.setVisibility(Visibility.PROTECTED);
                it.setStatic(true);
                it.setAbstract(false);
                TypeReference _returnType = m.getReturnType();
                it.setReturnType(_returnType);
                boolean _isAbstract = m.isAbstract();
                if (_isAbstract) {
                    CompilationStrategy _function = new CompilationStrategy(){

                        public CharSequence compile(CompilationStrategy.CompilationContext it) {
                            StringConcatenation _builder = new StringConcatenation();
                            _builder.append((Object)"throw new java.lang.RuntimeException(\"Not implemented\");");
                            return _builder;
                        }
                    };
                    it.setBody(_function);
                } else {
                    boolean _tripleEquals;
                    Expression _body = m.getBody();
                    boolean bl = _tripleEquals = _body == null;
                    if (_tripleEquals) {
                        CompilationStrategy _function_1 = new CompilationStrategy(){

                            public CharSequence compile(CompilationStrategy.CompilationContext it) {
                                return (CharSequence)bodies.get(m);
                            }
                        };
                        it.setBody(_function_1);
                    } else {
                        Expression _body_1 = m.getBody();
                        it.setBody(_body_1);
                    }
                }
                String _qualifiedName = clazz.getQualifiedName();
                String _plus = String.valueOf(_qualifiedName) + aspectizedClassName;
                String _plus_1 = String.valueOf(_plus) + AspectProcessor.PROP_NAME;
                MutableClassDeclaration _findClass = cxt.findClass(_plus_1);
                TypeReference _newTypeReference = cxt.newTypeReference((Type)_findClass, new TypeReference[0]);
                it.addParameter(AspectProcessor.PROP_VAR_NAME, _newTypeReference);
                Iterable _parameters = m.getParameters();
                for (MutableParameterDeclaration p : _parameters) {
                    String _simpleName = p.getSimpleName();
                    TypeReference _type = p.getType();
                    it.addParameter(_simpleName, _type);
                }
            }
        };
        clazz.addMethod(_plus, (Procedures.Procedure1)_function);
    }

    private void methodProcessingChangeBody(MutableMethodDeclaration m, final MutableClassDeclaration clazz, @Extension TransformationContext cxt, Map<MethodDeclaration, Set<MethodDeclaration>> dispatchmethod, List<String> inheritList, final String className) {
        boolean _tripleNotEquals;
        Iterable _parameters = m.getParameters();
        Functions.Function1<MutableParameterDeclaration, String> _function = new Functions.Function1<MutableParameterDeclaration, String>(){

            public String apply(MutableParameterDeclaration it) {
                return it.getSimpleName();
            }
        };
        Iterable _map = IterableExtensions.map((Iterable)_parameters, (Functions.Function1)_function);
        String s = IterableExtensions.join((Iterable)_map, (CharSequence)",");
        Iterable _annotations = m.getAnnotations();
        Functions.Function1<AnnotationReference, Boolean> _function_1 = new Functions.Function1<AnnotationReference, Boolean>(){

            public Boolean apply(AnnotationReference it) {
                AnnotationTypeDeclaration _annotationTypeDeclaration = it.getAnnotationTypeDeclaration();
                String _simpleName = _annotationTypeDeclaration.getSimpleName();
                return Objects.equal((Object)_simpleName, (Object)STEP);
            }
        };
        boolean isStep = IterableExtensions.exists((Iterable)_annotations, (Functions.Function1)_function_1);
        final String ret = this.getReturnInstruction(m, cxt);
        final StringBuilder call = new StringBuilder();
        Set<MethodDeclaration> _get = dispatchmethod.get(m);
        boolean bl = _tripleNotEquals = _get != null;
        if (_tripleNotEquals) {
            Set<MethodDeclaration> _get_1 = dispatchmethod.get(m);
            List<MethodDeclaration> listmethod = Helper.sortByMethodInheritance(_get_1, inheritList);
            Functions.Function1<MethodDeclaration, TypeDeclaration> _function_2 = new Functions.Function1<MethodDeclaration, TypeDeclaration>(){

                public TypeDeclaration apply(MethodDeclaration it) {
                    return it.getDeclaringType();
                }
            };
            List declTypes = ListExtensions.map(listmethod, (Functions.Function1)_function_2);
            String ifst = this.transformIfStatements(m, cxt, declTypes, s, ret, isStep, className);
            StringBuilder _append = call.append(ifst);
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)" ");
            _builder.append((Object)"{ throw new IllegalArgumentException(\"Unhandled parameter types: \" + java.util.Arrays.<Object>asList(");
            _builder.append((Object)SELF_VAR_NAME, " ");
            _builder.append((Object)").toString()); }");
            _append.append((CharSequence)_builder);
        } else {
            String instruction = this.transformNormalStatement(m, cxt, s, isStep, className);
            call.append(instruction);
        }
        m.setAbstract(false);
        CompilationStrategy _function_3 = new CompilationStrategy(){

            public CharSequence compile(CompilationStrategy.CompilationContext it) {
                String _string = call.toString();
                return AspectProcessor.this.getBody(clazz, className, _string, ret);
            }
        };
        m.setBody(_function_3);
    }

    private boolean hasReturnType(MutableMethodDeclaration declaration, @Extension TransformationContext cxt) {
        TypeReference _newTypeReference;
        TypeReference _returnType = declaration.getReturnType();
        return !Objects.equal((Object)_returnType, (Object)(_newTypeReference = cxt.newTypeReference("void", new TypeReference[0])));
    }

    private String transformIfStatements(MutableMethodDeclaration m, @Extension TransformationContext cxt, List<TypeDeclaration> declTypes, String parameters, String returnStatement, boolean isStep, String className) {
        boolean hasReturn = returnStatement.contains("return");
        StringBuilder sb = new StringBuilder();
        for (TypeDeclaration dt : declTypes) {
            String call = "";
            MutableTypeDeclaration _declaringType = m.getDeclaringType();
            boolean _equals = _declaringType.equals(dt);
            if (_equals) {
                StringConcatenation _builder = new StringConcatenation();
                TypeReference _newTypeReference = cxt.newTypeReference((Type)dt, new TypeReference[0]);
                String _name = _newTypeReference.getName();
                _builder.append((Object)_name, "");
                _builder.append((Object)".");
                String _simpleName = m.getSimpleName();
                String _plus = PRIV_PREFIX + _simpleName;
                _builder.append((Object)_plus, "");
                _builder.append((Object)"(_self_, ");
                String _aspectedClassName = Helper.getAspectedClassName(dt);
                String _plus_1 = "(" + _aspectedClassName;
                String _plus_2 = String.valueOf(_plus_1) + ")";
                String _plus_3 = String.valueOf(_plus_2) + SELF_VAR_NAME;
                String _replaceFirst = parameters.replaceFirst(SELF_VAR_NAME, _plus_3);
                _builder.append((Object)_replaceFirst, "");
                _builder.append((Object)")");
                call = _builder.toString();
                if (isStep) {
                    String _surroundWithStepCommandExecution;
                    Iterable _annotations = m.getAnnotations();
                    Functions.Function1<AnnotationReference, Boolean> _function = new Functions.Function1<AnnotationReference, Boolean>(){

                        public Boolean apply(AnnotationReference it) {
                            AnnotationTypeDeclaration _annotationTypeDeclaration = it.getAnnotationTypeDeclaration();
                            String _simpleName = _annotationTypeDeclaration.getSimpleName();
                            return Objects.equal((Object)_simpleName, (Object)STEP);
                        }
                    };
                    AnnotationReference _findFirst = (AnnotationReference)IterableExtensions.findFirst((Iterable)_annotations, (Functions.Function1)_function);
                    boolean waitForEvents = _findFirst.getBooleanValue("waitForEvents");
                    String _simpleName_1 = m.getSimpleName();
                    call = _surroundWithStepCommandExecution = this.surroundWithStepCommandExecution(className, _simpleName_1, call, hasReturn, "result", waitForEvents);
                } else if (hasReturn) {
                    StringConcatenation _builder_1 = new StringConcatenation();
                    _builder_1.append((Object)"result", "");
                    _builder_1.append((Object)" = ");
                    _builder_1.append((Object)call, "");
                    call = _builder_1.toString();
                }
            } else {
                StringConcatenation _builder_2 = new StringConcatenation();
                TypeReference _newTypeReference_1 = cxt.newTypeReference((Type)dt, new TypeReference[0]);
                String _name_1 = _newTypeReference_1.getName();
                _builder_2.append((Object)_name_1, "");
                _builder_2.append((Object)".");
                String _simpleName_2 = m.getSimpleName();
                _builder_2.append((Object)_simpleName_2, "");
                _builder_2.append((Object)"(");
                String _aspectedClassName_1 = Helper.getAspectedClassName(dt);
                String _plus_4 = "(" + _aspectedClassName_1;
                String _plus_5 = String.valueOf(_plus_4) + ")";
                String _plus_6 = String.valueOf(_plus_5) + SELF_VAR_NAME;
                String _replaceFirst_1 = parameters.replaceFirst(SELF_VAR_NAME, _plus_6);
                _builder_2.append((Object)_replaceFirst_1, "");
                _builder_2.append((Object)")");
                call = _builder_2.toString();
                if (hasReturn) {
                    StringConcatenation _builder_3 = new StringConcatenation();
                    _builder_3.append((Object)"result", "");
                    _builder_3.append((Object)" = ");
                    _builder_3.append((Object)call, "");
                    call = _builder_3.toString();
                }
            }
            StringConcatenation _builder_4 = new StringConcatenation();
            _builder_4.append((Object)" ");
            _builder_4.append((Object)"if (");
            _builder_4.append((Object)SELF_VAR_NAME, " ");
            _builder_4.append((Object)" instanceof ");
            String _aspectedClassName_2 = Helper.getAspectedClassName(dt);
            _builder_4.append((Object)_aspectedClassName_2, " ");
            _builder_4.append((Object)"){");
            _builder_4.newLineIfNotEmpty();
            _builder_4.append((Object)"\t\t\t\t\t");
            _builder_4.append((Object)call, "\t\t\t\t\t");
            _builder_4.append((Object)";");
            _builder_4.newLineIfNotEmpty();
            _builder_4.append((Object)"} else ");
            sb.append((CharSequence)_builder_4);
        }
        return sb.toString();
    }

    private String transformNormalStatement(MutableMethodDeclaration declaration, @Extension TransformationContext cxt, String parameters, boolean isStep, String className) {
        boolean hasReturn = this.hasReturnType(declaration, cxt);
        StringConcatenation _builder = new StringConcatenation();
        String _simpleName = declaration.getSimpleName();
        String _plus = PRIV_PREFIX + _simpleName;
        _builder.append((Object)_plus, "");
        _builder.append((Object)"(_self_, ");
        _builder.append((Object)parameters, "");
        _builder.append((Object)")");
        String call = _builder.toString();
        if (isStep) {
            String _surroundWithStepCommandExecution;
            Iterable _annotations = declaration.getAnnotations();
            Functions.Function1<AnnotationReference, Boolean> _function = new Functions.Function1<AnnotationReference, Boolean>(){

                public Boolean apply(AnnotationReference it) {
                    AnnotationTypeDeclaration _annotationTypeDeclaration = it.getAnnotationTypeDeclaration();
                    String _simpleName = _annotationTypeDeclaration.getSimpleName();
                    return Objects.equal((Object)_simpleName, (Object)STEP);
                }
            };
            AnnotationReference _findFirst = (AnnotationReference)IterableExtensions.findFirst((Iterable)_annotations, (Functions.Function1)_function);
            boolean waitForEvents = _findFirst.getBooleanValue("waitForEvents");
            String _simpleName_1 = declaration.getSimpleName();
            call = _surroundWithStepCommandExecution = this.surroundWithStepCommandExecution(className, _simpleName_1, call, hasReturn, "result", waitForEvents);
        } else if (hasReturn) {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append((Object)"result", "");
            _builder_1.append((Object)" = ");
            _builder_1.append((Object)call, "");
            call = _builder_1.toString();
        }
        return String.valueOf(call) + ";";
    }

    private String getReturnInstruction(MutableMethodDeclaration declaration, @Extension TransformationContext cxt) {
        String ret = "";
        boolean _hasReturnType = this.hasReturnType(declaration, cxt);
        if (_hasReturnType) {
            boolean _not;
            TypeReference _returnType = declaration.getReturnType();
            boolean _isInferred = _returnType.isInferred();
            boolean bl = _not = !_isInferred;
            if (_not) {
                String _plus_1;
                TypeReference _returnType_1 = declaration.getReturnType();
                String _name = _returnType_1.getName();
                String _plus = "return (" + _name;
                ret = _plus_1 = String.valueOf(_plus) + ")result;";
            } else {
                cxt.addError((Element)declaration, "Cannot infer return type. Please specify the return type of this method.");
                ret = "return result;";
            }
        } else {
            ret = "";
        }
        return ret;
    }

    private String surroundWithStepCommandExecution(String className, String methodName, String code, boolean hasReturn, String resultVar, boolean waitForEvents) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"fr.inria.diverse.k3.al.annotationprocessor.stepmanager.StepCommand command = new fr.inria.diverse.k3.al.annotationprocessor.stepmanager.StepCommand() {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"@Override");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public void execute() {");
        _builder.newLine();
        if (hasReturn) {
            _builder.append((Object)"\t\t");
            _builder.append((Object)"addToResult(");
            _builder.append((Object)code, "\t\t");
            _builder.append((Object)");");
            _builder.newLineIfNotEmpty();
        } else {
            _builder.append((Object)"\t\t");
            _builder.append((Object)code, "\t\t");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"};");
        _builder.newLine();
        _builder.append((Object)"fr.inria.diverse.k3.al.annotationprocessor.stepmanager.IStepManager stepManager = fr.inria.diverse.k3.al.annotationprocessor.stepmanager.StepManagerRegistry.getInstance().findStepManager(_self);");
        _builder.newLine();
        _builder.append((Object)"if (stepManager != null) {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"stepManager.executeStep(_self,command,\"");
        _builder.append((Object)className, "\t");
        _builder.append((Object)"\",\"");
        _builder.append((Object)methodName, "\t");
        _builder.append((Object)"\");");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"} else {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"command.execute();");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        if (hasReturn) {
            _builder.append((Object)resultVar, "");
            _builder.append((Object)" = command.getResult();");
            _builder.newLineIfNotEmpty();
        }
        return _builder.toString();
    }

    private CharSequence getBody(MutableClassDeclaration clazz, String className, String call, String returnStatement) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"final ");
        String _qualifiedName = clazz.getQualifiedName();
        String _plus = String.valueOf(_qualifiedName) + className;
        String _plus_1 = String.valueOf(_plus) + PROP_NAME;
        _builder.append((Object)_plus_1, "");
        _builder.append((Object)" ");
        _builder.append((Object)PROP_VAR_NAME, "");
        _builder.append((Object)" = ");
        String _qualifiedName_1 = clazz.getQualifiedName();
        String _plus_2 = String.valueOf(_qualifiedName_1) + className;
        String _plus_3 = String.valueOf(_plus_2) + CTX_NAME;
        _builder.append((Object)_plus_3, "");
        _builder.append((Object)".getSelf(");
        _builder.append((Object)SELF_VAR_NAME, "");
        _builder.append((Object)");");
        _builder.newLineIfNotEmpty();
        boolean _contains = returnStatement.contains("return");
        if (_contains) {
            _builder.append((Object)"Object result = null;");
            _builder.newLine();
        }
        String _string = call.toString();
        _builder.append((Object)_string, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)returnStatement, "");
        return _builder;
    }

    private void methodProcessingAddMultiInheritMeth(final MutableClassDeclaration clazz, final String identifier, final @Extension TransformationContext cxt) {
        List<TypeReference> _annotationWithType = Helper.getAnnotationWithType((TypeDeclaration)clazz);
        Functions.Function1<TypeReference, Boolean> _function = new Functions.Function1<TypeReference, Boolean>(){

            public Boolean apply(TypeReference cl) {
                TypeReference _extendedClass = clazz.getExtendedClass();
                return !Objects.equal((Object)cl, (Object)_extendedClass);
            }
        };
        Iterable _filter = IterableExtensions.filter(_annotationWithType, (Functions.Function1)_function);
        Functions.Function1<TypeReference, MutableClassDeclaration> _function_1 = new Functions.Function1<TypeReference, MutableClassDeclaration>(){

            public MutableClassDeclaration apply(TypeReference cl) {
                String _name = cl.getName();
                return cxt.findClass(_name);
            }
        };
        Iterable _map = IterableExtensions.map((Iterable)_filter, (Functions.Function1)_function_1);
        Iterable superClasses = IterableExtensions.filterNull((Iterable)_map);
        final HashSet scs = CollectionLiterals.newHashSet((Object[])new MutableClassDeclaration[0]);
        Consumer<MutableClassDeclaration> _function_2 = new Consumer<MutableClassDeclaration>(){

            @Override
            public void accept(MutableClassDeclaration sc) {
                Helper.getSuperClasses(sc, scs, cxt);
            }
        };
        superClasses.forEach(_function_2);
        Consumer<MutableClassDeclaration> _function_3 = new Consumer<MutableClassDeclaration>(){

            @Override
            public void accept(final MutableClassDeclaration sc) {
                Iterable _declaredMethods = sc.getDeclaredMethods();
                Functions.Function1<MutableMethodDeclaration, Boolean> _function = new Functions.Function1<MutableMethodDeclaration, Boolean>(){

                    public Boolean apply(final MutableMethodDeclaration dm) {
                        return !Objects.equal((Object)dm.getVisibility(), (Object)Visibility.PRIVATE) && !dm.getSimpleName().startsWith(AspectProcessor.PRIV_PREFIX) && !IterableExtensions.exists((Iterable)clazz.getDeclaredMethods(), (Functions.Function1)new Functions.Function1<MutableMethodDeclaration, Boolean>(){

                            public Boolean apply(MutableMethodDeclaration dm2) {
                                return Helper.isSamePrototype(dm, dm2, true);
                            }
                        });
                    }
                };
                Iterable _filter = IterableExtensions.filter((Iterable)_declaredMethods, (Functions.Function1)_function);
                Consumer<MutableMethodDeclaration> _function_1 = new Consumer<MutableMethodDeclaration>(){

                    @Override
                    public void accept(final MutableMethodDeclaration dm) {
                        String _simpleName = dm.getSimpleName();
                        Procedures.Procedure1<MutableMethodDeclaration> _function = new Procedures.Procedure1<MutableMethodDeclaration>(){

                            public void apply(final MutableMethodDeclaration it) {
                                cxt.setPrimarySourceElement((MutableElement)it, (Element)dm);
                                Visibility _visibility = dm.getVisibility();
                                it.setVisibility(_visibility);
                                it.setStatic(true);
                                it.setFinal(false);
                                it.setAbstract(false);
                                TypeReference _returnType = dm.getReturnType();
                                it.setReturnType(_returnType);
                                TypeReference _newTypeReference = cxt.newTypeReference(identifier, new TypeReference[0]);
                                it.addParameter(AspectProcessor.SELF_VAR_NAME, _newTypeReference);
                                Iterable _parameters = dm.getParameters();
                                Iterable _drop = IterableExtensions.drop((Iterable)_parameters, (int)1);
                                Consumer<MutableParameterDeclaration> _function = new Consumer<MutableParameterDeclaration>(){

                                    @Override
                                    public void accept(MutableParameterDeclaration par) {
                                        String _simpleName = par.getSimpleName();
                                        TypeReference _type = par.getType();
                                        it.addParameter(_simpleName, _type);
                                    }
                                };
                                _drop.forEach(_function);
                            }
                        };
                        final MutableMethodDeclaration me = clazz.addMethod(_simpleName, (Procedures.Procedure1)_function);
                        AspectProcessor.this.methodProcessingAddSelfStatic(me, identifier, cxt);
                        Iterable _parameters = me.getParameters();
                        Functions.Function1<MutableParameterDeclaration, String> _function_1 = new Functions.Function1<MutableParameterDeclaration, String>(){

                            public String apply(MutableParameterDeclaration it) {
                                return it.getSimpleName();
                            }
                        };
                        Iterable _map = IterableExtensions.map((Iterable)_parameters, (Functions.Function1)_function_1);
                        final String params = IterableExtensions.join((Iterable)_map, (CharSequence)",");
                        CompilationStrategy _function_2 = new CompilationStrategy(){

                            public CharSequence compile(CompilationStrategy.CompilationContext it) {
                                StringConcatenation _builder = new StringConcatenation();
                                if (me.getReturnType() != null && !Objects.equal((Object)me.getReturnType().getSimpleName(), (Object)"void")) {
                                    _builder.append((Object)"return ");
                                }
                                String _simpleName = sc.getSimpleName();
                                _builder.append((Object)_simpleName, "");
                                _builder.append((Object)".");
                                String _simpleName_1 = dm.getSimpleName();
                                _builder.append((Object)_simpleName_1, "");
                                _builder.append((Object)"(");
                                _builder.append((Object)params, "");
                                _builder.append((Object)");");
                                return _builder;
                            }
                        };
                        me.setBody(_function_2);
                    }
                };
                _filter.forEach(_function_1);
                Iterable _declaredFields = sc.getDeclaredFields();
                Functions.Function1<MutableFieldDeclaration, Boolean> _function_2 = new Functions.Function1<MutableFieldDeclaration, Boolean>(){

                    public Boolean apply(MutableFieldDeclaration it) {
                        String _simpleName = it.getSimpleName();
                        return !Objects.equal((Object)_simpleName, (Object)AspectProcessor.PROP_VAR_NAME);
                    }
                };
                Iterable _filter_1 = IterableExtensions.filter((Iterable)_declaredFields, (Functions.Function1)_function_2);
                Consumer<MutableFieldDeclaration> _function_3 = new Consumer<MutableFieldDeclaration>(){

                    @Override
                    public void accept(final MutableFieldDeclaration fi) {
                        boolean _not;
                        MutableTypeDeclaration _declaringType = fi.getDeclaringType();
                        final String clName = _declaringType.getSimpleName();
                        String _simpleName = fi.getSimpleName();
                        Procedures.Procedure1<MutableMethodDeclaration> _function = new Procedures.Procedure1<MutableMethodDeclaration>(){

                            public void apply(MutableMethodDeclaration it) {
                                cxt.setPrimarySourceElement((MutableElement)it, (Element)fi);
                                it.setStatic(true);
                                TypeReference _type = fi.getType();
                                it.setReturnType(_type);
                                TypeReference _newTypeReference = cxt.newTypeReference(identifier, new TypeReference[0]);
                                it.addParameter(AspectProcessor.SELF_VAR_NAME, _newTypeReference);
                                CompilationStrategy _function = new CompilationStrategy(){

                                    public CharSequence compile(CompilationStrategy.CompilationContext it) {
                                        StringConcatenation _builder = new StringConcatenation();
                                        _builder.append((Object)"return ");
                                        _builder.append((Object)clName, "");
                                        _builder.append((Object)".");
                                        String _simpleName = fi.getSimpleName();
                                        _builder.append((Object)_simpleName, "");
                                        _builder.append((Object)"(");
                                        _builder.append((Object)AspectProcessor.SELF_VAR_NAME, "");
                                        _builder.append((Object)");");
                                        return _builder;
                                    }
                                };
                                it.setBody(_function);
                            }
                        };
                        clazz.addMethod(_simpleName, (Procedures.Procedure1)_function);
                        boolean _isFinal = fi.isFinal();
                        boolean bl = _not = !_isFinal;
                        if (_not) {
                            String _simpleName_1 = fi.getSimpleName();
                            Procedures.Procedure1<MutableMethodDeclaration> _function_1 = new Procedures.Procedure1<MutableMethodDeclaration>(){

                                public void apply(MutableMethodDeclaration it) {
                                    cxt.setPrimarySourceElement((MutableElement)it, (Element)fi);
                                    it.setStatic(true);
                                    TypeReference _newTypeReference = cxt.newTypeReference("void", new TypeReference[0]);
                                    it.setReturnType(_newTypeReference);
                                    TypeReference _newTypeReference_1 = cxt.newTypeReference(identifier, new TypeReference[0]);
                                    it.addParameter(AspectProcessor.SELF_VAR_NAME, _newTypeReference_1);
                                    String _simpleName = fi.getSimpleName();
                                    TypeReference _type = fi.getType();
                                    it.addParameter(_simpleName, _type);
                                    CompilationStrategy _function = new CompilationStrategy(){

                                        public CharSequence compile(CompilationStrategy.CompilationContext it) {
                                            StringConcatenation _builder = new StringConcatenation();
                                            _builder.append((Object)clName, "");
                                            _builder.append((Object)".");
                                            String _simpleName = fi.getSimpleName();
                                            _builder.append((Object)_simpleName, "");
                                            _builder.append((Object)"(");
                                            _builder.append((Object)AspectProcessor.SELF_VAR_NAME, "");
                                            _builder.append((Object)", ");
                                            String _simpleName_1 = fi.getSimpleName();
                                            _builder.append((Object)_simpleName_1, "");
                                            _builder.append((Object)");");
                                            return _builder;
                                        }
                                    };
                                    it.setBody(_function);
                                }
                            };
                            clazz.addMethod(_simpleName_1, (Procedures.Procedure1)_function_1);
                        }
                    }
                };
                _filter_1.forEach(_function_3);
            }
        };
        scs.forEach(_function_3);
    }

    private void methodsProcessing(MutableClassDeclaration clazz, TransformationContext cxt, String identifier, Map<MutableMethodDeclaration, String> bodies, Map<MethodDeclaration, Set<MethodDeclaration>> dispatchmethod, List<String> inheritList, String aspectizedClassName) {
        Iterable _declaredMethods = clazz.getDeclaredMethods();
        for (MutableMethodDeclaration m : _declaredMethods) {
            boolean _checkAnnotationprocessorCorrect = this.checkAnnotationprocessorCorrect(m, clazz, cxt);
            if (_checkAnnotationprocessorCorrect) {
                Iterable _annotations = m.getAnnotations();
                Functions.Function1<AnnotationReference, Boolean> _function = new Functions.Function1<AnnotationReference, Boolean>(){

                    public Boolean apply(AnnotationReference an) {
                        AnnotationTypeDeclaration _annotationTypeDeclaration = an.getAnnotationTypeDeclaration();
                        String _qualifiedName = _annotationTypeDeclaration.getQualifiedName();
                        return Objects.equal((Object)_qualifiedName, (Object)"java.lang.Override");
                    }
                };
                AnnotationReference _findFirst = (AnnotationReference)IterableExtensions.findFirst((Iterable)_annotations, (Functions.Function1)_function);
                m.removeAnnotation(_findFirst);
                this.methodProcessingAddSelfStatic(m, identifier, cxt);
                this.methodProcessingAddSuper(m, clazz, aspectizedClassName, cxt);
                this.methodProcessingAddHidden(m, identifier, cxt);
                this.methodProcessingAddPriv(m, clazz, aspectizedClassName, bodies, cxt);
                this.methodProcessingChangeBody(m, clazz, cxt, dispatchmethod, inheritList, aspectizedClassName);
                continue;
            }
            cxt.addError((Element)m, "Cannot find a super method in the aspect hierarchy.");
        }
        this.methodProcessingCheckPreconditions(clazz, cxt);
        this.methodProcessingAddMultiInheritMeth(clazz, identifier, cxt);
    }

    private void methodProcessingCheckPreconditions(final MutableClassDeclaration clazz, final @Extension TransformationContext cxt) {
        Iterable _declaredMethods = clazz.getDeclaredMethods();
        Functions.Function1<MutableMethodDeclaration, Boolean> _function = new Functions.Function1<MutableMethodDeclaration, Boolean>(){

            public Boolean apply(MutableMethodDeclaration it) {
                Iterable _annotations = it.getAnnotations();
                Functions.Function1<AnnotationReference, Boolean> _function = new Functions.Function1<AnnotationReference, Boolean>(){

                    public Boolean apply(AnnotationReference it) {
                        AnnotationTypeDeclaration _annotationTypeDeclaration = it.getAnnotationTypeDeclaration();
                        String _simpleName = _annotationTypeDeclaration.getSimpleName();
                        return Objects.equal((Object)_simpleName, (Object)STEP);
                    }
                };
                return IterableExtensions.exists((Iterable)_annotations, (Functions.Function1)_function);
            }
        };
        Iterable steps = IterableExtensions.filter((Iterable)_declaredMethods, (Functions.Function1)_function);
        Functions.Function1<MutableMethodDeclaration, Boolean> _function_1 = new Functions.Function1<MutableMethodDeclaration, Boolean>(){

            public Boolean apply(MutableMethodDeclaration it) {
                Iterable _annotations = it.getAnnotations();
                Functions.Function1<AnnotationReference, Boolean> _function = new Functions.Function1<AnnotationReference, Boolean>(){

                    public Boolean apply(AnnotationReference it) {
                        AnnotationTypeDeclaration _annotationTypeDeclaration = it.getAnnotationTypeDeclaration();
                        String _simpleName = _annotationTypeDeclaration.getSimpleName();
                        return Objects.equal((Object)_simpleName, (Object)STEP);
                    }
                };
                AnnotationReference _findFirst = (AnnotationReference)IterableExtensions.findFirst((Iterable)_annotations, (Functions.Function1)_function);
                return _findFirst.getBooleanValue("eventHandler");
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)steps, (Functions.Function1)_function_1);
        List eventHandlers = IterableExtensions.toList((Iterable)_filter);
        Functions.Function1<MutableMethodDeclaration, Boolean> _function_2 = new Functions.Function1<MutableMethodDeclaration, Boolean>(){

            public Boolean apply(MutableMethodDeclaration it) {
                Functions.Function1<AnnotationReference, Boolean> _function;
                Iterable _annotations = it.getAnnotations();
                AnnotationReference _findFirst = (AnnotationReference)IterableExtensions.findFirst((Iterable)_annotations, (Functions.Function1)(_function = new Functions.Function1<AnnotationReference, Boolean>(){

                    public Boolean apply(AnnotationReference it) {
                        AnnotationTypeDeclaration _annotationTypeDeclaration = it.getAnnotationTypeDeclaration();
                        String _simpleName = _annotationTypeDeclaration.getSimpleName();
                        return Objects.equal((Object)_simpleName, (Object)STEP);
                    }
                }));
                String _stringValue = _findFirst.getStringValue("precondition");
                return !Objects.equal((Object)_stringValue, (Object)"");
            }
        };
        Iterable _filter_1 = IterableExtensions.filter((Iterable)steps, (Functions.Function1)_function_2);
        List preconditionedSteps = IterableExtensions.toList((Iterable)_filter_1);
        ArrayList<MutableMethodDeclaration> methodsInError = new ArrayList<MutableMethodDeclaration>(preconditionedSteps);
        methodsInError.removeAll(eventHandlers);
        Consumer<MutableMethodDeclaration> _function_3 = new Consumer<MutableMethodDeclaration>(){

            @Override
            public void accept(MutableMethodDeclaration m) {
                cxt.addError((Element)m, "Cannot declare precondition on non-event step");
            }
        };
        methodsInError.forEach(_function_3);
        preconditionedSteps.removeAll(methodsInError);
        Consumer<MutableMethodDeclaration> _function_4 = new Consumer<MutableMethodDeclaration>(){

            @Override
            public void accept(MutableMethodDeclaration m) {
                boolean _equals;
                Functions.Function1<MutableMethodDeclaration, Boolean> _function_1;
                Iterable _annotations = m.getAnnotations();
                Functions.Function1<AnnotationReference, Boolean> _function = new Functions.Function1<AnnotationReference, Boolean>(){

                    public Boolean apply(AnnotationReference it) {
                        AnnotationTypeDeclaration _annotationTypeDeclaration = it.getAnnotationTypeDeclaration();
                        String _simpleName = _annotationTypeDeclaration.getSimpleName();
                        return Objects.equal((Object)_simpleName, (Object)STEP);
                    }
                };
                AnnotationReference _findFirst = (AnnotationReference)IterableExtensions.findFirst((Iterable)_annotations, (Functions.Function1)_function);
                final String preconditionName = _findFirst.getStringValue("precondition");
                Iterable _declaredMethods = clazz.getDeclaredMethods();
                Iterable preconditionMethods = IterableExtensions.filter((Iterable)_declaredMethods, (Functions.Function1)(_function_1 = new Functions.Function1<MutableMethodDeclaration, Boolean>(){

                    public Boolean apply(MutableMethodDeclaration p) {
                        String _simpleName = p.getSimpleName();
                        return Objects.equal((Object)_simpleName, (Object)preconditionName);
                    }
                }));
                int _size = IterableExtensions.size((Iterable)preconditionMethods);
                boolean bl = _equals = _size == 0;
                if (_equals) {
                    cxt.addError((Element)m, "Cannot find associated precondition method");
                } else {
                    boolean _greaterThan;
                    int _size_1 = IterableExtensions.size((Iterable)preconditionMethods);
                    boolean bl2 = _greaterThan = _size_1 > 1;
                    if (_greaterThan) {
                        Consumer<MutableMethodDeclaration> _function_2 = new Consumer<MutableMethodDeclaration>(){

                            @Override
                            public void accept(MutableMethodDeclaration p) {
                                cxt.addError((Element)p, "Ambiguous precondition method name");
                            }
                        };
                        preconditionMethods.forEach(_function_2);
                    } else {
                        int _size_3;
                        boolean _notEquals;
                        MutableMethodDeclaration precondition = (MutableMethodDeclaration)IterableExtensions.head((Iterable)preconditionMethods);
                        Iterable preconditionParameters = precondition.getParameters();
                        Iterable eventParameters = m.getParameters();
                        int _size_2 = IterableExtensions.size((Iterable)preconditionParameters);
                        boolean bl3 = _notEquals = _size_2 != (_size_3 = IterableExtensions.size((Iterable)eventParameters));
                        if (_notEquals) {
                            cxt.addError((Element)precondition, "Precondition method parameters do not match event method parameters");
                        } else {
                            Iterator preIt = preconditionParameters.iterator();
                            Iterator eventIt = eventParameters.iterator();
                            boolean matching = true;
                            while (matching && preIt.hasNext()) {
                                boolean _equals_1;
                                MutableParameterDeclaration _next = (MutableParameterDeclaration)preIt.next();
                                TypeReference _type = _next.getType();
                                String _name = _type.getName();
                                MutableParameterDeclaration _next_1 = (MutableParameterDeclaration)eventIt.next();
                                TypeReference _type_1 = _next_1.getType();
                                String _name_1 = _type_1.getName();
                                matching = _equals_1 = Objects.equal((Object)_name, (Object)_name_1);
                            }
                            if (!matching) {
                                cxt.addError((Element)precondition, "Precondition method parameters do not match event method parameters");
                            }
                        }
                    }
                }
            }
        };
        preconditionedSteps.forEach(_function_4);
    }

    private boolean checkAnnotationprocessorCorrect(final MutableMethodDeclaration m, MutableClassDeclaration clazz, final TransformationContext cxt) {
        boolean _not;
        Functions.Function1<AnnotationReference, Boolean> _function;
        Iterable _annotations = m.getAnnotations();
        boolean _exists = IterableExtensions.exists((Iterable)_annotations, (Functions.Function1)(_function = new Functions.Function1<AnnotationReference, Boolean>(){

            public Boolean apply(AnnotationReference it) {
                AnnotationTypeDeclaration _annotationTypeDeclaration = it.getAnnotationTypeDeclaration();
                String _simpleName = _annotationTypeDeclaration.getSimpleName();
                return Objects.equal((Object)_simpleName, (Object)OVERRIDE_METHOD);
            }
        }));
        boolean bl = _not = !_exists;
        if (_not) {
            return true;
        }
        Set<ClassDeclaration> supers = Helper.getDirectSuperClasses((ClassDeclaration)clazz, cxt);
        boolean _isEmpty = supers.isEmpty();
        if (_isEmpty) {
            cxt.addError((Element)clazz, "passe par la");
            return false;
        }
        Functions.Function1<ClassDeclaration, Boolean> _function_1 = new Functions.Function1<ClassDeclaration, Boolean>(){

            public Boolean apply(ClassDeclaration superCl) {
                MethodDeclaration _findMethod = Helper.findMethod(superCl, m, cxt);
                return _findMethod != null;
            }
        };
        return IterableExtensions.exists(supers, (Functions.Function1)_function_1);
    }

    private void constructorsProcessing(MutableClassDeclaration clazz, TransformationContext cxt, String identifier, Map<MutableMethodDeclaration, String> bodies, Map<MethodDeclaration, Set<MethodDeclaration>> dispatchmethod, List<String> inheritList, String className) {
        Iterable _declaredConstructors = clazz.getDeclaredConstructors();
        for (MutableConstructorDeclaration c : _declaredConstructors) {
            boolean _notEquals;
            Expression _body = c.getBody();
            boolean bl = _notEquals = !Objects.equal((Object)_body, null);
            if (!_notEquals) continue;
            cxt.addError((Element)c, "Constructors not supported in aspect. Please consider using the @AspectInitializer annotation instead.");
        }
    }

    private void aspectContextMaker(final @Extension TransformationContext context, final MutableClassDeclaration clazz, final String className, final String identifier) {
        String _qualifiedName = clazz.getQualifiedName();
        String _plus = String.valueOf(_qualifiedName) + className;
        String _plus_1 = String.valueOf(_plus) + CTX_NAME;
        final MutableClassDeclaration holderClass = context.findClass(_plus_1);
        if (holderClass == null) {
            return;
        }
        context.setPrimarySourceElement((MutableElement)holderClass, (Element)clazz);
        holderClass.setVisibility(Visibility.PUBLIC);
        Procedures.Procedure1<MutableConstructorDeclaration> _function = new Procedures.Procedure1<MutableConstructorDeclaration>(){

            public void apply(MutableConstructorDeclaration it) {
                it.setVisibility(Visibility.PRIVATE);
                context.setPrimarySourceElement((MutableElement)it, (Element)clazz);
            }
        };
        holderClass.addConstructor((Procedures.Procedure1)_function);
        Procedures.Procedure1<MutableFieldDeclaration> _function_1 = new Procedures.Procedure1<MutableFieldDeclaration>(){

            public void apply(MutableFieldDeclaration it) {
                it.setVisibility(Visibility.PUBLIC);
                it.setStatic(true);
                it.setFinal(true);
                TypeReference _newTypeReference = context.newTypeReference((Type)holderClass, new TypeReference[0]);
                it.setType(_newTypeReference);
                CompilationStrategy _function = new CompilationStrategy(){

                    public CharSequence compile(CompilationStrategy.CompilationContext it) {
                        StringConcatenation _builder = new StringConcatenation();
                        _builder.append((Object)"new ");
                        String _simpleName = holderClass.getSimpleName();
                        _builder.append((Object)_simpleName, "");
                        _builder.append((Object)"()");
                        return _builder;
                    }
                };
                it.setInitializer(_function);
                context.setPrimarySourceElement((MutableElement)it, (Element)clazz);
            }
        };
        holderClass.addField("INSTANCE", (Procedures.Procedure1)_function_1);
        Procedures.Procedure1<MutableMethodDeclaration> _function_2 = new Procedures.Procedure1<MutableMethodDeclaration>(){

            public void apply(MutableMethodDeclaration it) {
                it.setVisibility(Visibility.PUBLIC);
                it.setStatic(true);
                TypeReference _newTypeReference = context.newTypeReference(identifier, new TypeReference[0]);
                it.addParameter(AspectProcessor.SELF_VAR_NAME, _newTypeReference);
                String _qualifiedName = clazz.getQualifiedName();
                String _plus = String.valueOf(_qualifiedName) + className;
                String _plus_1 = String.valueOf(_plus) + AspectProcessor.PROP_NAME;
                MutableClassDeclaration _findClass = context.findClass(_plus_1);
                TypeReference _newTypeReference_1 = context.newTypeReference((Type)_findClass, new TypeReference[0]);
                it.setReturnType(_newTypeReference_1);
                CompilationStrategy _function = new CompilationStrategy(){

                    public CharSequence compile(CompilationStrategy.CompilationContext it) {
                        StringConcatenation _builder = new StringConcatenation();
                        _builder.append((Object)"\t\t");
                        _builder.append((Object)"if (!INSTANCE.map.containsKey(_self))");
                        _builder.newLine();
                        _builder.append((Object)"\t\t\t");
                        _builder.append((Object)"INSTANCE.map.put(_self, new ");
                        String _qualifiedName = clazz.getQualifiedName();
                        String _plus = String.valueOf(_qualifiedName) + className;
                        String _plus_1 = String.valueOf(_plus) + AspectProcessor.PROP_NAME;
                        _builder.append((Object)_plus_1, "\t\t\t");
                        _builder.append((Object)"());");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"\t\t");
                        _builder.append((Object)"return INSTANCE.map.get(_self);");
                        return _builder;
                    }
                };
                it.setBody(_function);
                context.setPrimarySourceElement((MutableElement)it, (Element)clazz);
            }
        };
        holderClass.addMethod("getSelf", (Procedures.Procedure1)_function_2);
        Procedures.Procedure1<MutableFieldDeclaration> _function_3 = new Procedures.Procedure1<MutableFieldDeclaration>(){

            public void apply(MutableFieldDeclaration it) {
                it.setVisibility(Visibility.PRIVATE);
                it.setStatic(false);
                TypeReference _newTypeReference = context.newTypeReference(identifier, new TypeReference[0]);
                String _qualifiedName = clazz.getQualifiedName();
                String _plus = String.valueOf(_qualifiedName) + className;
                String _plus_1 = String.valueOf(_plus) + AspectProcessor.PROP_NAME;
                MutableClassDeclaration _findClass = context.findClass(_plus_1);
                TypeReference _newTypeReference_1 = context.newTypeReference((Type)_findClass, new TypeReference[0]);
                TypeReference _newTypeReference_2 = context.newTypeReference("java.util.Map", new TypeReference[]{_newTypeReference, _newTypeReference_1});
                it.setType(_newTypeReference_2);
                CompilationStrategy _function = new CompilationStrategy(){

                    public CharSequence compile(CompilationStrategy.CompilationContext it) {
                        StringConcatenation _builder = new StringConcatenation();
                        _builder.append((Object)"new java.util.WeakHashMap<");
                        TypeReference _newTypeReference = context.newTypeReference(identifier, new TypeReference[0]);
                        List _actualTypeArguments = _newTypeReference.getActualTypeArguments();
                        String _mkstring = Helper.mkstring(_actualTypeArguments, ",", "<", ">");
                        String _plus = String.valueOf(identifier) + _mkstring;
                        _builder.append((Object)_plus, "");
                        _builder.append((Object)", ");
                        String _qualifiedName = clazz.getQualifiedName();
                        String _plus_1 = String.valueOf(_qualifiedName) + className;
                        String _plus_2 = String.valueOf(_plus_1) + AspectProcessor.PROP_NAME;
                        _builder.append((Object)_plus_2, "");
                        _builder.append((Object)">()");
                        return _builder;
                    }
                };
                it.setInitializer(_function);
                context.setPrimarySourceElement((MutableElement)it, (Element)clazz);
            }
        };
        holderClass.addField("map", (Procedures.Procedure1)_function_3);
        Procedures.Procedure1<MutableMethodDeclaration> _function_4 = new Procedures.Procedure1<MutableMethodDeclaration>(){

            public void apply(MutableMethodDeclaration it) {
                it.setVisibility(Visibility.PUBLIC);
                it.setStatic(false);
                TypeReference _newTypeReference = context.newTypeReference(identifier, new TypeReference[0]);
                String _qualifiedName = clazz.getQualifiedName();
                String _plus = String.valueOf(_qualifiedName) + className;
                String _plus_1 = String.valueOf(_plus) + AspectProcessor.PROP_NAME;
                MutableClassDeclaration _findClass = context.findClass(_plus_1);
                TypeReference _newTypeReference_1 = context.newTypeReference((Type)_findClass, new TypeReference[0]);
                TypeReference _newTypeReference_2 = context.newTypeReference("java.util.Map", new TypeReference[]{_newTypeReference, _newTypeReference_1});
                it.setReturnType(_newTypeReference_2);
                CompilationStrategy _function = new CompilationStrategy(){

                    public CharSequence compile(CompilationStrategy.CompilationContext it) {
                        StringConcatenation _builder = new StringConcatenation();
                        _builder.append((Object)"return map;");
                        return _builder;
                    }
                };
                it.setBody(_function);
                context.setPrimarySourceElement((MutableElement)it, (Element)clazz);
            }
        };
        holderClass.addMethod("getMap", (Procedures.Procedure1)_function_4);
    }

    private void fieldProcessingMoveField(MutableClassDeclaration clazz, List<MutableFieldDeclaration> toRemove, List<MutableFieldDeclaration> propertyAspect, String className, final @Extension TransformationContext context) {
        String _qualifiedName = clazz.getQualifiedName();
        String _plus = String.valueOf(_qualifiedName) + className;
        String _plus_1 = String.valueOf(_plus) + PROP_NAME;
        MutableClassDeclaration c = context.findClass(_plus_1);
        if (c == null) {
            context.addError((Element)clazz, "Cannot resolve the class to aspectise. Check that the classes to aspectise are not in the same project that your aspects.");
        } else {
            Iterable _declaredFields = clazz.getDeclaredFields();
            for (final MutableFieldDeclaration f : _declaredFields) {
                boolean _notEquals;
                boolean _not;
                boolean _isStatic = f.isStatic();
                boolean bl = _not = !_isStatic;
                if (!_not) continue;
                String _simpleName = f.getSimpleName();
                boolean bl2 = _notEquals = !Objects.equal((Object)_simpleName, (Object)PROP_VAR_NAME);
                if (_notEquals) {
                    boolean _not_1;
                    toRemove.add(f);
                    Iterable _annotations = f.getAnnotations();
                    Functions.Function1<AnnotationReference, Boolean> _function = new Functions.Function1<AnnotationReference, Boolean>(){

                        public Boolean apply(AnnotationReference it) {
                            AnnotationTypeDeclaration _annotationTypeDeclaration = it.getAnnotationTypeDeclaration();
                            String _simpleName = _annotationTypeDeclaration.getSimpleName();
                            return Objects.equal((Object)_simpleName, (Object)"NotAspectProperty");
                        }
                    };
                    boolean _exists = IterableExtensions.exists((Iterable)_annotations, (Functions.Function1)_function);
                    boolean bl3 = _not_1 = !_exists;
                    if (_not_1) {
                        propertyAspect.add(f);
                    }
                    String _simpleName_1 = f.getSimpleName();
                    Procedures.Procedure1<MutableFieldDeclaration> _function_1 = new Procedures.Procedure1<MutableFieldDeclaration>(){

                        public void apply(MutableFieldDeclaration it) {
                            boolean _tripleNotEquals;
                            it.setVisibility(Visibility.PUBLIC);
                            boolean _isStatic = f.isStatic();
                            it.setStatic(_isStatic);
                            boolean _isFinal = f.isFinal();
                            it.setFinal(_isFinal);
                            TypeReference _type = f.getType();
                            it.setType(_type);
                            Expression _initializer = f.getInitializer();
                            boolean bl = _tripleNotEquals = _initializer != null;
                            if (_tripleNotEquals) {
                                Expression _initializer_1 = f.getInitializer();
                                it.setInitializer(_initializer_1);
                            }
                            context.setPrimarySourceElement((MutableElement)it, (Element)f);
                        }
                    };
                    c.addField(_simpleName_1, (Procedures.Procedure1)_function_1);
                    continue;
                }
                String _qualifiedName_1 = clazz.getQualifiedName();
                String _plus_2 = String.valueOf(_qualifiedName_1) + className;
                String _plus_3 = String.valueOf(_plus_2) + PROP_NAME;
                MutableClassDeclaration _findClass = context.findClass(_plus_3);
                TypeReference _newTypeReference = context.newTypeReference((Type)_findClass, new TypeReference[0]);
                f.setType(_newTypeReference);
                f.setStatic(true);
            }
        }
    }

    private void fieldProcessingAddField(final MutableClassDeclaration clazz, final String className, final @Extension TransformationContext context) {
        boolean _not;
        Functions.Function1<MutableFieldDeclaration, Boolean> _function;
        Iterable _declaredFields = clazz.getDeclaredFields();
        boolean _exists = IterableExtensions.exists((Iterable)_declaredFields, (Functions.Function1)(_function = new Functions.Function1<MutableFieldDeclaration, Boolean>(){

            public Boolean apply(MutableFieldDeclaration it) {
                String _simpleName = it.getSimpleName();
                return Objects.equal((Object)_simpleName, (Object)AspectProcessor.PROP_VAR_NAME);
            }
        }));
        boolean bl = _not = !_exists;
        if (_not) {
            String _qualifiedName = clazz.getQualifiedName();
            String _plus = String.valueOf(_qualifiedName) + className;
            String _plus_1 = String.valueOf(_plus) + PROP_NAME;
            MutableClassDeclaration clazzProp = context.findClass(_plus_1);
            if (clazzProp == null) {
                context.addError((Element)clazz, "Cannot resolve the class to aspectise. Check that the classes to aspectise are not in the same project that your aspects.");
            } else {
                Procedures.Procedure1<MutableFieldDeclaration> _function_1 = new Procedures.Procedure1<MutableFieldDeclaration>(){

                    public void apply(MutableFieldDeclaration it) {
                        String _qualifiedName = clazz.getQualifiedName();
                        String _plus = String.valueOf(_qualifiedName) + className;
                        String _plus_1 = String.valueOf(_plus) + AspectProcessor.PROP_NAME;
                        MutableClassDeclaration _findClass = context.findClass(_plus_1);
                        TypeReference _newTypeReference = context.newTypeReference((Type)_findClass, new TypeReference[0]);
                        it.setType(_newTypeReference);
                        it.setStatic(true);
                        it.setVisibility(Visibility.PUBLIC);
                        context.setPrimarySourceElement((MutableElement)it, (Element)clazz);
                    }
                };
                clazz.addField(PROP_VAR_NAME, (Procedures.Procedure1)_function_1);
            }
        }
    }

    private void fieldProcessingAddGetterSetter(MutableClassDeclaration clazz, List<MutableFieldDeclaration> propertyAspect, final String identifier, Map<MutableMethodDeclaration, String> bodies, final @Extension TransformationContext context) {
        for (final MutableFieldDeclaration f : propertyAspect) {
            boolean _not_1;
            boolean _not;
            String _simpleName = f.getSimpleName();
            Procedures.Procedure1<MutableMethodDeclaration> _function = new Procedures.Procedure1<MutableMethodDeclaration>(){

                public void apply(final MutableMethodDeclaration it) {
                    TypeReference _type = f.getType();
                    it.setReturnType(_type);
                    TypeReference _newTypeReference = context.newTypeReference(identifier, new TypeReference[0]);
                    it.addParameter(AspectProcessor.SELF_VAR_NAME, _newTypeReference);
                    context.setPrimarySourceElement((MutableElement)it, (Element)f);
                    Visibility _visibility = f.getVisibility();
                    it.setVisibility(_visibility);
                    Iterable _annotations = f.getAnnotations();
                    Consumer<AnnotationReference> _function = new Consumer<AnnotationReference>(){

                        @Override
                        public void accept(AnnotationReference ann) {
                            it.addAnnotation(ann);
                        }
                    };
                    _annotations.forEach(_function);
                }
            };
            MutableMethodDeclaration get = clazz.addMethod(_simpleName, (Procedures.Procedure1)_function);
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)"try {");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"for (java.lang.reflect.Method m : _self.getClass().getMethods()) {");
            _builder.newLine();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"if (m.getName().equals(\"");
            if (Objects.equal((Object)f.getType().getSimpleName(), (Object)"boolean") || Objects.equal((Object)f.getType().getSimpleName(), (Object)"Boolean")) {
                _builder.append((Object)"is");
            } else {
                _builder.append((Object)"get");
            }
            String _simpleName_1 = f.getSimpleName();
            String _substring = _simpleName_1.substring(0, 1);
            String _upperCase = _substring.toUpperCase();
            String _simpleName_2 = f.getSimpleName();
            String _substring_1 = _simpleName_2.substring(1);
            String _plus = String.valueOf(_upperCase) + _substring_1;
            _builder.append((Object)_plus, "\t\t");
            _builder.append((Object)"\") &&");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t\t");
            _builder.append((Object)"m.getParameterTypes().length == 0) {");
            _builder.newLine();
            _builder.append((Object)"\t\t\t\t");
            _builder.append((Object)"Object ret = m.invoke(_self);");
            _builder.newLine();
            _builder.append((Object)"\t\t\t\t");
            _builder.append((Object)"if (ret != null) {");
            _builder.newLine();
            _builder.append((Object)"\t\t\t\t\t");
            _builder.append((Object)"return (");
            TypeReference _type = f.getType();
            Type _type_1 = _type.getType();
            String _qualifiedName = _type_1.getQualifiedName();
            _builder.append((Object)_qualifiedName, "\t\t\t\t\t");
            _builder.append((Object)") ret;");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t\t\t");
            _builder.append((Object)"}");
            TypeReference _type_2 = f.getType();
            boolean _isPrimitive = _type_2.isPrimitive();
            boolean bl = _not = !_isPrimitive;
            if (_not) {
                _builder.append((Object)" else {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t\t\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"return null;");
                _builder.newLine();
                _builder.append((Object)"\t\t\t\t");
                _builder.append((Object)"}");
                _builder.newLine();
            }
            _builder.append((Object)"\t\t");
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.append((Object)"} catch (Exception e) {");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"// Chut !");
            _builder.newLine();
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.append((Object)"return ");
            _builder.append((Object)PROP_VAR_NAME, "");
            _builder.append((Object)".");
            String _simpleName_3 = f.getSimpleName();
            _builder.append((Object)_simpleName_3, "");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
            String gemocHackGetter = _builder.toString();
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append((Object)gemocHackGetter, "");
            bodies.put(get, _builder_1.toString());
            StringConcatenation _builder_2 = new StringConcatenation();
            _builder_2.append((Object)"try {");
            _builder_2.newLine();
            _builder_2.append((Object)"\t");
            _builder_2.append((Object)"for (java.lang.reflect.Method m : _self.getClass().getMethods()) {");
            _builder_2.newLine();
            _builder_2.append((Object)"\t\t");
            _builder_2.append((Object)"if (m.getName().equals(\"set");
            String _simpleName_4 = f.getSimpleName();
            String _substring_2 = _simpleName_4.substring(0, 1);
            String _upperCase_1 = _substring_2.toUpperCase();
            String _simpleName_5 = f.getSimpleName();
            String _substring_3 = _simpleName_5.substring(1);
            String _plus_1 = String.valueOf(_upperCase_1) + _substring_3;
            _builder_2.append((Object)_plus_1, "\t\t");
            _builder_2.append((Object)"\")");
            _builder_2.newLineIfNotEmpty();
            _builder_2.append((Object)"\t\t\t\t");
            _builder_2.append((Object)"&& m.getParameterTypes().length == 1) {");
            _builder_2.newLine();
            _builder_2.append((Object)"\t\t\t");
            _builder_2.append((Object)"m.invoke(_self, ");
            String _simpleName_6 = f.getSimpleName();
            _builder_2.append((Object)_simpleName_6, "\t\t\t");
            _builder_2.append((Object)");");
            _builder_2.newLineIfNotEmpty();
            _builder_2.append((Object)"\t\t\t");
            _builder_2.append((Object)"setterCalled = true;");
            _builder_2.newLine();
            _builder_2.append((Object)"\t\t");
            _builder_2.append((Object)"}");
            _builder_2.newLine();
            _builder_2.append((Object)"\t");
            _builder_2.append((Object)"}");
            _builder_2.newLine();
            _builder_2.append((Object)"} catch (Exception e) {");
            _builder_2.newLine();
            _builder_2.append((Object)"\t");
            _builder_2.append((Object)"// Chut !");
            _builder_2.newLine();
            _builder_2.append((Object)"}");
            _builder_2.newLine();
            String gemocHackSetter = _builder_2.toString();
            boolean _isFinal = f.isFinal();
            boolean bl2 = _not_1 = !_isFinal;
            if (!_not_1) continue;
            String _simpleName_7 = f.getSimpleName();
            Procedures.Procedure1<MutableMethodDeclaration> _function_1 = new Procedures.Procedure1<MutableMethodDeclaration>(){

                public void apply(final MutableMethodDeclaration it) {
                    TypeReference _newTypeReference = context.newTypeReference("void", new TypeReference[0]);
                    it.setReturnType(_newTypeReference);
                    TypeReference _newTypeReference_1 = context.newTypeReference(identifier, new TypeReference[0]);
                    it.addParameter(AspectProcessor.SELF_VAR_NAME, _newTypeReference_1);
                    String _simpleName = f.getSimpleName();
                    TypeReference _type = f.getType();
                    it.addParameter(_simpleName, _type);
                    Visibility _visibility = f.getVisibility();
                    it.setVisibility(_visibility);
                    context.setPrimarySourceElement((MutableElement)it, (Element)f);
                    Iterable _annotations = f.getAnnotations();
                    Consumer<AnnotationReference> _function = new Consumer<AnnotationReference>(){

                        @Override
                        public void accept(AnnotationReference ann) {
                            it.addAnnotation(ann);
                        }
                    };
                    _annotations.forEach(_function);
                }
            };
            MutableMethodDeclaration set = clazz.addMethod(_simpleName_7, (Procedures.Procedure1)_function_1);
            StringConcatenation _builder_3 = new StringConcatenation();
            _builder_3.append((Object)"boolean setterCalled = false;");
            _builder_3.newLine();
            _builder_3.append((Object)gemocHackSetter, "");
            _builder_3.newLineIfNotEmpty();
            _builder_3.append((Object)"if (!setterCalled) {");
            _builder_3.newLine();
            _builder_3.append((Object)"\t");
            _builder_3.append((Object)PROP_VAR_NAME, "\t");
            _builder_3.append((Object)".");
            String _simpleName_8 = f.getSimpleName();
            _builder_3.append((Object)_simpleName_8, "\t");
            _builder_3.append((Object)" = ");
            String _simpleName_9 = f.getSimpleName();
            _builder_3.append((Object)_simpleName_9, "\t");
            _builder_3.append((Object)";");
            _builder_3.newLineIfNotEmpty();
            _builder_3.append((Object)"}");
            _builder_3.newLine();
            bodies.put(set, _builder_3.toString());
        }
    }

    private void fieldsProcessing(@Extension TransformationContext context, MutableClassDeclaration clazz, String className, String identifier, Map<MutableMethodDeclaration, String> bodies) {
        ArrayList toRemove = CollectionLiterals.newArrayList((Object[])new MutableFieldDeclaration[0]);
        ArrayList propertyAspect = CollectionLiterals.newArrayList((Object[])new MutableFieldDeclaration[0]);
        this.fieldProcessingMoveField(clazz, toRemove, propertyAspect, className, context);
        this.fieldProcessingAddGetterSetter(clazz, propertyAspect, identifier, bodies, context);
        for (MutableFieldDeclaration f : toRemove) {
            f.remove();
        }
    }

    private void initDispatchmethod(Map<MutableClassDeclaration, List<ClassDeclaration>> superclass, Map<MethodDeclaration, Set<MethodDeclaration>> dispatchmethod, TransformationContext context) {
        Collection<Object> _get;
        int i = 0;
        Set<MutableClassDeclaration> _keySet = superclass.keySet();
        for (MutableClassDeclaration cl : _keySet) {
            ArrayList<Object> clazzes = new ArrayList<Object>();
            clazzes.add(cl);
            _get = superclass.get(cl);
            clazzes.addAll(_get);
            HashMap dispatchs = CollectionLiterals.newHashMap((Pair[])new Pair[0]);
            for (ClassDeclaration classDeclaration : clazzes) {
                Iterable _declaredMethods = classDeclaration.getDeclaredMethods();
                Iterator iterator = _declaredMethods.iterator();
                while (iterator.hasNext()) {
                    MethodDeclaration m = (MethodDeclaration)iterator.next();
                    String _simpleName = m.getSimpleName();
                    String _plus = String.valueOf(_simpleName) + "__";
                    Iterable _parameters = m.getParameters();
                    int _size = IterableExtensions.size((Iterable)_parameters);
                    String mname = String.valueOf(_plus) + Integer.valueOf(_size);
                    LinkedHashSet<MethodDeclaration> v = (LinkedHashSet<MethodDeclaration>)dispatchs.get(mname);
                    if (v == null) {
                        LinkedHashSet<MethodDeclaration> _linkedHashSet;
                        v = _linkedHashSet = new LinkedHashSet<MethodDeclaration>();
                        dispatchs.put(mname, v);
                    }
                    v.add(m);
                }
            }
            Set set = dispatchs.keySet();
            for (String key : set) {
                int _plus;
                boolean _greaterThan;
                Set res = (Set)dispatchs.get(key);
                int _size = res.size();
                boolean bl = _greaterThan = _size > 1;
                if (!_greaterThan) continue;
                int _size_1 = res.size();
                i = _plus = i + _size_1;
                for (MethodDeclaration m_1 : res) {
                    boolean _tripleEquals;
                    Set<MethodDeclaration> _get_1 = dispatchmethod.get(m_1);
                    boolean bl2 = _tripleEquals = _get_1 == null;
                    if (_tripleEquals) {
                        dispatchmethod.put(m_1, res);
                        continue;
                    }
                    Set<MethodDeclaration> _get_2 = dispatchmethod.get(m_1);
                    _get_2.addAll(res);
                }
            }
        }
        Set<MethodDeclaration> _keySet_1 = dispatchmethod.keySet();
        for (MethodDeclaration m : _keySet_1) {
            _get = dispatchmethod.get(m);
            SortMethod _sortMethod = new SortMethod(context);
            List list = IterableExtensions.sortWith(_get, (Comparator)_sortMethod);
            Set<MethodDeclaration> _get_1 = dispatchmethod.get(m);
            _get_1.clear();
            Set<MethodDeclaration> _get_2 = dispatchmethod.get(m);
            _get_2.addAll(list);
        }
    }

    private void initSuperclass(List<? extends MutableClassDeclaration> annotedClasses, TransformationContext context, Map<MutableClassDeclaration, List<ClassDeclaration>> superclass) {
        for (MutableClassDeclaration mutableClassDeclaration : annotedClasses) {
            boolean _greaterThan;
            ArrayList<ClassDeclaration> ext = new ArrayList<ClassDeclaration>();
            Helper.getSuperClass(ext, (ClassDeclaration)mutableClassDeclaration, context);
            int _size = ext.size();
            boolean bl = _greaterThan = _size > 0;
            if (!_greaterThan) continue;
            superclass.put(mutableClassDeclaration, ext);
        }
        LinkedHashSet<ClassDeclaration> linkedHashSet = new LinkedHashSet<ClassDeclaration>();
        Set<MutableClassDeclaration> _keySet = superclass.keySet();
        for (MutableClassDeclaration child : _keySet) {
            List<ClassDeclaration> _get = superclass.get(child);
            linkedHashSet.addAll(_get);
        }
        for (ClassDeclaration p : linkedHashSet) {
            superclass.remove(p);
        }
    }
}

