/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.io.IOException;
import javax.servlet.DispatcherType;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Wrapper;
import org.apache.catalina.comet.CometEvent;
import org.apache.catalina.connector.ClientAbortException;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardHostValve;
import org.apache.catalina.deploy.ErrorPage;
import org.apache.catalina.valves.ValveBase;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.buf.MessageBytes;

final class StandardContextValve
extends ValveBase {
    private static final Log log = LogFactory.getLog(StandardHostValve.class);
    private static final String info = "org.apache.catalina.core.StandardContextValve/1.0";
    private StandardContext context = null;

    public StandardContextValve() {
        super(true);
    }

    @Override
    public String getInfo() {
        return info;
    }

    @Override
    public void setContainer(Container container) {
        super.setContainer(container);
        this.context = (StandardContext)container;
    }

    @Override
    public final void invoke(Request request, Response response) throws IOException, ServletException {
        Wrapper wrapper;
        MessageBytes requestPathMB = request.getRequestPathMB();
        if (requestPathMB.startsWithIgnoreCase("/META-INF/", 0) || requestPathMB.equalsIgnoreCase("/META-INF") || requestPathMB.startsWithIgnoreCase("/WEB-INF/", 0) || requestPathMB.equalsIgnoreCase("/WEB-INF")) {
            this.error(request, response, 404);
            return;
        }
        boolean reloaded = false;
        while (this.context.getPaused()) {
            reloaded = true;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {}
        }
        if (reloaded && this.context.getLoader() != null && this.context.getLoader().getClassLoader() != null) {
            Thread.currentThread().setContextClassLoader(this.context.getLoader().getClassLoader());
        }
        if ((wrapper = request.getWrapper()) == null) {
            this.error(request, response, 404);
            return;
        }
        if (wrapper.isUnavailable() && (wrapper = (Wrapper)this.container.findChild(wrapper.getName())) == null) {
            this.error(request, response, 404);
            return;
        }
        try {
            response.sendAcknowledgement();
        }
        catch (IOException ioe) {
            this.container.getLogger().error((Object)sm.getString("standardContextValve.acknowledgeException"), (Throwable)ioe);
            request.setAttribute("javax.servlet.error.exception", ioe);
            this.error(request, response, 500);
            return;
        }
        boolean asyncAtStart = request.isAsync();
        if (asyncAtStart || this.context.fireRequestInitEvent((ServletRequest)request)) {
            StandardContext c;
            if (request.isAsyncSupported()) {
                request.setAsyncSupported(wrapper.getPipeline().isAsyncSupported());
            }
            wrapper.getPipeline().getFirst().invoke(request, response);
            if (!(request.isAsync() || asyncAtStart && request.getAttribute("javax.servlet.error.exception") != null || (c = this.context) == null || !c.getState().isAvailable())) {
                response.setSuspended(false);
                Throwable t = (Throwable)request.getAttribute("javax.servlet.error.exception");
                if (t != null) {
                    this.throwable(request, response, t);
                } else {
                    this.status(request, response);
                }
                this.context.fireRequestDestroyEvent((ServletRequest)request);
            }
        }
    }

    @Override
    public final void event(Request request, Response response, CometEvent event) throws IOException, ServletException {
        Wrapper wrapper = request.getWrapper();
        wrapper.getPipeline().getFirst().event(request, response, event);
        response.setSuspended(false);
        Throwable t = (Throwable)request.getAttribute("javax.servlet.error.exception");
        if (t != null) {
            this.throwable(request, response, t);
        } else {
            this.status(request, response);
        }
    }

    private void error(Request request, Response response, int status) {
        this.context.fireRequestInitEvent((ServletRequest)request);
        try {
            response.sendError(status);
        }
        catch (IllegalStateException e) {
        }
        catch (IOException e) {
            // empty catch block
        }
        response.setSuspended(false);
        this.status(request, response);
        this.context.fireRequestDestroyEvent((ServletRequest)request);
    }

    private void status(Request request, Response response) {
        int statusCode = response.getStatus();
        Context context = request.getContext();
        if (context == null) {
            return;
        }
        if (!response.isError()) {
            return;
        }
        ErrorPage errorPage = context.findErrorPage(statusCode);
        if (errorPage != null) {
            response.setAppCommitted(false);
            request.setAttribute("javax.servlet.error.status_code", statusCode);
            String message = response.getMessage();
            if (message == null) {
                message = "";
            }
            request.setAttribute("javax.servlet.error.message", message);
            request.setAttribute("org.apache.catalina.core.DISPATCHER_REQUEST_PATH", errorPage.getLocation());
            request.setAttribute("org.apache.catalina.core.DISPATCHER_TYPE", DispatcherType.ERROR);
            Wrapper wrapper = request.getWrapper();
            if (wrapper != null) {
                request.setAttribute("javax.servlet.error.servlet_name", wrapper.getName());
            }
            request.setAttribute("javax.servlet.error.request_uri", request.getRequestURI());
            if (this.custom(request, response, errorPage)) {
                try {
                    response.flushBuffer();
                }
                catch (ClientAbortException e) {
                }
                catch (IOException e) {
                    this.container.getLogger().warn((Object)("Exception Processing " + errorPage), (Throwable)e);
                }
            }
        }
    }

    private void throwable(Request request, Response response, Throwable throwable) {
        Context context = request.getContext();
        if (context == null) {
            return;
        }
        Throwable realError = throwable;
        if (realError instanceof ServletException && (realError = ((ServletException)realError).getRootCause()) == null) {
            realError = throwable;
        }
        if (realError instanceof ClientAbortException) {
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("standardHost.clientAbort", new Object[]{realError.getCause().getMessage()}));
            }
            return;
        }
        ErrorPage errorPage = StandardContextValve.findErrorPage(context, throwable);
        if (errorPage == null && realError != throwable) {
            errorPage = StandardContextValve.findErrorPage(context, realError);
        }
        if (errorPage != null) {
            response.setAppCommitted(false);
            request.setAttribute("org.apache.catalina.core.DISPATCHER_REQUEST_PATH", errorPage.getLocation());
            request.setAttribute("org.apache.catalina.core.DISPATCHER_TYPE", DispatcherType.ERROR);
            request.setAttribute("javax.servlet.error.status_code", new Integer(500));
            request.setAttribute("javax.servlet.error.message", throwable.getMessage());
            request.setAttribute("javax.servlet.error.exception", realError);
            Wrapper wrapper = request.getWrapper();
            if (wrapper != null) {
                request.setAttribute("javax.servlet.error.servlet_name", wrapper.getName());
            }
            request.setAttribute("javax.servlet.error.request_uri", request.getRequestURI());
            request.setAttribute("javax.servlet.error.exception_type", realError.getClass());
            if (this.custom(request, response, errorPage)) {
                try {
                    response.flushBuffer();
                }
                catch (IOException e) {
                    this.container.getLogger().warn((Object)("Exception Processing " + errorPage), (Throwable)e);
                }
            }
        } else {
            response.setStatus(500);
            response.setError();
            this.status(request, response);
        }
    }

    private boolean custom(Request request, Response response, ErrorPage errorPage) {
        if (this.container.getLogger().isDebugEnabled()) {
            this.container.getLogger().debug((Object)("Processing " + errorPage));
        }
        request.setPathInfo(errorPage.getLocation());
        try {
            ServletContext servletContext = request.getContext().getServletContext();
            RequestDispatcher rd = servletContext.getRequestDispatcher(errorPage.getLocation());
            if (response.isCommitted()) {
                rd.include((ServletRequest)request.getRequest(), (ServletResponse)response.getResponse());
            } else {
                response.resetBuffer(true);
                rd.forward((ServletRequest)request.getRequest(), (ServletResponse)response.getResponse());
                response.setSuspended(false);
            }
            return true;
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable((Throwable)t);
            this.container.getLogger().error((Object)("Exception Processing " + errorPage), t);
            return false;
        }
    }

    private static ErrorPage findErrorPage(Context context, Throwable exception) {
        if (exception == null) {
            return null;
        }
        Class<?> clazz = exception.getClass();
        String name = clazz.getName();
        while (!Object.class.equals(clazz)) {
            ErrorPage errorPage = context.findErrorPage(name);
            if (errorPage != null) {
                return errorPage;
            }
            if ((clazz = clazz.getSuperclass()) == null) break;
            name = clazz.getName();
        }
        return null;
    }
}

