/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11.filters;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;

public class FlushableGZIPOutputStream
extends GZIPOutputStream {
    private static final byte[] EMPTYBYTEARRAY = new byte[0];
    private boolean hasData = false;

    public FlushableGZIPOutputStream(OutputStream os) throws IOException {
        super(os);
    }

    public synchronized void write(byte[] bytes, int i, int i1) throws IOException {
        super.write(bytes, i, i1);
        this.hasData = true;
    }

    public synchronized void write(int i) throws IOException {
        super.write(i);
        this.hasData = true;
    }

    public synchronized void write(byte[] bytes) throws IOException {
        super.write(bytes);
        this.hasData = true;
    }

    public synchronized void flush() throws IOException {
        if (!this.hasData) {
            return;
        }
        if (!this.def.finished()) {
            this.def.setInput(EMPTYBYTEARRAY, 0, 0);
            this.def.setLevel(0);
            this.deflate();
            this.def.setLevel(-1);
            this.deflate();
            this.out.flush();
        }
        this.hasData = false;
    }

    protected void deflate() throws IOException {
        int len;
        do {
            if ((len = this.def.deflate(this.buf, 0, this.buf.length)) <= 0) continue;
            this.out.write(this.buf, 0, len);
        } while (len != 0);
    }
}

