/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.app.framework;

import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.DisabledInfo;
import org.eclipse.osgi.service.resolver.PlatformAdmin;
import org.eclipse.osgi.service.resolver.State;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public final class PlatformUtils {
    private PlatformUtils() {
    }

    public static String getStateName(Bundle bundle) {
        int state = bundle.getState();
        switch (state) {
            case 1: {
                return "UNINSTALLED";
            }
            case 2: {
                return PlatformUtils.isDisabled(bundle) ? "<DISABLED>" : "INSTALLED";
            }
            case 4: {
                return "RESOLVED";
            }
            case 8: {
                return "STARTING";
            }
            case 16: {
                return "STOPPING";
            }
            case 32: {
                return "ACTIVE";
            }
        }
        return Integer.toHexString(state);
    }

    private static boolean isDisabled(Bundle bundle) {
        Bundle appFrameworkBundle = FrameworkUtil.getBundle(PlatformUtils.class);
        BundleContext appFrameworkBundleContext = appFrameworkBundle.getBundleContext();
        boolean disabled = false;
        ServiceReference platformAdminRef = null;
        try {
            BundleDescription bundleDesc;
            State state;
            DisabledInfo[] disabledInfos;
            PlatformAdmin platAdmin;
            platformAdminRef = appFrameworkBundleContext.getServiceReference(PlatformAdmin.class);
            if (platformAdminRef != null && (platAdmin = (PlatformAdmin)appFrameworkBundleContext.getService(platformAdminRef)) != null && (disabledInfos = (state = platAdmin.getState(false)).getDisabledInfos(bundleDesc = state.getBundle(bundle.getBundleId()))) != null && disabledInfos.length != 0) {
                disabled = true;
            }
        }
        finally {
            if (platformAdminRef != null) {
                appFrameworkBundleContext.ungetService(platformAdminRef);
            }
        }
        return disabled;
    }
}

