/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tooling.simplemap.model.triggers.parent;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.gmfgraph.ChildAccess;
import org.eclipse.gmf.gmfgraph.Compartment;
import org.eclipse.gmf.gmfgraph.Connection;
import org.eclipse.gmf.gmfgraph.DecorationFigure;
import org.eclipse.gmf.gmfgraph.DiagramElement;
import org.eclipse.gmf.gmfgraph.Figure;
import org.eclipse.gmf.gmfgraph.FigureDescriptor;
import org.eclipse.gmf.gmfgraph.Node;
import org.eclipse.gmf.gmfgraph.PolylineConnection;
import org.eclipse.gmf.mappings.CompartmentMapping;
import org.eclipse.gmf.mappings.LabelMapping;
import org.eclipse.gmf.mappings.LinkMapping;
import org.eclipse.gmf.mappings.NodeMapping;
import org.eclipse.gmf.mappings.NodeReference;
import org.eclipse.gmf.tooldef.AbstractTool;
import org.eclipse.gmf.tooling.simplemap.model.triggers.AbstractTrigger;
import org.eclipse.gmf.tooling.simplemap.simplemappings.SimpleChildNode;
import org.eclipse.gmf.tooling.simplemap.simplemappings.SimpleChildReference;
import org.eclipse.gmf.tooling.simplemap.simplemappings.SimpleCompartment;
import org.eclipse.gmf.tooling.simplemap.simplemappings.SimpleLinkMapping;
import org.eclipse.gmf.tooling.simplemap.simplemappings.SimpleNode;
import org.eclipse.gmf.tooling.simplemap.simplemappings.SimpleSubNode;

public class RemoveChildNodeTrigger
extends AbstractTrigger {
    private List<SimpleChildNode> removedNodes = new ArrayList<SimpleChildNode>();

    public RemoveChildNodeTrigger(TransactionalEditingDomain domain, SimpleChildNode removedNode) {
        super(domain);
        this.removedNodes.add(removedNode);
    }

    public RemoveChildNodeTrigger(TransactionalEditingDomain domain, List<SimpleChildNode> removedNodes) {
        super(domain);
        this.removedNodes.addAll(removedNodes);
    }

    @Override
    public void executeTrigger() {
        for (SimpleChildNode removedNode : this.removedNodes) {
            this.removeChildNode(removedNode);
        }
    }

    private void removeChildNode(SimpleChildNode removedNode) {
        if (removedNode instanceof SimpleChildReference) {
            this.removeSimpleChildReference((SimpleChildReference)removedNode);
        }
        if (removedNode instanceof SimpleNode) {
            this.removeSimpleNode((SimpleNode)removedNode);
        }
        if (removedNode instanceof SimpleCompartment) {
            this.removeCompartment((SimpleCompartment)removedNode);
        }
        if (removedNode instanceof SimpleLinkMapping) {
            this.removeLinkMapping((SimpleLinkMapping)removedNode);
        }
    }

    private void removeSimpleNode(SimpleNode removedNode) {
        NodeReference nodeReferenceToRemove;
        if (removedNode instanceof SimpleSubNode) {
            for (SimpleChildNode childNode : ((SimpleSubNode)removedNode).getChildren()) {
                this.removeChildNode(childNode);
            }
        }
        if ((nodeReferenceToRemove = removedNode.getNodeReference()) != null && nodeReferenceToRemove.eIsProxy()) {
            nodeReferenceToRemove = (NodeReference)EcoreUtil.resolve((EObject)nodeReferenceToRemove, (ResourceSet)this.getDomain().getResourceSet());
        }
        AbstractTool toolToRemove = null;
        NodeMapping nodeMappingToRemove = null;
        if (nodeReferenceToRemove != null && nodeReferenceToRemove.getChild() != null) {
            nodeMappingToRemove = nodeReferenceToRemove.getChild();
            toolToRemove = nodeMappingToRemove.getTool();
        }
        List<DiagramElement> diagramElementsToRemove = this.collectDiagramElementsToRemove(removedNode);
        ArrayList<FigureDescriptor> figureDescToRemove = new ArrayList<FigureDescriptor>();
        for (DiagramElement diagramElement : diagramElementsToRemove) {
            if (diagramElement.getFigure() == null) continue;
            figureDescToRemove.add(diagramElement.getFigure());
        }
        for (FigureDescriptor figDesc : figureDescToRemove) {
            EcoreUtil.delete((EObject)figDesc);
        }
        for (DiagramElement diagramElement : diagramElementsToRemove) {
            EcoreUtil.delete((EObject)diagramElement);
        }
        if (toolToRemove != null && this.canRemove((EObject)toolToRemove)) {
            EcoreUtil.delete((EObject)toolToRemove);
        }
        if (nodeMappingToRemove != null) {
            EcoreUtil.delete((EObject)nodeMappingToRemove);
        }
        if (nodeReferenceToRemove != null) {
            EcoreUtil.delete((EObject)nodeReferenceToRemove);
        }
    }

    private void removeSimpleChildReference(SimpleChildReference removedNode) {
        NodeReference nodeReferenceToRemove = removedNode.getNodeReference();
        if (nodeReferenceToRemove != null && nodeReferenceToRemove.eIsProxy()) {
            nodeReferenceToRemove = (NodeReference)EcoreUtil.resolve((EObject)nodeReferenceToRemove, (ResourceSet)this.getDomain().getResourceSet());
        }
        if (nodeReferenceToRemove != null) {
            EcoreUtil.delete((EObject)nodeReferenceToRemove);
        }
    }

    private List<DiagramElement> collectDiagramElementsToRemove(SimpleNode removedNode) {
        NodeMapping nodeMapping;
        ArrayList<DiagramElement> diagramElementsToRemove = new ArrayList<DiagramElement>();
        NodeReference nodeReferenceToRemove = removedNode.getNodeReference();
        if (nodeReferenceToRemove == null) {
            return diagramElementsToRemove;
        }
        if (nodeReferenceToRemove.eIsProxy()) {
            nodeReferenceToRemove = (NodeReference)EcoreUtil.resolve((EObject)nodeReferenceToRemove, (ResourceSet)this.getDomain().getResourceSet());
        }
        if ((nodeMapping = nodeReferenceToRemove.getChild()) != null) {
            Node nodeToRemove = nodeMapping.getDiagramNode();
            if (nodeToRemove != null && this.canRemove((EObject)nodeToRemove)) {
                diagramElementsToRemove.add((DiagramElement)nodeToRemove);
            }
            for (LabelMapping labelMapping : nodeMapping.getLabelMappings()) {
                if (labelMapping.getDiagramLabel() == null || !this.canRemove((EObject)labelMapping.getDiagramLabel())) continue;
                diagramElementsToRemove.add((DiagramElement)labelMapping.getDiagramLabel());
            }
        }
        return diagramElementsToRemove;
    }

    private List<DiagramElement> collectDiagramElementsToRemove(SimpleLinkMapping removedLinkMapping) {
        ArrayList<DiagramElement> diagramElementsToRemove = new ArrayList<DiagramElement>();
        LinkMapping linkMapping = removedLinkMapping.getLinkMapping();
        if (linkMapping != null) {
            Connection connectionToRemove = linkMapping.getDiagramLink();
            if (connectionToRemove != null && this.canRemove((EObject)connectionToRemove)) {
                diagramElementsToRemove.add((DiagramElement)connectionToRemove);
            }
            for (LabelMapping labelMapping : linkMapping.getLabelMappings()) {
                if (labelMapping.getDiagramLabel() == null || !this.canRemove((EObject)labelMapping.getDiagramLabel())) continue;
                diagramElementsToRemove.add((DiagramElement)labelMapping.getDiagramLabel());
            }
        }
        return diagramElementsToRemove;
    }

    private void removeCompartment(SimpleCompartment removedCompartment) {
        Compartment compartmentToRemove;
        for (SimpleChildNode childNode : removedCompartment.getChildren()) {
            this.removeChildNode(childNode);
        }
        CompartmentMapping compartmentMappingToRemove = removedCompartment.getCompartmentMapping();
        if (compartmentMappingToRemove.eIsProxy()) {
            compartmentMappingToRemove = (CompartmentMapping)EcoreUtil.resolve((EObject)compartmentMappingToRemove, (ResourceSet)this.getDomain().getResourceSet());
        }
        Compartment compartment = compartmentToRemove = compartmentMappingToRemove != null ? compartmentMappingToRemove.getCompartment() : null;
        if (compartmentToRemove != null && this.canRemove((EObject)compartmentToRemove)) {
            ChildAccess accessorToRemove;
            FigureDescriptor labelFigDesToRemove = compartmentToRemove != null ? compartmentToRemove.getFigure() : null;
            ChildAccess childAccess = accessorToRemove = compartmentToRemove != null ? compartmentToRemove.getAccessor() : null;
            if (labelFigDesToRemove != null && this.canRemove((EObject)labelFigDesToRemove)) {
                EcoreUtil.delete((EObject)labelFigDesToRemove);
            }
            if (accessorToRemove != null && this.canRemove((EObject)accessorToRemove)) {
                Figure compartmentFigDesToRemove;
                Figure figure = compartmentFigDesToRemove = accessorToRemove != null ? accessorToRemove.getFigure() : null;
                if (compartmentFigDesToRemove != null) {
                    EcoreUtil.delete((EObject)compartmentFigDesToRemove);
                }
                EcoreUtil.delete((EObject)accessorToRemove);
            }
            EcoreUtil.delete((EObject)compartmentToRemove);
        }
        if (compartmentMappingToRemove != null) {
            EcoreUtil.delete((EObject)compartmentMappingToRemove);
        }
    }

    private void removeLinkMapping(SimpleLinkMapping removedLinkMapping) {
        AbstractTool toolToRemove = removedLinkMapping.getTool();
        LinkMapping linkMappingToRemove = removedLinkMapping.getLinkMapping();
        List<DiagramElement> diagramElementsToRemove = this.collectDiagramElementsToRemove(removedLinkMapping);
        ArrayList<FigureDescriptor> figureDescToRemove = new ArrayList<FigureDescriptor>();
        DecorationFigure targetDecorationToRemove = null;
        DecorationFigure sourceDecorationToRemove = null;
        for (DiagramElement diagramElement : diagramElementsToRemove) {
            if (diagramElement.getFigure() == null) continue;
            figureDescToRemove.add(diagramElement.getFigure());
            if (!(diagramElement.getFigure().getActualFigure() instanceof PolylineConnection)) continue;
            targetDecorationToRemove = ((PolylineConnection)diagramElement.getFigure().getActualFigure()).getTargetDecoration();
            sourceDecorationToRemove = ((PolylineConnection)diagramElement.getFigure().getActualFigure()).getSourceDecoration();
        }
        for (FigureDescriptor figDesc : figureDescToRemove) {
            EcoreUtil.delete((EObject)figDesc);
        }
        for (DiagramElement diagramElement : diagramElementsToRemove) {
            EcoreUtil.delete((EObject)diagramElement);
        }
        if (toolToRemove != null && this.canRemove((EObject)toolToRemove)) {
            EcoreUtil.delete((EObject)toolToRemove);
        }
        if (linkMappingToRemove != null) {
            EcoreUtil.delete((EObject)linkMappingToRemove);
        }
        if (targetDecorationToRemove != null) {
            EcoreUtil.delete(targetDecorationToRemove);
        }
        if (sourceDecorationToRemove != null) {
            EcoreUtil.delete(sourceDecorationToRemove);
        }
    }
}

