/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.internal.editor.handler;

import java.util.Collections;
import java.util.Set;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.view.internal.editor.handler.ControlGenerator;
import org.eclipse.emf.ecp.view.internal.editor.handler.SelectAttributesWizard;
import org.eclipse.emf.ecp.view.spi.model.VContainer;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.model.VView;
import org.eclipse.emf.ecp.view.spi.treemasterdetail.ui.swt.MasterDetailAction;
import org.eclipse.emf.edit.command.ChangeCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class GenerateControlsHandler
extends MasterDetailAction {
    public void execute(EObject object) {
        CallbackFeatureSupplier callBack = new CallbackFeatureSupplier(){

            @Override
            public Set<EStructuralFeature> get(VView view) {
                SelectAttributesWizard selectAttributesWizard;
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                WizardDialog sad = new WizardDialog(shell, (IWizard)(selectAttributesWizard = new SelectAttributesWizard(view)));
                int result = sad.open();
                if (result == 0) {
                    return selectAttributesWizard.getSelectedFeatures();
                }
                return Collections.emptySet();
            }
        };
        this.execute(object, callBack);
    }

    void execute(final EObject vElement, CallbackFeatureSupplier featureSupplier) {
        if (!VView.class.isInstance(vElement) && !VContainer.class.isInstance(vElement)) {
            return;
        }
        VView view = this.getView(vElement);
        if (view == null) {
            return;
        }
        final EClass rootEClass = view.getRootEClass();
        final Set<EStructuralFeature> featuresToAdd = featureSupplier.get(view);
        if (featuresToAdd.isEmpty()) {
            return;
        }
        AdapterFactoryEditingDomain.getEditingDomainFor((EObject)view).getCommandStack().execute((Command)new ChangeCommand((Notifier)view){

            protected void doExecute() {
                ControlGenerator.addControls(rootEClass, (VElement)vElement, featuresToAdd);
            }
        });
    }

    private VView getView(EObject object) {
        while (!(object instanceof VView)) {
            if ((object = object.eContainer()) != null) continue;
            return null;
        }
        return (VView)object;
    }

    public boolean shouldShow(EObject object) {
        if (object == null) {
            return false;
        }
        return object instanceof VView || object instanceof VContainer;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Object selection = ((IStructuredSelection)HandlerUtil.getActiveMenuSelection((ExecutionEvent)event)).getFirstElement();
        if (selection == null || !(selection instanceof EObject)) {
            return null;
        }
        this.execute((EObject)selection);
        return null;
    }

    static interface CallbackFeatureSupplier {
        public Set<EStructuralFeature> get(VView var1);
    }
}

