/*******************************************************************************
 * Copyright (c) 2011-2015 EclipseSource Muenchen GmbH and others.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Johannes Faltermeier - initial API and implementation
 * Clemens Elflein - initial implementation
 ******************************************************************************/
package org.eclipse.emfforms.internal.swt.treemasterdetail;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecp.view.model.common.edit.provider.CustomReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.ecp.view.spi.context.ViewModelService;
import org.eclipse.emf.ecp.view.spi.model.VView;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emfforms.internal.swt.treemasterdetail.defaultprovider.DefaultDNDProvider;
import org.eclipse.emfforms.internal.swt.treemasterdetail.defaultprovider.DefaultDetailCompositeBuilder;
import org.eclipse.emfforms.internal.swt.treemasterdetail.defaultprovider.DefaultMenuProvider;
import org.eclipse.emfforms.internal.swt.treemasterdetail.defaultprovider.DefaultTreeViewerBuilder;
import org.eclipse.emfforms.internal.swt.treemasterdetail.defaultprovider.DefaultTreeWidthProvider;
import org.eclipse.emfforms.internal.swt.treemasterdetail.defaultprovider.DefaultViewModelServiceProvider;
import org.eclipse.emfforms.internal.swt.treemasterdetail.defaultprovider.DefaultViewerFilterProvider;
import org.eclipse.emfforms.internal.swt.treemasterdetail.helpers.EcoreHelpers;
import org.eclipse.emfforms.spi.swt.treemasterdetail.ContentProviderProvider;
import org.eclipse.emfforms.spi.swt.treemasterdetail.DNDProvider;
import org.eclipse.emfforms.spi.swt.treemasterdetail.DetailCompositeBuilder;
import org.eclipse.emfforms.spi.swt.treemasterdetail.InitialSelectionProvider;
import org.eclipse.emfforms.spi.swt.treemasterdetail.LabelProviderProvider;
import org.eclipse.emfforms.spi.swt.treemasterdetail.MenuProvider;
import org.eclipse.emfforms.spi.swt.treemasterdetail.TreeMasterDetailSWTCustomization;
import org.eclipse.emfforms.spi.swt.treemasterdetail.TreeViewerBuilder;
import org.eclipse.emfforms.spi.swt.treemasterdetail.TreeWidthProvider;
import org.eclipse.emfforms.spi.swt.treemasterdetail.ViewModelServiceProvider;
import org.eclipse.emfforms.spi.swt.treemasterdetail.ViewerFilterProvider;
import org.eclipse.emfforms.spi.swt.treemasterdetail.util.RootObject;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;

/**
 * Default implementation of the {@link TreeMasterDetailSWTCustomization}.
 *
 * @author Johannes Faltermeier
 *
 */
public class DefaultTreeMasterDetailCustomization implements TreeMasterDetailSWTCustomization {

	private ViewerFilterProvider filters;
	private TreeWidthProvider width;
	private TreeViewerBuilder tree;
	private InitialSelectionProvider selection;
	private MenuProvider menu;
	private LabelProviderProvider labelProvider;
	private DNDProvider dnd;
	private DetailCompositeBuilder detailComposite;
	private ContentProviderProvider contentProvider;
	private ComposedAdapterFactory adapterFactory;
	private AdapterFactoryContentProvider adapterFactoryContentProvider;
	private ViewModelServiceProvider viewServiceProvider;

	/**
	 * Default constructor.
	 */
	public DefaultTreeMasterDetailCustomization() {
		filters = new DefaultViewerFilterProvider();
		width = new DefaultTreeWidthProvider();
		tree = new DefaultTreeViewerBuilder();
		selection = new DefaultTreeMasterDetailSelectionProvider();
		menu = new DefaultMenuProvider();
		labelProvider = new DefaultLabelProviderProvider();
		dnd = new DefaultDNDProvider();
		detailComposite = new DefaultDetailCompositeBuilder();
		contentProvider = new DefaultContentProviderProvider();
		viewServiceProvider = new DefaultViewModelServiceProvider();
	}

	private ComposedAdapterFactory getComposedAdapterFactory() {
		if (adapterFactory == null) {
			adapterFactory = new ComposedAdapterFactory(new AdapterFactory[] {
				new CustomReflectiveItemProviderAdapterFactory(),
				new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE) });
		}
		return adapterFactory;
	}

	private AdapterFactoryContentProvider getAdapterFactoryContentProvider() {
		if (adapterFactoryContentProvider == null) {
			final ComposedAdapterFactory adapterFactory = getComposedAdapterFactory();
			adapterFactoryContentProvider = new AdapterFactoryContentProvider(
				adapterFactory) {

				@Override
				public Object[] getElements(Object object) {
					if (RootObject.class.isInstance(object)) {
						return new Object[] { RootObject.class.cast(object).getRoot() };
					}
					return super.getElements(object);
				}

				@Override
				public boolean hasChildren(Object object) {
					return getChildren(object).length > 0;
				}

				@Override
				public Object[] getChildren(Object object) {
					// Filter all generic children
					// TODO move out of default behaviour
					return EcoreHelpers.filterGenericElements(super.getChildren(object));
				}
			};
		}
		return adapterFactoryContentProvider;
	}

	@Override
	public int getInitialTreeWidth() {
		return width.getInitialTreeWidth();
	}

	@Override
	public TreeViewer createTree(Composite parent) {
		return tree.createTree(parent);
	}

	@Override
	public boolean hasDND() {
		return dnd.hasDND();
	}

	@Override
	public int getDragOperations() {
		return dnd.getDragOperations();
	}

	@Override
	public Transfer[] getDragTransferTypes() {
		return dnd.getDragTransferTypes();
	}

	@Override
	public DragSourceListener getDragListener(TreeViewer treeViewer) {
		return dnd.getDragListener(treeViewer);
	}

	@Override
	public int getDropOperations() {
		return dnd.getDropOperations();
	}

	@Override
	public Transfer[] getDropTransferTypes() {
		return dnd.getDropTransferTypes();
	}

	@Override
	public DropTargetListener getDropListener(EditingDomain editingDomain, TreeViewer treeViewer) {
		return dnd.getDropListener(editingDomain, treeViewer);
	}

	@Override
	public Composite createDetailComposite(Composite parent) {
		return detailComposite.createDetailComposite(parent);
	}

	@Override
	public IContentProvider getContentProvider() {
		return contentProvider.getContentProvider();
	}

	@Override
	public IBaseLabelProvider getLabelProvider() {
		return labelProvider.getLabelProvider();
	}

	@Override
	public ViewerFilter[] getViewerFilters() {
		return filters.getViewerFilters();
	}

	@Override
	public EObject getInitialSelection(Object input) {
		return selection.getInitialSelection(input);
	}

	@Override
	public Menu getMenu(TreeViewer treeViewer, EditingDomain editingDomain) {
		return menu.getMenu(treeViewer, editingDomain);
	}

	@Override
	public ViewModelService[] getViewModelServices(VView view, EObject eObject) {
		return viewServiceProvider.getViewModelServices(view, eObject);
	}

	@Override
	public void dispose() {
		contentProvider.dispose();
		labelProvider.dispose();
		if (adapterFactoryContentProvider != null) {
			adapterFactoryContentProvider.dispose();
		}
		if (adapterFactory != null) {
			adapterFactory.dispose();
		}
	}

	/**
	 * Sets the content provider provider.
	 *
	 * @param contentProvider the content provider
	 */
	public void setContentProvider(ContentProviderProvider contentProvider) {
		this.contentProvider = contentProvider;
	}

	/**
	 * Sets the detail composite builder.
	 *
	 * @param detailComposite the builder
	 */
	public void setDetailComposite(DetailCompositeBuilder detailComposite) {
		this.detailComposite = detailComposite;
	}

	/**
	 * Sets the d&d support.
	 *
	 * @param dnd the dnd
	 */
	public void setDragAndDrop(DNDProvider dnd) {
		this.dnd = dnd;
	}

	/**
	 * Sets the label provider provider.
	 *
	 * @param labelProvider the provider
	 */
	public void setLabelProvider(LabelProviderProvider labelProvider) {
		this.labelProvider = labelProvider;
	}

	/**
	 * Sets the menu provider.
	 *
	 * @param menu the provider
	 */
	public void setMenu(MenuProvider menu) {
		this.menu = menu;
	}

	/**
	 * Sets the initial selection provider.
	 *
	 * @param selection the provider
	 */
	public void setInitialSelection(InitialSelectionProvider selection) {
		this.selection = selection;
	}

	/**
	 * Sets the tree builder.
	 *
	 * @param tree the tree builder
	 */
	public void setTree(TreeViewerBuilder tree) {
		this.tree = tree;
	}

	/**
	 * Sets the tree width provider.
	 *
	 * @param width the provider
	 */
	public void setInitialTreeWidth(TreeWidthProvider width) {
		this.width = width;
	}

	/**
	 * Sets the viewer filter provider.
	 *
	 * @param filters the provider
	 */
	public void setViewerFilters(ViewerFilterProvider filters) {
		this.filters = filters;
	}

	/**
	 * Sets the view model services provider.
	 *
	 * @param viewServiceProvider the provider
	 */
	public void setViewModelServices(ViewModelServiceProvider viewServiceProvider) {
		this.viewServiceProvider = viewServiceProvider;
	}

	/**
	 * Default {@link ContentProviderProvider}.
	 *
	 * @author jfaltermeier
	 *
	 */
	private final class DefaultContentProviderProvider implements ContentProviderProvider {
		@Override
		public IContentProvider getContentProvider() {
			return getAdapterFactoryContentProvider();
		}

		@Override
		public void dispose() {
			/* disposed by build behaviour */
		}
	}

	/**
	 * Default {@link LabelProviderProvider}.
	 *
	 * @author jfaltermeier
	 *
	 */
	private final class DefaultLabelProviderProvider implements LabelProviderProvider {
		private AdapterFactoryLabelProvider provider;

		@Override
		public IBaseLabelProvider getLabelProvider() {
			final ComposedAdapterFactory adapterFactory = getComposedAdapterFactory();
			provider = new AdapterFactoryLabelProvider(adapterFactory);
			return provider;
		}

		@Override
		public void dispose() {
			/* adapter factory will be disposed by build behaviour */
			provider.dispose();
		}
	}

	/**
	 * Default {@link InitialSelectionProvider}.
	 *
	 * @author jfaltermeier
	 *
	 */
	private final class DefaultTreeMasterDetailSelectionProvider implements InitialSelectionProvider {
		@Override
		public EObject getInitialSelection(Object input) {
			final AdapterFactoryContentProvider contentProvider = getAdapterFactoryContentProvider();
			if (input instanceof EObject) {
				return (EObject) input;
			}
			for (final Object child : contentProvider.getChildren(input)) {
				final EObject childSelector = getInitialSelection(child);
				if (childSelector != null) {
					return childSelector;
				}
			}
			return null;
		}
	}

}
