/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.embedcdt.debug.gdbjtag.qemu.dsf;

import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.cdt.dsf.concurrent.DefaultDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.gdb.internal.GdbPlugin;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.embedcdt.debug.gdbjtag.dsf.GnuMcuLaunch;
import org.eclipse.embedcdt.debug.gdbjtag.qemu.Activator;
import org.eclipse.embedcdt.debug.gdbjtag.qemu.Configuration;
import org.eclipse.embedcdt.debug.gdbjtag.qemu.dsf.GdbServerBackend;

public class Launch
extends GnuMcuLaunch {
    ILaunchConfiguration fConfig = null;
    private DsfSession fSession;
    private DsfServicesTracker fTracker;
    private DefaultDsfExecutor fExecutor;

    public Launch(ILaunchConfiguration launchConfiguration, String mode, ISourceLocator locator) {
        super(launchConfiguration, mode, locator);
        if (Activator.getInstance().isDebugging()) {
            System.out.println("qemu.Launch(" + launchConfiguration.getName() + "," + mode + ") " + (Object)((Object)this));
        }
        this.fConfig = launchConfiguration;
        this.fExecutor = (DefaultDsfExecutor)this.getDsfExecutor();
        this.fSession = this.getSession();
    }

    public void initialize() {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("qemu.Launch.initialize() " + (Object)((Object)this));
        }
        super.initialize();
        DsfRunnable initRunnable = new DsfRunnable(){

            public void run() {
                Launch.this.fTracker = new DsfServicesTracker(GdbPlugin.getBundleContext(), Launch.this.fSession.getId());
            }
        };
        try {
            this.fExecutor.submit((Runnable)initRunnable).get();
        }
        catch (InterruptedException e) {
            Activator.log((IStatus)new Status(4, "org.eclipse.embedcdt.debug.gdbjtag.qemu", 10005, "Error initializing launch", (Throwable)e));
        }
        catch (ExecutionException e) {
            Activator.log((IStatus)new Status(4, "org.eclipse.embedcdt.debug.gdbjtag.qemu", 10005, "Error initializing launch", (Throwable)e));
        }
    }

    protected void provideDefaults(ILaunchConfigurationWorkingCopy config) throws CoreException {
        super.provideDefaults(config);
        if (!config.hasAttribute("org.eclipse.cdt.debug.gdbjtag.core.ipAddress")) {
            config.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.ipAddress", "localhost");
        }
        if (!config.hasAttribute("org.eclipse.cdt.debug.gdbjtag.core.jtagDevice")) {
            config.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.jtagDevice", "GNU MCU QEMU");
        }
        if (!config.hasAttribute("org.eclipse.cdt.debug.gdbjtag.core.portNumber")) {
            config.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.portNumber", 1234);
        }
        if (!config.hasAttribute("org.eclipse.cdt.dsf.gdb.DEBUG_NAME")) {
            config.setAttribute("org.eclipse.cdt.dsf.gdb.DEBUG_NAME", "${cross_prefix}gdb${cross_suffix}");
        }
    }

    public void initializeServerConsole(IProgressMonitor monitor) throws CoreException {
        boolean doAddServerConsole;
        if (Activator.getInstance().isDebugging()) {
            System.out.println("qemu.Launch.initializeServerConsole()");
        }
        if (doAddServerConsole = Configuration.getDoAddServerConsole(this.fConfig)) {
            IProcess newProcess = this.addServerProcess(Configuration.getGdbServerCommandName(this.fConfig));
            newProcess.setAttribute(IProcess.ATTR_CMDLINE, Configuration.getGdbServerCommandLine(this.fConfig));
            monitor.worked(1);
        }
    }

    public void initializeConsoles(IProgressMonitor monitor) throws CoreException {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("qemu.Launch.initializeConsoles()");
        }
        IProcess newProcess = this.addClientProcess(Configuration.getGdbClientCommandName(this.fConfig));
        newProcess.setAttribute(IProcess.ATTR_CMDLINE, Configuration.getGdbClientCommandLine(this.fConfig));
        monitor.worked(1);
    }

    public IProcess addServerProcess(String label) throws CoreException {
        IProcess newProcess = null;
        try {
            Process serverProc = (Process)this.getDsfExecutor().submit((Callable)new Callable<Process>(){

                @Override
                public Process call() throws CoreException {
                    GdbServerBackend backend = (GdbServerBackend)((Object)Launch.this.fTracker.getService(GdbServerBackend.class));
                    if (backend != null) {
                        return backend.getServerProcess();
                    }
                    return null;
                }
            }).get();
            HashMap attributes = new HashMap();
            if (serverProc != null) {
                newProcess = DebugPlugin.newProcess((ILaunch)this, (Process)serverProc, (String)label, attributes);
            }
        }
        catch (InterruptedException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.embedcdt.debug.gdbjtag.qemu", 0, "Interrupted while waiting for get process callable.", (Throwable)e));
        }
        catch (ExecutionException e) {
            throw (CoreException)e.getCause();
        }
        catch (RejectedExecutionException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.embedcdt.debug.gdbjtag.qemu", 0, "Debugger shut down before launch was completed.", (Throwable)e));
        }
        return newProcess;
    }
}

