/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.embedcdt.debug.gdbjtag.qemu;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.embedcdt.core.EclipseUtils;
import org.eclipse.embedcdt.core.StringUtils;
import org.eclipse.embedcdt.debug.gdbjtag.DebugUtils;
import org.eclipse.embedcdt.debug.gdbjtag.qemu.Activator;
import org.eclipse.embedcdt.debug.gdbjtag.qemu.DynamicVariableResolver;
import org.eclipse.embedcdt.debug.gdbjtag.qemu.preferences.DefaultPreferences;

public class Configuration {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getGdbServerCommand(ILaunchConfiguration configuration, String executable) {
        DefaultPreferences fDefaultPreferences;
        block3: {
            try {
                if (executable != null) return Configuration.resolveAll(executable, configuration);
                fDefaultPreferences = Activator.getInstance().getDefaultPreferences();
                if (configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.qemu.doStartGdbServer", fDefaultPreferences.getGdbServerDoStart())) break block3;
                return null;
            }
            catch (CoreException e) {
                Activator.log((Throwable)e);
                return null;
            }
        }
        executable = configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.qemu.gdbServerExecutable", fDefaultPreferences.getGdbServerExecutable());
        return Configuration.resolveAll(executable, configuration);
    }

    public static String getGdbServerCommandLine(ILaunchConfiguration configuration) {
        String[] cmdLineArray = Configuration.getGdbServerCommandLineArray(configuration);
        return StringUtils.join((String[])cmdLineArray, (String)" ");
    }

    public static String[] getGdbServerCommandLineArray(ILaunchConfiguration configuration) {
        String semihostingCmdline;
        boolean nographic;
        String executable;
        ArrayList<String> lst;
        block11: {
            block10: {
                lst = new ArrayList<String>();
                try {
                    DefaultPreferences fDefaultPreferences = Activator.getInstance().getDefaultPreferences();
                    if (configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.qemu.doStartGdbServer", fDefaultPreferences.getGdbServerDoStart())) break block10;
                    return null;
                }
                catch (CoreException e) {
                    Activator.log((Throwable)e);
                    return null;
                }
            }
            executable = Configuration.getGdbServerCommand(configuration, null);
            if (executable != null && !executable.isEmpty()) break block11;
            return null;
        }
        lst.add(executable);
        lst.add("--verbose");
        if (configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.qemu.isGdbServerVerbose", false)) {
            lst.add("--verbose");
        }
        String boardName = configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.qemu.gdbServerBoardName", "").trim();
        if (!(boardName = DebugUtils.resolveAll((String)boardName, (Map)configuration.getAttributes())).isEmpty()) {
            lst.add("--board");
            lst.add(boardName);
        }
        String deviceName = configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.qemu.gdbServerDeviceName", "").trim();
        if (!(deviceName = DebugUtils.resolveAll((String)deviceName, (Map)configuration.getAttributes())).isEmpty()) {
            lst.add("--mcu");
            lst.add(deviceName);
        }
        lst.add("--gdb");
        lst.add("tcp::" + Integer.toString(configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.qemu.gdbServerGdbPortNumber", 1234)));
        String other = configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.qemu.gdbServerOther", "-d unimp,guest_errors").trim();
        other = DebugUtils.resolveAll((String)other, (Map)configuration.getAttributes());
        if (!other.isEmpty()) {
            lst.addAll(StringUtils.splitCommandLineOptions((String)other));
        }
        if (nographic = configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.qemu.disableGraphics", false)) {
            lst.add("--nographic");
        }
        boolean isSemihosting = configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.qemu.enableSemihosting", true);
        lst.add("--semihosting-config");
        lst.add(isSemihosting ? "enable=on,target=native" : "enable=off,target=native");
        if (isSemihosting && !(semihostingCmdline = configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.qemu.semihosting.cmdline", "").trim()).isEmpty()) {
            lst.add("--semihosting-cmdline");
            lst.addAll(StringUtils.splitCommandLineOptions((String)semihostingCmdline));
        }
        return lst.toArray(new String[0]);
    }

    public static String getGdbServerCommandName(ILaunchConfiguration config) {
        String fullCommand = Configuration.getGdbServerCommand(config, null);
        return StringUtils.extractNameFromPath((String)fullCommand);
    }

    public static String getGdbServerOtherConfig(ILaunchConfiguration config) throws CoreException {
        return config.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.qemu.gdbServerOther", "-d unimp,guest_errors").trim();
    }

    public static String getQemuBoardName(ILaunchConfiguration config) throws CoreException {
        return config.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.qemu.gdbServerBoardName", "").trim();
    }

    public static String getQemuDeviceName(ILaunchConfiguration config) throws CoreException {
        return config.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.qemu.gdbServerDeviceName", "").trim();
    }

    public static String getGdbClientCommand(ILaunchConfiguration configuration, String executable) {
        try {
            if (executable == null) {
                String defaultGdbCommand = Platform.getPreferencesService().getString("org.eclipse.cdt.dsf.gdb", "defaultGdbCommand", "gdb", null);
                executable = configuration.getAttribute("org.eclipse.cdt.dsf.gdb.DEBUG_NAME", defaultGdbCommand);
            }
            executable = Configuration.resolveAll(executable, configuration);
        }
        catch (CoreException e) {
            Activator.log((Throwable)e);
            return null;
        }
        return executable;
    }

    public static String[] getGdbClientCommandLineArray(ILaunchConfiguration configuration) {
        ArrayList<String> lst = new ArrayList<String>();
        String executable = Configuration.getGdbClientCommand(configuration, null);
        if (executable == null || executable.isEmpty()) {
            return null;
        }
        lst.add(executable);
        lst.add("--interpreter=mi2");
        lst.add("--nx");
        try {
            DefaultPreferences fDefaultPreferences = Activator.getInstance().getDefaultPreferences();
            String other = configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.qemu.gdbClientOtherOptions", fDefaultPreferences.getGdbClientOtherOptions()).trim();
            other = DebugUtils.resolveAll((String)other, (Map)configuration.getAttributes());
            if (other.length() > 0) {
                lst.addAll(StringUtils.splitCommandLineOptions((String)other));
            }
        }
        catch (CoreException e) {
            Activator.log((Throwable)e);
        }
        return lst.toArray(new String[0]);
    }

    public static String getGdbClientCommandLine(ILaunchConfiguration configuration) {
        String[] cmdLineArray = Configuration.getGdbClientCommandLineArray(configuration);
        return StringUtils.join((String[])cmdLineArray, (String)" ");
    }

    public static String getGdbClientCommandName(ILaunchConfiguration config) {
        String fullCommand = Configuration.getGdbClientCommand(config, null);
        return StringUtils.extractNameFromPath((String)fullCommand);
    }

    public static String resolveAll(String str, ILaunchConfiguration configuration) throws CoreException {
        IProject project;
        String value = str;
        if ((value = value.trim()).isEmpty()) {
            return null;
        }
        if (value.indexOf("${") >= 0 && (project = EclipseUtils.getProjectByLaunchConfiguration((ILaunchConfiguration)configuration)) != null) {
            value = DynamicVariableResolver.resolveAll(value, project);
        }
        if (value.indexOf("${") >= 0) {
            value = DebugUtils.resolveAll((String)value, (Map)configuration.getAttributes());
            ICConfigurationDescription buildConfig = EclipseUtils.getBuildConfigDescription((ILaunchConfiguration)configuration);
            if (buildConfig != null) {
                value = DebugUtils.resolveAll((String)value, (ICConfigurationDescription)buildConfig);
            }
        }
        if (Activator.getInstance().isDebugging()) {
            System.out.println("qemu.resolveAll(\"" + str + "\") = \"" + value + "\"");
        }
        return value;
    }

    public static boolean getDoStartGdbServer(ILaunchConfiguration config) throws CoreException {
        DefaultPreferences fDefaultPreferences = Activator.getInstance().getDefaultPreferences();
        return config.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.qemu.doStartGdbServer", fDefaultPreferences.getGdbServerDoStart());
    }

    public static boolean getDoAddServerConsole(ILaunchConfiguration config) throws CoreException {
        return Configuration.getDoStartGdbServer(config) && config.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.qemu.doGdbServerAllocateConsole", true);
    }
}

